/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.http.pathmap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.spark_project.jetty.http.pathmap.MappedResource;
import org.spark_project.jetty.http.pathmap.PathSpec;
import org.spark_project.jetty.util.annotation.ManagedAttribute;
import org.spark_project.jetty.util.annotation.ManagedObject;
import org.spark_project.jetty.util.component.ContainerLifeCycle;
import org.spark_project.jetty.util.component.Dumpable;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;

@ManagedObject(value="Path Mappings")
public class PathMappings<E>
implements Iterable<MappedResource<E>>,
Dumpable {
    private static final Logger LOG = Log.getLogger(PathMappings.class);
    private List<MappedResource<E>> mappings = new ArrayList<MappedResource<E>>();
    private MappedResource<E> defaultResource = null;
    private MappedResource<E> rootResource = null;

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dump(out, indent, this.mappings);
    }

    @ManagedAttribute(value="mappings", readonly=true)
    public List<MappedResource<E>> getMappings() {
        return this.mappings;
    }

    public void reset() {
        this.mappings.clear();
    }

    public void removeIf(Predicate<MappedResource<E>> predicate) {
        this.mappings.removeIf(predicate);
    }

    public List<MappedResource<E>> getMatches(String path) {
        boolean matchRoot = "/".equals(path);
        ArrayList<MappedResource<MappedResource<E>>> ret = new ArrayList<MappedResource<MappedResource<E>>>();
        int len = this.mappings.size();
        block4: for (int i = 0; i < len; ++i) {
            MappedResource<E> mr = this.mappings.get(i);
            switch (mr.getPathSpec().group) {
                case ROOT: {
                    if (!matchRoot) continue block4;
                    ret.add(mr);
                    continue block4;
                }
                case DEFAULT: {
                    if (!matchRoot && !mr.getPathSpec().matches(path)) continue block4;
                    ret.add(mr);
                    continue block4;
                }
                default: {
                    if (!mr.getPathSpec().matches(path)) continue block4;
                    ret.add(mr);
                }
            }
        }
        return ret;
    }

    public MappedResource<E> getMatch(String path) {
        if (path.equals("/") && this.rootResource != null) {
            return this.rootResource;
        }
        int len = this.mappings.size();
        for (int i = 0; i < len; ++i) {
            MappedResource<E> mr = this.mappings.get(i);
            if (!mr.getPathSpec().matches(path)) continue;
            return mr;
        }
        return this.defaultResource;
    }

    @Override
    public Iterator<MappedResource<E>> iterator() {
        return this.mappings.iterator();
    }

    public void put(PathSpec pathSpec, E resource) {
        MappedResource<E> entry = new MappedResource<E>(pathSpec, resource);
        switch (pathSpec.group) {
            case DEFAULT: {
                this.defaultResource = entry;
                break;
            }
            case ROOT: {
                this.rootResource = entry;
            }
        }
        this.mappings.add(entry);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Added {} to {}", entry, this);
        }
        Collections.sort(this.mappings);
    }

    public String toString() {
        return String.format("%s[size=%d]", this.getClass().getSimpleName(), this.mappings.size());
    }
}

