/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.AccumulableInfo;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.ShuffleReadMetrics;
import org.apache.spark.status.api.v1.StageData;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class ApiHelper$ {
    public static final ApiHelper$ MODULE$;
    private final String HEADER_ID;
    private final String HEADER_TASK_INDEX;
    private final String HEADER_ATTEMPT;
    private final String HEADER_STATUS;
    private final String HEADER_LOCALITY;
    private final String HEADER_EXECUTOR;
    private final String HEADER_HOST;
    private final String HEADER_LAUNCH_TIME;
    private final String HEADER_DURATION;
    private final String HEADER_SCHEDULER_DELAY;
    private final String HEADER_DESER_TIME;
    private final String HEADER_GC_TIME;
    private final String HEADER_SER_TIME;
    private final String HEADER_GETTING_RESULT_TIME;
    private final String HEADER_PEAK_MEM;
    private final String HEADER_ACCUMULATORS;
    private final String HEADER_INPUT_SIZE;
    private final String HEADER_OUTPUT_SIZE;
    private final String HEADER_SHUFFLE_READ_TIME;
    private final String HEADER_SHUFFLE_TOTAL_READS;
    private final String HEADER_SHUFFLE_REMOTE_READS;
    private final String HEADER_SHUFFLE_WRITE_TIME;
    private final String HEADER_SHUFFLE_WRITE_SIZE;
    private final String HEADER_MEM_SPILL;
    private final String HEADER_DISK_SPILL;
    private final String HEADER_ERROR;
    private final Map<String, String> COLUMN_TO_INDEX;

    static {
        new ApiHelper$();
    }

    public String HEADER_ID() {
        return this.HEADER_ID;
    }

    public String HEADER_TASK_INDEX() {
        return this.HEADER_TASK_INDEX;
    }

    public String HEADER_ATTEMPT() {
        return this.HEADER_ATTEMPT;
    }

    public String HEADER_STATUS() {
        return this.HEADER_STATUS;
    }

    public String HEADER_LOCALITY() {
        return this.HEADER_LOCALITY;
    }

    public String HEADER_EXECUTOR() {
        return this.HEADER_EXECUTOR;
    }

    public String HEADER_HOST() {
        return this.HEADER_HOST;
    }

    public String HEADER_LAUNCH_TIME() {
        return this.HEADER_LAUNCH_TIME;
    }

    public String HEADER_DURATION() {
        return this.HEADER_DURATION;
    }

    public String HEADER_SCHEDULER_DELAY() {
        return this.HEADER_SCHEDULER_DELAY;
    }

    public String HEADER_DESER_TIME() {
        return this.HEADER_DESER_TIME;
    }

    public String HEADER_GC_TIME() {
        return this.HEADER_GC_TIME;
    }

    public String HEADER_SER_TIME() {
        return this.HEADER_SER_TIME;
    }

    public String HEADER_GETTING_RESULT_TIME() {
        return this.HEADER_GETTING_RESULT_TIME;
    }

    public String HEADER_PEAK_MEM() {
        return this.HEADER_PEAK_MEM;
    }

    public String HEADER_ACCUMULATORS() {
        return this.HEADER_ACCUMULATORS;
    }

    public String HEADER_INPUT_SIZE() {
        return this.HEADER_INPUT_SIZE;
    }

    public String HEADER_OUTPUT_SIZE() {
        return this.HEADER_OUTPUT_SIZE;
    }

    public String HEADER_SHUFFLE_READ_TIME() {
        return this.HEADER_SHUFFLE_READ_TIME;
    }

    public String HEADER_SHUFFLE_TOTAL_READS() {
        return this.HEADER_SHUFFLE_TOTAL_READS;
    }

    public String HEADER_SHUFFLE_REMOTE_READS() {
        return this.HEADER_SHUFFLE_REMOTE_READS;
    }

    public String HEADER_SHUFFLE_WRITE_TIME() {
        return this.HEADER_SHUFFLE_WRITE_TIME;
    }

    public String HEADER_SHUFFLE_WRITE_SIZE() {
        return this.HEADER_SHUFFLE_WRITE_SIZE;
    }

    public String HEADER_MEM_SPILL() {
        return this.HEADER_MEM_SPILL;
    }

    public String HEADER_DISK_SPILL() {
        return this.HEADER_DISK_SPILL;
    }

    public String HEADER_ERROR() {
        return this.HEADER_ERROR;
    }

    public Map<String, String> COLUMN_TO_INDEX() {
        return this.COLUMN_TO_INDEX;
    }

    public boolean hasAccumulators(StageData stageData2) {
        return stageData2.accumulatorUpdates().exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AccumulableInfo acc) {
                return acc.name() != null && acc.value() != null;
            }
        });
    }

    public boolean hasInput(StageData stageData2) {
        return stageData2.inputBytes() > 0L;
    }

    public boolean hasOutput(StageData stageData2) {
        return stageData2.outputBytes() > 0L;
    }

    public boolean hasShuffleRead(StageData stageData2) {
        return stageData2.shuffleReadBytes() > 0L;
    }

    public boolean hasShuffleWrite(StageData stageData2) {
        return stageData2.shuffleWriteBytes() > 0L;
    }

    public boolean hasBytesSpilled(StageData stageData2) {
        return stageData2.diskBytesSpilled() > 0L || stageData2.memoryBytesSpilled() > 0L;
    }

    public long totalBytesRead(ShuffleReadMetrics metrics) {
        return metrics.localBytesRead() + metrics.remoteBytesRead();
    }

    public Option<String> indexName(String sortColumn) {
        Option option = this.COLUMN_TO_INDEX().get((Object)sortColumn);
        if (option instanceof Some) {
            Some some = (Some)option;
            String v = (String)some.x();
            Option option2 = Option$.MODULE$.apply((Object)v);
            return option2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid sort column: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sortColumn})));
    }

    public Tuple2<String, String> lastStageNameAndDescription(AppStatusStore store, JobData job) {
        Option stage = store.asOption(new Serializable(store, job){
            public static final long serialVersionUID = 0L;
            private final AppStatusStore store$1;
            private final JobData job$1;

            public final StageData apply() {
                return this.store$1.stageAttempt(BoxesRunTime.unboxToInt((Object)this.job$1.stageIds().max((Ordering)Ordering.Int$.MODULE$)), 0, this.store$1.stageAttempt$default$3());
            }
            {
                this.store$1 = store$1;
                this.job$1 = job$1;
            }
        });
        return new Tuple2(stage.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StageData x$24) {
                return x$24.name();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), stage.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(StageData x$25) {
                return x$25.description();
            }
        }).getOrElse((Function0)new Serializable(job){
            public static final long serialVersionUID = 0L;
            private final JobData job$1;

            public final String apply() {
                return this.job$1.name();
            }
            {
                this.job$1 = job$1;
            }
        }));
    }

    public int taskCount(StageData stageData2) {
        return stageData2.numActiveTasks() + stageData2.numCompleteTasks() + stageData2.numFailedTasks() + stageData2.numKilledTasks();
    }

    private ApiHelper$() {
        MODULE$ = this;
        this.HEADER_ID = "ID";
        this.HEADER_TASK_INDEX = "Index";
        this.HEADER_ATTEMPT = "Attempt";
        this.HEADER_STATUS = "Status";
        this.HEADER_LOCALITY = "Locality Level";
        this.HEADER_EXECUTOR = "Executor ID";
        this.HEADER_HOST = "Host";
        this.HEADER_LAUNCH_TIME = "Launch Time";
        this.HEADER_DURATION = "Duration";
        this.HEADER_SCHEDULER_DELAY = "Scheduler Delay";
        this.HEADER_DESER_TIME = "Task Deserialization Time";
        this.HEADER_GC_TIME = "GC Time";
        this.HEADER_SER_TIME = "Result Serialization Time";
        this.HEADER_GETTING_RESULT_TIME = "Getting Result Time";
        this.HEADER_PEAK_MEM = "Peak Execution Memory";
        this.HEADER_ACCUMULATORS = "Accumulators";
        this.HEADER_INPUT_SIZE = "Input Size / Records";
        this.HEADER_OUTPUT_SIZE = "Output Size / Records";
        this.HEADER_SHUFFLE_READ_TIME = "Shuffle Read Blocked Time";
        this.HEADER_SHUFFLE_TOTAL_READS = "Shuffle Read Size / Records";
        this.HEADER_SHUFFLE_REMOTE_READS = "Shuffle Remote Reads";
        this.HEADER_SHUFFLE_WRITE_TIME = "Write Time";
        this.HEADER_SHUFFLE_WRITE_SIZE = "Shuffle Write Size / Records";
        this.HEADER_MEM_SPILL = "Shuffle Spill (Memory)";
        this.HEADER_DISK_SPILL = "Shuffle Spill (Disk)";
        this.HEADER_ERROR = "Errors";
        this.COLUMN_TO_INDEX = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_ID()), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_TASK_INDEX()), (Object)"idx"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_ATTEMPT()), (Object)"att"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_STATUS()), (Object)"sta"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_LOCALITY()), (Object)"loc"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_EXECUTOR()), (Object)"exe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_HOST()), (Object)"hst"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_LAUNCH_TIME()), (Object)"lt"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_DURATION()), (Object)"dur"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_SCHEDULER_DELAY()), (Object)"dly"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_DESER_TIME()), (Object)"des"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_GC_TIME()), (Object)"gc"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_SER_TIME()), (Object)"rst"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_GETTING_RESULT_TIME()), (Object)"grt"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_PEAK_MEM()), (Object)"pem"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_ACCUMULATORS()), (Object)"acc"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_INPUT_SIZE()), (Object)"is"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_OUTPUT_SIZE()), (Object)"os"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_SHUFFLE_READ_TIME()), (Object)"srt"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_SHUFFLE_TOTAL_READS()), (Object)"stby"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_SHUFFLE_REMOTE_READS()), (Object)"srby"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_SHUFFLE_WRITE_TIME()), (Object)"swt"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_SHUFFLE_WRITE_SIZE()), (Object)"sws"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_MEM_SPILL()), (Object)"mbs"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_DISK_SPILL()), (Object)"dbs"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.HEADER_ERROR()), (Object)"err")}));
    }
}

