/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.utils;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class FileCryptoTool {
    private String algorithm = "PBEWithMD5AndDES";
    private SecretKey key = null;
    private AlgorithmParameterSpec algParamSpec = null;
    private int iterationCount = 5000;
    private byte[] salt = new byte[]{-92, 11, -56, 52, -42, -107, -13, 19};

    public void init(String password, String algorithm, byte[] salt, int interationCount) throws NoSuchAlgorithmException, InvalidKeySpecException {
        this.algorithm = algorithm;
        this.salt = salt;
        this.iterationCount = interationCount;
        PBEKeySpec keyspec = new PBEKeySpec(password.toCharArray(), this.salt, this.iterationCount, 32);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
        this.key = skf.generateSecret(keyspec);
        this.algParamSpec = new PBEParameterSpec(this.salt, this.iterationCount);
    }

    public void init(String password, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        this.init(password, algorithm, this.salt, this.iterationCount);
    }

    public void decryptFile(File inputFile, File outputFile) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IOException {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(2, (Key)this.key, this.algParamSpec);
        this.transferFileData(inputFile, outputFile, cipher);
    }

    public void encryptFile(File inputFile, File outputFile) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IOException {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(1, (Key)this.key, this.algParamSpec);
        this.transferFileData(inputFile, outputFile, cipher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferFileData(File inputFile, File outputFile, Cipher cipher) throws IOException {
        InputStream is;
        block6: {
            is = null;
            BufferedOutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(outputFile));
                is = new CipherInputStream(new BufferedInputStream(new FileInputStream(inputFile)), cipher);
                byte[] buffer = new byte[16384];
                int read = -1;
                while ((read = is.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, read);
                }
                Object var9_8 = null;
                if (os == null) break block6;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (os != null) {
                    ((OutputStream)os).close();
                }
                if (is != null) {
                    is.close();
                }
                throw throwable;
            }
            ((OutputStream)os).close();
        }
        if (is != null) {
            is.close();
        }
    }

    protected void initGui(final JFrame frame) {
        final FileCryptoTool self = this;
        final File[] filesArray = new File[2];
        JLabel inputFileLabel = new JLabel("Input file:");
        final JTextField inputFileTextField = new JTextField();
        JButton inputFileBrowseButton = new JButton("Browse");
        inputFileBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                filesArray[0] = FileCryptoTool.this.fileChooser("Input File", frame, false);
                if (filesArray[0] != null) {
                    inputFileTextField.setText(filesArray[0].getAbsolutePath());
                } else {
                    inputFileTextField.setText("");
                }
            }
        });
        JLabel outputDirectoryLabel = new JLabel("Output directory:");
        final JTextField outputDirectoryTextField = new JTextField();
        JButton outputDirectoryBrowseButton = new JButton("Browse");
        outputDirectoryBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                filesArray[1] = FileCryptoTool.this.fileChooser("Output Directory", frame, true);
                if (filesArray[1] != null) {
                    outputDirectoryTextField.setText(filesArray[1].getAbsolutePath());
                } else {
                    outputDirectoryTextField.setText("");
                }
            }
        });
        JLabel passwordLabel = new JLabel("Password:");
        final JPasswordField passwordField = new JPasswordField();
        JLabel passwordConfirmLabel = new JLabel("Password (confirm):");
        final JPasswordField password2Field = new JPasswordField();
        JLabel algorithmLabel = new JLabel("Algorithm:");
        final JComboBox<String> algorithmComboBox = new JComboBox<String>(FileCryptoTool.listAvailablePbeCiphers());
        algorithmComboBox.setSelectedItem(this.algorithm.toUpperCase());
        algorithmComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                self.algorithm = (String)algorithmComboBox.getSelectedItem();
            }
        });
        final JButton encryptButton = new JButton("Encrypt File");
        JButton decryptButton = new JButton("Decrypt File");
        ActionListener buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    if (inputFileTextField.getText().trim().length() == 0) {
                        JOptionPane.showMessageDialog(frame, "Choose an input file");
                    } else if (outputDirectoryTextField.getText().trim().length() == 0) {
                        JOptionPane.showMessageDialog(frame, "Choose an output directory");
                    } else if (passwordField.getPassword().length == 0 || password2Field.getPassword().length == 0) {
                        JOptionPane.showMessageDialog(frame, "Enter your password twice");
                    } else if (!new String(passwordField.getPassword()).equals(new String(password2Field.getPassword()))) {
                        JOptionPane.showMessageDialog(frame, "Password and confirmation password do not match");
                    } else {
                        File inputFile = new File(inputFileTextField.getText().trim());
                        File outputDirectory = new File(outputDirectoryTextField.getText().trim());
                        File outputFile = new File(outputDirectory, inputFile.getName());
                        if (!outputDirectory.isDirectory()) {
                            JOptionPane.showMessageDialog(frame, "The output directory is not valid");
                        } else if (inputFile.equals(outputFile)) {
                            JOptionPane.showMessageDialog(frame, "Choose a different output directory from the one that contains the input file");
                        } else {
                            boolean encrypting = event.getSource().equals(encryptButton);
                            FileCryptoTool.this.init(new String(passwordField.getPassword()), self.algorithm);
                            if (encrypting) {
                                FileCryptoTool.this.encryptFile(inputFile, outputFile);
                            } else {
                                FileCryptoTool.this.decryptFile(inputFile, outputFile);
                            }
                            JOptionPane.showMessageDialog(frame, "'" + inputFile.getName() + "' " + (encrypting ? "encrypted" : "decrypted") + " to: \n'" + outputFile.getAbsolutePath() + "'");
                        }
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(frame, "ERROR: " + e.getMessage());
                }
            }
        };
        encryptButton.addActionListener(buttonListener);
        decryptButton.addActionListener(buttonListener);
        Insets insetsDefault = new Insets(2, 3, 2, 3);
        JPanel inputsPanel = new JPanel(new GridBagLayout());
        inputsPanel.add((Component)inputFileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 13, 0, insetsDefault, 0, 0));
        inputsPanel.add((Component)inputFileTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, insetsDefault, 0, 0));
        inputsPanel.add((Component)inputFileBrowseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 0, insetsDefault, 0, 0));
        inputsPanel.add((Component)outputDirectoryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 13, 0, insetsDefault, 0, 0));
        inputsPanel.add((Component)outputDirectoryTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 2, insetsDefault, 0, 0));
        inputsPanel.add((Component)outputDirectoryBrowseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 1.0, 10, 0, insetsDefault, 0, 0));
        inputsPanel.add((Component)passwordLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 13, 0, insetsDefault, 0, 0));
        inputsPanel.add((Component)passwordField, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 2, insetsDefault, 0, 0));
        inputsPanel.add((Component)passwordConfirmLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 13, 0, insetsDefault, 0, 0));
        inputsPanel.add((Component)password2Field, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 2, insetsDefault, 0, 0));
        inputsPanel.add((Component)algorithmLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 13, 0, insetsDefault, 0, 0));
        inputsPanel.add(algorithmComboBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 10, 2, insetsDefault, 0, 0));
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.add((Component)encryptButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insetsDefault, 0, 0));
        buttonsPanel.add((Component)decryptButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, insetsDefault, 0, 0));
        frame.getContentPane().setLayout(new GridBagLayout());
        frame.getContentPane().add((Component)inputsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, insetsDefault, 0, 0));
        frame.getContentPane().add((Component)buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, insetsDefault, 0, 0));
        frame.pack();
        frame.setVisible(true);
    }

    private File fileChooser(String title, JFrame frame, boolean dirOnly) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setDialogTitle(title);
        fileChooser.setFileSelectionMode(dirOnly ? 1 : 0);
        fileChooser.setApproveButtonText("Select " + (dirOnly ? "Directory" : "File"));
        int returnVal = fileChooser.showOpenDialog(frame);
        if (returnVal != 0) {
            return null;
        }
        return fileChooser.getSelectedFile();
    }

    private static String[] listAvailablePbeCiphers() {
        Set<String> ciphers = Security.getAlgorithms("Cipher");
        HashSet<String> pbeCiphers = new HashSet<String>();
        for (String cipher : ciphers) {
            if (!cipher.toLowerCase().startsWith("pbe")) continue;
            pbeCiphers.add(cipher);
        }
        return pbeCiphers.toArray(new String[pbeCiphers.size()]);
    }

    public static void main(String[] args) throws Exception {
        FileCryptoTool fct = new FileCryptoTool();
        JFrame frame = new JFrame("File Crypto Tool");
        fct.initGui(frame);
    }

    static {
        try {
            Class<?> bouncyCastleProviderClass = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            if (bouncyCastleProviderClass != null) {
                Provider bouncyCastleProvider = (Provider)bouncyCastleProviderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Security.addProvider(bouncyCastleProvider);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            System.err.println("Unable to load security provider BouncyCastleProvider");
        }
    }
}

