/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.spark.internal.Logging;
import org.apache.spark.package$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.FunctionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.AlterDatabaseEvent;
import org.apache.spark.sql.catalyst.catalog.AlterDatabasePreEvent;
import org.apache.spark.sql.catalyst.catalog.AlterFunctionEvent;
import org.apache.spark.sql.catalyst.catalog.AlterFunctionPreEvent;
import org.apache.spark.sql.catalyst.catalog.AlterTableEvent;
import org.apache.spark.sql.catalyst.catalog.AlterTableKind$;
import org.apache.spark.sql.catalyst.catalog.AlterTablePreEvent;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CreateDatabaseEvent;
import org.apache.spark.sql.catalyst.catalog.CreateDatabasePreEvent;
import org.apache.spark.sql.catalyst.catalog.CreateFunctionEvent;
import org.apache.spark.sql.catalyst.catalog.CreateFunctionPreEvent;
import org.apache.spark.sql.catalyst.catalog.CreateTableEvent;
import org.apache.spark.sql.catalyst.catalog.CreateTablePreEvent;
import org.apache.spark.sql.catalyst.catalog.DropDatabaseEvent;
import org.apache.spark.sql.catalyst.catalog.DropDatabasePreEvent;
import org.apache.spark.sql.catalyst.catalog.DropFunctionEvent;
import org.apache.spark.sql.catalyst.catalog.DropFunctionPreEvent;
import org.apache.spark.sql.catalyst.catalog.DropTableEvent;
import org.apache.spark.sql.catalyst.catalog.DropTablePreEvent;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogEvent;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogEventListener;
import org.apache.spark.sql.catalyst.catalog.RenameFunctionEvent;
import org.apache.spark.sql.catalyst.catalog.RenameFunctionPreEvent;
import org.apache.spark.sql.catalyst.catalog.RenameTableEvent;
import org.apache.spark.sql.catalyst.catalog.RenameTablePreEvent;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ListenerBus;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\rUe!B\u0001\u0003\u0003\u0003y!aD#yi\u0016\u0014h.\u00197DCR\fGn\\4\u000b\u0005\r!\u0011aB2bi\u0006dwn\u001a\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A1\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0003\u00185q\u0001S\"\u0001\r\u000b\u0005eA\u0011\u0001B;uS2L!a\u0007\r\u0003\u00171K7\u000f^3oKJ\u0014Uo\u001d\t\u0003;yi\u0011AA\u0005\u0003?\t\u0011A$\u0012=uKJt\u0017\r\\\"bi\u0006dwnZ#wK:$H*[:uK:,'\u000f\u0005\u0002\u001eC%\u0011!E\u0001\u0002\u0015\u000bb$XM\u001d8bY\u000e\u000bG/\u00197pO\u00163XM\u001c;\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\u00051\u0003CA\u000f\u0001\u0011\u0015A\u0003\u0001\"\u0005*\u0003=\u0011X-];je\u0016$%-\u0012=jgR\u001cHC\u0001\u0016.!\t\t2&\u0003\u0002-%\t!QK\\5u\u0011\u0015qs\u00051\u00010\u0003\t!'\r\u0005\u00021g9\u0011\u0011#M\u0005\u0003eI\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\u0019\u0019FO]5oO*\u0011!G\u0005\u0005\u0006o\u0001!\t\u0002O\u0001\u0013e\u0016\fX/\u001b:f)\u0006\u0014G.Z#ySN$8\u000fF\u0002+siBQA\f\u001cA\u0002=BQa\u000f\u001cA\u0002=\nQ\u0001^1cY\u0016DQ!\u0010\u0001\u0005\u0012y\nQC]3rk&\u0014XMR;oGRLwN\\#ySN$8\u000fF\u0002+\u007f\u0001CQA\f\u001fA\u0002=BQ!\u0011\u001fA\u0002=\n\u0001BZ;oG:\u000bW.\u001a\u0005\u0006\u0007\u0002!\t\u0002R\u0001\u0019e\u0016\fX/\u001b:f\rVt7\r^5p]:{G/\u0012=jgR\u001cHc\u0001\u0016F\r\")aF\u0011a\u0001_!)\u0011I\u0011a\u0001_!)\u0001\n\u0001C\u0003\u0013\u0006q1M]3bi\u0016$\u0015\r^1cCN,Gc\u0001\u0016K\u001f\")1j\u0012a\u0001\u0019\u0006aAM\u0019#fM&t\u0017\u000e^5p]B\u0011Q$T\u0005\u0003\u001d\n\u0011qbQ1uC2|w\rR1uC\n\f7/\u001a\u0005\u0006!\u001e\u0003\r!U\u0001\u000fS\u001etwN]3JM\u0016C\u0018n\u001d;t!\t\t\"+\u0003\u0002T%\t9!i\\8mK\u0006t\u0007\"B+\u0001\r#1\u0016\u0001\u00053p\u0007J,\u0017\r^3ECR\f'-Y:f)\rQs\u000b\u0017\u0005\u0006\u0017R\u0003\r\u0001\u0014\u0005\u0006!R\u0003\r!\u0015\u0005\u00065\u0002!)aW\u0001\rIJ|\u0007\u000fR1uC\n\f7/\u001a\u000b\u0005Uqkv\fC\u0003/3\u0002\u0007q\u0006C\u0003_3\u0002\u0007\u0011+A\tjO:|'/Z%g\u001d>$X\t_5tiNDQ\u0001Y-A\u0002E\u000bqaY1tG\u0006$W\rC\u0003c\u0001\u0019E1-\u0001\be_\u0012\u0013x\u000e\u001d#bi\u0006\u0014\u0017m]3\u0015\t)\"WM\u001a\u0005\u0006]\u0005\u0004\ra\f\u0005\u0006=\u0006\u0004\r!\u0015\u0005\u0006A\u0006\u0004\r!\u0015\u0005\u0006Q\u0002!)![\u0001\u000eC2$XM\u001d#bi\u0006\u0014\u0017m]3\u0015\u0005)R\u0007\"B&h\u0001\u0004a\u0005\"\u00027\u0001\r#i\u0017a\u00043p\u00032$XM\u001d#bi\u0006\u0014\u0017m]3\u0015\u0005)r\u0007\"B&l\u0001\u0004a\u0005\"\u00029\u0001\r\u0003\t\u0018aC4fi\u0012\u000bG/\u00192bg\u0016$\"\u0001\u0014:\t\u000b9z\u0007\u0019A\u0018\t\u000bQ\u0004a\u0011A;\u0002\u001d\u0011\fG/\u00192bg\u0016,\u00050[:ugR\u0011\u0011K\u001e\u0005\u0006]M\u0004\ra\f\u0005\u0006q\u00021\t!_\u0001\u000eY&\u001cH\u000fR1uC\n\f7/Z:\u0015\u0003i\u0004Ba_A\u0004_9\u0019A0a\u0001\u000f\u0007u\f\t!D\u0001\u007f\u0015\tyh\"\u0001\u0004=e>|GOP\u0005\u0002'%\u0019\u0011Q\u0001\n\u0002\u000fA\f7m[1hK&!\u0011\u0011BA\u0006\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u000b\u0011\u0002B\u0002=\u0001\r\u0003\ty\u0001F\u0002{\u0003#Aq!a\u0005\u0002\u000e\u0001\u0007q&A\u0004qCR$XM\u001d8\t\u000f\u0005]\u0001A\"\u0001\u0002\u001a\u0005\u00112/\u001a;DkJ\u0014XM\u001c;ECR\f'-Y:f)\rQ\u00131\u0004\u0005\u0007]\u0005U\u0001\u0019A\u0018\t\u000f\u0005}\u0001\u0001\"\u0002\u0002\"\u0005Y1M]3bi\u0016$\u0016M\u00197f)\u0015Q\u00131EA\u0017\u0011!\t)#!\bA\u0002\u0005\u001d\u0012a\u0004;bE2,G)\u001a4j]&$\u0018n\u001c8\u0011\u0007u\tI#C\u0002\u0002,\t\u0011AbQ1uC2|w\rV1cY\u0016Da\u0001UA\u000f\u0001\u0004\t\u0006bBA\u0019\u0001\u0019E\u00111G\u0001\u000eI>\u001c%/Z1uKR\u000b'\r\\3\u0015\u000b)\n)$a\u000e\t\u0011\u0005\u0015\u0012q\u0006a\u0001\u0003OAa\u0001UA\u0018\u0001\u0004\t\u0006bBA\u001e\u0001\u0011\u0015\u0011QH\u0001\nIJ|\u0007\u000fV1cY\u0016$\u0012BKA \u0003\u0003\n\u0019%!\u0012\t\r9\nI\u00041\u00010\u0011\u0019Y\u0014\u0011\ba\u0001_!1a,!\u000fA\u0002ECq!a\u0012\u0002:\u0001\u0007\u0011+A\u0003qkJ<W\rC\u0004\u0002L\u00011\t\"!\u0014\u0002\u0017\u0011|GI]8q)\u0006\u0014G.\u001a\u000b\nU\u0005=\u0013\u0011KA*\u0003+BaALA%\u0001\u0004y\u0003BB\u001e\u0002J\u0001\u0007q\u0006\u0003\u0004_\u0003\u0013\u0002\r!\u0015\u0005\b\u0003\u000f\nI\u00051\u0001R\u0011\u001d\tI\u0006\u0001C\u0003\u00037\n1B]3oC6,G+\u00192mKR9!&!\u0018\u0002`\u0005\r\u0004B\u0002\u0018\u0002X\u0001\u0007q\u0006C\u0004\u0002b\u0005]\u0003\u0019A\u0018\u0002\u000f=dGMT1nK\"9\u0011QMA,\u0001\u0004y\u0013a\u00028fo:\u000bW.\u001a\u0005\b\u0003S\u0002a\u0011CA6\u00035!wNU3oC6,G+\u00192mKR9!&!\u001c\u0002p\u0005E\u0004B\u0002\u0018\u0002h\u0001\u0007q\u0006C\u0004\u0002b\u0005\u001d\u0004\u0019A\u0018\t\u000f\u0005\u0015\u0014q\ra\u0001_!9\u0011Q\u000f\u0001\u0005\u0006\u0005]\u0014AC1mi\u0016\u0014H+\u00192mKR\u0019!&!\u001f\t\u0011\u0005\u0015\u00121\u000fa\u0001\u0003OAq!! \u0001\r#\ty(\u0001\u0007e_\u0006cG/\u001a:UC\ndW\rF\u0002+\u0003\u0003C\u0001\"!\n\u0002|\u0001\u0007\u0011q\u0005\u0005\b\u0003\u000b\u0003AQAAD\u0003Q\tG\u000e^3s)\u0006\u0014G.\u001a#bi\u0006\u001c6\r[3nCR9!&!#\u0002\f\u00065\u0005B\u0002\u0018\u0002\u0004\u0002\u0007q\u0006\u0003\u0004<\u0003\u0007\u0003\ra\f\u0005\t\u0003\u001f\u000b\u0019\t1\u0001\u0002\u0012\u0006ia.Z<ECR\f7k\u00195f[\u0006\u0004B!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0004\u0003/3\u0011!\u0002;za\u0016\u001c\u0018\u0002BAN\u0003+\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\ty\n\u0001D\t\u0003C\u000ba\u0003Z8BYR,'\u000fV1cY\u0016$\u0015\r^1TG\",W.\u0019\u000b\bU\u0005\r\u0016QUAT\u0011\u0019q\u0013Q\u0014a\u0001_!11(!(A\u0002=B\u0001\"a$\u0002\u001e\u0002\u0007\u0011\u0011\u0013\u0005\b\u0003W\u0003AQAAW\u0003=\tG\u000e^3s)\u0006\u0014G.Z*uCR\u001cHc\u0002\u0016\u00020\u0006E\u00161\u0017\u0005\u0007]\u0005%\u0006\u0019A\u0018\t\rm\nI\u000b1\u00010\u0011!\t),!+A\u0002\u0005]\u0016!B:uCR\u001c\b#B\t\u0002:\u0006u\u0016bAA^%\t1q\n\u001d;j_:\u00042!HA`\u0013\r\t\tM\u0001\u0002\u0012\u0007\u0006$\u0018\r\\8h'R\fG/[:uS\u000e\u001c\bbBAc\u0001\u0019E\u0011qY\u0001\u0012I>\fE\u000e^3s)\u0006\u0014G.Z*uCR\u001cHc\u0002\u0016\u0002J\u0006-\u0017Q\u001a\u0005\u0007]\u0005\r\u0007\u0019A\u0018\t\rm\n\u0019\r1\u00010\u0011!\t),a1A\u0002\u0005]\u0006bBAi\u0001\u0019\u0005\u00111[\u0001\tO\u0016$H+\u00192mKR1\u0011qEAk\u0003/DaALAh\u0001\u0004y\u0003BB\u001e\u0002P\u0002\u0007q\u0006C\u0004\u0002\\\u00021\t!!8\u0002\u0017Q\f'\r\\3Fq&\u001cHo\u001d\u000b\u0006#\u0006}\u0017\u0011\u001d\u0005\u0007]\u0005e\u0007\u0019A\u0018\t\rm\nI\u000e1\u00010\u0011\u001d\t)\u000f\u0001D\u0001\u0003O\f!\u0002\\5tiR\u000b'\r\\3t)\rQ\u0018\u0011\u001e\u0005\u0007]\u0005\r\b\u0019A\u0018\t\u000f\u0005\u0015\bA\"\u0001\u0002nR)!0a<\u0002r\"1a&a;A\u0002=Bq!a\u0005\u0002l\u0002\u0007q\u0006C\u0004\u0002v\u00021\t!a>\u0002\u00131|\u0017\r\u001a+bE2,Gc\u0003\u0016\u0002z\u0006m\u0018Q B\u0001\u0005\u000bAaALAz\u0001\u0004y\u0003BB\u001e\u0002t\u0002\u0007q\u0006C\u0004\u0002\u0000\u0006M\b\u0019A\u0018\u0002\u00111|\u0017\r\u001a)bi\"DqAa\u0001\u0002t\u0002\u0007\u0011+A\u0006jg>3XM]<sSR,\u0007b\u0002B\u0004\u0003g\u0004\r!U\u0001\u000bSN\u001c&o\u0019'pG\u0006d\u0007b\u0002B\u0006\u0001\u0019\u0005!QB\u0001\u000eY>\fG\rU1si&$\u0018n\u001c8\u0015\u001f)\u0012yA!\u0005\u0003\u0014\tU!q\u0005B\u0015\u0005[AaA\fB\u0005\u0001\u0004y\u0003BB\u001e\u0003\n\u0001\u0007q\u0006C\u0004\u0002\u0000\n%\u0001\u0019A\u0018\t\u0011\t]!\u0011\u0002a\u0001\u00053\t\u0011\u0002]1si&$\u0018n\u001c8\u0011\t\tm!\u0011\u0005\b\u0004;\tu\u0011b\u0001B\u0010\u0005\u0005a1)\u0019;bY><G+\u001f9fg&!!1\u0005B\u0013\u0005I!\u0016M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u000b\u0007\t}!\u0001C\u0004\u0003\u0004\t%\u0001\u0019A)\t\u000f\t-\"\u0011\u0002a\u0001#\u0006\t\u0012N\u001c5fe&$H+\u00192mKN\u0003XmY:\t\u000f\t\u001d!\u0011\u0002a\u0001#\"9!\u0011\u0007\u0001\u0007\u0002\tM\u0012!\u00067pC\u0012$\u0015P\\1nS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u000eU\tU\"q\u0007B\u001d\u0005w\u0011iD!\u0011\t\r9\u0012y\u00031\u00010\u0011\u0019Y$q\u0006a\u0001_!9\u0011q B\u0018\u0001\u0004y\u0003\u0002\u0003B\f\u0005_\u0001\rA!\u0007\t\u000f\t}\"q\u0006a\u0001#\u00069!/\u001a9mC\u000e,\u0007\u0002\u0003B\"\u0005_\u0001\rA!\u0012\u0002\u000b9,X\u000e\u0012)\u0011\u0007E\u00119%C\u0002\u0003JI\u00111!\u00138u\u0011\u001d\u0011i\u0005\u0001D\u0001\u0005\u001f\n\u0001c\u0019:fCR,\u0007+\u0019:uSRLwN\\:\u0015\u0013)\u0012\tFa\u0015\u0003V\t\u0005\u0004B\u0002\u0018\u0003L\u0001\u0007q\u0006\u0003\u0004<\u0005\u0017\u0002\ra\f\u0005\t\u0005/\u0012Y\u00051\u0001\u0003Z\u0005)\u0001/\u0019:ugB)10a\u0002\u0003\\A\u0019QD!\u0018\n\u0007\t}#AA\u000bDCR\fGn\\4UC\ndW\rU1si&$\u0018n\u001c8\t\rA\u0013Y\u00051\u0001R\u0011\u001d\u0011)\u0007\u0001D\u0001\u0005O\na\u0002\u001a:paB\u000b'\u000f^5uS>t7\u000fF\u0007+\u0005S\u0012YG!\u001c\u0003r\tM$Q\u000f\u0005\u0007]\t\r\u0004\u0019A\u0018\t\rm\u0012\u0019\u00071\u00010\u0011!\u00119Fa\u0019A\u0002\t=\u0004#B>\u0002\b\te\u0001B\u00020\u0003d\u0001\u0007\u0011\u000bC\u0004\u0002H\t\r\u0004\u0019A)\t\u000f\t]$1\ra\u0001#\u0006Q!/\u001a;bS:$\u0015\r^1\t\u000f\tm\u0004A\"\u0001\u0003~\u0005\u0001\"/\u001a8b[\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u000b\nU\t}$\u0011\u0011BB\u0005\u000fCaA\fB=\u0001\u0004y\u0003BB\u001e\u0003z\u0001\u0007q\u0006\u0003\u0005\u0003\u0006\ne\u0004\u0019\u0001B8\u0003\u0015\u0019\b/Z2t\u0011!\u0011II!\u001fA\u0002\t=\u0014\u0001\u00038foN\u0003XmY:\t\u000f\t5\u0005A\"\u0001\u0003\u0010\u0006y\u0011\r\u001c;feB\u000b'\u000f^5uS>t7\u000fF\u0004+\u0005#\u0013\u0019J!&\t\r9\u0012Y\t1\u00010\u0011\u0019Y$1\u0012a\u0001_!A!q\u000bBF\u0001\u0004\u0011I\u0006C\u0004\u0003\u001a\u00021\tAa'\u0002\u0019\u001d,G\u000fU1si&$\u0018n\u001c8\u0015\u0011\tm#Q\u0014BP\u0005CCaA\fBL\u0001\u0004y\u0003BB\u001e\u0003\u0018\u0002\u0007q\u0006\u0003\u0005\u0003$\n]\u0005\u0019\u0001B\r\u0003\u0011\u0019\b/Z2\t\u000f\t\u001d\u0006A\"\u0001\u0003*\u0006\u0011r-\u001a;QCJ$\u0018\u000e^5p]>\u0003H/[8o)!\u0011YK!,\u00030\nE\u0006#B\t\u0002:\nm\u0003B\u0002\u0018\u0003&\u0002\u0007q\u0006\u0003\u0004<\u0005K\u0003\ra\f\u0005\t\u0005G\u0013)\u000b1\u0001\u0003\u001a!9!Q\u0017\u0001\u0007\u0002\t]\u0016A\u00057jgR\u0004\u0016M\u001d;ji&|gNT1nKN$rA\u001fB]\u0005w\u0013i\f\u0003\u0004/\u0005g\u0003\ra\f\u0005\u0007w\tM\u0006\u0019A\u0018\t\u0015\t}&1\u0017I\u0001\u0002\u0004\u0011\t-A\u0006qCJ$\u0018.\u00197Ta\u0016\u001c\u0007#B\t\u0002:\ne\u0001b\u0002Bc\u0001\u0019\u0005!qY\u0001\u000fY&\u001cH\u000fU1si&$\u0018n\u001c8t)!\u0011IF!3\u0003L\n5\u0007B\u0002\u0018\u0003D\u0002\u0007q\u0006\u0003\u0004<\u0005\u0007\u0004\ra\f\u0005\u000b\u0005\u007f\u0013\u0019\r%AA\u0002\t\u0005\u0007b\u0002Bi\u0001\u0019\u0005!1[\u0001\u0017Y&\u001cH\u000fU1si&$\u0018n\u001c8t\u0005f4\u0015\u000e\u001c;feRQ!\u0011\fBk\u0005/\u0014INa;\t\r9\u0012y\r1\u00010\u0011\u0019Y$q\u001aa\u0001_!A!1\u001cBh\u0001\u0004\u0011i.\u0001\u0006qe\u0016$\u0017nY1uKN\u0004Ra_A\u0004\u0005?\u0004BA!9\u0003h6\u0011!1\u001d\u0006\u0004\u0005K$\u0011aC3yaJ,7o]5p]NLAA!;\u0003d\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\t5(q\u001aa\u0001_\u0005\tB-\u001a4bk2$H+[7f5>tW-\u00133\t\u000f\tE\b\u0001\"\u0002\u0003t\u0006q1M]3bi\u00164UO\\2uS>tG#\u0002\u0016\u0003v\n]\bB\u0002\u0018\u0003p\u0002\u0007q\u0006\u0003\u0005\u0003z\n=\b\u0019\u0001B~\u000391WO\\2EK\u001aLg.\u001b;j_:\u00042!\bB\u007f\u0013\r\u0011yP\u0001\u0002\u0010\u0007\u0006$\u0018\r\\8h\rVt7\r^5p]\"911\u0001\u0001\u0007\u0012\r\u0015\u0011\u0001\u00053p\u0007J,\u0017\r^3Gk:\u001cG/[8o)\u0015Q3qAB\u0005\u0011\u0019q3\u0011\u0001a\u0001_!A!\u0011`B\u0001\u0001\u0004\u0011Y\u0010C\u0004\u0004\u000e\u0001!)aa\u0004\u0002\u0019\u0011\u0014x\u000e\u001d$v]\u000e$\u0018n\u001c8\u0015\u000b)\u001a\tba\u0005\t\r9\u001aY\u00011\u00010\u0011\u0019\t51\u0002a\u0001_!91q\u0003\u0001\u0007\u0012\re\u0011A\u00043p\tJ|\u0007OR;oGRLwN\u001c\u000b\u0006U\rm1Q\u0004\u0005\u0007]\rU\u0001\u0019A\u0018\t\r\u0005\u001b)\u00021\u00010\u0011\u001d\u0019\t\u0003\u0001C\u0003\u0007G\tQ\"\u00197uKJ4UO\\2uS>tG#\u0002\u0016\u0004&\r\u001d\u0002B\u0002\u0018\u0004 \u0001\u0007q\u0006\u0003\u0005\u0003z\u000e}\u0001\u0019\u0001B~\u0011\u001d\u0019Y\u0003\u0001D\t\u0007[\tq\u0002Z8BYR,'OR;oGRLwN\u001c\u000b\u0006U\r=2\u0011\u0007\u0005\u0007]\r%\u0002\u0019A\u0018\t\u0011\te8\u0011\u0006a\u0001\u0005wDqa!\u000e\u0001\t\u000b\u00199$\u0001\bsK:\fW.\u001a$v]\u000e$\u0018n\u001c8\u0015\u000f)\u001aIda\u000f\u0004>!1afa\rA\u0002=Bq!!\u0019\u00044\u0001\u0007q\u0006C\u0004\u0002f\rM\u0002\u0019A\u0018\t\u000f\r\u0005\u0003A\"\u0005\u0004D\u0005\u0001Bm\u001c*f]\u0006lWMR;oGRLwN\u001c\u000b\bU\r\u00153qIB%\u0011\u0019q3q\ba\u0001_!9\u0011\u0011MB \u0001\u0004y\u0003bBA3\u0007\u007f\u0001\ra\f\u0005\b\u0007\u001b\u0002a\u0011AB(\u0003-9W\r\u001e$v]\u000e$\u0018n\u001c8\u0015\r\tm8\u0011KB*\u0011\u0019q31\na\u0001_!1\u0011ia\u0013A\u0002=Bqaa\u0016\u0001\r\u0003\u0019I&\u0001\bgk:\u001cG/[8o\u000bbL7\u000f^:\u0015\u000bE\u001bYf!\u0018\t\r9\u001a)\u00061\u00010\u0011\u0019\t5Q\u000ba\u0001_!91\u0011\r\u0001\u0007\u0002\r\r\u0014!\u00047jgR4UO\\2uS>t7\u000fF\u0003{\u0007K\u001a9\u0007\u0003\u0004/\u0007?\u0002\ra\f\u0005\b\u0003'\u0019y\u00061\u00010\u0011\u001d\u0019Y\u0007\u0001C)\u0007[\n1\u0002Z8Q_N$XI^3oiR)!fa\u001c\u0004t!91\u0011OB5\u0001\u0004a\u0012\u0001\u00037jgR,g.\u001a:\t\u000f\rU4\u0011\u000ea\u0001A\u0005)QM^3oi\"I1\u0011\u0010\u0001\u0012\u0002\u0013\u000511P\u0001\u001dY&\u001cH\u000fU1si&$\u0018n\u001c8OC6,7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019iH\u000b\u0003\u0003B\u000e}4FABA!\u0011\u0019\u0019i!$\u000e\u0005\r\u0015%\u0002BBD\u0007\u0013\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r-%#\u0001\u0006b]:|G/\u0019;j_:LAaa$\u0004\u0006\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\rM\u0005!%A\u0005\u0002\rm\u0014\u0001\u00077jgR\u0004\u0016M\u001d;ji&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0001")
public abstract class ExternalCatalog
implements ListenerBus<ExternalCatalogEventListener, ExternalCatalogEvent> {
    private final CopyOnWriteArrayList org$apache$spark$util$ListenerBus$$listenersPlusTimers;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public CopyOnWriteArrayList org$apache$spark$util$ListenerBus$$listenersPlusTimers() {
        return this.org$apache$spark$util$ListenerBus$$listenersPlusTimers;
    }

    public void org$apache$spark$util$ListenerBus$_setter_$org$apache$spark$util$ListenerBus$$listenersPlusTimers_$eq(CopyOnWriteArrayList x$1) {
        this.org$apache$spark$util$ListenerBus$$listenersPlusTimers = x$1;
    }

    public List<ExternalCatalogEventListener> listeners() {
        return ListenerBus.class.listeners((ListenerBus)this);
    }

    public Option getTimer(Object listener) {
        return ListenerBus.class.getTimer((ListenerBus)this, (Object)listener);
    }

    public final void addListener(Object listener) {
        ListenerBus.class.addListener((ListenerBus)this, (Object)listener);
    }

    public final void removeListener(Object listener) {
        ListenerBus.class.removeListener((ListenerBus)this, (Object)listener);
    }

    public void postToAll(Object event) {
        ListenerBus.class.postToAll((ListenerBus)this, (Object)event);
    }

    public <T extends ExternalCatalogEventListener> Seq<T> findListenersByClass(ClassTag<T> evidence$1) {
        return ListenerBus.class.findListenersByClass((ListenerBus)this, evidence$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public void requireDbExists(String db) {
        if (this.databaseExists(db)) {
            return;
        }
        throw new NoSuchDatabaseException(db);
    }

    public void requireTableExists(String db, String table) {
        if (this.tableExists(db, table)) {
            return;
        }
        throw new NoSuchTableException(db, table);
    }

    public void requireFunctionExists(String db, String funcName) {
        if (this.functionExists(db, funcName)) {
            return;
        }
        throw new NoSuchFunctionException(db, funcName);
    }

    public void requireFunctionNotExists(String db, String funcName) {
        if (this.functionExists(db, funcName)) {
            throw new FunctionAlreadyExistsException(db, funcName);
        }
    }

    public final void createDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        String db = dbDefinition.name();
        this.postToAll(new CreateDatabasePreEvent(db));
        this.doCreateDatabase(dbDefinition, ignoreIfExists);
        this.postToAll(new CreateDatabaseEvent(db));
    }

    public abstract void doCreateDatabase(CatalogDatabase var1, boolean var2);

    public final void dropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        this.postToAll(new DropDatabasePreEvent(db));
        this.doDropDatabase(db, ignoreIfNotExists, cascade);
        this.postToAll(new DropDatabaseEvent(db));
    }

    public abstract void doDropDatabase(String var1, boolean var2, boolean var3);

    public final void alterDatabase(CatalogDatabase dbDefinition) {
        String db = dbDefinition.name();
        this.postToAll(new AlterDatabasePreEvent(db));
        this.doAlterDatabase(dbDefinition);
        this.postToAll(new AlterDatabaseEvent(db));
    }

    public abstract void doAlterDatabase(CatalogDatabase var1);

    public abstract CatalogDatabase getDatabase(String var1);

    public abstract boolean databaseExists(String var1);

    public abstract Seq<String> listDatabases();

    public abstract Seq<String> listDatabases(String var1);

    public abstract void setCurrentDatabase(String var1);

    public final void createTable(CatalogTable tableDefinition, boolean ignoreIfExists) {
        String db = tableDefinition.database();
        String name2 = tableDefinition.identifier().table();
        String x$1 = package$.MODULE$.SPARK_VERSION();
        TableIdentifier x$2 = tableDefinition.copy$default$1();
        CatalogTableType x$3 = tableDefinition.copy$default$2();
        CatalogStorageFormat x$4 = tableDefinition.copy$default$3();
        StructType x$5 = tableDefinition.copy$default$4();
        Option<String> x$6 = tableDefinition.copy$default$5();
        Seq<String> x$7 = tableDefinition.copy$default$6();
        Option<BucketSpec> x$8 = tableDefinition.copy$default$7();
        String x$9 = tableDefinition.copy$default$8();
        long x$10 = tableDefinition.copy$default$9();
        long x$11 = tableDefinition.copy$default$10();
        Map<String, String> x$12 = tableDefinition.copy$default$12();
        Option<CatalogStatistics> x$13 = tableDefinition.copy$default$13();
        Option<String> x$14 = tableDefinition.copy$default$14();
        Option<String> x$15 = tableDefinition.copy$default$15();
        Seq<String> x$16 = tableDefinition.copy$default$16();
        boolean x$17 = tableDefinition.copy$default$17();
        boolean x$18 = tableDefinition.copy$default$18();
        Map<String, String> x$19 = tableDefinition.copy$default$19();
        CatalogTable tableDefinitionWithVersion = tableDefinition.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$1, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19);
        this.postToAll(new CreateTablePreEvent(db, name2));
        this.doCreateTable(tableDefinitionWithVersion, ignoreIfExists);
        this.postToAll(new CreateTableEvent(db, name2));
    }

    public abstract void doCreateTable(CatalogTable var1, boolean var2);

    public final void dropTable(String db, String table, boolean ignoreIfNotExists, boolean purge) {
        this.postToAll(new DropTablePreEvent(db, table));
        this.doDropTable(db, table, ignoreIfNotExists, purge);
        this.postToAll(new DropTableEvent(db, table));
    }

    public abstract void doDropTable(String var1, String var2, boolean var3, boolean var4);

    public final void renameTable(String db, String oldName, String newName) {
        this.postToAll(new RenameTablePreEvent(db, oldName, newName));
        this.doRenameTable(db, oldName, newName);
        this.postToAll(new RenameTableEvent(db, oldName, newName));
    }

    public abstract void doRenameTable(String var1, String var2, String var3);

    public final void alterTable(CatalogTable tableDefinition) {
        String db = tableDefinition.database();
        String name2 = tableDefinition.identifier().table();
        this.postToAll(new AlterTablePreEvent(db, name2, AlterTableKind$.MODULE$.TABLE()));
        this.doAlterTable(tableDefinition);
        this.postToAll(new AlterTableEvent(db, name2, AlterTableKind$.MODULE$.TABLE()));
    }

    public abstract void doAlterTable(CatalogTable var1);

    public final void alterTableDataSchema(String db, String table, StructType newDataSchema) {
        this.postToAll(new AlterTablePreEvent(db, table, AlterTableKind$.MODULE$.DATASCHEMA()));
        this.doAlterTableDataSchema(db, table, newDataSchema);
        this.postToAll(new AlterTableEvent(db, table, AlterTableKind$.MODULE$.DATASCHEMA()));
    }

    public abstract void doAlterTableDataSchema(String var1, String var2, StructType var3);

    public final void alterTableStats(String db, String table, Option<CatalogStatistics> stats2) {
        this.postToAll(new AlterTablePreEvent(db, table, AlterTableKind$.MODULE$.STATS()));
        this.doAlterTableStats(db, table, stats2);
        this.postToAll(new AlterTableEvent(db, table, AlterTableKind$.MODULE$.STATS()));
    }

    public abstract void doAlterTableStats(String var1, String var2, Option<CatalogStatistics> var3);

    public abstract CatalogTable getTable(String var1, String var2);

    public abstract boolean tableExists(String var1, String var2);

    public abstract Seq<String> listTables(String var1);

    public abstract Seq<String> listTables(String var1, String var2);

    public abstract void loadTable(String var1, String var2, String var3, boolean var4, boolean var5);

    public abstract void loadPartition(String var1, String var2, String var3, Map<String, String> var4, boolean var5, boolean var6, boolean var7);

    public abstract void loadDynamicPartitions(String var1, String var2, String var3, Map<String, String> var4, boolean var5, int var6);

    public abstract void createPartitions(String var1, String var2, Seq<CatalogTablePartition> var3, boolean var4);

    public abstract void dropPartitions(String var1, String var2, Seq<Map<String, String>> var3, boolean var4, boolean var5, boolean var6);

    public abstract void renamePartitions(String var1, String var2, Seq<Map<String, String>> var3, Seq<Map<String, String>> var4);

    public abstract void alterPartitions(String var1, String var2, Seq<CatalogTablePartition> var3);

    public abstract CatalogTablePartition getPartition(String var1, String var2, Map<String, String> var3);

    public abstract Option<CatalogTablePartition> getPartitionOption(String var1, String var2, Map<String, String> var3);

    public abstract Seq<String> listPartitionNames(String var1, String var2, Option<Map<String, String>> var3);

    public Option<Map<String, String>> listPartitionNames$default$3() {
        return None$.MODULE$;
    }

    public abstract Seq<CatalogTablePartition> listPartitions(String var1, String var2, Option<Map<String, String>> var3);

    public Option<Map<String, String>> listPartitions$default$3() {
        return None$.MODULE$;
    }

    public abstract Seq<CatalogTablePartition> listPartitionsByFilter(String var1, String var2, Seq<Expression> var3, String var4);

    public final void createFunction(String db, CatalogFunction funcDefinition) {
        String name2 = funcDefinition.identifier().funcName();
        this.postToAll(new CreateFunctionPreEvent(db, name2));
        this.doCreateFunction(db, funcDefinition);
        this.postToAll(new CreateFunctionEvent(db, name2));
    }

    public abstract void doCreateFunction(String var1, CatalogFunction var2);

    public final void dropFunction(String db, String funcName) {
        this.postToAll(new DropFunctionPreEvent(db, funcName));
        this.doDropFunction(db, funcName);
        this.postToAll(new DropFunctionEvent(db, funcName));
    }

    public abstract void doDropFunction(String var1, String var2);

    public final void alterFunction(String db, CatalogFunction funcDefinition) {
        String name2 = funcDefinition.identifier().funcName();
        this.postToAll(new AlterFunctionPreEvent(db, name2));
        this.doAlterFunction(db, funcDefinition);
        this.postToAll(new AlterFunctionEvent(db, name2));
    }

    public abstract void doAlterFunction(String var1, CatalogFunction var2);

    public final void renameFunction(String db, String oldName, String newName) {
        this.postToAll(new RenameFunctionPreEvent(db, oldName, newName));
        this.doRenameFunction(db, oldName, newName);
        this.postToAll(new RenameFunctionEvent(db, oldName, newName));
    }

    public abstract void doRenameFunction(String var1, String var2, String var3);

    public abstract CatalogFunction getFunction(String var1, String var2);

    public abstract boolean functionExists(String var1, String var2);

    public abstract Seq<String> listFunctions(String var1, String var2);

    public void doPostEvent(ExternalCatalogEventListener listener, ExternalCatalogEvent event) {
        listener.onEvent(event);
    }

    public ExternalCatalog() {
        Logging.class.$init$((Logging)this);
        ListenerBus.class.$init$((ListenerBus)this);
    }
}

