/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.input.PortableDataStream;
import org.apache.spark.input.StreamInputFormat;
import org.apache.spark.rdd.BinaryFileRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.FailureSafeParser;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonInferSchema$;
import org.apache.spark.sql.execution.datasources.json.JsonUtils$;
import org.apache.spark.sql.execution.datasources.json.MultiLineJsonDataSource$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import org.spark_project.guava.io.ByteStreams;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;

public final class MultiLineJsonDataSource$
extends JsonDataSource {
    public static final MultiLineJsonDataSource$ MODULE$;
    private final boolean isSplitable;

    static {
        new MultiLineJsonDataSource$();
    }

    @Override
    public boolean isSplitable() {
        return this.isSplitable;
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, JSONOptions parsedOptions) {
        RDD<PortableDataStream> json = this.createBaseRdd(sparkSession, inputPaths);
        RDD<PortableDataStream> sampled = JsonUtils$.MODULE$.sample(json, parsedOptions);
        return JsonInferSchema$.MODULE$.infer(sampled, parsedOptions, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonParser apply(JsonFactory jsonFactory, PortableDataStream record) {
                return MultiLineJsonDataSource$.MODULE$.org$apache$spark$sql$execution$datasources$json$MultiLineJsonDataSource$$createParser(jsonFactory, record);
            }
        });
    }

    private RDD<PortableDataStream> createBaseRdd(SparkSession sparkSession, Seq<FileStatus> inputPaths) {
        Seq paths = (Seq)inputPaths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(FileStatus x$5) {
                return x$5.getPath();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Job job = Job.getInstance((Configuration)sparkSession.sessionState().newHadoopConf());
        Configuration conf = job.getConfiguration();
        String name = paths.mkString(",");
        FileInputFormat.setInputPaths((Job)job, (Path[])((Path[])paths.toArray(ClassTag$.MODULE$.apply(Path.class))));
        return RDD$.MODULE$.rddToPairRDDFunctions(new BinaryFileRDD(sparkSession.sparkContext(), StreamInputFormat.class, String.class, PortableDataStream.class, conf, sparkSession.sparkContext().defaultMinPartitions()).setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JsonFile: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PortableDataStream.class), (Ordering)Ordering.String$.MODULE$).values();
    }

    public JsonParser org$apache$spark$sql$execution$datasources$json$MultiLineJsonDataSource$$createParser(JsonFactory jsonFactory, PortableDataStream record) {
        Path path = new Path(record.getPath());
        return CreateJacksonParser$.MODULE$.inputStream(jsonFactory, CodecStreams$.MODULE$.createInputStreamWithCloseResource(record.getConfiguration(), path));
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, JacksonParser parser, StructType schema2) {
        FailureSafeParser<InputStream> safeParser = new FailureSafeParser<InputStream>((Function1<InputStream, Seq<InternalRow>>)new Serializable(conf, file, parser){
            public static final long serialVersionUID = 0L;
            public final Configuration conf$1;
            public final PartitionedFile file$1;
            private final JacksonParser parser$2;

            public final Seq<InternalRow> apply(InputStream input) {
                return this.parser$2.parse((Object)input, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonParser apply(JsonFactory jsonFactory, InputStream record) {
                        return CreateJacksonParser$.MODULE$.inputStream(jsonFactory, record);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.5 $outer;

                    public final UTF8String apply(Object ignored) {
                        return MultiLineJsonDataSource$.MODULE$.org$apache$spark$sql$execution$datasources$json$MultiLineJsonDataSource$$partitionedFileString$1(ignored, this.$outer.conf$1, this.$outer.file$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conf$1 = conf$1;
                this.file$1 = file$1;
                this.parser$2 = parser$2;
            }
        }, parser.options().parseMode(), schema2, parser.options().columnNameOfCorruptRecord());
        return safeParser.parse(CodecStreams$.MODULE$.createInputStreamWithCloseResource(conf, new Path(new URI(file.filePath()))));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final UTF8String org$apache$spark$sql$execution$datasources$json$MultiLineJsonDataSource$$partitionedFileString$1(Object ignored, Configuration conf$1, PartitionedFile file$1) {
        return (UTF8String)Utils$.MODULE$.tryWithResource((Function0)new Serializable(conf$1, file$1){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;
            private final PartitionedFile file$1;

            public final InputStream apply() {
                return CodecStreams$.MODULE$.createInputStreamWithCloseResource(this.conf$1, new Path(new URI(this.file$1.filePath())));
            }
            {
                this.conf$1 = conf$1;
                this.file$1 = file$1;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final UTF8String apply(InputStream inputStream) {
                return UTF8String.fromBytes((byte[])ByteStreams.toByteArray((InputStream)inputStream));
            }
        });
    }

    private MultiLineJsonDataSource$() {
        MODULE$ = this;
        this.isSplitable = false;
    }
}

