/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;

public class HiveStatsUtils {
    public static FileStatus[] getFileStatusRecurse(Path path, int level, FileSystem fs) throws IOException {
        if (level < 0) {
            ArrayList<FileStatus> result = new ArrayList<FileStatus>();
            try {
                FileStatus fileStatus = fs.getFileStatus(path);
                FileUtils.listStatusRecursively(fs, fileStatus, result);
            }
            catch (IOException e) {
                return new FileStatus[0];
            }
            return result.toArray(new FileStatus[result.size()]);
        }
        StringBuilder sb = new StringBuilder(path.toUri().getPath());
        for (int i = 0; i < level; ++i) {
            sb.append("/").append("*");
        }
        Path pathPattern = new Path(path, sb.toString());
        return fs.globStatus(pathPattern, FileUtils.HIDDEN_FILES_PATH_FILTER);
    }
}

