/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.spark_project.jetty.client.ContentDecoder;
import org.spark_project.jetty.client.GZIPContentDecoder;
import org.spark_project.jetty.client.api.ContentProvider;
import org.spark_project.jetty.client.api.Request;
import org.spark_project.jetty.client.api.Response;
import org.spark_project.jetty.client.api.Result;
import org.spark_project.jetty.client.util.DeferredContentProvider;
import org.spark_project.jetty.http.HttpHeader;
import org.spark_project.jetty.http.HttpVersion;
import org.spark_project.jetty.io.RuntimeIOException;
import org.spark_project.jetty.proxy.AbstractProxyServlet;
import org.spark_project.jetty.proxy.ProxyServlet;
import org.spark_project.jetty.util.BufferUtil;
import org.spark_project.jetty.util.Callback;
import org.spark_project.jetty.util.CountingCallback;
import org.spark_project.jetty.util.IteratingCallback;
import org.spark_project.jetty.util.component.Destroyable;

public class AsyncMiddleManServlet
extends AbstractProxyServlet {
    private static final String PROXY_REQUEST_COMMITTED = AsyncMiddleManServlet.class.getName() + ".proxyRequestCommitted";
    private static final String CLIENT_TRANSFORMER = AsyncMiddleManServlet.class.getName() + ".clientTransformer";
    private static final String SERVER_TRANSFORMER = AsyncMiddleManServlet.class.getName() + ".serverTransformer";

    protected void service(HttpServletRequest clientRequest, HttpServletResponse proxyResponse) throws ServletException, IOException {
        String rewrittenTarget = this.rewriteTarget(clientRequest);
        if (this._log.isDebugEnabled()) {
            StringBuffer target = clientRequest.getRequestURL();
            if (clientRequest.getQueryString() != null) {
                target.append("?").append(clientRequest.getQueryString());
            }
            this._log.debug("{} rewriting: {} -> {}", this.getRequestId(clientRequest), target, rewrittenTarget);
        }
        if (rewrittenTarget == null) {
            this.onProxyRewriteFailed(clientRequest, proxyResponse);
            return;
        }
        Request proxyRequest = this.getHttpClient().newRequest(rewrittenTarget).method(clientRequest.getMethod()).version(HttpVersion.fromString(clientRequest.getProtocol()));
        boolean hasContent = this.hasContent(clientRequest);
        this.copyRequestHeaders(clientRequest, proxyRequest);
        this.addProxyHeaders(clientRequest, proxyRequest);
        AsyncContext asyncContext = clientRequest.startAsync();
        asyncContext.setTimeout(0L);
        proxyRequest.timeout(this.getTimeout(), TimeUnit.MILLISECONDS);
        if (hasContent) {
            proxyRequest.content(this.newProxyContentProvider(clientRequest, proxyResponse, proxyRequest));
        } else {
            this.sendProxyRequest(clientRequest, proxyResponse, proxyRequest);
        }
    }

    protected ContentProvider newProxyContentProvider(final HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Request proxyRequest) throws IOException {
        ServletInputStream input = clientRequest.getInputStream();
        DeferredContentProvider provider = new DeferredContentProvider(new ByteBuffer[0]){

            @Override
            public boolean offer(ByteBuffer buffer, Callback callback) {
                if (AsyncMiddleManServlet.this._log.isDebugEnabled()) {
                    AsyncMiddleManServlet.this._log.debug("{} proxying content to upstream: {} bytes", AsyncMiddleManServlet.this.getRequestId(clientRequest), buffer.remaining());
                }
                return super.offer(buffer, callback);
            }
        };
        input.setReadListener(this.newProxyReadListener(clientRequest, proxyResponse, proxyRequest, provider));
        return provider;
    }

    protected ReadListener newProxyReadListener(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Request proxyRequest, DeferredContentProvider provider) {
        return new ProxyReader(clientRequest, proxyResponse, proxyRequest, provider);
    }

    protected ProxyWriter newProxyWriteListener(HttpServletRequest clientRequest, Response proxyResponse) {
        return new ProxyWriter(clientRequest, proxyResponse);
    }

    @Override
    protected Response.CompleteListener newProxyResponseListener(HttpServletRequest clientRequest, HttpServletResponse proxyResponse) {
        return new ProxyResponseListener(clientRequest, proxyResponse);
    }

    protected ContentTransformer newClientRequestContentTransformer(HttpServletRequest clientRequest, Request proxyRequest) {
        return ContentTransformer.IDENTITY;
    }

    protected ContentTransformer newServerResponseContentTransformer(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Response serverResponse) {
        return ContentTransformer.IDENTITY;
    }

    private void transform(ContentTransformer transformer, ByteBuffer input, boolean finished, List<ByteBuffer> output) throws IOException {
        try {
            transformer.transform(input, finished, output);
        }
        catch (Throwable x) {
            this._log.info("Exception while transforming " + transformer, x);
            throw x;
        }
    }

    int readClientRequestContent(ServletInputStream input, byte[] buffer) throws IOException {
        return input.read(buffer);
    }

    void writeProxyResponseContent(ServletOutputStream output, ByteBuffer content) throws IOException {
        AsyncMiddleManServlet.write((OutputStream)output, content);
    }

    private static void write(OutputStream output, ByteBuffer content) throws IOException {
        byte[] buffer;
        int length = content.remaining();
        int offset = 0;
        if (content.hasArray()) {
            offset = content.arrayOffset();
            buffer = content.array();
        } else {
            buffer = new byte[length];
            content.get(buffer);
        }
        output.write(buffer, offset, length);
    }

    private void cleanup(HttpServletRequest clientRequest) {
        ContentTransformer serverTransformer;
        ContentTransformer clientTransformer = (ContentTransformer)clientRequest.getAttribute(CLIENT_TRANSFORMER);
        if (clientTransformer instanceof Destroyable) {
            ((Destroyable)((Object)clientTransformer)).destroy();
        }
        if ((serverTransformer = (ContentTransformer)clientRequest.getAttribute(SERVER_TRANSFORMER)) instanceof Destroyable) {
            ((Destroyable)((Object)serverTransformer)).destroy();
        }
    }

    public static class GZIPContentTransformer
    implements ContentTransformer {
        private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>(2);
        private final ContentDecoder decoder = new GZIPContentDecoder();
        private final ContentTransformer transformer;
        private final ByteArrayOutputStream out;
        private final GZIPOutputStream gzipOut;

        public GZIPContentTransformer(ContentTransformer transformer) {
            try {
                this.transformer = transformer;
                this.out = new ByteArrayOutputStream();
                this.gzipOut = new GZIPOutputStream(this.out);
            }
            catch (IOException x) {
                throw new RuntimeIOException(x);
            }
        }

        @Override
        public void transform(ByteBuffer input, boolean finished, List<ByteBuffer> output) throws IOException {
            if (!input.hasRemaining()) {
                if (finished) {
                    this.transformer.transform(input, true, this.buffers);
                }
            } else {
                while (input.hasRemaining()) {
                    ByteBuffer decoded = this.decoder.decode(input);
                    if (!decoded.hasRemaining()) continue;
                    this.transformer.transform(decoded, finished && !input.hasRemaining(), this.buffers);
                }
            }
            if (!this.buffers.isEmpty() || finished) {
                ByteBuffer result2 = this.gzip(this.buffers, finished);
                this.buffers.clear();
                output.add(result2);
            }
        }

        private ByteBuffer gzip(List<ByteBuffer> buffers, boolean finished) throws IOException {
            for (ByteBuffer buffer : buffers) {
                AsyncMiddleManServlet.write(this.gzipOut, buffer);
            }
            if (finished) {
                this.gzipOut.close();
            }
            byte[] gzipBytes = this.out.toByteArray();
            this.out.reset();
            return ByteBuffer.wrap(gzipBytes);
        }
    }

    private static class IdentityContentTransformer
    implements ContentTransformer {
        private IdentityContentTransformer() {
        }

        @Override
        public void transform(ByteBuffer input, boolean finished, List<ByteBuffer> output) {
            output.add(input);
        }
    }

    public static interface ContentTransformer {
        public static final ContentTransformer IDENTITY = new IdentityContentTransformer();

        public void transform(ByteBuffer var1, boolean var2, List<ByteBuffer> var3) throws IOException;
    }

    protected class ProxyWriter
    implements WriteListener {
        private final Queue<DeferredContentProvider.Chunk> chunks = new ArrayDeque<DeferredContentProvider.Chunk>();
        private final HttpServletRequest clientRequest;
        private final Response serverResponse;
        private DeferredContentProvider.Chunk chunk;
        private boolean writePending;

        protected ProxyWriter(HttpServletRequest clientRequest, Response serverResponse) {
            this.clientRequest = clientRequest;
            this.serverResponse = serverResponse;
        }

        public boolean offer(ByteBuffer content, Callback callback) {
            if (AsyncMiddleManServlet.this._log.isDebugEnabled()) {
                AsyncMiddleManServlet.this._log.debug("{} proxying content to downstream: {} bytes {}", AsyncMiddleManServlet.this.getRequestId(this.clientRequest), content.remaining(), callback);
            }
            return this.chunks.offer(new DeferredContentProvider.Chunk(content, callback));
        }

        public void onWritePossible() throws IOException {
            ServletOutputStream output = this.clientRequest.getAsyncContext().getResponse().getOutputStream();
            if (this.writePending) {
                if (AsyncMiddleManServlet.this._log.isDebugEnabled()) {
                    AsyncMiddleManServlet.this._log.debug("{} pending async write complete of {} on {}", AsyncMiddleManServlet.this.getRequestId(this.clientRequest), this.chunk, output);
                }
                this.writePending = false;
                if (this.succeed(this.chunk.callback)) {
                    return;
                }
            }
            int length = 0;
            DeferredContentProvider.Chunk chunk = null;
            while (output.isReady()) {
                if (chunk != null) {
                    if (AsyncMiddleManServlet.this._log.isDebugEnabled()) {
                        AsyncMiddleManServlet.this._log.debug("{} async write complete of {} ({} bytes) on {}", AsyncMiddleManServlet.this.getRequestId(this.clientRequest), chunk, length, output);
                    }
                    if (this.succeed(chunk.callback)) {
                        return;
                    }
                }
                this.chunk = chunk = this.chunks.poll();
                if (chunk == null) {
                    return;
                }
                length = chunk.buffer.remaining();
                if (length <= 0) continue;
                AsyncMiddleManServlet.this.writeProxyResponseContent(output, chunk.buffer);
            }
            if (AsyncMiddleManServlet.this._log.isDebugEnabled()) {
                AsyncMiddleManServlet.this._log.debug("{} async write pending of {} ({} bytes) on {}", AsyncMiddleManServlet.this.getRequestId(this.clientRequest), chunk, length, output);
            }
            this.writePending = true;
        }

        private boolean succeed(Callback callback) {
            callback.succeeded();
            return this.writePending;
        }

        public void onError(Throwable failure) {
            DeferredContentProvider.Chunk chunk = this.chunk;
            if (chunk != null) {
                chunk.callback.failed(failure);
            } else {
                this.serverResponse.abort(failure);
            }
        }
    }

    protected class ProxyResponseListener
    extends Response.Listener.Adapter
    implements Callback {
        private final String WRITE_LISTENER_ATTRIBUTE = AsyncMiddleManServlet.class.getName() + ".writeListener";
        private final Callback complete = new CountingCallback(this, 2);
        private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        private final HttpServletRequest clientRequest;
        private final HttpServletResponse proxyResponse;
        private boolean hasContent;
        private long contentLength;
        private long length;
        private Response response;

        protected ProxyResponseListener(HttpServletRequest clientRequest, HttpServletResponse proxyResponse) {
            this.clientRequest = clientRequest;
            this.proxyResponse = proxyResponse;
        }

        @Override
        public void onBegin(Response serverResponse) {
            this.proxyResponse.setStatus(serverResponse.getStatus());
        }

        @Override
        public void onHeaders(Response serverResponse) {
            this.contentLength = serverResponse.getHeaders().getLongField(HttpHeader.CONTENT_LENGTH.asString());
            AsyncMiddleManServlet.this.onServerResponseHeaders(this.clientRequest, this.proxyResponse, serverResponse);
        }

        @Override
        public void onContent(Response serverResponse, ByteBuffer content, Callback callback) {
            try {
                ContentTransformer transformer;
                boolean committed;
                int contentBytes = content.remaining();
                if (AsyncMiddleManServlet.this._log.isDebugEnabled()) {
                    AsyncMiddleManServlet.this._log.debug("{} received server content: {} bytes", AsyncMiddleManServlet.this.getRequestId(this.clientRequest), contentBytes);
                }
                this.hasContent = true;
                ProxyWriter proxyWriter = (ProxyWriter)this.clientRequest.getAttribute(this.WRITE_LISTENER_ATTRIBUTE);
                boolean bl = committed = proxyWriter != null;
                if (proxyWriter == null) {
                    proxyWriter = AsyncMiddleManServlet.this.newProxyWriteListener(this.clientRequest, serverResponse);
                    this.clientRequest.setAttribute(this.WRITE_LISTENER_ATTRIBUTE, (Object)proxyWriter);
                }
                if ((transformer = (ContentTransformer)this.clientRequest.getAttribute(SERVER_TRANSFORMER)) == null) {
                    transformer = AsyncMiddleManServlet.this.newServerResponseContentTransformer(this.clientRequest, this.proxyResponse, serverResponse);
                    this.clientRequest.setAttribute(SERVER_TRANSFORMER, (Object)transformer);
                }
                this.length += (long)contentBytes;
                boolean finished = this.contentLength >= 0L && this.length == this.contentLength;
                AsyncMiddleManServlet.this.transform(transformer, content, finished, this.buffers);
                int newContentBytes = 0;
                int size = this.buffers.size();
                if (size > 0) {
                    Callback counter = size == 1 ? callback : new CountingCallback(callback, size);
                    for (int i = 0; i < size; ++i) {
                        ByteBuffer buffer = this.buffers.get(i);
                        newContentBytes += buffer.remaining();
                        proxyWriter.offer(buffer, counter);
                    }
                    this.buffers.clear();
                } else {
                    proxyWriter.offer(BufferUtil.EMPTY_BUFFER, callback);
                }
                if (finished) {
                    proxyWriter.offer(BufferUtil.EMPTY_BUFFER, this.complete);
                }
                if (AsyncMiddleManServlet.this._log.isDebugEnabled()) {
                    AsyncMiddleManServlet.this._log.debug("{} downstream content transformation {} -> {} bytes", AsyncMiddleManServlet.this.getRequestId(this.clientRequest), contentBytes, newContentBytes);
                }
                if (committed) {
                    proxyWriter.onWritePossible();
                } else {
                    if (this.contentLength >= 0L) {
                        this.proxyResponse.setContentLength(-1);
                    }
                    this.proxyResponse.getOutputStream().setWriteListener((WriteListener)proxyWriter);
                }
            }
            catch (Throwable x) {
                callback.failed(x);
            }
        }

        @Override
        public void onSuccess(Response serverResponse) {
            try {
                if (this.hasContent) {
                    if (this.contentLength < 0L) {
                        ProxyWriter proxyWriter = (ProxyWriter)this.clientRequest.getAttribute(this.WRITE_LISTENER_ATTRIBUTE);
                        ContentTransformer transformer = (ContentTransformer)this.clientRequest.getAttribute(SERVER_TRANSFORMER);
                        AsyncMiddleManServlet.this.transform(transformer, BufferUtil.EMPTY_BUFFER, true, this.buffers);
                        long newContentBytes = 0L;
                        int size = this.buffers.size();
                        if (size > 0) {
                            Callback callback = size == 1 ? this.complete : new CountingCallback(this.complete, size);
                            for (int i = 0; i < size; ++i) {
                                ByteBuffer buffer = this.buffers.get(i);
                                newContentBytes += (long)buffer.remaining();
                                proxyWriter.offer(buffer, callback);
                            }
                            this.buffers.clear();
                        } else {
                            proxyWriter.offer(BufferUtil.EMPTY_BUFFER, this.complete);
                        }
                        if (AsyncMiddleManServlet.this._log.isDebugEnabled()) {
                            AsyncMiddleManServlet.this._log.debug("{} downstream content transformation to {} bytes", AsyncMiddleManServlet.this.getRequestId(this.clientRequest), newContentBytes);
                        }
                        proxyWriter.onWritePossible();
                    }
                } else {
                    this.complete.succeeded();
                }
            }
            catch (Throwable x) {
                this.complete.failed(x);
            }
        }

        @Override
        public void onComplete(Result result2) {
            this.response = result2.getResponse();
            if (result2.isSucceeded()) {
                this.complete.succeeded();
            } else {
                this.complete.failed(result2.getFailure());
            }
        }

        @Override
        public void succeeded() {
            AsyncMiddleManServlet.this.cleanup(this.clientRequest);
            AsyncMiddleManServlet.this.onProxyResponseSuccess(this.clientRequest, this.proxyResponse, this.response);
        }

        @Override
        public void failed(Throwable failure) {
            AsyncMiddleManServlet.this.cleanup(this.clientRequest);
            AsyncMiddleManServlet.this.onProxyResponseFailure(this.clientRequest, this.proxyResponse, this.response, failure);
        }
    }

    protected class ProxyReader
    extends IteratingCallback
    implements ReadListener {
        private final byte[] buffer;
        private final List<ByteBuffer> buffers;
        private final HttpServletRequest clientRequest;
        private final HttpServletResponse proxyResponse;
        private final Request proxyRequest;
        private final DeferredContentProvider provider;
        private final int contentLength;
        private int length;

        protected ProxyReader(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Request proxyRequest, DeferredContentProvider provider) {
            this.buffer = new byte[AsyncMiddleManServlet.this.getHttpClient().getRequestBufferSize()];
            this.buffers = new ArrayList<ByteBuffer>();
            this.clientRequest = clientRequest;
            this.proxyResponse = proxyResponse;
            this.proxyRequest = proxyRequest;
            this.provider = provider;
            this.contentLength = clientRequest.getContentLength();
        }

        public void onDataAvailable() throws IOException {
            this.iterate();
        }

        public void onAllDataRead() throws IOException {
            if (!this.provider.isClosed()) {
                this.process(BufferUtil.EMPTY_BUFFER, new Callback(){

                    @Override
                    public void failed(Throwable x) {
                        ProxyReader.this.onError(x);
                    }
                }, true);
            }
            if (AsyncMiddleManServlet.this._log.isDebugEnabled()) {
                AsyncMiddleManServlet.this._log.debug("{} proxying content to upstream completed", AsyncMiddleManServlet.this.getRequestId(this.clientRequest));
            }
        }

        public void onError(Throwable t) {
            AsyncMiddleManServlet.this.cleanup(this.clientRequest);
            AsyncMiddleManServlet.this.onClientRequestFailure(this.clientRequest, this.proxyRequest, this.proxyResponse, t);
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            ServletInputStream input = this.clientRequest.getInputStream();
            while (input.isReady() && !input.isFinished()) {
                int read2 = AsyncMiddleManServlet.this.readClientRequestContent(input, this.buffer);
                if (AsyncMiddleManServlet.this._log.isDebugEnabled()) {
                    AsyncMiddleManServlet.this._log.debug("{} asynchronous read {} bytes on {}", AsyncMiddleManServlet.this.getRequestId(this.clientRequest), read2, input);
                }
                if (read2 < 0) {
                    return IteratingCallback.Action.SUCCEEDED;
                }
                if (this.contentLength > 0 && read2 > 0) {
                    this.length += read2;
                }
                ByteBuffer content = read2 > 0 ? ByteBuffer.wrap(this.buffer, 0, read2) : BufferUtil.EMPTY_BUFFER;
                boolean finished = this.length == this.contentLength;
                this.process(content, this, finished);
                if (read2 <= 0) continue;
                return IteratingCallback.Action.SCHEDULED;
            }
            if (input.isFinished()) {
                if (AsyncMiddleManServlet.this._log.isDebugEnabled()) {
                    AsyncMiddleManServlet.this._log.debug("{} asynchronous read complete on {}", AsyncMiddleManServlet.this.getRequestId(this.clientRequest), input);
                }
                return IteratingCallback.Action.SUCCEEDED;
            }
            if (AsyncMiddleManServlet.this._log.isDebugEnabled()) {
                AsyncMiddleManServlet.this._log.debug("{} asynchronous read pending on {}", AsyncMiddleManServlet.this.getRequestId(this.clientRequest), input);
            }
            return IteratingCallback.Action.IDLE;
        }

        private void process(ByteBuffer content, Callback callback, boolean finished) throws IOException {
            ContentTransformer transformer = (ContentTransformer)this.clientRequest.getAttribute(CLIENT_TRANSFORMER);
            if (transformer == null) {
                transformer = AsyncMiddleManServlet.this.newClientRequestContentTransformer(this.clientRequest, this.proxyRequest);
                this.clientRequest.setAttribute(CLIENT_TRANSFORMER, (Object)transformer);
            }
            boolean committed = this.clientRequest.getAttribute(PROXY_REQUEST_COMMITTED) != null;
            int contentBytes = content.remaining();
            if (contentBytes == 0 && !finished) {
                callback.succeeded();
                return;
            }
            AsyncMiddleManServlet.this.transform(transformer, content, finished, this.buffers);
            int newContentBytes = 0;
            int size = this.buffers.size();
            if (size > 0) {
                CountingCallback counter = new CountingCallback(callback, size);
                for (int i = 0; i < size; ++i) {
                    ByteBuffer buffer = this.buffers.get(i);
                    newContentBytes += buffer.remaining();
                    this.provider.offer(buffer, counter);
                }
                this.buffers.clear();
            }
            if (finished) {
                this.provider.close();
            }
            if (AsyncMiddleManServlet.this._log.isDebugEnabled()) {
                AsyncMiddleManServlet.this._log.debug("{} upstream content transformation {} -> {} bytes", AsyncMiddleManServlet.this.getRequestId(this.clientRequest), contentBytes, newContentBytes);
            }
            if (!committed && (size > 0 || finished)) {
                this.proxyRequest.header(HttpHeader.CONTENT_LENGTH, null);
                this.clientRequest.setAttribute(PROXY_REQUEST_COMMITTED, (Object)true);
                AsyncMiddleManServlet.this.sendProxyRequest(this.clientRequest, this.proxyResponse, this.proxyRequest);
            }
            if (size == 0) {
                callback.succeeded();
            }
        }

        @Override
        protected void onCompleteFailure(Throwable x) {
            this.onError(x);
        }
    }

    public static class Transparent
    extends ProxyServlet {
        private final AbstractProxyServlet.TransparentDelegate delegate = new AbstractProxyServlet.TransparentDelegate(this);

        public void init(ServletConfig config) throws ServletException {
            super.init(config);
            this.delegate.init(config);
        }

        @Override
        protected String rewriteTarget(HttpServletRequest request) {
            return this.delegate.rewriteTarget(request);
        }
    }
}

