/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public class DateTimeMath {
    protected Calendar calUtc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    protected Calendar calLocal = Calendar.getInstance();
    protected NanosResult nanosResult = new NanosResult();

    public long addMonthsToMillisUtc(long millis, int months) {
        this.calUtc.setTimeInMillis(millis);
        this.calUtc.add(2, months);
        return this.calUtc.getTimeInMillis();
    }

    public long addMonthsToMillisLocal(long millis, int months) {
        this.calLocal.setTimeInMillis(millis);
        this.calLocal.add(2, months);
        return this.calLocal.getTimeInMillis();
    }

    public long addMonthsToNanosUtc(long nanos, int months) {
        long result = this.addMonthsToMillisUtc(nanos / 1000000L, months) * 1000000L + nanos % 1000000L;
        return result;
    }

    public long addMonthsToNanosLocal(long nanos, int months) {
        long result = this.addMonthsToMillisLocal(nanos / 1000000L, months) * 1000000L + nanos % 1000000L;
        return result;
    }

    public long addMonthsToDays(long days, int months) {
        long millis = DateWritable.daysToMillis((int)days);
        millis = this.addMonthsToMillisLocal(millis, months);
        return DateWritable.millisToDays(millis);
    }

    public Timestamp add(Timestamp ts, HiveIntervalYearMonth interval) {
        if (ts == null || interval == null) {
            return null;
        }
        long resultMillis = this.addMonthsToMillisUtc(ts.getTime(), interval.getTotalMonths());
        Timestamp tsResult = new Timestamp(resultMillis);
        tsResult.setNanos(ts.getNanos());
        return tsResult;
    }

    public Date add(Date dt, HiveIntervalYearMonth interval) {
        if (dt == null || interval == null) {
            return null;
        }
        long resultMillis = this.addMonthsToMillisLocal(dt.getTime(), interval.getTotalMonths());
        return new Date(resultMillis);
    }

    public HiveIntervalYearMonth add(HiveIntervalYearMonth left, HiveIntervalYearMonth right) {
        HiveIntervalYearMonth result = null;
        if (left == null || right == null) {
            return null;
        }
        result = new HiveIntervalYearMonth(left.getTotalMonths() + right.getTotalMonths());
        return result;
    }

    public Timestamp subtract(Timestamp left, HiveIntervalYearMonth right) {
        if (left == null || right == null) {
            return null;
        }
        return this.add(left, right.negate());
    }

    public Date subtract(Date left, HiveIntervalYearMonth right) {
        if (left == null || right == null) {
            return null;
        }
        return this.add(left, right.negate());
    }

    public HiveIntervalYearMonth subtract(HiveIntervalYearMonth left, HiveIntervalYearMonth right) {
        if (left == null || right == null) {
            return null;
        }
        return this.add(left, right.negate());
    }

    public Timestamp add(Timestamp ts, HiveIntervalDayTime interval) {
        if (ts == null || interval == null) {
            return null;
        }
        this.nanosResult.addNanos(ts.getNanos(), interval.getNanos());
        long newMillis = ts.getTime() + TimeUnit.SECONDS.toMillis(interval.getTotalSeconds() + (long)this.nanosResult.seconds);
        Timestamp tsResult = new Timestamp(newMillis);
        tsResult.setNanos(this.nanosResult.nanos);
        return tsResult;
    }

    public HiveIntervalDayTime add(HiveIntervalDayTime left, HiveIntervalDayTime right) {
        HiveIntervalDayTime result = null;
        if (left == null || right == null) {
            return null;
        }
        this.nanosResult.addNanos(left.getNanos(), right.getNanos());
        long totalSeconds = left.getTotalSeconds() + right.getTotalSeconds() + (long)this.nanosResult.seconds;
        result = new HiveIntervalDayTime(totalSeconds, this.nanosResult.nanos);
        return result;
    }

    public Timestamp subtract(Timestamp left, HiveIntervalDayTime right) {
        if (left == null || right == null) {
            return null;
        }
        return this.add(left, right.negate());
    }

    public HiveIntervalDayTime subtract(HiveIntervalDayTime left, HiveIntervalDayTime right) {
        if (left == null || right == null) {
            return null;
        }
        return this.add(left, right.negate());
    }

    public HiveIntervalDayTime subtract(Timestamp left, Timestamp right) {
        HiveIntervalDayTime result = null;
        if (left == null || right == null) {
            return null;
        }
        this.nanosResult.addNanos(left.getNanos(), -right.getNanos());
        long totalSeconds = TimeUnit.MILLISECONDS.toSeconds(left.getTime()) - TimeUnit.MILLISECONDS.toSeconds(right.getTime()) + (long)this.nanosResult.seconds;
        result = new HiveIntervalDayTime(totalSeconds, this.nanosResult.nanos);
        return result;
    }

    private static class NanosResult {
        public int seconds;
        public int nanos;

        private NanosResult() {
        }

        public void addNanos(int leftNanos, int rightNanos) {
            this.seconds = 0;
            this.nanos = leftNanos + rightNanos;
            if (this.nanos < 0) {
                this.seconds = -1;
                this.nanos += 1000000000;
            } else if (this.nanos >= 1000000000) {
                this.seconds = 1;
                this.nanos -= 1000000000;
            }
        }
    }
}

