/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FormatNumber$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr1, expr2) - Formats the number `expr1` like '#,###,###.##', rounded to `expr2`\n      decimal places. If `expr2` is 0, the result has no decimal point or fractional part.\n      This is supposed to function like MySQL's FORMAT.\n  ", extended="\n    Examples:\n      > SELECT _FUNC_(12332.123456, 4);\n       12,332.1235\n  ")
@ScalaSignature(bytes="\u0006\u0001\t]a\u0001B\u0001\u0003\u0001>\u0011ABR8s[\u0006$h*^7cKJT!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001A!r#\b\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005E)\u0012B\u0001\f\u0003\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%A\u0001y+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0003q\u0002B\u0001\"\u000b\u0001\u0003\u0016\u0004%\tAI\u0001\u0002I\"A1\u0006\u0001B\tB\u0003%1%\u0001\u0002eA!)Q\u0006\u0001C\u0001]\u00051A(\u001b8jiz\"2a\f\u00192!\t\t\u0002\u0001C\u0003\"Y\u0001\u00071\u0005C\u0003*Y\u0001\u00071\u0005C\u00034\u0001\u0011\u0005#%\u0001\u0003mK\u001a$\b\"B\u001b\u0001\t\u0003\u0012\u0013!\u0002:jO\"$\b\"B\u001c\u0001\t\u0003B\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0004\u0002\u000bQL\b/Z:\n\u0005yZ$\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000b\u0001\u0003A\u0011I!\u0002\u00119,H\u000e\\1cY\u0016,\u0012A\u0011\t\u00031\rK!\u0001R\r\u0003\u000f\t{w\u000e\\3b]\")a\t\u0001C!\u000f\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003!\u00032!S)U\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002N\u001d\u00051AH]8pizJ\u0011AG\u0005\u0003!f\tq\u0001]1dW\u0006<W-\u0003\u0002S'\n\u00191+Z9\u000b\u0005AK\u0002C\u0001\u001eV\u0013\t16H\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\"9\u0001\f\u0001a\u0001\n\u0013I\u0016A\u00037bgR$e+\u00197vKV\t!\fE\u0002\u00197vK!\u0001X\r\u0003\r=\u0003H/[8o!\tAb,\u0003\u0002`3\t\u0019\u0011J\u001c;\t\u000f\u0005\u0004\u0001\u0019!C\u0005E\u0006qA.Y:u\tZ\u000bG.^3`I\u0015\fHCA2g!\tAB-\u0003\u0002f3\t!QK\\5u\u0011\u001d9\u0007-!AA\u0002i\u000b1\u0001\u001f\u00132\u0011\u0019I\u0007\u0001)Q\u00055\u0006YA.Y:u\tZ\u000bG.^3!Q\tA7\u000e\u0005\u0002\u0019Y&\u0011Q.\u0007\u0002\niJ\fgn]5f]RD\u0001b\u001c\u0001\t\u0006\u0004%I\u0001]\u0001\ba\u0006$H/\u001a:o+\u0005\t\bC\u0001:x\u001b\u0005\u0019(B\u0001;v\u0003\u0011a\u0017M\\4\u000b\u0003Y\fAA[1wC&\u0011\u0001p\u001d\u0002\r'R\u0014\u0018N\\4Ck\u001a4WM\u001d\u0005\tu\u0002A\t\u0011)Q\u0005c\u0006A\u0001/\u0019;uKJt\u0007\u0005\u000b\u0002zW\"AQ\u0010\u0001EC\u0002\u0013%a0\u0001\u0007ok6\u0014WM\u001d$pe6\fG/F\u0001\u0000!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003k\u0006!A/\u001a=u\u0013\u0011\tI!a\u0001\u0003\u001b\u0011+7-[7bY\u001a{'/\\1u\u0011%\ti\u0001\u0001E\u0001B\u0003&q0A\u0007ok6\u0014WM\u001d$pe6\fG\u000f\t\u0015\u0004\u0003\u0017Y\u0007bBA\n\u0001\u0011E\u0013QC\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0007\u0003/\ti\"!\t\u0011\u0007a\tI\"C\u0002\u0002\u001ce\u00111!\u00118z\u0011!\ty\"!\u0005A\u0002\u0005]\u0011a\u0002=PE*,7\r\u001e\u0005\t\u0003G\t\t\u00021\u0001\u0002\u0018\u00059Am\u00142kK\u000e$\bbBA\u0014\u0001\u0011\u0005\u0013\u0011F\u0001\nI><UM\\\"pI\u0016$b!a\u000b\u00028\u0005\u0005\u0003\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005E\"!A\u0004d_\u0012,w-\u001a8\n\t\u0005U\u0012q\u0006\u0002\t\u000bb\u0004(oQ8eK\"A\u0011\u0011HA\u0013\u0001\u0004\tY$A\u0002dib\u0004B!!\f\u0002>%!\u0011qHA\u0018\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRD\u0001\"a\u0011\u0002&\u0001\u0007\u00111F\u0001\u0003KZDq!a\u0012\u0001\t\u0003\nI%\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u0013\u0011\t\u00055\u00131\u000b\b\u00041\u0005=\u0013bAA)3\u00051\u0001K]3eK\u001aLA!!\u0016\u0002X\t11\u000b\u001e:j]\u001eT1!!\u0015\u001a\u0011%\tY\u0006AA\u0001\n\u0003\ti&\u0001\u0003d_BLH#B\u0018\u0002`\u0005\u0005\u0004\u0002C\u0011\u0002ZA\u0005\t\u0019A\u0012\t\u0011%\nI\u0006%AA\u0002\rB\u0011\"!\u001a\u0001#\u0003%\t!a\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u000e\u0016\u0004G\u0005-4FAA7!\u0011\ty'!\u001f\u000e\u0005\u0005E$\u0002BA:\u0003k\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]\u0014$\u0001\u0006b]:|G/\u0019;j_:LA!a\u001f\u0002r\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005}\u0004!%A\u0005\u0002\u0005\u001d\u0014AD2paf$C-\u001a4bk2$HE\r\u0005\n\u0003\u0007\u0003\u0011\u0011!C!\u0003\u000b\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAD!\r\u0011\u0018\u0011R\u0005\u0004\u0003+\u001a\b\"CAG\u0001\u0005\u0005I\u0011AAH\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005i\u0006\"CAJ\u0001\u0005\u0005I\u0011AAK\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0006\u0002\u0018\"Aq-!%\u0002\u0002\u0003\u0007Q\fC\u0005\u0002\u001c\u0002\t\t\u0011\"\u0011\u0002\u001e\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002 B1\u0011\u0011UAT\u0003/i!!a)\u000b\u0007\u0005\u0015\u0016$\u0001\u0006d_2dWm\u0019;j_:LA!!+\u0002$\nA\u0011\n^3sCR|'\u000fC\u0005\u0002.\u0002\t\t\u0011\"\u0001\u00020\u0006A1-\u00198FcV\fG\u000eF\u0002C\u0003cC\u0011bZAV\u0003\u0003\u0005\r!a\u0006\t\u0013\u0005U\u0006!!A\u0005B\u0005]\u0016AB3rk\u0006d7\u000fF\u0002C\u0003sC\u0011bZAZ\u0003\u0003\u0005\r!a\u0006)\u0017\u0001\ti,a1\u0002F\u0006%\u00171\u001a\t\u0004#\u0005}\u0016bAAa\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAd\u0003\u0005%(\u0002\t\u0011!A}3UKT\"`Q\u0015D\bO]\u0019-A\u0015D\bO\u001d\u001a*A5\u0002ci\u001c:nCR\u001c\b\u0005\u001e5fA9,XNY3sA\u0001,\u0007\u0010\u001d:2A\u0002b\u0017n[3!O\rb3eI\u0012-G\r\u001acfI\u0012(Y\u0001\u0012x.\u001e8eK\u0012\u0004Co\u001c\u0011aKb\u0004(O\r1\u000bA\u0001\u0002\u0003\u0005\t\u0011eK\u000eLW.\u00197!a2\f7-Z:/A%3\u0007\u0005Y3yaJ\u0014\u0004\rI5tAAb\u0003\u0005\u001e5fAI,7/\u001e7uA!\f7\u000f\t8pA\u0011,7-[7bY\u0002\u0002x.\u001b8uA=\u0014\bE\u001a:bGRLwN\\1mAA\f'\u000f\u001e\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011UQ&\u001c\b%[:!gV\u0004\bo\\:fI\u0002\"x\u000e\t4v]\u000e$\u0018n\u001c8!Y&\\W\rI'z'Fcue\u001d\u0011G\u001fJk\u0015\t\u0016\u0018\u000bA\u0001\n\u0001\"\u001a=uK:$W\rZ\u0011\u0003\u0003\u001b\fAJ\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152eM\u001a$GL\u00193gQ*d\u0007\f\u00115SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013G\r\u00174gIr\u0013GM\u001a6\u0015\u0001\u0002s!CAi\u0005\u0005\u0005\t\u0012AAj\u000311uN]7bi:+XNY3s!\r\t\u0012Q\u001b\u0004\t\u0003\t\t\t\u0011#\u0001\u0002XN)\u0011Q[Am;A9\u00111\\AqG\rzSBAAo\u0015\r\ty.G\u0001\beVtG/[7f\u0013\u0011\t\u0019/!8\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004.\u0003+$\t!a:\u0015\u0005\u0005M\u0007BCAv\u0003+\f\t\u0011\"\u0012\u0002n\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\b\"Q\u0011\u0011_Ak\u0003\u0003%\t)a=\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b=\n)0a>\t\r\u0005\ny\u000f1\u0001$\u0011\u0019I\u0013q\u001ea\u0001G!Q\u00111`Ak\u0003\u0003%\t)!@\u0002\u000fUt\u0017\r\u001d9msR!\u0011q B\u0004!\u0011A2L!\u0001\u0011\u000ba\u0011\u0019aI\u0012\n\u0007\t\u0015\u0011D\u0001\u0004UkBdWM\r\u0005\n\u0005\u0013\tI0!AA\u0002=\n1\u0001\u001f\u00131\u0011)\u0011i!!6\u0002\u0002\u0013%!qB\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0012A\u0019!Oa\u0005\n\u0007\tU1O\u0001\u0004PE*,7\r\u001e")
public class FormatNumber
extends BinaryExpression
implements ExpectsInputTypes,
Serializable {
    private final Expression x;
    private final Expression d;
    private transient Option<Object> lastDValue;
    private transient StringBuffer pattern;
    private transient DecimalFormat numberFormat;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(FormatNumber formatNumber) {
        return FormatNumber$.MODULE$.unapply(formatNumber);
    }

    public static Function1<Tuple2<Expression, Expression>, FormatNumber> tupled() {
        return FormatNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FormatNumber>> curried() {
        return FormatNumber$.MODULE$.curried();
    }

    private StringBuffer pattern$lzycompute() {
        FormatNumber formatNumber = this;
        synchronized (formatNumber) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.pattern = new StringBuffer();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.pattern;
        }
    }

    private DecimalFormat numberFormat$lzycompute() {
        FormatNumber formatNumber = this;
        synchronized (formatNumber) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.numberFormat = new DecimalFormat("", new DecimalFormatSymbols(Locale.US));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.numberFormat;
        }
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression x() {
        return this.x;
    }

    public Expression d() {
        return this.d;
    }

    @Override
    public Expression left() {
        return this.x();
    }

    @Override
    public Expression right() {
        return this.d();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, IntegerType$.MODULE$}));
    }

    private Option<Object> lastDValue() {
        return this.lastDValue;
    }

    private void lastDValue_$eq(Option<Object> x$1) {
        this.lastDValue = x$1;
    }

    private StringBuffer pattern() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.pattern$lzycompute() : this.pattern;
    }

    private DecimalFormat numberFormat() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.numberFormat$lzycompute() : this.numberFormat;
    }

    @Override
    public Object nullSafeEval(Object xObject, Object dObject) {
        DataType dataType2;
        block15: {
            UTF8String uTF8String;
            block9: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        Some some;
                                        int last;
                                        int dValue = BoxesRunTime.unboxToInt((Object)dObject);
                                        if (dValue < 0) {
                                            return null;
                                        }
                                        Option<Object> option = this.lastDValue();
                                        if (option instanceof Some && (last = BoxesRunTime.unboxToInt((Object)(some = (Some)option).x())) == dValue) {
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            this.pattern().delete(0, this.pattern().length());
                                            this.pattern().append("#,###,###,###,###,###,##0");
                                            if (dValue > 0) {
                                                this.pattern().append(".");
                                                for (int i = 0; i < dValue; ++i) {
                                                    this.pattern().append("0");
                                                }
                                            }
                                            this.lastDValue_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)dValue)));
                                            this.numberFormat().applyLocalizedPattern(this.pattern().toString());
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        }
                                        dataType2 = this.x().dataType();
                                        if (!ByteType$.MODULE$.equals(dataType2)) break block8;
                                        uTF8String = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToByte((Object)xObject)));
                                        break block9;
                                    }
                                    if (!ShortType$.MODULE$.equals(dataType2)) break block10;
                                    uTF8String = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToShort((Object)xObject)));
                                    break block9;
                                }
                                if (!FloatType$.MODULE$.equals(dataType2)) break block11;
                                uTF8String = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToFloat((Object)xObject)));
                                break block9;
                            }
                            if (!IntegerType$.MODULE$.equals(dataType2)) break block12;
                            uTF8String = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToInt((Object)xObject)));
                            break block9;
                        }
                        if (!LongType$.MODULE$.equals(dataType2)) break block13;
                        uTF8String = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToLong((Object)xObject)));
                        break block9;
                    }
                    if (!DoubleType$.MODULE$.equals(dataType2)) break block14;
                    uTF8String = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToDouble((Object)xObject)));
                    break block9;
                }
                if (!(dataType2 instanceof DecimalType)) break block15;
                uTF8String = UTF8String.fromString((String)this.numberFormat().format(((Decimal)xObject).toJavaBigDecimal()));
            }
            return uTF8String;
        }
        throw new MatchError((Object)dataType2);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ctx, ev){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FormatNumber $outer;
            private final CodegenContext ctx$6;
            private final ExprCode ev$10;

            public final String apply(String num, String d) {
                String sb = StringBuffer.class.getName();
                String df = DecimalFormat.class.getName();
                String dfs = DecimalFormatSymbols.class.getName();
                String l = Locale.class.getName();
                String usLocale = "US";
                String lastDValue = this.ctx$6.freshName("lastDValue");
                String pattern = this.ctx$6.freshName("pattern");
                String numberFormat = this.ctx$6.freshName("numberFormat");
                String i = this.ctx$6.freshName("i");
                String dFormat = this.ctx$6.freshName("dFormat");
                this.ctx$6.addMutableState("int", lastDValue, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = -100;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lastDValue})));
                this.ctx$6.addMutableState(sb, pattern, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = new ", "();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pattern, sb})));
                this.ctx$6.addMutableState(df, numberFormat, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = new ", "(\"\", new ", "(", ".", "));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{numberFormat, df, dfs, l, usLocale})));
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        if (", " >= 0) {\n          ", ".delete(0, ", ".length());\n          if (", " != ", ") {\n            ", ".append(\"#,###,###,###,###,###,##0\");\n\n            if (", " > 0) {\n              ", ".append(\".\");\n              for (int ", " = 0; ", " < ", "; ", "++) {\n                ", ".append(\"0\");\n              }\n            }\n            ", " = ", ";\n            ", ".applyLocalizedPattern(", ".toString());\n          }\n          ", " = UTF8String.fromString(", ".format(", "));\n        } else {\n          ", " = null;\n          ", " = true;\n        }\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d, pattern, pattern, d, lastDValue, pattern, d, pattern, i, i, d, i, pattern, lastDValue, d, numberFormat, pattern, this.ev$10.value(), numberFormat, this.typeHelper$1(num), this.ev$10.value(), this.ev$10.isNull()}));
            }

            private final String typeHelper$1(String p) {
                DataType dataType2 = this.$outer.x().dataType();
                String string = dataType2 instanceof DecimalType ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".toJavaBigDecimal()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p}));
                return string;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ctx$6 = ctx$6;
                this.ev$10 = ev$10;
            }
        });
    }

    @Override
    public String prettyName() {
        return "format_number";
    }

    public FormatNumber copy(Expression x, Expression d) {
        return new FormatNumber(x, d);
    }

    public Expression copy$default$1() {
        return this.x();
    }

    public Expression copy$default$2() {
        return this.d();
    }

    @Override
    public String productPrefix() {
        return "FormatNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.d();
                break;
            }
            case 0: {
                expression = this.x();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FormatNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FormatNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        FormatNumber formatNumber = (FormatNumber)x$1;
        Expression expression = this.x();
        Expression expression2 = formatNumber.x();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.d();
        Expression expression4 = formatNumber.d();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!formatNumber.canEqual(this)) return false;
        return true;
    }

    public FormatNumber(Expression x, Expression d) {
        this.x = x;
        this.d = d;
        ExpectsInputTypes$class.$init$(this);
        this.lastDValue = None$.MODULE$;
    }
}

