/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.analysis.FunctionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CreateDatabaseEvent;
import org.apache.spark.sql.catalyst.catalog.CreateDatabasePreEvent;
import org.apache.spark.sql.catalyst.catalog.CreateFunctionEvent;
import org.apache.spark.sql.catalyst.catalog.CreateFunctionPreEvent;
import org.apache.spark.sql.catalyst.catalog.CreateTableEvent;
import org.apache.spark.sql.catalyst.catalog.CreateTablePreEvent;
import org.apache.spark.sql.catalyst.catalog.DropDatabaseEvent;
import org.apache.spark.sql.catalyst.catalog.DropDatabasePreEvent;
import org.apache.spark.sql.catalyst.catalog.DropFunctionEvent;
import org.apache.spark.sql.catalyst.catalog.DropFunctionPreEvent;
import org.apache.spark.sql.catalyst.catalog.DropTableEvent;
import org.apache.spark.sql.catalyst.catalog.DropTablePreEvent;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogEvent;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogEventListener;
import org.apache.spark.sql.catalyst.catalog.RenameFunctionEvent;
import org.apache.spark.sql.catalyst.catalog.RenameFunctionPreEvent;
import org.apache.spark.sql.catalyst.catalog.RenameTableEvent;
import org.apache.spark.sql.catalyst.catalog.RenameTablePreEvent;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ListenerBus;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r\rc!B\u0001\u0003\u0003\u0003y!aD#yi\u0016\u0014h.\u00197DCR\fGn\\4\u000b\u0005\r!\u0011aB2bi\u0006dwn\u001a\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A1\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0003\u00185q\u0001S\"\u0001\r\u000b\u0005eA\u0011\u0001B;uS2L!a\u0007\r\u0003\u00171K7\u000f^3oKJ\u0014Uo\u001d\t\u0003;yi\u0011AA\u0005\u0003?\t\u0011A$\u0012=uKJt\u0017\r\\\"bi\u0006dwnZ#wK:$H*[:uK:,'\u000f\u0005\u0002\u001eC%\u0011!E\u0001\u0002\u0015\u000bb$XM\u001d8bY\u000e\u000bG/\u00197pO\u00163XM\u001c;\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\u00051\u0003CA\u000f\u0001\u0011\u0015A\u0003\u0001\"\u0005*\u0003=\u0011X-];je\u0016$%-\u0012=jgR\u001cHC\u0001\u0016.!\t\t2&\u0003\u0002-%\t!QK\\5u\u0011\u0015qs\u00051\u00010\u0003\t!'\r\u0005\u00021g9\u0011\u0011#M\u0005\u0003eI\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\u0019\u0019FO]5oO*\u0011!G\u0005\u0005\u0006o\u0001!\t\u0002O\u0001\u0013e\u0016\fX/\u001b:f)\u0006\u0014G.Z#ySN$8\u000fF\u0002+siBQA\f\u001cA\u0002=BQa\u000f\u001cA\u0002=\nQ\u0001^1cY\u0016DQ!\u0010\u0001\u0005\u0012y\nQC]3rk&\u0014XMR;oGRLwN\\#ySN$8\u000fF\u0002+\u007f\u0001CQA\f\u001fA\u0002=BQ!\u0011\u001fA\u0002=\n\u0001BZ;oG:\u000bW.\u001a\u0005\u0006\u0007\u0002!\t\u0002R\u0001\u0019e\u0016\fX/\u001b:f\rVt7\r^5p]:{G/\u0012=jgR\u001cHc\u0001\u0016F\r\")aF\u0011a\u0001_!)\u0011I\u0011a\u0001_!)\u0001\n\u0001C\u0003\u0013\u0006q1M]3bi\u0016$\u0015\r^1cCN,Gc\u0001\u0016K\u001f\")1j\u0012a\u0001\u0019\u0006aAM\u0019#fM&t\u0017\u000e^5p]B\u0011Q$T\u0005\u0003\u001d\n\u0011qbQ1uC2|w\rR1uC\n\f7/\u001a\u0005\u0006!\u001e\u0003\r!U\u0001\u000fS\u001etwN]3JM\u0016C\u0018n\u001d;t!\t\t\"+\u0003\u0002T%\t9!i\\8mK\u0006t\u0007\"B+\u0001\r#1\u0016\u0001\u00053p\u0007J,\u0017\r^3ECR\f'-Y:f)\rQs\u000b\u0017\u0005\u0006\u0017R\u0003\r\u0001\u0014\u0005\u0006!R\u0003\r!\u0015\u0005\u00065\u0002!)aW\u0001\rIJ|\u0007\u000fR1uC\n\f7/\u001a\u000b\u0005Uqkv\fC\u0003/3\u0002\u0007q\u0006C\u0003_3\u0002\u0007\u0011+A\tjO:|'/Z%g\u001d>$X\t_5tiNDQ\u0001Y-A\u0002E\u000bqaY1tG\u0006$W\rC\u0003c\u0001\u0019E1-\u0001\be_\u0012\u0013x\u000e\u001d#bi\u0006\u0014\u0017m]3\u0015\t)\"WM\u001a\u0005\u0006]\u0005\u0004\ra\f\u0005\u0006=\u0006\u0004\r!\u0015\u0005\u0006A\u0006\u0004\r!\u0015\u0005\u0006Q\u00021\t![\u0001\u000eC2$XM\u001d#bi\u0006\u0014\u0017m]3\u0015\u0005)R\u0007\"B&h\u0001\u0004a\u0005\"\u00027\u0001\r\u0003i\u0017aC4fi\u0012\u000bG/\u00192bg\u0016$\"\u0001\u00148\t\u000b9Z\u0007\u0019A\u0018\t\u000bA\u0004a\u0011A9\u0002\u001d\u0011\fG/\u00192bg\u0016,\u00050[:ugR\u0011\u0011K\u001d\u0005\u0006]=\u0004\ra\f\u0005\u0006i\u00021\t!^\u0001\u000eY&\u001cH\u000fR1uC\n\f7/Z:\u0015\u0003Y\u00042a^@0\u001d\tAXP\u0004\u0002zy6\t!P\u0003\u0002|\u001d\u00051AH]8pizJ\u0011aE\u0005\u0003}J\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0002\u0005\r!aA*fc*\u0011aP\u0005\u0005\u0007i\u00021\t!a\u0002\u0015\u0007Y\fI\u0001C\u0004\u0002\f\u0005\u0015\u0001\u0019A\u0018\u0002\u000fA\fG\u000f^3s]\"9\u0011q\u0002\u0001\u0007\u0002\u0005E\u0011AE:fi\u000e+(O]3oi\u0012\u000bG/\u00192bg\u0016$2AKA\n\u0011\u0019q\u0013Q\u0002a\u0001_!9\u0011q\u0003\u0001\u0005\u0006\u0005e\u0011aC2sK\u0006$X\rV1cY\u0016$RAKA\u000e\u0003KA\u0001\"!\b\u0002\u0016\u0001\u0007\u0011qD\u0001\u0010i\u0006\u0014G.\u001a#fM&t\u0017\u000e^5p]B\u0019Q$!\t\n\u0007\u0005\r\"A\u0001\u0007DCR\fGn\\4UC\ndW\r\u0003\u0004Q\u0003+\u0001\r!\u0015\u0005\b\u0003S\u0001a\u0011CA\u0016\u00035!wn\u0011:fCR,G+\u00192mKR)!&!\f\u00020!A\u0011QDA\u0014\u0001\u0004\ty\u0002\u0003\u0004Q\u0003O\u0001\r!\u0015\u0005\b\u0003g\u0001AQAA\u001b\u0003%!'o\u001c9UC\ndW\rF\u0005+\u0003o\tI$a\u000f\u0002>!1a&!\rA\u0002=BaaOA\u0019\u0001\u0004y\u0003B\u00020\u00022\u0001\u0007\u0011\u000bC\u0004\u0002@\u0005E\u0002\u0019A)\u0002\u000bA,(oZ3\t\u000f\u0005\r\u0003A\"\u0005\u0002F\u0005YAm\u001c#s_B$\u0016M\u00197f)%Q\u0013qIA%\u0003\u0017\ni\u0005\u0003\u0004/\u0003\u0003\u0002\ra\f\u0005\u0007w\u0005\u0005\u0003\u0019A\u0018\t\ry\u000b\t\u00051\u0001R\u0011\u001d\ty$!\u0011A\u0002ECq!!\u0015\u0001\t\u000b\t\u0019&A\u0006sK:\fW.\u001a+bE2,Gc\u0002\u0016\u0002V\u0005]\u00131\f\u0005\u0007]\u0005=\u0003\u0019A\u0018\t\u000f\u0005e\u0013q\na\u0001_\u00059q\u000e\u001c3OC6,\u0007bBA/\u0003\u001f\u0002\raL\u0001\b]\u0016<h*Y7f\u0011\u001d\t\t\u0007\u0001D\t\u0003G\nQ\u0002Z8SK:\fW.\u001a+bE2,Gc\u0002\u0016\u0002f\u0005\u001d\u0014\u0011\u000e\u0005\u0007]\u0005}\u0003\u0019A\u0018\t\u000f\u0005e\u0013q\fa\u0001_!9\u0011QLA0\u0001\u0004y\u0003bBA7\u0001\u0019\u0005\u0011qN\u0001\u000bC2$XM\u001d+bE2,Gc\u0001\u0016\u0002r!A\u0011QDA6\u0001\u0004\ty\u0002C\u0004\u0002v\u00011\t!a\u001e\u0002)\u0005dG/\u001a:UC\ndW\rR1uCN\u001b\u0007.Z7b)\u001dQ\u0013\u0011PA>\u0003{BaALA:\u0001\u0004y\u0003BB\u001e\u0002t\u0001\u0007q\u0006\u0003\u0005\u0002\u0000\u0005M\u0004\u0019AAA\u00035qWm\u001e#bi\u0006\u001c6\r[3nCB!\u00111QAE\u001b\t\t)IC\u0002\u0002\b\u001a\tQ\u0001^=qKNLA!a#\u0002\u0006\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u0005=\u0005A\"\u0001\u0002\u0012\u0006Aq-\u001a;UC\ndW\r\u0006\u0004\u0002 \u0005M\u0015Q\u0013\u0005\u0007]\u00055\u0005\u0019A\u0018\t\rm\ni\t1\u00010\u0011\u001d\tI\n\u0001D\u0001\u00037\u000b1\u0002^1cY\u0016,\u00050[:ugR)\u0011+!(\u0002 \"1a&a&A\u0002=BaaOAL\u0001\u0004y\u0003bBAR\u0001\u0019\u0005\u0011QU\u0001\u000bY&\u001cH\u000fV1cY\u0016\u001cHc\u0001<\u0002(\"1a&!)A\u0002=Bq!a)\u0001\r\u0003\tY\u000bF\u0003w\u0003[\u000by\u000b\u0003\u0004/\u0003S\u0003\ra\f\u0005\b\u0003\u0017\tI\u000b1\u00010\u0011\u001d\t\u0019\f\u0001D\u0001\u0003k\u000b\u0011\u0002\\8bIR\u000b'\r\\3\u0015\u0017)\n9,!/\u0002<\u0006}\u00161\u0019\u0005\u0007]\u0005E\u0006\u0019A\u0018\t\rm\n\t\f1\u00010\u0011\u001d\ti,!-A\u0002=\n\u0001\u0002\\8bIB\u000bG\u000f\u001b\u0005\b\u0003\u0003\f\t\f1\u0001R\u0003-I7o\u0014<fe^\u0014\u0018\u000e^3\t\u000f\u0005\u0015\u0017\u0011\u0017a\u0001#\u0006Q\u0011n]*sG2{7-\u00197\t\u000f\u0005%\u0007A\"\u0001\u0002L\u0006iAn\\1e!\u0006\u0014H/\u001b;j_:$rBKAg\u0003\u001f\f\t.a5\u0002f\u0006\u001d\u00181\u001e\u0005\u0007]\u0005\u001d\u0007\u0019A\u0018\t\rm\n9\r1\u00010\u0011\u001d\ti,a2A\u0002=B\u0001\"!6\u0002H\u0002\u0007\u0011q[\u0001\na\u0006\u0014H/\u001b;j_:\u0004B!!7\u0002`:\u0019Q$a7\n\u0007\u0005u'!\u0001\u0007DCR\fGn\\4UsB,7/\u0003\u0003\u0002b\u0006\r(A\u0005+bE2,\u0007+\u0019:uSRLwN\\*qK\u000eT1!!8\u0003\u0011\u001d\t\t-a2A\u0002ECq!!;\u0002H\u0002\u0007\u0011+A\tj]\",'/\u001b;UC\ndWm\u00159fGNDq!!2\u0002H\u0002\u0007\u0011\u000bC\u0004\u0002p\u00021\t!!=\u0002+1|\u0017\r\u001a#z]\u0006l\u0017n\u0019)beRLG/[8ogRi!&a=\u0002v\u0006]\u0018\u0011`A~\u0003\u007fDaALAw\u0001\u0004y\u0003BB\u001e\u0002n\u0002\u0007q\u0006C\u0004\u0002>\u00065\b\u0019A\u0018\t\u0011\u0005U\u0017Q\u001ea\u0001\u0003/Dq!!@\u0002n\u0002\u0007\u0011+A\u0004sKBd\u0017mY3\t\u0011\t\u0005\u0011Q\u001ea\u0001\u0005\u0007\tQA\\;n\tB\u00032!\u0005B\u0003\u0013\r\u00119A\u0005\u0002\u0004\u0013:$\bb\u0002B\u0006\u0001\u0019\u0005!QB\u0001\u0011GJ,\u0017\r^3QCJ$\u0018\u000e^5p]N$\u0012B\u000bB\b\u0005#\u0011\u0019Ba\b\t\r9\u0012I\u00011\u00010\u0011\u0019Y$\u0011\u0002a\u0001_!A!Q\u0003B\u0005\u0001\u0004\u00119\"A\u0003qCJ$8\u000f\u0005\u0003x\u007f\ne\u0001cA\u000f\u0003\u001c%\u0019!Q\u0004\u0002\u0003+\r\u000bG/\u00197pOR\u000b'\r\\3QCJ$\u0018\u000e^5p]\"1\u0001K!\u0003A\u0002ECqAa\t\u0001\r\u0003\u0011)#\u0001\bee>\u0004\b+\u0019:uSRLwN\\:\u0015\u001b)\u00129C!\u000b\u0003,\t=\"\u0011\u0007B\u001a\u0011\u0019q#\u0011\u0005a\u0001_!11H!\tA\u0002=B\u0001B!\u0006\u0003\"\u0001\u0007!Q\u0006\t\u0005o~\f9\u000e\u0003\u0004_\u0005C\u0001\r!\u0015\u0005\b\u0003\u007f\u0011\t\u00031\u0001R\u0011\u001d\u0011)D!\tA\u0002E\u000b!B]3uC&tG)\u0019;b\u0011\u001d\u0011I\u0004\u0001D\u0001\u0005w\t\u0001C]3oC6,\u0007+\u0019:uSRLwN\\:\u0015\u0013)\u0012iDa\u0010\u0003B\t\u0015\u0003B\u0002\u0018\u00038\u0001\u0007q\u0006\u0003\u0004<\u0005o\u0001\ra\f\u0005\t\u0005\u0007\u00129\u00041\u0001\u0003.\u0005)1\u000f]3dg\"A!q\tB\u001c\u0001\u0004\u0011i#\u0001\u0005oK^\u001c\u0006/Z2t\u0011\u001d\u0011Y\u0005\u0001D\u0001\u0005\u001b\nq\"\u00197uKJ\u0004\u0016M\u001d;ji&|gn\u001d\u000b\bU\t=#\u0011\u000bB*\u0011\u0019q#\u0011\na\u0001_!11H!\u0013A\u0002=B\u0001B!\u0006\u0003J\u0001\u0007!q\u0003\u0005\b\u0005/\u0002a\u0011\u0001B-\u000319W\r\u001e)beRLG/[8o)!\u0011IBa\u0017\u0003^\t}\u0003B\u0002\u0018\u0003V\u0001\u0007q\u0006\u0003\u0004<\u0005+\u0002\ra\f\u0005\t\u0005C\u0012)\u00061\u0001\u0002X\u0006!1\u000f]3d\u0011\u001d\u0011)\u0007\u0001D\u0001\u0005O\n!cZ3u!\u0006\u0014H/\u001b;j_:|\u0005\u000f^5p]RA!\u0011\u000eB8\u0005c\u0012\u0019\bE\u0003\u0012\u0005W\u0012I\"C\u0002\u0003nI\u0011aa\u00149uS>t\u0007B\u0002\u0018\u0003d\u0001\u0007q\u0006\u0003\u0004<\u0005G\u0002\ra\f\u0005\t\u0005C\u0012\u0019\u00071\u0001\u0002X\"9!q\u000f\u0001\u0007\u0002\te\u0014A\u00057jgR\u0004\u0016M\u001d;ji&|gNT1nKN$rA\u001eB>\u0005{\u0012y\b\u0003\u0004/\u0005k\u0002\ra\f\u0005\u0007w\tU\u0004\u0019A\u0018\t\u0015\t\u0005%Q\u000fI\u0001\u0002\u0004\u0011\u0019)A\u0006qCJ$\u0018.\u00197Ta\u0016\u001c\u0007#B\t\u0003l\u0005]\u0007b\u0002BD\u0001\u0019\u0005!\u0011R\u0001\u000fY&\u001cH\u000fU1si&$\u0018n\u001c8t)!\u00119Ba#\u0003\u000e\n=\u0005B\u0002\u0018\u0003\u0006\u0002\u0007q\u0006\u0003\u0004<\u0005\u000b\u0003\ra\f\u0005\u000b\u0005\u0003\u0013)\t%AA\u0002\t\r\u0005b\u0002BJ\u0001\u0019\u0005!QS\u0001\u0017Y&\u001cH\u000fU1si&$\u0018n\u001c8t\u0005f4\u0015\u000e\u001c;feRQ!q\u0003BL\u00053\u0013YJ!,\t\r9\u0012\t\n1\u00010\u0011\u0019Y$\u0011\u0013a\u0001_!A!Q\u0014BI\u0001\u0004\u0011y*\u0001\u0006qe\u0016$\u0017nY1uKN\u0004Ba^@\u0003\"B!!1\u0015BU\u001b\t\u0011)KC\u0002\u0003(\u0012\t1\"\u001a=qe\u0016\u001c8/[8og&!!1\u0016BS\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\b\u0005_\u0013\t\n1\u00010\u0003E!WMZ1vYR$\u0016.\\3[_:,\u0017\n\u001a\u0005\b\u0005g\u0003AQ\u0001B[\u00039\u0019'/Z1uK\u001a+hn\u0019;j_:$RA\u000bB\\\u0005sCaA\fBY\u0001\u0004y\u0003\u0002\u0003B^\u0005c\u0003\rA!0\u0002\u001d\u0019,hn\u0019#fM&t\u0017\u000e^5p]B\u0019QDa0\n\u0007\t\u0005'AA\bDCR\fGn\\4Gk:\u001cG/[8o\u0011\u001d\u0011)\r\u0001D\t\u0005\u000f\f\u0001\u0003Z8De\u0016\fG/\u001a$v]\u000e$\u0018n\u001c8\u0015\u000b)\u0012IMa3\t\r9\u0012\u0019\r1\u00010\u0011!\u0011YLa1A\u0002\tu\u0006b\u0002Bh\u0001\u0011\u0015!\u0011[\u0001\rIJ|\u0007OR;oGRLwN\u001c\u000b\u0006U\tM'Q\u001b\u0005\u0007]\t5\u0007\u0019A\u0018\t\r\u0005\u0013i\r1\u00010\u0011\u001d\u0011I\u000e\u0001D\t\u00057\fa\u0002Z8Ee>\u0004h)\u001e8di&|g\u000eF\u0003+\u0005;\u0014y\u000e\u0003\u0004/\u0005/\u0004\ra\f\u0005\u0007\u0003\n]\u0007\u0019A\u0018\t\u000f\t\r\b\u0001\"\u0002\u0003f\u0006q!/\u001a8b[\u00164UO\\2uS>tGc\u0002\u0016\u0003h\n%(1\u001e\u0005\u0007]\t\u0005\b\u0019A\u0018\t\u000f\u0005e#\u0011\u001da\u0001_!9\u0011Q\fBq\u0001\u0004y\u0003b\u0002Bx\u0001\u0019E!\u0011_\u0001\u0011I>\u0014VM\\1nK\u001a+hn\u0019;j_:$rA\u000bBz\u0005k\u00149\u0010\u0003\u0004/\u0005[\u0004\ra\f\u0005\b\u00033\u0012i\u000f1\u00010\u0011\u001d\tiF!<A\u0002=BqAa?\u0001\r\u0003\u0011i0A\u0006hKR4UO\\2uS>tGC\u0002B_\u0005\u007f\u001c\t\u0001\u0003\u0004/\u0005s\u0004\ra\f\u0005\u0007\u0003\ne\b\u0019A\u0018\t\u000f\r\u0015\u0001A\"\u0001\u0004\b\u0005qa-\u001e8di&|g.\u0012=jgR\u001cH#B)\u0004\n\r-\u0001B\u0002\u0018\u0004\u0004\u0001\u0007q\u0006\u0003\u0004B\u0007\u0007\u0001\ra\f\u0005\b\u0007\u001f\u0001a\u0011AB\t\u00035a\u0017n\u001d;Gk:\u001cG/[8ogR)aoa\u0005\u0004\u0016!1af!\u0004A\u0002=Bq!a\u0003\u0004\u000e\u0001\u0007q\u0006C\u0004\u0004\u001a\u0001!\tfa\u0007\u0002\u0017\u0011|\u0007k\\:u\u000bZ,g\u000e\u001e\u000b\u0006U\ru1\u0011\u0005\u0005\b\u0007?\u00199\u00021\u0001\u001d\u0003!a\u0017n\u001d;f]\u0016\u0014\bbBB\u0012\u0007/\u0001\r\u0001I\u0001\u0006KZ,g\u000e\u001e\u0005\n\u0007O\u0001\u0011\u0013!C\u0001\u0007S\tA\u0004\\5tiB\u000b'\u000f^5uS>tg*Y7fg\u0012\"WMZ1vYR$3'\u0006\u0002\u0004,)\"!1QB\u0017W\t\u0019y\u0003\u0005\u0003\u00042\rmRBAB\u001a\u0015\u0011\u0019)da\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAB\u001d%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\ru21\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CB!\u0001E\u0005I\u0011AB\u0015\u0003aa\u0017n\u001d;QCJ$\u0018\u000e^5p]N$C-\u001a4bk2$He\r")
public abstract class ExternalCatalog
implements ListenerBus<ExternalCatalogEventListener, ExternalCatalogEvent> {
    private final CopyOnWriteArrayList<Object> listeners;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public CopyOnWriteArrayList<ExternalCatalogEventListener> listeners() {
        return this.listeners;
    }

    public void org$apache$spark$util$ListenerBus$_setter_$listeners_$eq(CopyOnWriteArrayList x$1) {
        this.listeners = x$1;
    }

    public final void addListener(Object listener) {
        ListenerBus.class.addListener((ListenerBus)this, (Object)listener);
    }

    public final void removeListener(Object listener) {
        ListenerBus.class.removeListener((ListenerBus)this, (Object)listener);
    }

    public void postToAll(Object event) {
        ListenerBus.class.postToAll((ListenerBus)this, (Object)event);
    }

    public <T extends ExternalCatalogEventListener> Seq<T> findListenersByClass(ClassTag<T> evidence$1) {
        return ListenerBus.class.findListenersByClass((ListenerBus)this, evidence$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public void requireDbExists(String db) {
        if (this.databaseExists(db)) {
            return;
        }
        throw new NoSuchDatabaseException(db);
    }

    public void requireTableExists(String db, String table) {
        if (this.tableExists(db, table)) {
            return;
        }
        throw new NoSuchTableException(db, table);
    }

    public void requireFunctionExists(String db, String funcName) {
        if (this.functionExists(db, funcName)) {
            return;
        }
        throw new NoSuchFunctionException(db, funcName);
    }

    public void requireFunctionNotExists(String db, String funcName) {
        if (this.functionExists(db, funcName)) {
            throw new FunctionAlreadyExistsException(db, funcName);
        }
    }

    public final void createDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        String db = dbDefinition.name();
        this.postToAll(new CreateDatabasePreEvent(db));
        this.doCreateDatabase(dbDefinition, ignoreIfExists);
        this.postToAll(new CreateDatabaseEvent(db));
    }

    public abstract void doCreateDatabase(CatalogDatabase var1, boolean var2);

    public final void dropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        this.postToAll(new DropDatabasePreEvent(db));
        this.doDropDatabase(db, ignoreIfNotExists, cascade);
        this.postToAll(new DropDatabaseEvent(db));
    }

    public abstract void doDropDatabase(String var1, boolean var2, boolean var3);

    public abstract void alterDatabase(CatalogDatabase var1);

    public abstract CatalogDatabase getDatabase(String var1);

    public abstract boolean databaseExists(String var1);

    public abstract Seq<String> listDatabases();

    public abstract Seq<String> listDatabases(String var1);

    public abstract void setCurrentDatabase(String var1);

    public final void createTable(CatalogTable tableDefinition, boolean ignoreIfExists) {
        String db = tableDefinition.database();
        String name2 = tableDefinition.identifier().table();
        this.postToAll(new CreateTablePreEvent(db, name2));
        this.doCreateTable(tableDefinition, ignoreIfExists);
        this.postToAll(new CreateTableEvent(db, name2));
    }

    public abstract void doCreateTable(CatalogTable var1, boolean var2);

    public final void dropTable(String db, String table, boolean ignoreIfNotExists, boolean purge) {
        this.postToAll(new DropTablePreEvent(db, table));
        this.doDropTable(db, table, ignoreIfNotExists, purge);
        this.postToAll(new DropTableEvent(db, table));
    }

    public abstract void doDropTable(String var1, String var2, boolean var3, boolean var4);

    public final void renameTable(String db, String oldName, String newName) {
        this.postToAll(new RenameTablePreEvent(db, oldName, newName));
        this.doRenameTable(db, oldName, newName);
        this.postToAll(new RenameTableEvent(db, oldName, newName));
    }

    public abstract void doRenameTable(String var1, String var2, String var3);

    public abstract void alterTable(CatalogTable var1);

    public abstract void alterTableDataSchema(String var1, String var2, StructType var3);

    public abstract CatalogTable getTable(String var1, String var2);

    public abstract boolean tableExists(String var1, String var2);

    public abstract Seq<String> listTables(String var1);

    public abstract Seq<String> listTables(String var1, String var2);

    public abstract void loadTable(String var1, String var2, String var3, boolean var4, boolean var5);

    public abstract void loadPartition(String var1, String var2, String var3, Map<String, String> var4, boolean var5, boolean var6, boolean var7);

    public abstract void loadDynamicPartitions(String var1, String var2, String var3, Map<String, String> var4, boolean var5, int var6);

    public abstract void createPartitions(String var1, String var2, Seq<CatalogTablePartition> var3, boolean var4);

    public abstract void dropPartitions(String var1, String var2, Seq<Map<String, String>> var3, boolean var4, boolean var5, boolean var6);

    public abstract void renamePartitions(String var1, String var2, Seq<Map<String, String>> var3, Seq<Map<String, String>> var4);

    public abstract void alterPartitions(String var1, String var2, Seq<CatalogTablePartition> var3);

    public abstract CatalogTablePartition getPartition(String var1, String var2, Map<String, String> var3);

    public abstract Option<CatalogTablePartition> getPartitionOption(String var1, String var2, Map<String, String> var3);

    public abstract Seq<String> listPartitionNames(String var1, String var2, Option<Map<String, String>> var3);

    public Option<Map<String, String>> listPartitionNames$default$3() {
        return None$.MODULE$;
    }

    public abstract Seq<CatalogTablePartition> listPartitions(String var1, String var2, Option<Map<String, String>> var3);

    public Option<Map<String, String>> listPartitions$default$3() {
        return None$.MODULE$;
    }

    public abstract Seq<CatalogTablePartition> listPartitionsByFilter(String var1, String var2, Seq<Expression> var3, String var4);

    public final void createFunction(String db, CatalogFunction funcDefinition) {
        String name2 = funcDefinition.identifier().funcName();
        this.postToAll(new CreateFunctionPreEvent(db, name2));
        this.doCreateFunction(db, funcDefinition);
        this.postToAll(new CreateFunctionEvent(db, name2));
    }

    public abstract void doCreateFunction(String var1, CatalogFunction var2);

    public final void dropFunction(String db, String funcName) {
        this.postToAll(new DropFunctionPreEvent(db, funcName));
        this.doDropFunction(db, funcName);
        this.postToAll(new DropFunctionEvent(db, funcName));
    }

    public abstract void doDropFunction(String var1, String var2);

    public final void renameFunction(String db, String oldName, String newName) {
        this.postToAll(new RenameFunctionPreEvent(db, oldName, newName));
        this.doRenameFunction(db, oldName, newName);
        this.postToAll(new RenameFunctionEvent(db, oldName, newName));
    }

    public abstract void doRenameFunction(String var1, String var2, String var3);

    public abstract CatalogFunction getFunction(String var1, String var2);

    public abstract boolean functionExists(String var1, String var2);

    public abstract Seq<String> listFunctions(String var1, String var2);

    public void doPostEvent(ExternalCatalogEventListener listener, ExternalCatalogEvent event) {
        listener.onEvent(event);
    }

    public ExternalCatalog() {
        Logging.class.$init$((Logging)this);
        ListenerBus.class.$init$((ListenerBus)this);
    }
}

