/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.hive.HiveShim;
import org.apache.spark.sql.hive.HiveShim$;
import org.apache.spark.sql.hive.HiveTableUtil$;
import org.apache.spark.sql.hive.execution.HiveFileFormat$;
import org.apache.spark.sql.hive.execution.HiveOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableJobConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001=\u0011a\u0002S5wK\u001aKG.\u001a$pe6\fGO\u0003\u0002\u0004\t\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000b\u0019\tA\u0001[5wK*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\f\u001eGA\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"aF\u000e\u000e\u0003aQ!!\u0007\u000e\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u0007\u0019I!\u0001\b\r\u0003\u0015\u0019KG.\u001a$pe6\fG\u000f\u0005\u0002\u001fC5\tqD\u0003\u0002!\r\u000591o\\;sG\u0016\u001c\u0018B\u0001\u0012 \u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019B\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005!*#a\u0002'pO\u001eLgn\u001a\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u0005aa-\u001b7f'&t7nQ8oMB\u0011A\u0006\u0010\b\u0003[ir!AL\u001d\u000f\u0005=BdB\u0001\u00198\u001d\t\tdG\u0004\u00023k5\t1G\u0003\u00025\u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\tYD!\u0001\u0005ISZ,7\u000b[5n\u0013\tidH\u0001\tTQ&lg)\u001b7f'&t7\u000eR3tG*\u00111\b\u0002\u0005\u0006\u0001\u0002!\t!Q\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\t#\u0005CA\"\u0001\u001b\u0005\u0011\u0001\"\u0002\u0016@\u0001\u0004Y\u0003\"\u0002!\u0001\t\u00031E#\u0001\"\t\u000b!\u0003A\u0011I%\u0002\u0013MDwN\u001d;OC6,G#\u0001&\u0011\u0005-seBA\tM\u0013\ti%#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u0013aa\u0015;sS:<'BA'\u0013\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0003-IgNZ3s'\u000eDW-\\1\u0015\tQk6\r\u001b\t\u0004#U;\u0016B\u0001,\u0013\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001lW\u0007\u00023*\u0011!LB\u0001\u0006if\u0004Xm]\u0005\u00039f\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015q\u0016\u000b1\u0001`\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\t\u0001\u0017-D\u0001\u0007\u0013\t\u0011gA\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003e#\u0002\u0007Q-A\u0004paRLwN\\:\u0011\t-3'JS\u0005\u0003OB\u00131!T1q\u0011\u0015I\u0017\u000b1\u0001k\u0003\u00151\u0017\u000e\\3t!\rY\u0007o\u001d\b\u0003Y:t!AM7\n\u0003MI!a\u001c\n\u0002\u000fA\f7m[1hK&\u0011\u0011O\u001d\u0002\u0004'\u0016\f(BA8\u0013!\t!\u00180D\u0001v\u0015\t1x/\u0001\u0002gg*\u0011\u0001PC\u0001\u0007Q\u0006$wn\u001c9\n\u0005i,(A\u0003$jY\u0016\u001cF/\u0019;vg\")A\u0010\u0001C!{\u0006a\u0001O]3qCJ,wK]5uKRIa0a\u0001\u0002\u0006\u0005U\u0011q\u0003\t\u0003/}L1!!\u0001\u0019\u0005MyU\u000f\u001e9vi^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011\u0015q6\u00101\u0001`\u0011\u001d\t9a\u001fa\u0001\u0003\u0013\t1A[8c!\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\bo\u0006IQ.\u00199sK\u0012,8-Z\u0005\u0005\u0003'\tiAA\u0002K_\nDQ\u0001Z>A\u0002\u0015Da!!\u0007|\u0001\u00049\u0016A\u00033bi\u0006\u001c6\r[3nC\u0002")
public class HiveFileFormat
implements FileFormat,
DataSourceRegister,
Logging {
    private final HiveShim.ShimFileSinkDesc fileSinkConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.class.supportBatch((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return FileFormat.class.isSplitable((FileFormat)this, (SparkSession)sparkSession, options, (Path)path);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.class.buildReader((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.class.buildReaderWithPartitionValues((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public String shortName() {
        return "hive";
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"inferSchema is not supported for hive data source."})).s((Seq)Nil$.MODULE$));
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        Configuration conf = job.getConfiguration();
        TableDesc tableDesc = HiveShim$.MODULE$.wrapperToFileSinkDesc(this.fileSinkConf).getTableInfo();
        conf.set("mapred.output.format.class", tableDesc.getOutputFileFormatClassName());
        boolean speculationEnabled = sparkSession.sparkContext().conf().getBoolean("spark.speculation", false);
        String outputCommitterClass = conf.get("mapred.output.committer.class", "");
        if (speculationEnabled && outputCommitterClass.contains("Direct")) {
            String warningMessage = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " may be an output committer that writes data directly to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputCommitterClass}))).append((Object)"the final location. Because speculation is enabled, this output committer may ").append((Object)"cause data loss (see the case in SPARK-10063). If possible, please use an output ").append((Object)"committer that does not have this behavior (e.g. FileOutputCommitter).").toString();
            this.logWarning((Function0<String>)new Serializable(this, warningMessage){
                public static final long serialVersionUID = 0L;
                private final String warningMessage$1;

                public final String apply() {
                    return this.warningMessage$1;
                }
                {
                    this.warningMessage$1 = warningMessage$1;
                }
            });
        }
        HiveTableUtil$.MODULE$.configureJobPropertiesForStorageHandler(tableDesc, conf, false);
        Utilities.copyTableJobPropertiesToConf((TableDesc)tableDesc, (Configuration)conf);
        HiveShim.ShimFileSinkDesc fileSinkConfSer = this.fileSinkConf;
        return new OutputWriterFactory(this, conf, fileSinkConfSer){
            private final SerializableJobConf jobConf;
            private transient HiveOutputFormat<Object, Writable> outputFormat;
            private final HiveShim.ShimFileSinkDesc fileSinkConfSer$1;
            private volatile transient boolean bitmap$trans$0;

            private HiveOutputFormat outputFormat$lzycompute() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$trans$0) {
                        this.outputFormat = (HiveOutputFormat)this.jobConf().value().getOutputFormat();
                        this.bitmap$trans$0 = true;
                    }
                    return this.outputFormat;
                }
            }

            private SerializableJobConf jobConf() {
                return this.jobConf;
            }

            private HiveOutputFormat<Object, Writable> outputFormat() {
                return this.bitmap$trans$0 ? this.outputFormat : this.outputFormat$lzycompute();
            }

            public String getFileExtension(TaskAttemptContext context) {
                return Utilities.getFileExtension((JobConf)this.jobConf().value(), (boolean)HiveShim$.MODULE$.wrapperToFileSinkDesc(this.fileSinkConfSer$1).getCompressed(), this.outputFormat());
            }

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new HiveOutputWriter(path, this.fileSinkConfSer$1, this.jobConf().value(), dataSchema);
            }
            {
                this.fileSinkConfSer$1 = fileSinkConfSer$1;
                this.jobConf = new SerializableJobConf(new JobConf(conf$1));
            }
        };
    }

    public HiveFileFormat(HiveShim.ShimFileSinkDesc fileSinkConf) {
        this.fileSinkConf = fileSinkConf;
        FileFormat.class.$init$((FileFormat)this);
        Logging.class.$init$((Logging)this);
    }

    public HiveFileFormat() {
        this(null);
    }
}

