/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.source.libsvm;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.source.libsvm.LibSVMFileFormat$;
import org.apache.spark.ml.source.libsvm.LibSVMFileFormat$$anonfun$buildReader$1$;
import org.apache.spark.ml.source.libsvm.LibSVMOptions;
import org.apache.spark.ml.source.libsvm.LibSVMOptions$;
import org.apache.spark.ml.source.libsvm.LibSVMOutputWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055c!B\u0001\u0003\u0001\tq!\u0001\u0005'jEN3VJR5mK\u001a{'/\\1u\u0015\t\u0019A!\u0001\u0004mS\n\u001ch/\u001c\u0006\u0003\u000b\u0019\taa]8ve\u000e,'BA\u0004\t\u0003\tiGN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\r\u0001q\"\u0007\t\u0003!]i\u0011!\u0005\u0006\u0003%M\t1\u0002Z1uCN|WO]2fg*\u0011A#F\u0001\nKb,7-\u001e;j_:T!A\u0006\u0005\u0002\u0007M\fH.\u0003\u0002\u0019#\t\u0019B+\u001a=u\u0005\u0006\u001cX\r\u001a$jY\u00164uN]7biB\u0011!$H\u0007\u00027)\u0011A$F\u0001\bg>,(oY3t\u0013\tq2D\u0001\nECR\f7k\\;sG\u0016\u0014VmZ5ti\u0016\u0014\b\"\u0002\u0011\u0001\t\u0003\u0011\u0013A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\r\u0002\"\u0001\n\u0001\u000e\u0003\tAQA\n\u0001\u0005B\u001d\n\u0011b\u001d5peRt\u0015-\\3\u0015\u0003!\u0002\"!K\u0018\u000f\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0014G\u0001\u0004TiJLgn\u001a\u0006\u0003]-BQa\r\u0001\u0005B\u001d\n\u0001\u0002^8TiJLgn\u001a\u0005\u0006k\u0001!IAN\u0001\rm\u0016\u0014\u0018NZ=TG\",W.\u0019\u000b\u0004oi\u0012\u0005C\u0001\u00169\u0013\tI4F\u0001\u0003V]&$\b\"B\u001e5\u0001\u0004a\u0014A\u00033bi\u0006\u001c6\r[3nCB\u0011Q\bQ\u0007\u0002})\u0011q(F\u0001\u0006if\u0004Xm]\u0005\u0003\u0003z\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015\u0019E\u00071\u0001E\u0003)1wN],sSRLgn\u001a\t\u0003U\u0015K!AR\u0016\u0003\u000f\t{w\u000e\\3b]\")\u0001\n\u0001C!\u0013\u0006Y\u0011N\u001c4feN\u001b\u0007.Z7b)\u0011QUj\u0015-\u0011\u0007)ZE(\u0003\u0002MW\t1q\n\u001d;j_:DQAT$A\u0002=\u000bAb\u001d9be.\u001cVm]:j_:\u0004\"\u0001U)\u000e\u0003UI!AU\u000b\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000bQ;\u0005\u0019A+\u0002\u000f=\u0004H/[8ogB!\u0011F\u0016\u0015)\u0013\t9\u0016GA\u0002NCBDQ!W$A\u0002i\u000bQAZ5mKN\u00042aW2g\u001d\ta\u0016M\u0004\u0002^A6\taL\u0003\u0002`C\u00051AH]8pizJ\u0011\u0001L\u0005\u0003E.\nq\u0001]1dW\u0006<W-\u0003\u0002eK\n\u00191+Z9\u000b\u0005\t\\\u0003CA4m\u001b\u0005A'BA5k\u0003\t17O\u0003\u0002l\u0015\u00051\u0001.\u00193p_BL!!\u001c5\u0003\u0015\u0019KG.Z*uCR,8\u000fC\u0003p\u0001\u0011\u0005\u0003/\u0001\u0007qe\u0016\u0004\u0018M]3Xe&$X\rF\u0003riVlh\u0010\u0005\u0002\u0011e&\u00111/\u0005\u0002\u0014\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\u0006\u001d:\u0004\ra\u0014\u0005\u0006m:\u0004\ra^\u0001\u0004U>\u0014\u0007C\u0001=|\u001b\u0005I(B\u0001>k\u0003%i\u0017\r\u001d:fIV\u001cW-\u0003\u0002}s\n\u0019!j\u001c2\t\u000bQs\u0007\u0019A+\t\u000bmr\u0007\u0019\u0001\u001f\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004\u0005Y!-^5mIJ+\u0017\rZ3s)A\t)!a\t\u0002&\u0005\u001d\u00121FA\u0018\u0003w\ti\u0004E\u0004+\u0003\u000f\tY!!\u0005\n\u0007\u0005%1FA\u0005Gk:\u001cG/[8ocA\u0019\u0001#!\u0004\n\u0007\u0005=\u0011CA\bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f!\u0015Y\u00161CA\f\u0013\r\t)\"\u001a\u0002\t\u0013R,'/\u0019;peB!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001eU\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003C\tYBA\u0006J]R,'O\\1m%><\b\"\u0002(\u0000\u0001\u0004y\u0005\"B\u001e\u0000\u0001\u0004a\u0004BBA\u0015\u007f\u0002\u0007A(A\bqCJ$\u0018\u000e^5p]N\u001b\u0007.Z7b\u0011\u0019\tic a\u0001y\u0005q!/Z9vSJ,GmU2iK6\f\u0007bBA\u0019\u007f\u0002\u0007\u00111G\u0001\bM&dG/\u001a:t!\u0011Y6-!\u000e\u0011\u0007i\t9$C\u0002\u0002:m\u0011aAR5mi\u0016\u0014\b\"\u0002+\u0000\u0001\u0004)\u0006bBA \u007f\u0002\u0007\u0011\u0011I\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001d#.\u0001\u0003d_:4\u0017\u0002BA&\u0003\u000b\u0012QbQ8oM&<WO]1uS>t\u0007")
public class LibSVMFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    public String shortName() {
        return "libsvm";
    }

    public String toString() {
        return "LibSVM";
    }

    private void verifySchema(StructType dataSchema, boolean forWriting) {
        if (dataSchema.size() == 2 && dataSchema.apply(0).dataType().sameType(DataTypes.DoubleType) && dataSchema.apply(1).dataType().sameType((DataType)new VectorUDT()) && (forWriting || (int)dataSchema.apply(1).metadata().getLong(LibSVMOptions$.MODULE$.NUM_FEATURES()) > 0)) {
            return;
        }
        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal schema for libsvm data, schema=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataSchema})));
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        LibSVMOptions libSVMOptions = new LibSVMOptions(options);
        int numFeatures = BoxesRunTime.unboxToInt((Object)libSVMOptions.numFeatures().getOrElse((Function0)new Serializable(this, sparkSession, files){
            public static final long serialVersionUID = 0L;
            private final SparkSession sparkSession$1;
            private final Seq files$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            /*
             * WARNING - void declaration
             */
            public int apply$mcI$sp() {
                void var1_1;
                Seq dataFiles = (Seq)this.files$1.filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileStatus x$1) {
                        return x$1.getPath().getName().startsWith("_");
                    }
                });
                if (dataFiles.length() == 1) {
                    String path = ((FileStatus)dataFiles.head()).getPath().toUri().toString();
                    SparkContext sc = this.sparkSession$1.sparkContext();
                    RDD<Tuple3<Object, int[], double[]>> parsed = MLUtils$.MODULE$.parseLibSVMFile(sc, path, sc.defaultParallelism());
                    return MLUtils$.MODULE$.computeNumFeatures(parsed);
                }
                if (var1_1.isEmpty()) {
                    throw new IOException("No input path specified for libsvm data");
                }
                throw new IOException("Multiple input paths are not supported for libsvm data.");
            }
            {
                this.sparkSession$1 = sparkSession$1;
                this.files$1 = files$1;
            }
        }));
        Metadata featuresMetadata = new MetadataBuilder().putLong(LibSVMOptions$.MODULE$.NUM_FEATURES(), (long)numFeatures).build();
        StructField structField = new StructField("label", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("features", (DataType)new VectorUDT(), false, featuresMetadata);
        return new Some((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField)));
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema, true);
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new LibSVMOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder().append((Object)".libsvm").append((Object)CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
        };
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        this.verifySchema(dataSchema, false);
        int numFeatures = (int)dataSchema.apply("features").metadata().getLong(LibSVMOptions$.MODULE$.NUM_FEATURES());
        Predef$.MODULE$.assert(numFeatures > 0);
        LibSVMOptions libSVMOptions = new LibSVMOptions(options);
        boolean isSparse = libSVMOptions.isSparse();
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return new Serializable(this, dataSchema, requiredSchema, numFeatures, isSparse, broadcastedHadoopConf){
            public static final long serialVersionUID = 0L;
            private final StructType dataSchema$1;
            public final StructType requiredSchema$1;
            public final int numFeatures$1;
            public final boolean isSparse$1;
            private final Broadcast broadcastedHadoopConf$1;

            public final Iterator<UnsafeRow> apply(PartitionedFile file) {
                HadoopFileLinesReader linesReader = new HadoopFileLinesReader(file, ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value());
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(this, linesReader){
                    public static final long serialVersionUID = 0L;
                    public final HadoopFileLinesReader linesReader$1;

                    public final TaskContext apply(TaskContext x$4) {
                        return x$4.addTaskCompletionListener((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$buildReader$1$$anonfun$apply$1 $outer;

                            public final void apply(TaskContext x$5) {
                                this.$outer.linesReader$1.close();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.linesReader$1 = linesReader$1;
                    }
                });
                Iterator points = linesReader.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Text x$6) {
                        return x$6.toString().trim();
                    }
                }).filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String line) {
                        return line.isEmpty() || line.startsWith("#");
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$1 $outer;

                    public final LabeledPoint apply(String line) {
                        Tuple3<Object, int[], double[]> tuple3 = MLUtils$.MODULE$.parseLibSVMRecord(line);
                        if (tuple3 != null) {
                            Tuple3 tuple32;
                            double label = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                            int[] indices = (int[])tuple3._2();
                            double[] values = (double[])tuple3._3();
                            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)label), (Object)indices, (Object)values);
                            double label2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
                            int[] indices2 = (int[])tuple33._2();
                            double[] values2 = (double[])tuple33._3();
                            return new LabeledPoint(label2, Vectors$.MODULE$.sparse(this.$outer.numFeatures$1, indices2, values2));
                        }
                        throw new MatchError(tuple3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                ExpressionEncoder converter = RowEncoder$.MODULE$.apply(this.dataSchema$1);
                Seq fullOutput = (Seq)this.dataSchema$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AttributeReference apply(StructField f) {
                        String x$8 = f.name();
                        DataType x$9 = f.dataType();
                        boolean x$10 = f.nullable();
                        Metadata x$11 = f.metadata();
                        ExprId x$12 = AttributeReference$.MODULE$.apply$default$5(x$8, x$9, x$10, x$11);
                        Option x$13 = AttributeReference$.MODULE$.apply$default$6(x$8, x$9, x$10, x$11);
                        Boolean x$14 = AttributeReference$.MODULE$.apply$default$7(x$8, x$9, x$10, x$11);
                        return new AttributeReference(x$8, x$9, x$10, x$11, x$12, x$13, x$14);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq requiredOutput = (Seq)fullOutput.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$1 $outer;

                    public final boolean apply(AttributeReference a) {
                        return Predef$.MODULE$.refArrayOps((Object[])this.$outer.requiredSchema$1.fieldNames()).contains((Object)a.name());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                UnsafeProjection requiredColumns = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)requiredOutput, fullOutput);
                return points.map((Function1)new Serializable(this, converter, requiredColumns){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$1 $outer;
                    private final ExpressionEncoder converter$1;
                    private final UnsafeProjection requiredColumns$1;

                    public final UnsafeRow apply(LabeledPoint pt) {
                        SparseVector features = this.$outer.isSparse$1 ? pt.features().toSparse() : pt.features().toDense();
                        return this.requiredColumns$1.apply(this.converter$1.toRow((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)pt.label()), features}))));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.converter$1 = converter$1;
                        this.requiredColumns$1 = requiredColumns$1;
                    }
                });
            }
            {
                this.dataSchema$1 = dataSchema$1;
                this.requiredSchema$1 = requiredSchema$1;
                this.numFeatures$1 = numFeatures$1;
                this.isSparse$1 = isSparse$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
            }
        };
    }
}

