/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.servlets.gatekeeper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.utils.gatekeeper.GatekeeperMessage;
import org.jets3t.service.utils.gatekeeper.SignatureRequest;
import org.jets3t.servlets.gatekeeper.Authorizer;
import org.jets3t.servlets.gatekeeper.BucketLister;
import org.jets3t.servlets.gatekeeper.ClientInformation;
import org.jets3t.servlets.gatekeeper.TransactionIdProvider;
import org.jets3t.servlets.gatekeeper.UrlSigner;
import org.jets3t.servlets.gatekeeper.impl.DefaultAuthorizer;
import org.jets3t.servlets.gatekeeper.impl.DefaultBucketLister;
import org.jets3t.servlets.gatekeeper.impl.DefaultTransactionIdProvider;
import org.jets3t.servlets.gatekeeper.impl.DefaultUrlSigner;

public class GatekeeperServlet
extends HttpServlet {
    private static final long serialVersionUID = 2054765427620529238L;
    private static final Log log = LogFactory.getLog(GatekeeperServlet.class);
    private ServletConfig servletConfig = null;
    private TransactionIdProvider transactionIdProvider = null;
    private UrlSigner urlSigner = null;
    private Authorizer authorizer = null;
    private BucketLister bucketLister = null;
    private boolean isInitCompleted = false;

    private Object instantiateClass(String className, Class[] constructorParamClasses, Object[] constructorParams) throws ServletException {
        try {
            Class<?> myClass = Class.forName(className);
            Constructor<?> constructor = myClass.getConstructor(constructorParamClasses);
            Object instance = constructor.newInstance(constructorParams);
            return instance;
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Class does not exist for name: " + className));
            }
        }
        catch (Exception e) {
            throw new ServletException("Unable to instantiate class '" + className + "'", (Throwable)e);
        }
        return null;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Initialising GatekeeperServlet");
        }
        this.servletConfig = servletConfig;
        this.transactionIdProvider = this.initTransactionIdProvider();
        this.authorizer = this.initAuthorizer();
        this.urlSigner = this.initUrlSigner();
        this.bucketLister = this.initBucketLister();
        this.isInitCompleted = true;
    }

    private Authorizer initAuthorizer() throws ServletException {
        String authorizerClass = this.servletConfig.getInitParameter("AuthorizerClass");
        if (log.isDebugEnabled()) {
            log.debug((Object)("AuthorizerClass: " + authorizerClass));
        }
        if (authorizerClass != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading Authorizer implementation class: " + authorizerClass));
            }
            return (Authorizer)this.instantiateClass(authorizerClass, new Class[]{ServletConfig.class}, new Object[]{this.servletConfig});
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded default Authorizer implementation class: " + DefaultAuthorizer.class.getName()));
        }
        return new DefaultAuthorizer(this.servletConfig);
    }

    private UrlSigner initUrlSigner() throws ServletException {
        String urlSignerClass = this.servletConfig.getInitParameter("UrlSignerClass");
        if (log.isDebugEnabled()) {
            log.debug((Object)("UrlSignerClass: " + urlSignerClass));
        }
        if (urlSignerClass != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading UrlSigner implementation class: " + urlSignerClass));
            }
            return (UrlSigner)this.instantiateClass(urlSignerClass, new Class[]{ServletConfig.class}, new Object[]{this.servletConfig});
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded default UrlSigner implementation class: " + DefaultUrlSigner.class.getName()));
        }
        return new DefaultUrlSigner(this.servletConfig);
    }

    private TransactionIdProvider initTransactionIdProvider() throws ServletException {
        String transactionIdProviderClass = this.servletConfig.getInitParameter("TransactionIdProviderClass");
        if (log.isDebugEnabled()) {
            log.debug((Object)("TransactionIdProviderClass: " + transactionIdProviderClass));
        }
        if (transactionIdProviderClass != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading TransactionIdProvider implementation class: " + transactionIdProviderClass));
            }
            return (TransactionIdProvider)this.instantiateClass(transactionIdProviderClass, new Class[]{ServletConfig.class}, new Object[]{this.servletConfig});
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded default TransactionIdProvider implementation class: " + TransactionIdProvider.class.getName()));
        }
        return new DefaultTransactionIdProvider(this.servletConfig);
    }

    private BucketLister initBucketLister() throws ServletException {
        String bucketListerClass = this.servletConfig.getInitParameter("BucketListerClass");
        if (log.isDebugEnabled()) {
            log.debug((Object)("BucketListerClass: " + bucketListerClass));
        }
        if (bucketListerClass != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading BucketLister implementation class: " + bucketListerClass));
            }
            return (BucketLister)this.instantiateClass(bucketListerClass, new Class[]{ServletConfig.class}, new Object[]{this.servletConfig});
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded default BucketLister implementation class: " + TransactionIdProvider.class.getName()));
        }
        return new DefaultBucketLister(this.servletConfig);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Handling GET request");
        }
        response.setStatus(200);
        response.setContentType("text/html");
        response.getWriter().println("<html><head><title>JetS3t Gatekeeper</title><body>");
        response.getWriter().println("<p>JetS3t Gatekeeper is running " + (this.isInitCompleted ? "and initialized successfully" : "but <b>initialization failed</b>") + "</p></body></html>");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Handling POST request");
        }
        try {
            GatekeeperMessage gatekeeperMessage = GatekeeperMessage.decodeFromProperties(request.getParameterMap());
            ClientInformation clientInformation = new ClientInformation(request.getRemoteAddr(), request.getRemoteHost(), request.getRemoteUser(), request.getRemotePort(), request.getSession(false), request.getUserPrincipal(), request.getHeader("User-Agent"), request);
            String transactionId = this.transactionIdProvider.getTransactionId(gatekeeperMessage, clientInformation);
            if (transactionId != null) {
                gatekeeperMessage.addMessageProperty("transactionId", transactionId);
            }
            if (!this.isInitCompleted) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Cannot process POST request as Gatekeeper servlet did not initialize correctly");
                }
                gatekeeperMessage.addApplicationProperty("gatekeeperErrorCode", "GatekeeperInitializationError");
            } else if (gatekeeperMessage.getApplicationProperties().containsKey("list-objects-in-bucket")) {
                boolean allowed;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Listing objects");
                }
                if (allowed = this.authorizer.allowBucketListingRequest(gatekeeperMessage, clientInformation)) {
                    this.bucketLister.listObjects(gatekeeperMessage, clientInformation);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Processing " + gatekeeperMessage.getSignatureRequests().length + " object signature requests"));
                }
                for (int i = 0; i < gatekeeperMessage.getSignatureRequests().length; ++i) {
                    SignatureRequest signatureRequest = gatekeeperMessage.getSignatureRequests()[i];
                    boolean allowed = this.authorizer.allowSignatureRequest(gatekeeperMessage, clientInformation, signatureRequest);
                    if (!allowed) continue;
                    String signedUrl = null;
                    if ("get".equals(signatureRequest.getSignatureType())) {
                        signedUrl = this.urlSigner.signGet(gatekeeperMessage, clientInformation, signatureRequest);
                    } else if ("head".equals(signatureRequest.getSignatureType())) {
                        signedUrl = this.urlSigner.signHead(gatekeeperMessage, clientInformation, signatureRequest);
                    } else if ("put".equals(signatureRequest.getSignatureType())) {
                        signedUrl = this.urlSigner.signPut(gatekeeperMessage, clientInformation, signatureRequest);
                    } else if ("delete".equals(signatureRequest.getSignatureType())) {
                        signedUrl = this.urlSigner.signDelete(gatekeeperMessage, clientInformation, signatureRequest);
                    } else if ("acl-lookup".equals(signatureRequest.getSignatureType())) {
                        signedUrl = this.urlSigner.signGetAcl(gatekeeperMessage, clientInformation, signatureRequest);
                    } else if ("acl-update".equals(signatureRequest.getSignatureType())) {
                        signedUrl = this.urlSigner.signPutAcl(gatekeeperMessage, clientInformation, signatureRequest);
                    }
                    signatureRequest.signRequest(signedUrl);
                }
            }
            Properties responseProperties = gatekeeperMessage.encodeToProperties();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending response message as properties: " + responseProperties));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            responseProperties.store(baos, "");
            response.setStatus(200);
            response.setContentType("text/plain");
            response.getOutputStream().write(baos.toByteArray());
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Gatekeeper failed to send valid response", (Throwable)e);
            }
            response.setStatus(500);
            response.setContentType("text/plain");
            response.getWriter().println(e.toString());
        }
    }
}

