/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.cockpit.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.utils.ServiceUtils;

public class CreateBucketDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -8085778146542157010L;
    private static String[] locationNames = new String[0];
    private static Map locationValueMap = new HashMap();
    private boolean okClicked = false;
    private JTextField bucketNameTextField = null;
    private JLabel bucketNameIsValidDNSResultLabel = null;
    private JComboBox bucketLocationComboBox = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private final Insets insetsDefault = new Insets(3, 5, 3, 5);
    static int locOffset = 0;

    public CreateBucketDialog(String suggestedBucketName, Frame ownerFrame, HyperlinkActivatedListener hyperlinkListener) {
        super(ownerFrame, "Create a new bucket", true);
        boolean disableDnsBuckets = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME).getBoolProperty("s3service.disable-dns-buckets", false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
        this.okButton = new JButton("Create Bucket");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        JHtmlLabel bucketNameLabel = new JHtmlLabel("<html><b>Bucket name</b></html>", hyperlinkListener);
        bucketNameLabel.setHorizontalAlignment(0);
        JHtmlLabel bucketLocationLabel = new JHtmlLabel("<html><b>Bucket location</b></html>", hyperlinkListener);
        bucketLocationLabel.setHorizontalAlignment(0);
        JHtmlLabel bucketNameIsValidDNSLabel = new JHtmlLabel("<html>DNS compatible?</html>", hyperlinkListener);
        bucketLocationLabel.setHorizontalAlignment(0);
        this.bucketNameIsValidDNSResultLabel = new JLabel("No");
        this.bucketLocationComboBox = new JComboBox<String>(locationNames);
        this.bucketLocationComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateBucketDialog.this.okButton.setEnabled(CreateBucketDialog.this.bucketLocationComboBox.getSelectedIndex() == 0 || "Yes".equals(CreateBucketDialog.this.bucketNameIsValidDNSResultLabel.getText()));
            }
        });
        this.bucketLocationComboBox.setToolTipText("The geographical location where the bucket's contents will be stored");
        JHtmlLabel bucketNameIsValidDNSExplanationLabel = null;
        if (disableDnsBuckets) {
            bucketNameIsValidDNSExplanationLabel = new JHtmlLabel("<html><font size=\"-2\">Because the 's3service.disable-dns-buckets' property is set, you<br>may only create buckets in the U.S. location.</font></html>", hyperlinkListener);
            this.bucketLocationComboBox.setEnabled(false);
        } else {
            bucketNameIsValidDNSExplanationLabel = new JHtmlLabel("<html><font size=\"-2\">If your bucket name is DNS-compatible, you can choose a storage location<br>other than US Standard and may potentially use the bucket as a virtual host.</font></html>", hyperlinkListener);
            this.bucketLocationComboBox.setEnabled(true);
        }
        bucketNameIsValidDNSExplanationLabel.setHorizontalAlignment(0);
        this.bucketNameTextField = new JTextField();
        this.bucketNameTextField.setToolTipText("A unique bucket name in S3");
        this.bucketNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.checkBucketName(e.getDocument());
            }

            public void removeUpdate(DocumentEvent e) {
                this.checkBucketName(e.getDocument());
            }

            public void changedUpdate(DocumentEvent e) {
                this.checkBucketName(e.getDocument());
            }

            private void checkBucketName(Document doc) {
                String bucketName = "";
                try {
                    bucketName = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (ServiceUtils.isBucketNameValidDNSName(bucketName)) {
                    CreateBucketDialog.this.bucketNameIsValidDNSResultLabel.setText("Yes");
                    CreateBucketDialog.this.okButton.setEnabled(true);
                } else {
                    CreateBucketDialog.this.bucketNameIsValidDNSResultLabel.setText("No");
                    CreateBucketDialog.this.okButton.setEnabled(CreateBucketDialog.this.bucketLocationComboBox.getSelectedIndex() == 0);
                }
            }
        });
        this.bucketNameTextField.setText(suggestedBucketName);
        this.bucketNameTextField.setSelectionStart(0);
        this.bucketNameTextField.setSelectionEnd(suggestedBucketName.length());
        this.getRootPane().setDefaultButton(this.okButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = -6225706489569112809L;

            public void actionPerformed(ActionEvent actionEvent) {
                CreateBucketDialog.this.setVisible(false);
                CreateBucketDialog.this.okClicked = false;
            }
        });
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.add((Component)this.cancelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, this.insetsDefault, 0, 0));
        buttonsPanel.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, this.insetsDefault, 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        int row = 0;
        panel.add((Component)bucketNameLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        panel.add((Component)this.bucketNameTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        panel.add((Component)bucketNameIsValidDNSExplanationLabel, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        if (!disableDnsBuckets) {
            panel.add((Component)bucketNameIsValidDNSLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
            panel.add((Component)this.bucketNameIsValidDNSResultLabel, new GridBagConstraints(1, row, 2, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        }
        panel.add((Component)bucketLocationLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        panel.add((Component)this.bucketLocationComboBox, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        panel.add((Component)new JHtmlLabel("<html><font size=\"-2\">Choosing a location other than US Standard may incur additional S3 usage fees.</font></html>", hyperlinkListener), new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        panel.add((Component)buttonsPanel, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(ownerFrame);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.okButton)) {
            this.setVisible(false);
            this.okClicked = true;
        } else if (event.getSource().equals(this.cancelButton)) {
            this.setVisible(false);
            this.okClicked = false;
        }
    }

    public boolean getOkClicked() {
        return this.okClicked;
    }

    public String getBucketLocation() {
        Object locationSelected = this.bucketLocationComboBox.getSelectedItem();
        return (String)locationValueMap.get(locationSelected);
    }

    public String getBucketName() {
        return this.bucketNameTextField.getText();
    }

    static {
        locationNames = new String[]{"US Standard", "US West (N. California)", "US West (Oregon)", "EU West (Ireland)", "EU Central (Frankfurt)", "Asia Pacific (Singapore)", "Asia Pacific (Tokyo)", "Asia Pacific (Sydney)", "South America (Sao Paulo)", "GovCloud US West", "GovCloud US West (FIPS 140-2)"};
        locationValueMap.put(locationNames[locOffset++], S3Bucket.LOCATION_US);
        locationValueMap.put(locationNames[locOffset++], "us-west-1");
        locationValueMap.put(locationNames[locOffset++], "us-west-2");
        locationValueMap.put(locationNames[locOffset++], "eu-west-1");
        locationValueMap.put(locationNames[locOffset++], "eu-central-1");
        locationValueMap.put(locationNames[locOffset++], "ap-southeast-1");
        locationValueMap.put(locationNames[locOffset++], "ap-northeast-1");
        locationValueMap.put(locationNames[locOffset++], "ap-southeast-2");
        locationValueMap.put(locationNames[locOffset++], "sa-east-1");
        locationValueMap.put(locationNames[locOffset++], "s3-us-gov-west-1");
        locationValueMap.put(locationNames[locOffset++], "s3-fips-us-gov-west-1");
    }
}

