/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.SimpleFetchOptimizer;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public class SimpleFetchAggregation
implements Transform {
    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        if (pctx.getFetchTask() != null || !pctx.getQueryProperties().isQuery() || pctx.getQueryProperties().isAnalyzeRewrite() || pctx.getQueryProperties().isCTAS() || pctx.getLoadFileWork().size() > 1 || !pctx.getLoadTableWork().isEmpty()) {
            return pctx;
        }
        String GBY = GroupByOperator.getOperatorName() + "%";
        String RS = ReduceSinkOperator.getOperatorName() + "%";
        String SEL = SelectOperator.getOperatorName() + "%";
        String FS = FileSinkOperator.getOperatorName() + "%";
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", GBY + RS + GBY + SEL + FS), new SingleGBYProcessor(pctx));
        opRules.put(new RuleRegExp("R2", GBY + RS + GBY + FS), new SingleGBYProcessor(pctx));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    static class SingleGBYProcessor
    implements NodeProcessor {
        private ParseContext pctx;

        public SingleGBYProcessor(ParseContext pctx) {
            this.pctx = pctx;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            FileSinkOperator FS = (FileSinkOperator)nd;
            int shift = stack.get(stack.size() - 2) instanceof SelectOperator ? 0 : 1;
            GroupByOperator cGBY = (GroupByOperator)stack.get(stack.size() - 3 + shift);
            ReduceSinkOperator RS = (ReduceSinkOperator)stack.get(stack.size() - 4 + shift);
            if (((ReduceSinkDesc)RS.getConf()).getNumReducers() != 1 || !((ReduceSinkDesc)RS.getConf()).getKeyCols().isEmpty()) {
                return null;
            }
            GroupByOperator pGBY = (GroupByOperator)stack.get(stack.size() - 5 + shift);
            Path fileName = ((FileSinkDesc)FS.getConf()).getFinalDirName();
            TableDesc tsDesc = this.createIntermediateFS(pGBY, fileName);
            for (AggregationDesc aggregation : ((GroupByDesc)cGBY.getConf()).getAggregators()) {
                ArrayList<ExprNodeDesc> parameters = aggregation.getParameters();
                aggregation.setParameters(ExprNodeDescUtils.backtrack(parameters, cGBY, RS));
            }
            this.pctx.setFetchTabledesc(tsDesc);
            this.pctx.setFetchSource(cGBY);
            this.pctx.setFetchSink(SimpleFetchOptimizer.replaceFSwithLS(FS, "NULL"));
            RS.setParentOperators(null);
            RS.setChildOperators(null);
            cGBY.setParentOperators(null);
            return null;
        }

        private TableDesc createIntermediateFS(Operator<?> parent, Path fileName) {
            TableDesc tsDesc = PlanUtils.getIntermediateFileTableDesc(PlanUtils.getFieldSchemasFromRowSchema(parent.getSchema(), "temporarycol"));
            FileSinkDesc desc = new FileSinkDesc(fileName, tsDesc, false);
            FileSinkOperator newFS = (FileSinkOperator)OperatorFactory.get(desc, parent.getSchema(), new Operator[0]);
            newFS.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>());
            newFS.getParentOperators().add(parent);
            parent.getChildOperators().clear();
            parent.getChildOperators().add(newFS);
            return tsDesc;
        }
    }
}

