/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.SparkException;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.VertexRDD$;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.PowerIterationClustering$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class PowerIterationClustering$
implements Logging,
Serializable {
    public static final PowerIterationClustering$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new PowerIterationClustering$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Graph<Object, Object> normalize(Graph<Object, Object> graph) {
        VertexRDD vD = graph.aggregateMessages((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(EdgeContext<Object, Object, Object> ctx) {
                long i = ctx.srcId();
                long j = ctx.dstId();
                double s = BoxesRunTime.unboxToDouble((Object)ctx.attr());
                if (s < 0.0) {
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Similarity must be nonnegative but found s(", ", ", ") = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)i), BoxesRunTime.boxToLong((long)j), BoxesRunTime.boxToDouble((double)s)})));
                }
                if (s > 0.0) {
                    ctx.sendToSrc((Object)BoxesRunTime.boxToDouble((double)s));
                }
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$2, double x$3) {
                return this.apply$mcDDD$sp(x$2, x$3);
            }

            public double apply$mcDDD$sp(double x$2, double x$3) {
                return x$2 + x$3;
            }
        }, TripletFields.EdgeOnly, ClassTag$.MODULE$.Double());
        return Graph$.MODULE$.apply((RDD)vD, (RDD)graph.edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double()).mapTriplets((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(EdgeTriplet<Object, Object> e) {
                return e.attr$mcD$sp() / package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)e.srcAttr()), MLUtils$.MODULE$.EPSILON());
            }
        }, new TripletFields(true, false, true), ClassTag$.MODULE$.Double());
    }

    public Graph<Object, Object> normalize(RDD<Tuple3<Object, Object, Object>> similarities) {
        RDD edges = similarities.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Edge<Object>> apply(Tuple3<Object, Object, Object> x0$3) {
                Tuple3<Object, Object, Object> tuple3 = x0$3;
                if (tuple3 != null) {
                    long i = BoxesRunTime.unboxToLong((Object)tuple3._1());
                    long j = BoxesRunTime.unboxToLong((Object)tuple3._2());
                    double s = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                    if (s < 0.0) {
                        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Similarity must be nonnegative but found s(", ", ", ") = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)i), BoxesRunTime.boxToLong((long)j), BoxesRunTime.boxToDouble((double)s)})));
                    }
                    Iterable iterable = i != j ? (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Edge[]{new Edge.mcD.sp(i, j, s), new Edge.mcD.sp(j, i, s)})) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    return iterable;
                }
                throw new MatchError(tuple3);
            }
        }, ClassTag$.MODULE$.apply(Edge.class));
        Graph gA = Graph$.MODULE$.fromEdges(edges, (Object)BoxesRunTime.boxToDouble((double)0.0), Graph$.MODULE$.fromEdges$default$3(), Graph$.MODULE$.fromEdges$default$4(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
        VertexRDD vD = gA.aggregateMessages((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(EdgeContext<Object, Object, Object> ctx) {
                ctx.sendToSrc(ctx.attr());
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$4, double x$5) {
                return this.apply$mcDDD$sp(x$4, x$5);
            }

            public double apply$mcDDD$sp(double x$4, double x$5) {
                return x$4 + x$5;
            }
        }, TripletFields.EdgeOnly, ClassTag$.MODULE$.Double());
        return Graph$.MODULE$.apply((RDD)vD, (RDD)gA.edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double()).mapTriplets((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(EdgeTriplet<Object, Object> e) {
                return e.attr$mcD$sp() / package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)e.srcAttr()), MLUtils$.MODULE$.EPSILON());
            }
        }, new TripletFields(true, false, true), ClassTag$.MODULE$.Double());
    }

    public Graph<Object, Object> randomInit(Graph<Object, Object> g) {
        RDD r = g.vertices().mapPartitionsWithIndex((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<Tuple2<Object, Object>> apply(int part, Iterator<Tuple2<Object, Object>> iter) {
                XORShiftRandom random = new XORShiftRandom((long)part);
                return iter.map((Function1)new Serializable(this, random){
                    public static final long serialVersionUID = 0L;
                    private final XORShiftRandom random$1;

                    public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$4) {
                        Tuple2<Object, Object> tuple2 = x0$4;
                        if (tuple2 != null) {
                            long id = tuple2._1$mcJ$sp();
                            Tuple2.mcJD.sp sp2 = new Tuple2.mcJD.sp(id, this.random$1.nextGaussian());
                            return sp2;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.random$1 = random$1;
                    }
                });
            }
        }, true, ClassTag$.MODULE$.apply(Tuple2.class)).cache();
        double sum = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(r, ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Long$.MODULE$).values().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return package$.MODULE$.abs(x);
            }
        }, ClassTag$.MODULE$.Double())).sum();
        RDD v0 = RDD$.MODULE$.rddToPairRDDFunctions(r, ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Long$.MODULE$).mapValues((Function1)new Serializable(sum){
            public static final long serialVersionUID = 0L;
            private final double sum$1;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return x / this.sum$1;
            }
            {
                this.sum$1 = sum$1;
            }
        });
        return Graph$.MODULE$.apply((RDD)VertexRDD$.MODULE$.apply(v0, ClassTag$.MODULE$.Double()), (RDD)g.edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
    }

    public Graph<Object, Object> initDegreeVector(Graph<Object, Object> g) {
        double sum = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions((RDD)g.vertices(), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Long$.MODULE$).values()).sum();
        VertexRDD v0 = g.vertices().mapValues((Function1)new Serializable(sum){
            public static final long serialVersionUID = 0L;
            private final double sum$2;

            public final double apply(double x$6) {
                return this.apply$mcDD$sp(x$6);
            }

            public double apply$mcDD$sp(double x$6) {
                return x$6 / this.sum$2;
            }
            {
                this.sum$2 = sum$2;
            }
        }, ClassTag$.MODULE$.Double());
        return Graph$.MODULE$.apply((RDD)VertexRDD$.MODULE$.apply((RDD)v0, ClassTag$.MODULE$.Double()), (RDD)g.edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
    }

    public VertexRDD<Object> powerIter(Graph<Object, Object> g, int maxIterations) {
        double tol = package$.MODULE$.max(1.0E-5 / (double)g.vertices().count(), 1.0E-8);
        DoubleRef prevDelta = DoubleRef.create((double)Double.MAX_VALUE);
        DoubleRef diffDelta = DoubleRef.create((double)Double.MAX_VALUE);
        ObjectRef curG = ObjectRef.create(g);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxIterations).withFilter((Function1)new Serializable(tol, diffDelta){
            public static final long serialVersionUID = 0L;
            private final double tol$1;
            private final DoubleRef diffDelta$1;

            public final boolean apply(int iter) {
                return this.apply$mcZI$sp(iter);
            }

            public boolean apply$mcZI$sp(int iter) {
                return package$.MODULE$.abs(this.diffDelta$1.elem) > this.tol$1;
            }
            {
                this.tol$1 = tol$1;
                this.diffDelta$1 = diffDelta$1;
            }
        }).foreach((Function1)new Serializable(g, prevDelta, diffDelta, curG){
            public static final long serialVersionUID = 0L;
            private final Graph g$1;
            private final DoubleRef prevDelta$1;
            public final DoubleRef diffDelta$1;
            private final ObjectRef curG$1;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                String msgPrefix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Iteration ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)iter)}));
                VertexRDD v = (VertexRDD)((Graph)this.curG$1.elem).aggregateMessages((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(EdgeContext<Object, Object, Object> ctx) {
                        ctx.sendToSrc((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)ctx.attr()) * BoxesRunTime.unboxToDouble((Object)ctx.dstAttr()))));
                    }
                }, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$7, double x$8) {
                        return this.apply$mcDDD$sp(x$7, x$8);
                    }

                    public double apply$mcDDD$sp(double x$7, double x$8) {
                        return x$7 + x$8;
                    }
                }, new TripletFields(false, true, true), ClassTag$.MODULE$.Double()).cache();
                double norm2 = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions((RDD)v, ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Long$.MODULE$).values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return package$.MODULE$.abs(x);
                    }
                }, ClassTag$.MODULE$.Double())).sum();
                PowerIterationClustering$.MODULE$.logInfo((Function0<String>)new Serializable(this, msgPrefix, norm2){
                    public static final long serialVersionUID = 0L;
                    private final String msgPrefix$1;
                    private final double norm$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": norm(v) = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.msgPrefix$1, BoxesRunTime.boxToDouble((double)this.norm$1)}));
                    }
                    {
                        this.msgPrefix$1 = msgPrefix$1;
                        this.norm$1 = norm$1;
                    }
                });
                VertexRDD v1 = v.mapValues((Function1)new Serializable(this, norm2){
                    public static final long serialVersionUID = 0L;
                    private final double norm$1;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return x / this.norm$1;
                    }
                    {
                        this.norm$1 = norm$1;
                    }
                }, ClassTag$.MODULE$.Double());
                double delta = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions((RDD)Graph$.MODULE$.graphToGraphOps((Graph)this.curG$1.elem, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double()).joinVertices((RDD)v1, (Function3)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(long x0$5, double x1$1, double x2$1) {
                        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)x0$5), (Object)BoxesRunTime.boxToDouble((double)x1$1), (Object)BoxesRunTime.boxToDouble((double)x2$1));
                        if (tuple3 != null) {
                            double x = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                            double y = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                            double d = package$.MODULE$.abs(x - y);
                            return d;
                        }
                        throw new MatchError((Object)tuple3);
                    }
                }, ClassTag$.MODULE$.Double()).vertices(), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Long$.MODULE$).values()).sum();
                PowerIterationClustering$.MODULE$.logInfo((Function0<String>)new Serializable(this, msgPrefix, delta){
                    public static final long serialVersionUID = 0L;
                    private final String msgPrefix$1;
                    private final double delta$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": delta = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.msgPrefix$1, BoxesRunTime.boxToDouble((double)this.delta$1)}));
                    }
                    {
                        this.msgPrefix$1 = msgPrefix$1;
                        this.delta$1 = delta$1;
                    }
                });
                this.diffDelta$1.elem = package$.MODULE$.abs(delta - this.prevDelta$1.elem);
                PowerIterationClustering$.MODULE$.logInfo((Function0<String>)new Serializable(this, msgPrefix){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.powerIter.2 $outer;
                    private final String msgPrefix$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": diff(delta) = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.msgPrefix$1, BoxesRunTime.boxToDouble((double)this.$outer.diffDelta$1.elem)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.msgPrefix$1 = msgPrefix$1;
                    }
                });
                this.curG$1.elem = Graph$.MODULE$.apply((RDD)VertexRDD$.MODULE$.apply((RDD)v1, ClassTag$.MODULE$.Double()), (RDD)this.g$1.edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
                this.prevDelta$1.elem = delta;
            }
            {
                this.g$1 = g$1;
                this.prevDelta$1 = prevDelta$1;
                this.diffDelta$1 = diffDelta$1;
                this.curG$1 = curG$1;
            }
        });
        return ((Graph)curG.elem).vertices();
    }

    public VertexRDD<Object> kMeans(VertexRDD<Object> v, int k) {
        VertexRDD points = (VertexRDD)v.mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(double x) {
                return Vectors$.MODULE$.dense(x, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[0]));
            }
        }, ClassTag$.MODULE$.apply(Vector.class)).cache();
        KMeansModel model = new KMeans().setK(k).setSeed(0L).run((RDD<Vector>)RDD$.MODULE$.rddToPairRDDFunctions((RDD)points, ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Long$.MODULE$).values());
        return (VertexRDD)points.mapValues((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final KMeansModel model$1;

            public final int apply(Vector p) {
                return this.model$1.predict(p);
            }
            {
                this.model$1 = model$1;
            }
        }, ClassTag$.MODULE$.Int()).cache();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PowerIterationClustering$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

