/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.regression.AFTPoint;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0001\u0003\t5\u0011Q\"\u0011$U\u0003\u001e<'/Z4bi>\u0014(BA\u0002\u0005\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\b\u0016\u0013\t1\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0019\u0001\t\u0005\t\u0015!\u0003\u001a\u00031\u00117\rU1sC6,G/\u001a:t!\rQRdH\u0007\u00027)\u0011ADB\u0001\nEJ|\u0017\rZ2bgRL!AH\u000e\u0003\u0013\t\u0013x.\u00193dCN$\bc\u0001\u0011&O5\t\u0011E\u0003\u0002#G\u00051A.\u001b8bY\u001eT\u0011\u0001J\u0001\u0007EJ,WM_3\n\u0005\u0019\n#a\u0003#f]N,g+Z2u_J\u0004\"a\u0004\u0015\n\u0005%\u0002\"A\u0002#pk\ndW\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u000311\u0017\u000e^%oi\u0016\u00148-\u001a9u!\tyQ&\u0003\u0002/!\t9!i\\8mK\u0006t\u0007\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u001b\t\u001cg)Z1ukJ,7o\u0015;e!\rQRD\r\t\u0004\u001fM:\u0013B\u0001\u001b\u0011\u0005\u0015\t%O]1z\u0011\u00151\u0004\u0001\"\u00018\u0003\u0019a\u0014N\\5u}Q!\u0001HO\u001e=!\tI\u0004!D\u0001\u0003\u0011\u0015AR\u00071\u0001\u001a\u0011\u0015YS\u00071\u0001-\u0011\u0015\u0001T\u00071\u00012\u0011\u001dq\u0004A1A\u0005\n}\na\u0001\\3oORDW#\u0001!\u0011\u0005=\t\u0015B\u0001\"\u0011\u0005\rIe\u000e\u001e\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002!\u0002\u000f1,gn\u001a;iA!Aa\t\u0001EC\u0002\u0013%q)\u0001\u0006qCJ\fW.\u001a;feN,\u0012a\b\u0005\t\u0013\u0002A\t\u0011)Q\u0005?\u0005Y\u0001/\u0019:b[\u0016$XM]:!Q\tA5\n\u0005\u0002\u0010\u0019&\u0011Q\n\u0005\u0002\niJ\fgn]5f]RD\u0001b\u0014\u0001\t\u0006\u0004%IaR\u0001\rG>,gMZ5dS\u0016tGo\u001d\u0005\t#\u0002A\t\u0011)Q\u0005?\u0005i1m\\3gM&\u001c\u0017.\u001a8ug\u0002B#\u0001U&\t\u0011Q\u0003\u0001R1A\u0005\nU\u000b\u0011\"\u001b8uKJ\u001cW\r\u001d;\u0016\u0003\u001dB\u0001b\u0016\u0001\t\u0002\u0003\u0006KaJ\u0001\u000bS:$XM]2faR\u0004\u0003F\u0001,L\u0011!Q\u0006\u0001#b\u0001\n\u0013)\u0016!B:jO6\f\u0007\u0002\u0003/\u0001\u0011\u0003\u0005\u000b\u0015B\u0014\u0002\rMLw-\\1!Q\tY6\nC\u0004`\u0001\u0001\u0007I\u0011\u00021\u0002\u0011Q|G/\u00197D]R,\u0012!\u0019\t\u0003\u001f\tL!a\u0019\t\u0003\t1{gn\u001a\u0005\bK\u0002\u0001\r\u0011\"\u0003g\u00031!x\u000e^1m\u0007:$x\fJ3r)\t9'\u000e\u0005\u0002\u0010Q&\u0011\u0011\u000e\u0005\u0002\u0005+:LG\u000fC\u0004lI\u0006\u0005\t\u0019A1\u0002\u0007a$\u0013\u0007\u0003\u0004n\u0001\u0001\u0006K!Y\u0001\ni>$\u0018\r\\\"oi\u0002Bqa\u001c\u0001A\u0002\u0013%Q+A\u0004m_N\u001c8+^7\t\u000fE\u0004\u0001\u0019!C\u0005e\u0006YAn\\:t'Vlw\fJ3r)\t97\u000fC\u0004la\u0006\u0005\t\u0019A\u0014\t\rU\u0004\u0001\u0015)\u0003(\u0003!awn]:Tk6\u0004\u0003\u0002C<\u0001\u0011\u000b\u0007I\u0011\u0002=\u0002!\u001d\u0014\u0018\rZ5f]R\u001cV/\\!se\u0006LX#\u0001\u001a\t\u0011i\u0004\u0001\u0012!Q!\nI\n\u0011c\u001a:bI&,g\u000e^*v[\u0006\u0013(/Y=!\u0011\u0015a\b\u0001\"\u0001a\u0003\u0015\u0019w.\u001e8u\u0011\u0015q\b\u0001\"\u0001V\u0003\u0011awn]:\t\r\u0005\u0005\u0001\u0001\"\u0001H\u0003!9'/\u00193jK:$\bbBA\u0003\u0001\u0011\u0005\u0011qA\u0001\u0004C\u0012$G\u0003BA\u0005\u0003\u0017i\u0011\u0001\u0001\u0005\t\u0003\u001b\t\u0019\u00011\u0001\u0002\u0010\u0005!A-\u0019;b!\rI\u0014\u0011C\u0005\u0004\u0003'\u0011!\u0001C!G)B{\u0017N\u001c;\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a\u0005)Q.\u001a:hKR!\u0011\u0011BA\u000e\u0011\u001d\ti\"!\u0006A\u0002a\nQa\u001c;iKJ\u0004")
public class AFTAggregator
implements Serializable {
    private final Broadcast<DenseVector<Object>> bcParameters;
    private final boolean fitIntercept;
    private final Broadcast<double[]> bcFeaturesStd;
    private final int length;
    private transient DenseVector<Object> parameters;
    private transient DenseVector<Object> org$apache$spark$ml$regression$AFTAggregator$$coefficients;
    private transient double intercept;
    private transient double sigma;
    private long org$apache$spark$ml$regression$AFTAggregator$$totalCnt;
    private double lossSum;
    private double[] org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    private DenseVector parameters$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.parameters = (DenseVector)this.bcParameters.value();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.parameters;
        }
    }

    private DenseVector org$apache$spark$ml$regression$AFTAggregator$$coefficients$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.org$apache$spark$ml$regression$AFTAggregator$$coefficients = this.parameters().slice$mcD$sp(2, this.length(), this.parameters().slice$default$3());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.org$apache$spark$ml$regression$AFTAggregator$$coefficients;
        }
    }

    private double intercept$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.intercept = this.parameters().apply$mcD$sp(1);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.intercept;
        }
    }

    private double sigma$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.sigma = package$.MODULE$.exp(this.parameters().apply$mcD$sp(0));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.sigma;
        }
    }

    private double[] org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if (!this.bitmap$0) {
                this.org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray = (double[])Array$.MODULE$.ofDim(this.length(), ClassTag$.MODULE$.Double());
                this.bitmap$0 = true;
            }
            return this.org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray;
        }
    }

    private int length() {
        return this.length;
    }

    private DenseVector<Object> parameters() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.parameters$lzycompute() : this.parameters;
    }

    public DenseVector<Object> org$apache$spark$ml$regression$AFTAggregator$$coefficients() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.org$apache$spark$ml$regression$AFTAggregator$$coefficients$lzycompute() : this.org$apache$spark$ml$regression$AFTAggregator$$coefficients;
    }

    private double intercept() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.intercept$lzycompute() : this.intercept;
    }

    private double sigma() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.sigma$lzycompute() : this.sigma;
    }

    public long org$apache$spark$ml$regression$AFTAggregator$$totalCnt() {
        return this.org$apache$spark$ml$regression$AFTAggregator$$totalCnt;
    }

    private void org$apache$spark$ml$regression$AFTAggregator$$totalCnt_$eq(long x$1) {
        this.org$apache$spark$ml$regression$AFTAggregator$$totalCnt = x$1;
    }

    private double lossSum() {
        return this.lossSum;
    }

    private void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    public double[] org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray() {
        return this.bitmap$0 ? this.org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray : this.org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray$lzycompute();
    }

    public long count() {
        return this.org$apache$spark$ml$regression$AFTAggregator$$totalCnt();
    }

    public double loss() {
        Predef$.MODULE$.require((double)this.org$apache$spark$ml$regression$AFTAggregator$$totalCnt() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTAggregator $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of instances should be "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"greater than 0.0, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$ml$regression$AFTAggregator$$totalCnt())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.lossSum() / (double)this.org$apache$spark$ml$regression$AFTAggregator$$totalCnt();
    }

    public DenseVector<Object> gradient() {
        Predef$.MODULE$.require((double)this.org$apache$spark$ml$regression$AFTAggregator$$totalCnt() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTAggregator $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of instances should be "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"greater than 0.0, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$ml$regression$AFTAggregator$$totalCnt())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return new DenseVector.mcD.sp((double[])Predef$.MODULE$.doubleArrayOps(this.org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTAggregator $outer;

            public final double apply(double x$2) {
                return this.apply$mcDD$sp(x$2);
            }

            public double apply$mcDD$sp(double x$2) {
                return x$2 / (double)this.$outer.org$apache$spark$ml$regression$AFTAggregator$$totalCnt();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    public AFTAggregator add(AFTPoint data) {
        Vector xi = data.features();
        double ti = data.label();
        double delta = data.censor();
        double[] localFeaturesStd = (double[])this.bcFeaturesStd.value();
        DoubleRef sum = DoubleRef.create((double)0.0);
        xi.foreachActive((Function2)new Serializable(this, localFeaturesStd, sum){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTAggregator $outer;
            private final double[] localFeaturesStd$1;
            private final DoubleRef sum$1;

            public final void apply(int index2, double value) {
                this.apply$mcVID$sp(index2, value);
            }

            public void apply$mcVID$sp(int index2, double value) {
                if (this.localFeaturesStd$1[index2] != 0.0 && value != 0.0) {
                    this.sum$1.elem += this.$outer.org$apache$spark$ml$regression$AFTAggregator$$coefficients().apply$mcD$sp(index2) * (value / this.localFeaturesStd$1[index2]);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.localFeaturesStd$1 = localFeaturesStd$1;
                this.sum$1 = sum$1;
            }
        });
        double margin = sum.elem + this.intercept();
        double epsilon = (package$.MODULE$.log(ti) - margin) / this.sigma();
        this.lossSum_$eq(this.lossSum() + (delta * package$.MODULE$.log(this.sigma()) - delta * epsilon + package$.MODULE$.exp(epsilon)));
        double multiplier = (delta - package$.MODULE$.exp(epsilon)) / this.sigma();
        this.org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray()[0] = this.org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray()[0] + (delta + multiplier * this.sigma() * epsilon);
        this.org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray()[1] = this.org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray()[1] + (this.fitIntercept ? multiplier : 0.0);
        xi.foreachActive((Function2)new Serializable(this, localFeaturesStd, multiplier){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTAggregator $outer;
            private final double[] localFeaturesStd$1;
            private final double multiplier$1;

            public final void apply(int index2, double value) {
                this.apply$mcVID$sp(index2, value);
            }

            public void apply$mcVID$sp(int index2, double value) {
                if (this.localFeaturesStd$1[index2] != 0.0 && value != 0.0) {
                    int n = index2 + 2;
                    this.$outer.org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray()[n] = this.$outer.org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray()[n] + this.multiplier$1 * (value / this.localFeaturesStd$1[index2]);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.localFeaturesStd$1 = localFeaturesStd$1;
                this.multiplier$1 = multiplier$1;
            }
        });
        this.org$apache$spark$ml$regression$AFTAggregator$$totalCnt_$eq(this.org$apache$spark$ml$regression$AFTAggregator$$totalCnt() + 1L);
        return this;
    }

    public AFTAggregator merge(AFTAggregator other) {
        if (other.count() != 0L) {
            this.org$apache$spark$ml$regression$AFTAggregator$$totalCnt_$eq(this.org$apache$spark$ml$regression$AFTAggregator$$totalCnt() + other.org$apache$spark$ml$regression$AFTAggregator$$totalCnt());
            this.lossSum_$eq(this.lossSum() + other.lossSum());
            for (int i = 0; i < this.length(); ++i) {
                int n = i;
                this.org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray()[n] = this.org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray()[n] + other.org$apache$spark$ml$regression$AFTAggregator$$gradientSumArray()[i];
            }
        }
        return this;
    }

    public AFTAggregator(Broadcast<DenseVector<Object>> bcParameters, boolean fitIntercept, Broadcast<double[]> bcFeaturesStd) {
        this.bcParameters = bcParameters;
        this.fitIntercept = fitIntercept;
        this.bcFeaturesStd = bcFeaturesStd;
        this.length = ((DenseVector)bcParameters.value()).length();
        this.org$apache$spark$ml$regression$AFTAggregator$$totalCnt = 0L;
        this.lossSum = 0.0;
    }
}

