/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.ListResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ResetProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005=tAB\u0001\u0003\u0011\u0003!a\"A\tTa\u0006\u00148nU)M\u00072KEI]5wKJT!a\u0001\u0003\u0002\u0019QD'/\u001b4ug\u0016\u0014h/\u001a:\u000b\u0005\u00151\u0011\u0001\u00025jm\u0016T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h!\ty\u0001#D\u0001\u0003\r\u0019\t\"\u0001#\u0001\u0005%\t\t2\u000b]1sWN\u000bFj\u0011'J\tJLg/\u001a:\u0014\u0007A\u0019\u0012\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035ui\u0011a\u0007\u0006\u00039!\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003=m\u0011q\u0001T8hO&tw\rC\u0003!!\u0011\u0005!%\u0001\u0004=S:LGOP\u0002\u0001)\u0005q\u0001b\u0002\u0013\u0011\u0005\u0004%I!J\u0001\u0007aJ|W\u000e\u001d;\u0016\u0003\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0004TiJLgn\u001a\u0005\u0007_A\u0001\u000b\u0011\u0002\u0014\u0002\u000fA\u0014x.\u001c9uA!9\u0011\u0007\u0005b\u0001\n\u0013\u0011\u0014aD2p]RLg.^3e!J|W\u000e\u001d;\u0016\u0003M\u0002\"\u0001N\u001c\u000f\u0005Q)\u0014B\u0001\u001c\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011Q\u0006\u000f\u0006\u0003mUAaA\u000f\t!\u0002\u0013\u0019\u0014\u0001E2p]RLg.^3e!J|W\u000e\u001d;!\u0011%a\u0004\u00031AA\u0002\u0013%Q(A\u0005ue\u0006t7\u000f]8siV\ta\b\u0005\u0002@\u00076\t\u0001I\u0003\u0002=\u0003*\u0011!IC\u0001\u0007i\"\u0014\u0018N\u001a;\n\u0005\u0011\u0003%a\u0002+T_\u000e\\W\r\u001e\u0005\n\rB\u0001\r\u00111A\u0005\n\u001d\u000bQ\u0002\u001e:b]N\u0004xN\u001d;`I\u0015\fHC\u0001%L!\t!\u0012*\u0003\u0002K+\t!QK\\5u\u0011\u001daU)!AA\u0002y\n1\u0001\u001f\u00132\u0011\u0019q\u0005\u0003)Q\u0005}\u0005QAO]1ogB|'\u000f\u001e\u0011\t\u000bA\u0003B\u0011A)\u0002)%t7\u000f^1mYNKwM\\1m\u0011\u0006tG\r\\3s)\u0005A\u0005\"B*\u0011\t\u0003!\u0016\u0001B7bS:$\"\u0001S+\t\u000bY\u0013\u0006\u0019A,\u0002\t\u0005\u0014xm\u001d\t\u0004)a\u001b\u0014BA-\u0016\u0005\u0015\t%O]1z\u0011\u0015Y\u0006\u0003\"\u0001]\u00031I7OU3n_R,Wj\u001c3f)\ti\u0006\r\u0005\u0002\u0015=&\u0011q,\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015\t'\f1\u0001c\u0003\u0015\u0019H/\u0019;f!\t\u0019\u0017.D\u0001e\u0015\t)g-A\u0002dY&T!!B4\u000b\u0005!T\u0011A\u00025bI>|\u0007/\u0003\u0002kI\ny1\t\\5TKN\u001c\u0018n\u001c8Ti\u0006$XMB\u0003\u0012\u0005\u0001!AnE\u0002l[f\u0001\"a\u00198\n\u0005=$'!C\"mS\u0012\u0013\u0018N^3s\u0011\u0015\u00013\u000e\"\u0001r)\u0005\u0011\bCA\bl\u0011\u001d!8N1A\u0005\nU\fAb]3tg&|gn\u0015;bi\u0016,\u0012A\u0019\u0005\u0007o.\u0004\u000b\u0011\u00022\u0002\u001bM,7o]5p]N#\u0018\r^3!\u0011\u001dI8N1A\u0005\ni\f1\u0001T(H+\u0005Y\bc\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u00069An\\4hS:<'bAA\u0001\u0015\u000591m\\7n_:\u001c\u0018bAA\u0003{\n\u0019Aj\\4\t\u000f\u0005%1\u000e)A\u0005w\u0006!AjT$!\u0011%\tia\u001bb\u0001\n\u0013\ty!A\u0004d_:\u001cx\u000e\\3\u0016\u0005\u0005E\u0001\u0003BA\n\u0003GqA!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0004tKN\u001c\u0018n\u001c8\u000b\u0007\u0005ua-\u0001\u0002rY&!\u0011\u0011EA\f\u00031\u0019Vm]:j_:\u001cF/\u0019;f\u0013\u0011\t)#a\n\u0003\u00131{w\rS3ma\u0016\u0014(\u0002BA\u0011\u0003/A\u0001\"a\u000blA\u0003%\u0011\u0011C\u0001\tG>t7o\u001c7fA!A1l\u001bb\u0001\n\u0013\ty#F\u0001^\u0011\u001d\t\u0019d\u001bQ\u0001\nu\u000bQ\"[:SK6|G/Z'pI\u0016\u0004\u0003\"CA\u001cW\n\u0007I\u0011BA\u001d\u0003\u0011\u0019wN\u001c4\u0016\u0005\u0005m\u0002\u0003BA\u001f\u0003\u0003j!!a\u0010\u000b\u0007\u0005]r-\u0003\u0003\u0002D\u0005}\"!D\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0005\u0002H-\u0004\u000b\u0011BA\u001e\u0003\u0015\u0019wN\u001c4!\u0011\u001d\tYe\u001bC!\u0003\u001b\n\u0001c]3u\u0011&4XMV1sS\u0006\u0014G.Z:\u0015\u0007!\u000by\u0005\u0003\u0005\u0002R\u0005%\u0003\u0019AA*\u00035A\u0017N^3WCJL\u0017M\u00197fgB1\u0011QKA.gMj!!a\u0016\u000b\u0007\u0005e#&\u0001\u0003vi&d\u0017\u0002BA/\u0003/\u00121!T1q\u0011\u001d\t\tg\u001bC!\u0003G\n!\u0002\u001d:pG\u0016\u001c8oQ7e)\u0011\t)'a\u001b\u0011\u0007Q\t9'C\u0002\u0002jU\u00111!\u00138u\u0011\u001d\ti'a\u0018A\u0002M\n1aY7e\u0001")
public class SparkSQLCLIDriver
extends CliDriver
implements Logging {
    private final CliSessionState sessionState;
    private final Log LOG;
    private final SessionState.LogHelper console;
    private final boolean isRemoteMode;
    private final Configuration conf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void main(String[] stringArray) {
        SparkSQLCLIDriver$.MODULE$.main(stringArray);
    }

    public static void installSignalHandler() {
        SparkSQLCLIDriver$.MODULE$.installSignalHandler();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private CliSessionState sessionState() {
        return this.sessionState;
    }

    private Log LOG() {
        return this.LOG;
    }

    private SessionState.LogHelper console() {
        return this.console;
    }

    private boolean isRemoteMode() {
        return this.isRemoteMode;
    }

    private Configuration conf() {
        return this.conf;
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(hiveVariables).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, String> kv) {
                SparkSQLEnv$.MODULE$.sqlContext().conf().setConfString((String)kv._1(), (String)kv._2());
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int processCmd(String cmd) {
        String cmd_trimmed = cmd.trim();
        String cmd_lower = cmd_trimmed.toLowerCase(Locale.ROOT);
        String[] tokens = cmd_trimmed.split("\\s+");
        String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
        if (cmd_lower.equals("quit") || cmd_lower.equals("exit")) {
            this.sessionState().close();
            System.exit(0);
        }
        if (tokens[0].toLowerCase(Locale.ROOT).equals("source") || cmd_trimmed.startsWith("!") || this.isRemoteMode()) {
            long start = System.currentTimeMillis();
            super.processCmd(cmd);
            long end = System.currentTimeMillis();
            double timeTaken = (double)(end - start) / 1000.0;
            this.console().printInfo(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time taken: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)timeTaken)})));
            return 0;
        }
        int ret = 0;
        HiveConf hconf = (HiveConf)this.conf();
        CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)hconf);
        if (proc != null) {
            if (!(proc instanceof Driver || proc instanceof SetProcessor || proc instanceof AddResourceProcessor || proc instanceof ListResourceProcessor || proc instanceof ResetProcessor)) {
                if (this.sessionState().getIsVerbose()) {
                    this.sessionState().out.println(new StringBuilder().append((Object)tokens[0]).append((Object)" ").append((Object)cmd_1).toString());
                }
                ret = proc.run(cmd_1).getResponseCode();
            } else {
                SparkSQLDriver driver = new SparkSQLDriver(SparkSQLDriver$.MODULE$.$lessinit$greater$default$1());
                driver.init();
                PrintStream out = this.sessionState().out;
                PrintStream err = this.sessionState().err;
                long start = System.currentTimeMillis();
                if (this.sessionState().getIsVerbose()) {
                    out.println(cmd);
                }
                CommandProcessorResponse rc = driver.run(cmd);
                long end = System.currentTimeMillis();
                double timeTaken = (double)(end - start) / 1000.0;
                ret = rc.getResponseCode();
                if (ret != 0) {
                    Throwable throwable = rc.getException();
                    if (throwable instanceof AnalysisException) {
                        AnalysisException analysisException = (AnalysisException)throwable;
                        err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analysisException.getMessage()})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        err.println(rc.getErrorMessage());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    driver.close();
                    return ret;
                }
                ArrayList res = new ArrayList();
                if (HiveConf.getBoolVar((Configuration)this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER)) {
                    Option$.MODULE$.apply((Object)driver.getSchema().getFieldSchemas()).foreach((Function1)new Serializable(this, out){
                        public static final long serialVersionUID = 0L;
                        private final PrintStream out$1;

                        public final void apply(List<FieldSchema> fields) {
                            this.out$1.println(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(FieldSchema x$1) {
                                    return x$1.getName();
                                }
                            }, Buffer$.MODULE$.canBuildFrom())).mkString("\t"));
                        }
                        {
                            this.out$1 = out$1;
                        }
                    });
                }
                IntRef counter = IntRef.create((int)0);
                try {
                    while (!out.checkError() && driver.getResults(res)) {
                        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res).asScala()).foreach((Function1)new Serializable(this, out, counter){
                            public static final long serialVersionUID = 0L;
                            private final PrintStream out$1;
                            private final IntRef counter$1;

                            public final void apply(String l) {
                                ++this.counter$1.elem;
                                this.out$1.println(l);
                            }
                            {
                                this.out$1 = out$1;
                                this.counter$1 = counter$1;
                            }
                        });
                        res.clear();
                    }
                }
                catch (IOException iOException) {
                    this.console().printError(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed with exception ", ": ", "\n                   |", "\n                 "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getClass().getName(), iOException.getMessage(), StringUtils.stringifyException((Throwable)iOException)})))).stripMargin());
                    ret = 1;
                }
                int cret = driver.close();
                if (ret == 0) {
                    ret = cret;
                }
                String responseMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time taken: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)timeTaken)}));
                if (counter.elem != 0) {
                    responseMsg = new StringBuilder().append((Object)responseMsg).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", Fetched ", " row(s)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)counter.elem)}))).toString();
                }
                this.console().printInfo(responseMsg, null);
                driver.destroy();
            }
        }
        int n = ret;
        return n;
    }

    public SparkSQLCLIDriver() {
        Logging.class.$init$((Logging)this);
        this.sessionState = (CliSessionState)SessionState.get();
        this.LOG = LogFactory.getLog((String)"CliDriver");
        this.console = new SessionState.LogHelper(this.LOG());
        if (this.sessionState().getIsSilent()) {
            org.apache.log4j.Logger.getRootLogger().setLevel(Level.WARN);
        }
        this.isRemoteMode = SparkSQLCLIDriver$.MODULE$.isRemoteMode(this.sessionState());
        Object object = this.conf = this.sessionState() == null ? new Configuration() : this.sessionState().getConf();
        if (this.isRemoteMode()) {
            throw new RuntimeException("Remote operations not supported");
        }
        SparkSQLEnv$.MODULE$.init();
    }
}

