/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.window;

import java.util.ArrayDeque;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.ExternalAppendOnlyUnsafeRowArray;
import org.apache.spark.sql.execution.window.AggregateProcessor;
import org.apache.spark.sql.execution.window.BoundOrdering;
import org.apache.spark.sql.execution.window.WindowFunctionFrame;
import org.apache.spark.sql.execution.window.WindowFunctionFrame$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=4Q!\u0001\u0002\u0003\u00059\u0011!d\u00157jI&twmV5oI><h)\u001e8di&|gN\u0012:b[\u0016T!a\u0001\u0003\u0002\r]Lg\u000eZ8x\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0014\u0005\u0001y\u0001C\u0001\t\u0012\u001b\u0005\u0011\u0011B\u0001\n\u0003\u0005M9\u0016N\u001c3po\u001a+hn\u0019;j_:4%/Y7f\u0011!!\u0002A!A!\u0002\u00131\u0012A\u0002;be\u001e,Go\u0001\u0001\u0011\u0005]QR\"\u0001\r\u000b\u0005e1\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005mA\"aC%oi\u0016\u0014h.\u00197S_^D\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\naJ|7-Z:t_J\u0004\"\u0001E\u0010\n\u0005\u0001\u0012!AE!hOJ,w-\u0019;f!J|7-Z:t_JD\u0001B\t\u0001\u0003\u0002\u0003\u0006IaI\u0001\u0007Y\n|WO\u001c3\u0011\u0005A!\u0013BA\u0013\u0003\u00055\u0011u.\u001e8e\u001fJ$WM]5oO\"Aq\u0005\u0001B\u0001B\u0003%1%\u0001\u0004vE>,h\u000e\u001a\u0005\u0006S\u0001!\tAK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b-bSFL\u0018\u0011\u0005A\u0001\u0001\"\u0002\u000b)\u0001\u00041\u0002\"B\u000f)\u0001\u0004q\u0002\"\u0002\u0012)\u0001\u0004\u0019\u0003\"B\u0014)\u0001\u0004\u0019\u0003BB\u0019\u0001A\u0003&!'A\u0003j]B,H\u000f\u0005\u00024i5\tA!\u0003\u00026\t\t\u0001S\t\u001f;fe:\fG.\u00119qK:$wJ\u001c7z+:\u001c\u0018MZ3S_^\f%O]1z\u0011%9\u0004\u00011A\u0001B\u0003&\u0001(A\u0007j]B,H/\u0013;fe\u0006$xN\u001d\t\u0004s\r3eB\u0001\u001eA\u001d\tYd(D\u0001=\u0015\tiT#\u0001\u0004=e>|GOP\u0005\u0002\u007f\u0005)1oY1mC&\u0011\u0011IQ\u0001\ba\u0006\u001c7.Y4f\u0015\u0005y\u0014B\u0001#F\u0005!IE/\u001a:bi>\u0014(BA!C!\t9%*D\u0001I\u0015\tI\u0005$A\u0006fqB\u0014Xm]:j_:\u001c\u0018BA&I\u0005%)fn]1gKJ{w\u000f\u0003\u0004N\u0001\u0001\u0006KAF\u0001\b]\u0016DHOU8x\u0011\u0019y\u0005\u0001)A\u0005!\u00061!-\u001e4gKJ\u00042!\u0015,\u0017\u001b\u0005\u0011&BA*U\u0003\u0011)H/\u001b7\u000b\u0003U\u000bAA[1wC&\u0011qK\u0015\u0002\u000b\u0003J\u0014\u0018-\u001f#fcV,\u0007BB-\u0001A\u0003&!,\u0001\bj]B,H\u000fS5hQ&sG-\u001a=\u0011\u0005mcV\"\u0001\"\n\u0005u\u0013%aA%oi\"1q\f\u0001Q!\ni\u000bQ\"\u001b8qkRdun^%oI\u0016D\b\"B1\u0001\t\u0003\u0012\u0017a\u00029sKB\f'/\u001a\u000b\u0003G\u001a\u0004\"a\u00173\n\u0005\u0015\u0014%\u0001B+oSRDQa\u001a1A\u0002I\nAA]8xg\")\u0011\u000e\u0001C!U\u0006)qO]5uKR\u00191m[7\t\u000b1D\u0007\u0019\u0001.\u0002\u000b%tG-\u001a=\t\u000b9D\u0007\u0019\u0001\f\u0002\u000f\r,(O]3oi\u0002")
public final class SlidingWindowFunctionFrame
extends WindowFunctionFrame {
    private final InternalRow target;
    private final AggregateProcessor processor;
    private final BoundOrdering lbound;
    private final BoundOrdering ubound;
    private ExternalAppendOnlyUnsafeRowArray input;
    private Iterator<UnsafeRow> inputIterator;
    private InternalRow nextRow;
    private final ArrayDeque<InternalRow> buffer;
    private int inputHighIndex;
    private int inputLowIndex;

    @Override
    public void prepare(ExternalAppendOnlyUnsafeRowArray rows) {
        this.input = rows;
        this.inputIterator = this.input.generateIterator();
        this.nextRow = WindowFunctionFrame$.MODULE$.getNextOrNull(this.inputIterator);
        this.inputHighIndex = 0;
        this.inputLowIndex = 0;
        this.buffer.clear();
    }

    @Override
    public void write(int index, InternalRow current) {
        boolean bufferUpdated;
        boolean bl = bufferUpdated = index == 0;
        while (this.nextRow != null && this.ubound.compare(this.nextRow, this.inputHighIndex, current, index) <= 0) {
            this.buffer.add(this.nextRow.copy());
            this.nextRow = WindowFunctionFrame$.MODULE$.getNextOrNull(this.inputIterator);
            ++this.inputHighIndex;
            bufferUpdated = true;
        }
        while (!this.buffer.isEmpty() && this.lbound.compare(this.buffer.peek(), this.inputLowIndex, current, index) < 0) {
            this.buffer.remove();
            ++this.inputLowIndex;
            bufferUpdated = true;
        }
        if (bufferUpdated) {
            this.processor.initialize(this.input.length());
            java.util.Iterator<InternalRow> iter = this.buffer.iterator();
            while (iter.hasNext()) {
                this.processor.update(iter.next());
            }
            this.processor.evaluate(this.target);
        }
    }

    public SlidingWindowFunctionFrame(InternalRow target, AggregateProcessor processor2, BoundOrdering lbound, BoundOrdering ubound) {
        this.target = target;
        this.processor = processor2;
        this.lbound = lbound;
        this.ubound = ubound;
        this.input = null;
        this.nextRow = null;
        this.buffer = new ArrayDeque();
        this.inputHighIndex = 0;
        this.inputLowIndex = 0;
    }
}

