/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.sql.Date;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeTimeout$;
import org.apache.spark.sql.catalyst.plans.logical.ProcessingTimeTimeout$;
import org.apache.spark.sql.execution.streaming.GroupStateImpl$;
import org.apache.spark.sql.streaming.GroupState;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMa!B\u0001\u0003\u0001\u0019q!AD$s_V\u00048\u000b^1uK&k\u0007\u000f\u001c\u0006\u0003\u0007\u0011\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u000b\u0003\u001fu\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0019q#G\u000e\u000e\u0003aQ!a\u0001\u0004\n\u0005iA\"AC$s_V\u00048\u000b^1uKB\u0011A$\b\u0007\u0001\t\u0015q\u0002A1\u0001!\u0005\u0005\u00196\u0001A\t\u0003C\u0011\u0002\"!\u0005\u0012\n\u0005\r\u0012\"a\u0002(pi\"Lgn\u001a\t\u0003#\u0015J!A\n\n\u0003\u0007\u0005s\u0017\u0010\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u00035y\u0007\u000f^5p]\u0006dg+\u00197vKB\u0019\u0011CK\u000e\n\u0005-\u0012\"AB(qi&|g\u000e\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003U\u0011\u0017\r^2i!J|7-Z:tS:<G+[7f\u001bN\u0004\"!E\u0018\n\u0005A\u0012\"\u0001\u0002'p]\u001eD\u0001B\r\u0001\u0003\u0002\u0003\u0006IAL\u0001\u0015KZ,g\u000e\u001e+j[\u0016<\u0016\r^3s[\u0006\u00148.T:\t\u0011Q\u0002!\u0011!Q\u0001\nU\n1\u0002^5nK>,HoQ8oMB\u0011qCN\u0005\u0003oa\u0011\u0011c\u0012:pkB\u001cF/\u0019;f)&lWm\\;u\u0011!I\u0004A!b\u0001\n\u0003R\u0014a\u00035bgRKW.\u001a3PkR,\u0012a\u000f\t\u0003#qJ!!\u0010\n\u0003\u000f\t{w\u000e\\3b]\"Aq\b\u0001B\u0001B\u0003%1(\u0001\u0007iCN$\u0016.\\3e\u001fV$\b\u0005C\u0003B\u0001\u0011%!)\u0001\u0004=S:LGO\u0010\u000b\u0007\u0007\u00163u\tS%\u0011\u0007\u0011\u00031$D\u0001\u0003\u0011\u0015A\u0003\t1\u0001*\u0011\u0015i\u0003\t1\u0001/\u0011\u0015\u0011\u0004\t1\u0001/\u0011\u0015!\u0004\t1\u00016\u0011\u0015I\u0004\t1\u0001<\u0011\u001dY\u0005\u00011A\u0005\n1\u000bQA^1mk\u0016,\u0012a\u0007\u0005\b\u001d\u0002\u0001\r\u0011\"\u0003P\u0003%1\u0018\r\\;f?\u0012*\u0017\u000f\u0006\u0002Q'B\u0011\u0011#U\u0005\u0003%J\u0011A!\u00168ji\"9A+TA\u0001\u0002\u0004Y\u0012a\u0001=%c!1a\u000b\u0001Q!\nm\taA^1mk\u0016\u0004\u0003b\u0002-\u0001\u0001\u0004%IAO\u0001\bI\u00164\u0017N\\3e\u0011\u001dQ\u0006\u00011A\u0005\nm\u000b1\u0002Z3gS:,Gm\u0018\u0013fcR\u0011\u0001\u000b\u0018\u0005\b)f\u000b\t\u00111\u0001<\u0011\u0019q\u0006\u0001)Q\u0005w\u0005AA-\u001a4j]\u0016$\u0007\u0005C\u0004a\u0001\u0001\u0007I\u0011\u0002\u001e\u0002\u000fU\u0004H-\u0019;fI\"9!\r\u0001a\u0001\n\u0013\u0019\u0017aC;qI\u0006$X\rZ0%KF$\"\u0001\u00153\t\u000fQ\u000b\u0017\u0011!a\u0001w!1a\r\u0001Q!\nm\n\u0001\"\u001e9eCR,G\r\t\u0005\bQ\u0002\u0001\r\u0011\"\u0003;\u0003\u001d\u0011X-\\8wK\u0012DqA\u001b\u0001A\u0002\u0013%1.A\u0006sK6|g/\u001a3`I\u0015\fHC\u0001)m\u0011\u001d!\u0016.!AA\u0002mBaA\u001c\u0001!B\u0013Y\u0014\u0001\u0003:f[>4X\r\u001a\u0011\t\u000fA\u0004\u0001\u0019!C\u0005c\u0006\u0001B/[7f_V$H+[7fgR\fW\u000e]\u000b\u0002]!91\u000f\u0001a\u0001\n\u0013!\u0018\u0001\u0006;j[\u0016|W\u000f\u001e+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0002Qk\"9AK]A\u0001\u0002\u0004q\u0003BB<\u0001A\u0003&a&A\tuS6,w.\u001e;US6,7\u000f^1na\u0002BQ!\u001f\u0001\u0005Bi\na!\u001a=jgR\u001c\b\"B>\u0001\t\u0003b\u0015aA4fi\")Q\u0010\u0001C!}\u0006Iq-\u001a;PaRLwN\\\u000b\u0002S!9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0011AB;qI\u0006$X\rF\u0002Q\u0003\u000bAa!a\u0002\u0000\u0001\u0004Y\u0012\u0001\u00038foZ\u000bG.^3\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e\u00051!/Z7pm\u0016$\u0012\u0001\u0015\u0005\b\u0003#\u0001A\u0011IA\n\u0003I\u0019X\r\u001e+j[\u0016|W\u000f\u001e#ve\u0006$\u0018n\u001c8\u0015\u0007A\u000b)\u0002C\u0004\u0002\u0018\u0005=\u0001\u0019\u0001\u0018\u0002\u0015\u0011,(/\u0019;j_:l5\u000fC\u0004\u0002\u0012\u0001!\t%a\u0007\u0015\u0007A\u000bi\u0002\u0003\u0005\u0002 \u0005e\u0001\u0019AA\u0011\u0003!!WO]1uS>t\u0007\u0003BA\u0012\u0003Sq1!EA\u0013\u0013\r\t9CE\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0012Q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d\"\u0003C\u0004\u00022\u0001!\t%a\r\u0002'M,G\u000fV5nK>,H\u000fV5nKN$\u0018-\u001c9\u0015\u0007A\u000b)\u0004C\u0004\u00028\u0005=\u0002\u0019\u0001\u0018\u0002\u0017QLW.Z:uC6\u0004Xj\u001d\u0015\u0007\u0003_\tY$!\u0017\u0011\u000bE\ti$!\u0011\n\u0007\u0005}\"C\u0001\u0004uQJ|wo\u001d\t\u0005\u0003\u0007\n\u0019F\u0004\u0003\u0002F\u0005=c\u0002BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-s$\u0001\u0004=e>|GOP\u0005\u0002'%\u0019\u0011\u0011\u000b\n\u0002\u000fA\f7m[1hK&!\u0011QKA,\u0005u)fn];qa>\u0014H/\u001a3Pa\u0016\u0014\u0018\r^5p]\u0016C8-\u001a9uS>t'bAA)%\u0005\u0012\u00111L\u0001WS\u001a\u0004s\u0005^5nK>,Ho\n\u0011iCN\u0004cn\u001c;!E\u0016,g\u000eI3oC\ndW\r\u001a\u0011j]\u0002ZV.\u00199}M2\fG/T1q;\u001e\u0013x.\u001e9t/&$\bn\u0015;bi\u0016\u0004\u0013N\u001c\u0011bAM$(/Z1nS:<\u0007%];fefDc!a\f\u0002`\u0005E\u0004#B\t\u0002>\u0005\u0005\u0004\u0003BA2\u0003[j!!!\u001a\u000b\t\u0005\u001d\u0014\u0011N\u0001\u0005Y\u0006twM\u0003\u0002\u0002l\u0005!!.\u0019<b\u0013\u0011\ty'!\u001a\u0003+%cG.Z4bYN#\u0018\r^3Fq\u000e,\u0007\u000f^5p]\u0006\u0012\u00111O\u00019o\",g\u000eI:uCR,\u0007%[:!K&$\b.\u001a:!]>$\b%\u001b8ji&\fG.\u001b>fI2\u0002sN\u001d\u0011bYJ,\u0017\rZ=!e\u0016lwN^3eQ\u0019\ty#a\u001e\u0002\u0000A)\u0011#!\u0010\u0002zA!\u00111IA>\u0013\u0011\ti(a\u0016\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|g.\t\u0002\u0002\u0002\u0006\u0001\u0013N\u001a\u0011(i&lWm\u001d;b[Bl5o\n\u0011jg\u0002rw\u000e\u001e\u0011q_NLG/\u001b<f\u0011\u001d\t\t\u0004\u0001C!\u0003\u000b#R\u0001UAD\u0003\u0013Cq!a\u000e\u0002\u0004\u0002\u0007a\u0006\u0003\u0005\u0002\f\u0006\r\u0005\u0019AA\u0011\u0003I\tG\rZ5uS>t\u0017\r\u001c#ve\u0006$\u0018n\u001c8)\r\u0005\r\u00151HA-Q\u0019\t\u0019)a\u0018\u0002r!2\u00111QA<\u0003'\u000b#!!&\u0002E%4\u0007eJ1eI&$\u0018n\u001c8bY\u0012+(/\u0019;j_:<\u0003%[:!S:4\u0018\r\\5e\u0011\u001d\t\t\u0004\u0001C!\u00033#2\u0001UAN\u0011!\ti*a&A\u0002\u0005}\u0015!\u0003;j[\u0016\u001cH/Y7q!\u0011\t\t+!*\u000e\u0005\u0005\r&bA\u0004\u0002j%!\u0011qUAR\u0005\u0011!\u0015\r^3)\r\u0005]\u00151HA-Q\u0019\t9*a\u0018\u0002r!9\u0011\u0011\u0007\u0001\u0005B\u0005=F#\u0002)\u00022\u0006M\u0006\u0002CAO\u0003[\u0003\r!a(\t\u0011\u0005-\u0015Q\u0016a\u0001\u0003CAc!!,\u0002<\u0005e\u0003FBAW\u0003?\n\t\b\u000b\u0004\u0002.\u0006]\u00141\u0013\u0005\b\u0003{\u0003A\u0011IA`\u0003!!xn\u0015;sS:<GCAA\u0011\u0011\u0019\t\u0019\r\u0001C\u0001u\u0005Q\u0001.Y:SK6|g/\u001a3\t\r\u0005\u001d\u0007\u0001\"\u0001;\u0003)A\u0017m]+qI\u0006$X\r\u001a\u0005\u0007\u0003\u0017\u0004A\u0011A9\u0002'\u001d,G\u000fV5nK>,H\u000fV5nKN$\u0018-\u001c9\t\u000f\u0005=\u0007\u0001\"\u0003\u0002R\u0006i\u0001/\u0019:tK\u0012+(/\u0019;j_:$2ALAj\u0011!\ty\"!4A\u0002\u0005\u0005\u0002bBAl\u0001\u0011%\u0011QB\u0001\u001dG\",7m\u001b+j[\u0016|W\u000f\u001e+j[\u0016\u001cH/Y7q\u00032dwn^3e\u000f!\tYN\u0001E\u0001\r\u0005u\u0017AD$s_V\u00048\u000b^1uK&k\u0007\u000f\u001c\t\u0004\t\u0006}gaB\u0001\u0003\u0011\u00031\u0011\u0011]\n\u0004\u0003?\u0004\u0002bB!\u0002`\u0012\u0005\u0011Q\u001d\u000b\u0003\u0003;D\u0011\"!;\u0002`\n\u0007I\u0011A9\u0002\u00199{u\fV%N\u000bN#\u0016)\u0014)\t\u0011\u00055\u0018q\u001cQ\u0001\n9\nQBT(`)&kUi\u0015+B\u001bB\u0003\u0003\u0002CAy\u0003?$\t!a=\u0002%\r\u0014X-\u0019;f\r>\u00148\u000b\u001e:fC6LgnZ\u000b\u0005\u0003k\fY\u0010\u0006\u0007\u0002x\u0006u(\u0011\u0001B\u0002\u0005\u000b\u00119\u0001\u0005\u0003E\u0001\u0005e\bc\u0001\u000f\u0002|\u00121a$a<C\u0002\u0001Bq\u0001KAx\u0001\u0004\ty\u0010\u0005\u0003\u0012U\u0005e\bBB\u0017\u0002p\u0002\u0007a\u0006\u0003\u00043\u0003_\u0004\rA\f\u0005\u0007i\u0005=\b\u0019A\u001b\t\re\ny\u000f1\u0001<\u0011!\u0011Y!a8\u0005\u0002\t5\u0011AD2sK\u0006$XMR8s\u0005\u0006$8\r\u001b\u000b\u0005\u0005\u001f\u0011\t\u0002E\u0002E\u0001\u0011Ba\u0001\u000eB\u0005\u0001\u0004)\u0004")
public class GroupStateImpl<S>
implements GroupState<S> {
    private final long batchProcessingTimeMs;
    private final long eventTimeWatermarkMs;
    private final GroupStateTimeout timeoutConf;
    private final boolean hasTimedOut;
    private S value;
    private boolean defined;
    private boolean updated;
    private boolean removed;
    private long timeoutTimestamp;

    public static GroupStateImpl<Object> createForBatch(GroupStateTimeout groupStateTimeout) {
        return GroupStateImpl$.MODULE$.createForBatch(groupStateTimeout);
    }

    public static <S> GroupStateImpl<S> createForStreaming(Option<S> option, long l, long l2, GroupStateTimeout groupStateTimeout, boolean bl) {
        return GroupStateImpl$.MODULE$.createForStreaming(option, l, l2, groupStateTimeout, bl);
    }

    public static long NO_TIMESTAMP() {
        return GroupStateImpl$.MODULE$.NO_TIMESTAMP();
    }

    @Override
    public boolean hasTimedOut() {
        return this.hasTimedOut;
    }

    private S value() {
        return this.value;
    }

    private void value_$eq(S x$1) {
        this.value = x$1;
    }

    private boolean defined() {
        return this.defined;
    }

    private void defined_$eq(boolean x$1) {
        this.defined = x$1;
    }

    private boolean updated() {
        return this.updated;
    }

    private void updated_$eq(boolean x$1) {
        this.updated = x$1;
    }

    private boolean removed() {
        return this.removed;
    }

    private void removed_$eq(boolean x$1) {
        this.removed = x$1;
    }

    private long timeoutTimestamp() {
        return this.timeoutTimestamp;
    }

    private void timeoutTimestamp_$eq(long x$1) {
        this.timeoutTimestamp = x$1;
    }

    @Override
    public boolean exists() {
        return this.defined();
    }

    @Override
    public S get() {
        if (this.defined()) {
            return this.value();
        }
        throw new NoSuchElementException("State is either not defined or has already been removed");
    }

    @Override
    public Option<S> getOption() {
        return this.defined() ? new Some(this.value()) : None$.MODULE$;
    }

    @Override
    public void update(S newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("'null' is not a valid state value");
        }
        this.value_$eq(newValue);
        this.defined_$eq(true);
        this.updated_$eq(true);
        this.removed_$eq(false);
    }

    @Override
    public void remove() {
        this.defined_$eq(false);
        this.updated_$eq(false);
        this.removed_$eq(true);
    }

    @Override
    public void setTimeoutDuration(long durationMs) {
        GroupStateTimeout groupStateTimeout = this.timeoutConf;
        ProcessingTimeTimeout$ processingTimeTimeout$ = ProcessingTimeTimeout$.MODULE$;
        if (!(groupStateTimeout != null ? !groupStateTimeout.equals(processingTimeTimeout$) : processingTimeTimeout$ != null)) {
            if (durationMs <= 0L) {
                throw new IllegalArgumentException("Timeout duration must be positive");
            }
            this.timeoutTimestamp_$eq(durationMs + this.batchProcessingTimeMs);
            return;
        }
        throw new UnsupportedOperationException("Cannot set timeout duration without enabling processing time timeout in map/flatMapGroupsWithState");
    }

    @Override
    public void setTimeoutDuration(String duration) {
        this.setTimeoutDuration(this.parseDuration(duration));
    }

    @Override
    public void setTimeoutTimestamp(long timestampMs) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        this.checkTimeoutTimestampAllowed();
        if (timestampMs <= 0L) {
            throw new IllegalArgumentException("Timeout timestamp must be positive");
        }
        if (this.eventTimeWatermarkMs != GroupStateImpl$.MODULE$.NO_TIMESTAMP() && timestampMs < this.eventTimeWatermarkMs) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timeout timestamp (", ") cannot be earlier than the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timestampMs)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current watermark (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.eventTimeWatermarkMs)}))).toString());
        }
        this.timeoutTimestamp_$eq(timestampMs);
    }

    @Override
    public void setTimeoutTimestamp(long timestampMs, String additionalDuration) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(this.parseDuration(additionalDuration) + timestampMs);
    }

    @Override
    public void setTimeoutTimestamp(Date timestamp) throws IllegalStateException, UnsupportedOperationException {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(timestamp.getTime());
    }

    @Override
    public void setTimeoutTimestamp(Date timestamp, String additionalDuration) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(timestamp.getTime() + this.parseDuration(additionalDuration));
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GroupState(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getOption().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(S x$1) {
                return x$1.toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "<undefined>";
            }
        })}));
    }

    public boolean hasRemoved() {
        return this.removed();
    }

    public boolean hasUpdated() {
        return this.updated();
    }

    public long getTimeoutTimestamp() {
        return this.timeoutTimestamp();
    }

    private long parseDuration(String duration) {
        if (StringUtils.isBlank((CharSequence)duration)) {
            throw new IllegalArgumentException("Provided duration is null or blank.");
        }
        String intervalString = duration.startsWith("interval") ? duration : new StringBuilder().append((Object)"interval ").append((Object)duration).toString();
        CalendarInterval cal = CalendarInterval.fromString((String)intervalString);
        if (cal == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Provided duration (", ") is not valid."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duration})));
        }
        if (cal.milliseconds() < 0L || cal.months < 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Provided duration (", ") is not positive"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duration})));
        }
        long millisPerMonth = 2678400000L;
        return cal.milliseconds() + (long)cal.months * millisPerMonth;
    }

    private void checkTimeoutTimestampAllowed() {
        GroupStateTimeout groupStateTimeout = this.timeoutConf;
        EventTimeTimeout$ eventTimeTimeout$ = EventTimeTimeout$.MODULE$;
        if (!(groupStateTimeout != null ? !groupStateTimeout.equals(eventTimeTimeout$) : eventTimeTimeout$ != null)) {
            return;
        }
        throw new UnsupportedOperationException("Cannot set timeout timestamp without enabling event time timeout in map/flatMapGroupsWithState");
    }

    public GroupStateImpl(Option<S> optionalValue, long batchProcessingTimeMs, long eventTimeWatermarkMs, GroupStateTimeout timeoutConf, boolean hasTimedOut) {
        this.batchProcessingTimeMs = batchProcessingTimeMs;
        this.eventTimeWatermarkMs = eventTimeWatermarkMs;
        this.timeoutConf = timeoutConf;
        this.hasTimedOut = hasTimedOut;
        this.value = optionalValue.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final S apply() {
                return null;
            }
        });
        this.defined = optionalValue.isDefined();
        this.updated = false;
        this.removed = false;
        this.timeoutTimestamp = GroupStateImpl$.MODULE$.NO_TIMESTAMP();
    }
}

