/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.io.NioBufferedFileInputStream;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.io.ByteStreams;
import org.spark_project.guava.io.Closeables;

public final class UnsafeSorterSpillReader
extends UnsafeSorterIterator
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(UnsafeSorterSpillReader.class);
    private static final int DEFAULT_BUFFER_SIZE_BYTES = 0x100000;
    private static final int MAX_BUFFER_SIZE_BYTES = 0x1000000;
    private InputStream in;
    private DataInputStream din;
    private int recordLength;
    private long keyPrefix;
    private int numRecords;
    private int numRecordsRemaining;
    private byte[] arr = new byte[0x100000];
    private Object baseObject = this.arr;
    private final long baseOffset = Platform.BYTE_ARRAY_OFFSET;
    private final TaskContext taskContext = TaskContext.get();

    public UnsafeSorterSpillReader(SerializerManager serializerManager, File file, BlockId blockId) throws IOException {
        long bufferSizeBytes;
        assert (file.length() > 0L);
        long l = bufferSizeBytes = SparkEnv.get() == null ? 0x100000L : SparkEnv.get().conf().getSizeAsBytes("spark.unsafe.sorter.spill.reader.buffer.size", 0x100000L);
        if (bufferSizeBytes > 0x1000000L || bufferSizeBytes < 0x100000L) {
            logger.warn("Value of config \"spark.unsafe.sorter.spill.reader.buffer.size\" = {} not in allowed range [{}, {}). Falling back to default value : {} bytes", new Object[]{bufferSizeBytes, 0x100000, 0x1000000, 0x100000});
            bufferSizeBytes = 0x100000L;
        }
        NioBufferedFileInputStream bs = new NioBufferedFileInputStream(file, (int)bufferSizeBytes);
        try {
            this.in = serializerManager.wrapStream(blockId, bs);
            this.din = new DataInputStream(this.in);
            this.numRecords = this.numRecordsRemaining = this.din.readInt();
        }
        catch (IOException e) {
            Closeables.close((Closeable)bs, (boolean)true);
            throw e;
        }
    }

    @Override
    public int getNumRecords() {
        return this.numRecords;
    }

    @Override
    public boolean hasNext() {
        return this.numRecordsRemaining > 0;
    }

    @Override
    public void loadNext() throws IOException {
        if (this.taskContext != null) {
            this.taskContext.killTaskIfInterrupted();
        }
        this.recordLength = this.din.readInt();
        this.keyPrefix = this.din.readLong();
        if (this.recordLength > this.arr.length) {
            this.arr = new byte[this.recordLength];
            this.baseObject = this.arr;
        }
        ByteStreams.readFully((InputStream)this.in, (byte[])this.arr, (int)0, (int)this.recordLength);
        --this.numRecordsRemaining;
        if (this.numRecordsRemaining == 0) {
            this.close();
        }
    }

    @Override
    public Object getBaseObject() {
        return this.baseObject;
    }

    @Override
    public long getBaseOffset() {
        return this.baseOffset;
    }

    @Override
    public int getRecordLength() {
        return this.recordLength;
    }

    @Override
    public long getKeyPrefix() {
        return this.keyPrefix;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
                this.din = null;
            }
        }
    }
}

