/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.source.libsvm;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.source.libsvm.LibSVMFileFormat$;
import org.apache.spark.ml.source.libsvm.LibSVMFileFormat$$anonfun$buildReader$1$;
import org.apache.spark.ml.source.libsvm.LibSVMOptions;
import org.apache.spark.ml.source.libsvm.LibSVMOptions$;
import org.apache.spark.ml.source.libsvm.LibSVMOutputWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc!B\u0001\u0003\u0001\tq!\u0001\u0005'jEN3VJR5mK\u001a{'/\\1u\u0015\t\u0019A!\u0001\u0004mS\n\u001ch/\u001c\u0006\u0003\u000b\u0019\taa]8ve\u000e,'BA\u0004\t\u0003\tiGN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\r\u0001q\"\u0007\t\u0003!]i\u0011!\u0005\u0006\u0003%M\t1\u0002Z1uCN|WO]2fg*\u0011A#F\u0001\nKb,7-\u001e;j_:T!A\u0006\u0005\u0002\u0007M\fH.\u0003\u0002\u0019#\t\u0019B+\u001a=u\u0005\u0006\u001cX\r\u001a$jY\u00164uN]7biB\u0011!$H\u0007\u00027)\u0011A$F\u0001\bg>,(oY3t\u0013\tq2D\u0001\nECR\f7k\\;sG\u0016\u0014VmZ5ti\u0016\u0014\b\"\u0002\u0011\u0001\t\u0003\u0011\u0013A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\r\u0002\"\u0001\n\u0001\u000e\u0003\tAQA\n\u0001\u0005B\u001d\n\u0011b\u001d5peRt\u0015-\\3\u0015\u0003!\u0002\"!K\u0018\u000f\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0014G\u0001\u0004TiJLgn\u001a\u0006\u0003]-BQa\r\u0001\u0005B\u001d\n\u0001\u0002^8TiJLgn\u001a\u0005\u0006k\u0001!IAN\u0001\rm\u0016\u0014\u0018NZ=TG\",W.\u0019\u000b\u0003oi\u0002\"A\u000b\u001d\n\u0005eZ#\u0001B+oSRDQa\u000f\u001bA\u0002q\n!\u0002Z1uCN\u001b\u0007.Z7b!\ti\u0004)D\u0001?\u0015\tyT#A\u0003usB,7/\u0003\u0002B}\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b\r\u0003A\u0011\t#\u0002\u0017%tg-\u001a:TG\",W.\u0019\u000b\u0005\u000b\"s5\u000bE\u0002+\rrJ!aR\u0016\u0003\r=\u0003H/[8o\u0011\u0015I%\t1\u0001K\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tYE*D\u0001\u0016\u0013\tiUC\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003P\u0005\u0002\u0007\u0001+A\u0004paRLwN\\:\u0011\t%\n\u0006\u0006K\u0005\u0003%F\u00121!T1q\u0011\u0015!&\t1\u0001V\u0003\u00151\u0017\u000e\\3t!\r1f,\u0019\b\u0003/rs!\u0001W.\u000e\u0003eS!AW\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0013BA/,\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00181\u0003\u0007M+\u0017O\u0003\u0002^WA\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0003MNT!A\u001a\u0006\u0002\r!\fGm\\8q\u0013\tA7M\u0001\u0006GS2,7\u000b^1ukNDQA\u001b\u0001\u0005B-\fA\u0002\u001d:fa\u0006\u0014Xm\u0016:ji\u0016$R\u0001\\8qqf\u0004\"\u0001E7\n\u00059\f\"aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\b\"B%j\u0001\u0004Q\u0005\"B9j\u0001\u0004\u0011\u0018a\u00016pEB\u00111O^\u0007\u0002i*\u0011Q/Z\u0001\n[\u0006\u0004(/\u001a3vG\u0016L!a\u001e;\u0003\u0007){'\rC\u0003PS\u0002\u0007\u0001\u000bC\u0003<S\u0002\u0007A\bC\u0003|\u0001\u0011\u0005C0A\u0006ck&dGMU3bI\u0016\u0014HcD?\u0002\u001a\u0005m\u0011QDA\u0011\u0003K\t\t$a\r\u0011\r)r\u0018\u0011AA\u0004\u0013\ty8FA\u0005Gk:\u001cG/[8ocA\u0019\u0001#a\u0001\n\u0007\u0005\u0015\u0011CA\bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f!\u00151\u0016\u0011BA\u0007\u0013\r\tY\u0001\u0019\u0002\t\u0013R,'/\u0019;peB!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014U\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003/\t\tBA\u0006J]R,'O\\1m%><\b\"B%{\u0001\u0004Q\u0005\"B\u001e{\u0001\u0004a\u0004BBA\u0010u\u0002\u0007A(A\bqCJ$\u0018\u000e^5p]N\u001b\u0007.Z7b\u0011\u0019\t\u0019C\u001fa\u0001y\u0005q!/Z9vSJ,GmU2iK6\f\u0007bBA\u0014u\u0002\u0007\u0011\u0011F\u0001\bM&dG/\u001a:t!\u00111f,a\u000b\u0011\u0007i\ti#C\u0002\u00020m\u0011aAR5mi\u0016\u0014\b\"B({\u0001\u0004\u0001\u0006bBA\u001bu\u0002\u0007\u0011qG\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005uR-\u0001\u0003d_:4\u0017\u0002BA!\u0003w\u0011QbQ8oM&<WO]1uS>t\u0007")
public class LibSVMFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    public String shortName() {
        return "libsvm";
    }

    public String toString() {
        return "LibSVM";
    }

    private void verifySchema(StructType dataSchema) {
        if (dataSchema.size() == 2 && dataSchema.apply(0).dataType().sameType(DataTypes.DoubleType) && dataSchema.apply(1).dataType().sameType((DataType)new VectorUDT()) && (int)dataSchema.apply(1).metadata().getLong(LibSVMOptions$.MODULE$.NUM_FEATURES()) > 0) {
            return;
        }
        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal schema for libsvm data, schema=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataSchema})));
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        LibSVMOptions libSVMOptions = new LibSVMOptions(options);
        int numFeatures = BoxesRunTime.unboxToInt((Object)libSVMOptions.numFeatures().getOrElse((Function0)new Serializable(this, sparkSession, files){
            public static final long serialVersionUID = 0L;
            private final SparkSession sparkSession$1;
            private final Seq files$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            /*
             * WARNING - void declaration
             */
            public int apply$mcI$sp() {
                void var1_1;
                Seq dataFiles = (Seq)this.files$1.filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileStatus x$1) {
                        return x$1.getPath().getName().startsWith("_");
                    }
                });
                if (dataFiles.length() == 1) {
                    String path = ((FileStatus)dataFiles.head()).getPath().toUri().toString();
                    SparkContext sc = this.sparkSession$1.sparkContext();
                    RDD<Tuple3<Object, int[], double[]>> parsed = MLUtils$.MODULE$.parseLibSVMFile(sc, path, sc.defaultParallelism());
                    return MLUtils$.MODULE$.computeNumFeatures(parsed);
                }
                if (var1_1.isEmpty()) {
                    throw new IOException("No input path specified for libsvm data");
                }
                throw new IOException("Multiple input paths are not supported for libsvm data.");
            }
            {
                this.sparkSession$1 = sparkSession$1;
                this.files$1 = files$1;
            }
        }));
        Metadata featuresMetadata = new MetadataBuilder().putLong(LibSVMOptions$.MODULE$.NUM_FEATURES(), (long)numFeatures).build();
        StructField structField = new StructField("label", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("features", (DataType)new VectorUDT(), false, featuresMetadata);
        return new Some((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField)));
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema);
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new LibSVMOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder().append((Object)".libsvm").append((Object)CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
        };
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        this.verifySchema(dataSchema);
        int numFeatures = (int)dataSchema.apply("features").metadata().getLong(LibSVMOptions$.MODULE$.NUM_FEATURES());
        Predef$.MODULE$.assert(numFeatures > 0);
        LibSVMOptions libSVMOptions = new LibSVMOptions(options);
        boolean isSparse = libSVMOptions.isSparse();
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return new Serializable(this, dataSchema, requiredSchema, numFeatures, isSparse, broadcastedHadoopConf){
            public static final long serialVersionUID = 0L;
            private final StructType dataSchema$1;
            public final StructType requiredSchema$1;
            public final int numFeatures$1;
            public final boolean isSparse$1;
            private final Broadcast broadcastedHadoopConf$1;

            public final Iterator<UnsafeRow> apply(PartitionedFile file) {
                HadoopFileLinesReader linesReader = new HadoopFileLinesReader(file, ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value());
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(this, linesReader){
                    public static final long serialVersionUID = 0L;
                    public final HadoopFileLinesReader linesReader$1;

                    public final TaskContext apply(TaskContext x$4) {
                        return x$4.addTaskCompletionListener((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$buildReader$1$$anonfun$apply$1 $outer;

                            public final void apply(TaskContext x$5) {
                                this.$outer.linesReader$1.close();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.linesReader$1 = linesReader$1;
                    }
                });
                Iterator points = linesReader.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Text x$6) {
                        return x$6.toString().trim();
                    }
                }).filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String line) {
                        return line.isEmpty() || line.startsWith("#");
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$1 $outer;

                    public final LabeledPoint apply(String line) {
                        Tuple3<Object, int[], double[]> tuple3 = MLUtils$.MODULE$.parseLibSVMRecord(line);
                        if (tuple3 != null) {
                            Tuple3 tuple32;
                            double label = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                            int[] indices = (int[])tuple3._2();
                            double[] values = (double[])tuple3._3();
                            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)label), (Object)indices, (Object)values);
                            double label2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
                            int[] indices2 = (int[])tuple33._2();
                            double[] values2 = (double[])tuple33._3();
                            return new LabeledPoint(label2, Vectors$.MODULE$.sparse(this.$outer.numFeatures$1, indices2, values2));
                        }
                        throw new MatchError(tuple3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                ExpressionEncoder converter = RowEncoder$.MODULE$.apply(this.dataSchema$1);
                Seq fullOutput = (Seq)this.dataSchema$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AttributeReference apply(StructField f) {
                        String x$8 = f.name();
                        DataType x$9 = f.dataType();
                        boolean x$10 = f.nullable();
                        Metadata x$11 = f.metadata();
                        ExprId x$12 = AttributeReference$.MODULE$.apply$default$5(x$8, x$9, x$10, x$11);
                        Option x$13 = AttributeReference$.MODULE$.apply$default$6(x$8, x$9, x$10, x$11);
                        Boolean x$14 = AttributeReference$.MODULE$.apply$default$7(x$8, x$9, x$10, x$11);
                        return new AttributeReference(x$8, x$9, x$10, x$11, x$12, x$13, x$14);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq requiredOutput = (Seq)fullOutput.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$1 $outer;

                    public final boolean apply(AttributeReference a) {
                        return Predef$.MODULE$.refArrayOps((Object[])this.$outer.requiredSchema$1.fieldNames()).contains((Object)a.name());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                UnsafeProjection requiredColumns = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)requiredOutput, fullOutput);
                return points.map((Function1)new Serializable(this, converter, requiredColumns){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$1 $outer;
                    private final ExpressionEncoder converter$1;
                    private final UnsafeProjection requiredColumns$1;

                    public final UnsafeRow apply(LabeledPoint pt) {
                        SparseVector features = this.$outer.isSparse$1 ? pt.features().toSparse() : pt.features().toDense();
                        return this.requiredColumns$1.apply(this.converter$1.toRow((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)pt.label()), features}))));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.converter$1 = converter$1;
                        this.requiredColumns$1 = requiredColumns$1;
                    }
                });
            }
            {
                this.dataSchema$1 = dataSchema$1;
                this.requiredSchema$1 = requiredSchema$1;
                this.numFeatures$1 = numFeatures$1;
                this.isSparse$1 = isSparse$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
            }
        };
    }
}

