/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnSecurityTokenProtos;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class NMTokenIdentifier
extends TokenIdentifier {
    private static Log LOG = LogFactory.getLog(NMTokenIdentifier.class);
    public static final Text KIND = new Text("NMToken");
    private YarnSecurityTokenProtos.NMTokenIdentifierProto proto;

    public NMTokenIdentifier(ApplicationAttemptId appAttemptId, NodeId nodeId, String applicationSubmitter, int masterKeyId) {
        YarnSecurityTokenProtos.NMTokenIdentifierProto.Builder builder = YarnSecurityTokenProtos.NMTokenIdentifierProto.newBuilder();
        if (appAttemptId != null) {
            builder.setAppAttemptId(((ApplicationAttemptIdPBImpl)appAttemptId).getProto());
        }
        if (nodeId != null) {
            builder.setNodeId(((NodeIdPBImpl)nodeId).getProto());
        }
        builder.setAppSubmitter(applicationSubmitter);
        builder.setKeyId(masterKeyId);
        this.proto = builder.build();
    }

    public NMTokenIdentifier() {
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        if (!this.proto.hasAppAttemptId()) {
            return null;
        }
        return new ApplicationAttemptIdPBImpl(this.proto.getAppAttemptId());
    }

    public NodeId getNodeId() {
        if (!this.proto.hasNodeId()) {
            return null;
        }
        return new NodeIdPBImpl(this.proto.getNodeId());
    }

    public String getApplicationSubmitter() {
        return this.proto.getAppSubmitter();
    }

    public int getKeyId() {
        return this.proto.getKeyId();
    }

    public void write(DataOutput out) throws IOException {
        LOG.debug((Object)("Writing NMTokenIdentifier to RPC layer: " + (Object)((Object)this)));
        out.write(this.proto.toByteArray());
    }

    public void readFields(DataInput in) throws IOException {
        this.proto = YarnSecurityTokenProtos.NMTokenIdentifierProto.parseFrom((DataInputStream)in);
    }

    public Text getKind() {
        return KIND;
    }

    public UserGroupInformation getUser() {
        String appAttemptId = null;
        if (this.proto.hasAppAttemptId()) {
            appAttemptId = new ApplicationAttemptIdPBImpl(this.proto.getAppAttemptId()).toString();
        }
        return UserGroupInformation.createRemoteUser(appAttemptId);
    }

    public YarnSecurityTokenProtos.NMTokenIdentifierProto getProto() {
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals(((NMTokenIdentifier)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }
}

