/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.Context;
import com.univocity.parsers.common.ConversionProcessor;
import com.univocity.parsers.common.DataProcessingException;
import com.univocity.parsers.common.NoopProcessorErrorHandler;
import com.univocity.parsers.common.ProcessorErrorHandler;
import com.univocity.parsers.common.fields.FieldConversionMapping;
import com.univocity.parsers.common.fields.FieldSet;
import com.univocity.parsers.conversions.Conversion;
import java.util.HashMap;
import java.util.Map;

public abstract class DefaultConversionProcessor
implements ConversionProcessor {
    private Map<Class<?>, Conversion[]> conversionsByType;
    private FieldConversionMapping conversions;
    private boolean conversionsInitialized;
    private int[] fieldIndexes;
    private boolean fieldsReordered;
    ProcessorErrorHandler errorHandler = NoopProcessorErrorHandler.instance;
    Context context;

    @Override
    public final FieldSet<Integer> convertIndexes(Conversion ... conversions) {
        return this.getConversions().applyConversionsOnFieldIndexes(conversions);
    }

    @Override
    public final void convertAll(Conversion ... conversions) {
        this.getConversions().applyConversionsOnAllFields(conversions);
    }

    @Override
    public final FieldSet<String> convertFields(Conversion ... conversions) {
        return this.getConversions().applyConversionsOnFieldNames(conversions);
    }

    private FieldConversionMapping getConversions() {
        if (this.conversions == null) {
            this.conversions = new FieldConversionMapping();
        }
        return this.conversions;
    }

    private void initializeConversions(String[] row, Context context) {
        this.conversionsInitialized = true;
        this.fieldIndexes = null;
        this.fieldsReordered = false;
        this.conversionsInitialized = false;
        String[] contextHeaders = context.headers();
        if (contextHeaders != null && contextHeaders.length > 0) {
            this.conversions.prepareExecution(false, contextHeaders);
        } else {
            this.conversions.prepareExecution(false, row);
        }
        this.fieldIndexes = context.extractedFieldIndexes();
        this.fieldsReordered = context.columnsReordered();
    }

    public final Object[] applyConversions(String[] row, Context context) {
        boolean keepRow = true;
        Object[] objectRow = new Object[row.length];
        boolean[] convertedFlags = this.conversionsByType != null ? new boolean[row.length] : null;
        System.arraycopy(row, 0, objectRow, 0, row.length);
        if (this.conversions != null) {
            if (!this.conversionsInitialized) {
                this.initializeConversions(row, context);
            }
            int length = !this.fieldsReordered && this.fieldIndexes == null ? objectRow.length : this.fieldIndexes.length;
            for (int i = 0; i < length; ++i) {
                try {
                    if (!this.fieldsReordered) {
                        if (this.fieldIndexes == null) {
                            objectRow[i] = this.conversions.applyConversions(i, row[i], convertedFlags);
                            continue;
                        }
                        int index = this.fieldIndexes[i];
                        objectRow[index] = this.conversions.applyConversions(index, row[index], convertedFlags);
                        continue;
                    }
                    objectRow[i] = this.conversions.applyConversions(this.fieldIndexes[i], row[i], convertedFlags);
                    continue;
                }
                catch (Throwable ex) {
                    keepRow = false;
                    this.handleConversionError(ex, objectRow, i);
                }
            }
        }
        if (keepRow && convertedFlags != null) {
            keepRow = this.applyConversionsByType(false, objectRow, convertedFlags);
        }
        if (keepRow) {
            return objectRow;
        }
        return null;
    }

    public final boolean reverseConversions(boolean executeInReverseOrder, Object[] row, String[] headers, int[] indexesToWrite) {
        boolean[] convertedFlags;
        boolean keepRow = true;
        boolean[] blArray = convertedFlags = this.conversionsByType != null ? new boolean[row.length] : null;
        if (this.conversions != null) {
            if (!this.conversionsInitialized) {
                this.conversionsInitialized = true;
                this.conversions.prepareExecution(true, headers != null ? headers : new String[row.length]);
                this.fieldIndexes = indexesToWrite;
            }
            int last = this.fieldIndexes == null ? row.length : this.fieldIndexes.length;
            for (int i = 0; i < last; ++i) {
                try {
                    if (this.fieldIndexes == null || this.fieldIndexes[i] == -1) {
                        row[i] = this.conversions.reverseConversions(executeInReverseOrder, i, row[i], convertedFlags);
                        continue;
                    }
                    int index = this.fieldIndexes[i];
                    row[index] = this.conversions.reverseConversions(executeInReverseOrder, index, row[index], convertedFlags);
                    continue;
                }
                catch (Throwable ex) {
                    keepRow = false;
                    this.handleConversionError(ex, row, i);
                }
            }
        }
        if (keepRow && convertedFlags != null) {
            keepRow = this.applyConversionsByType(true, row, convertedFlags);
        }
        return keepRow;
    }

    private boolean applyConversionsByType(boolean reverse, Object[] row, boolean[] convertedFlags) {
        boolean keepRow = true;
        for (int i = 0; i < row.length; ++i) {
            if (convertedFlags[i]) continue;
            try {
                row[i] = this.applyTypeConversion(reverse, row[i]);
                continue;
            }
            catch (Throwable ex) {
                keepRow = false;
                this.handleConversionError(ex, row, i);
            }
        }
        return keepRow;
    }

    protected final void handleConversionError(Throwable ex, Object[] row, int column) {
        DataProcessingException error;
        if (ex instanceof DataProcessingException) {
            error = (DataProcessingException)ex;
            error.setRow(row);
            error.setColumnIndex(column);
        } else {
            error = new DataProcessingException("Error processing data conversions", column, row, ex);
        }
        error.markAsNonFatal();
        error.setContext(this.context);
        this.errorHandler.handleError(error, row, this.context);
    }

    @Override
    public final void convertType(Class<?> type, Conversion ... conversions) {
        ArgumentUtils.noNulls("Type to convert", type);
        ArgumentUtils.noNulls("Sequence of conversions to apply over data of type " + type.getSimpleName(), conversions);
        if (this.conversionsByType == null) {
            this.conversionsByType = new HashMap();
        }
        this.conversionsByType.put(type, conversions);
    }

    private Object applyTypeConversion(boolean revert, Object input) {
        if (this.conversionsByType == null || input == null) {
            return input;
        }
        Conversion[] conversionSequence = this.conversionsByType.get(input.getClass());
        if (conversionSequence == null) {
            return input;
        }
        if (revert) {
            for (int i = 0; i < conversionSequence.length; ++i) {
                input = conversionSequence[i].revert(input);
            }
        } else {
            for (int i = 0; i < conversionSequence.length; ++i) {
                input = conversionSequence[i].execute(input);
            }
        }
        return input;
    }
}

