/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.spark_project.jetty.client.api.ContentProvider;
import org.spark_project.jetty.client.api.Request;
import org.spark_project.jetty.client.api.Response;
import org.spark_project.jetty.client.api.Result;
import org.spark_project.jetty.client.util.InputStreamContentProvider;
import org.spark_project.jetty.http.HttpVersion;
import org.spark_project.jetty.proxy.AbstractProxyServlet;
import org.spark_project.jetty.util.Callback;

public class ProxyServlet
extends AbstractProxyServlet {
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int requestId = this.getRequestId(request);
        String rewrittenTarget = this.rewriteTarget(request);
        if (this._log.isDebugEnabled()) {
            StringBuffer uri = request.getRequestURL();
            if (request.getQueryString() != null) {
                uri.append("?").append(request.getQueryString());
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug("{} rewriting: {} -> {}", requestId, uri, rewrittenTarget);
            }
        }
        if (rewrittenTarget == null) {
            this.onProxyRewriteFailed(request, response);
            return;
        }
        Request proxyRequest = this.getHttpClient().newRequest(rewrittenTarget).method(request.getMethod()).version(HttpVersion.fromString(request.getProtocol()));
        this.copyRequestHeaders(request, proxyRequest);
        this.addProxyHeaders(request, proxyRequest);
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        proxyRequest.timeout(this.getTimeout(), TimeUnit.MILLISECONDS);
        if (this.hasContent(request)) {
            proxyRequest.content(this.proxyRequestContent(request, response, proxyRequest));
        }
        this.sendProxyRequest(request, response, proxyRequest);
    }

    protected ContentProvider proxyRequestContent(HttpServletRequest request, HttpServletResponse response, Request proxyRequest) throws IOException {
        return new ProxyInputStreamContentProvider(request, response, proxyRequest, (InputStream)request.getInputStream());
    }

    @Override
    protected Response.Listener newProxyResponseListener(HttpServletRequest request, HttpServletResponse response) {
        return new ProxyResponseListener(request, response);
    }

    protected void onResponseContent(HttpServletRequest request, HttpServletResponse response, Response proxyResponse, byte[] buffer, int offset, int length, Callback callback) {
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug("{} proxying content to downstream: {} bytes", this.getRequestId(request), length);
            }
            response.getOutputStream().write(buffer, offset, length);
            callback.succeeded();
        }
        catch (Throwable x) {
            callback.failed(x);
        }
    }

    protected class ProxyInputStreamContentProvider
    extends InputStreamContentProvider {
        private final HttpServletResponse response;
        private final Request proxyRequest;
        private final HttpServletRequest request;

        protected ProxyInputStreamContentProvider(HttpServletRequest request, HttpServletResponse response, Request proxyRequest, InputStream input) {
            super(input);
            this.request = request;
            this.response = response;
            this.proxyRequest = proxyRequest;
        }

        @Override
        public long getLength() {
            return this.request.getContentLength();
        }

        @Override
        protected ByteBuffer onRead(byte[] buffer, int offset, int length) {
            if (ProxyServlet.this._log.isDebugEnabled()) {
                ProxyServlet.this._log.debug("{} proxying content to upstream: {} bytes", ProxyServlet.this.getRequestId(this.request), length);
            }
            return this.onRequestContent(this.request, this.proxyRequest, buffer, offset, length);
        }

        protected ByteBuffer onRequestContent(HttpServletRequest request, Request proxyRequest, byte[] buffer, int offset, int length) {
            return super.onRead(buffer, offset, length);
        }

        @Override
        protected void onReadFailure(Throwable failure) {
            ProxyServlet.this.onClientRequestFailure(this.request, this.proxyRequest, this.response, failure);
        }
    }

    protected class ProxyResponseListener
    extends Response.Listener.Adapter {
        private final HttpServletRequest request;
        private final HttpServletResponse response;

        protected ProxyResponseListener(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        @Override
        public void onBegin(Response proxyResponse) {
            this.response.setStatus(proxyResponse.getStatus());
        }

        @Override
        public void onHeaders(Response proxyResponse) {
            ProxyServlet.this.onServerResponseHeaders(this.request, this.response, proxyResponse);
        }

        @Override
        public void onContent(final Response proxyResponse, ByteBuffer content, Callback callback) {
            int offset;
            byte[] buffer;
            int length = content.remaining();
            if (content.hasArray()) {
                buffer = content.array();
                offset = content.arrayOffset();
            } else {
                buffer = new byte[length];
                content.get(buffer);
                offset = 0;
            }
            ProxyServlet.this.onResponseContent(this.request, this.response, proxyResponse, buffer, offset, length, new Callback.Nested(callback){

                @Override
                public void failed(Throwable x) {
                    super.failed(x);
                    proxyResponse.abort(x);
                }
            });
        }

        @Override
        public void onComplete(Result result2) {
            if (result2.isSucceeded()) {
                ProxyServlet.this.onProxyResponseSuccess(this.request, this.response, result2.getResponse());
            } else {
                ProxyServlet.this.onProxyResponseFailure(this.request, this.response, result2.getResponse(), result2.getFailure());
            }
            if (ProxyServlet.this._log.isDebugEnabled()) {
                ProxyServlet.this._log.debug("{} proxying complete", ProxyServlet.this.getRequestId(this.request));
            }
        }
    }

    public static class Transparent
    extends ProxyServlet {
        private final AbstractProxyServlet.TransparentDelegate delegate = new AbstractProxyServlet.TransparentDelegate(this);

        public void init(ServletConfig config) throws ServletException {
            super.init(config);
            this.delegate.init(config);
        }

        @Override
        protected String rewriteTarget(HttpServletRequest request) {
            return this.delegate.rewriteTarget(request);
        }
    }
}

