/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.StorageStatus;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001-\u0011Qc\u0015;pe\u0006<Wm\u0015;biV\u001cH*[:uK:,'O\u0003\u0002\u0004\t\u000591\u000f^8sC\u001e,'BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0003\u001f\u0011\t\u0011b]2iK\u0012,H.\u001a:\n\u0005Eq!!D*qCJ\\G*[:uK:,'\u000f\u0003\u0005\u0014\u0001\t\u0005\t\u0015!\u0003\u0015\u0003\u0011\u0019wN\u001c4\u0011\u0005U1R\"\u0001\u0003\n\u0005]!!!C*qCJ\\7i\u001c8g\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\u00111$\b\t\u00039\u0001i\u0011A\u0001\u0005\u0006'a\u0001\r\u0001\u0006\u0005\t?\u0001\u0011\r\u0011\"\u0001\u0003A\u0005IR\r_3dkR|'/\u00133U_N#xN]1hKN#\u0018\r^;t+\u0005\t\u0003\u0003\u0002\u0012*WMj\u0011a\t\u0006\u0003I\u0015\nq!\\;uC\ndWM\u0003\u0002'O\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003!\nQa]2bY\u0006L!AK\u0012\u0003\u00075\u000b\u0007\u000f\u0005\u0002-a9\u0011QFL\u0007\u0002O%\u0011qfJ\u0001\u0007!J,G-\u001a4\n\u0005E\u0012$AB*ue&twM\u0003\u00020OA\u0011A\u0004N\u0005\u0003k\t\u0011Qb\u0015;pe\u0006<Wm\u0015;biV\u001c\bBB\u001c\u0001A\u0003%\u0011%\u0001\u000efq\u0016\u001cW\u000f^8s\u0013\u0012$vn\u0015;pe\u0006<Wm\u0015;biV\u001c\b\u0005\u0003\u0005:\u0001\t\u0007I\u0011\u0001\u0002;\u0003e!W-\u00193Fq\u0016\u001cW\u000f^8s'R|'/Y4f'R\fG/^:\u0016\u0003m\u00022A\t\u001f4\u0013\ti4E\u0001\u0006MSN$()\u001e4gKJDaa\u0010\u0001!\u0002\u0013Y\u0014A\u00073fC\u0012,\u00050Z2vi>\u00148\u000b^8sC\u001e,7\u000b^1ukN\u0004\u0003BB!\u0001A\u0003%!)A\u000bsKR\f\u0017N\\3e\t\u0016\fG-\u0012=fGV$xN]:\u0011\u00055\u001a\u0015B\u0001#(\u0005\rIe\u000e\u001e\u0005\u0006\r\u0002!\taR\u0001\u0012gR|'/Y4f'R\fG/^:MSN$X#\u0001%\u0011\u0007%\u000b6G\u0004\u0002K\u001f:\u00111JT\u0007\u0002\u0019*\u0011QJC\u0001\u0007yI|w\u000e\u001e \n\u0003!J!\u0001U\u0014\u0002\u000fA\f7m[1hK&\u0011!k\u0015\u0002\u0004'\u0016\f(B\u0001)(\u0011\u0015)\u0006\u0001\"\u0001H\u0003U!W-\u00193Ti>\u0014\u0018mZ3Ti\u0006$Xo\u001d'jgRDQa\u0016\u0001\u0005\na\u000b1#\u001e9eCR,7\u000b^8sC\u001e,7\u000b^1ukN$2!\u0017/_!\ti#,\u0003\u0002\\O\t!QK\\5u\u0011\u0015if\u000b1\u0001,\u0003\u0019)\u00070Z2JI\")qL\u0016a\u0001A\u0006iQ\u000f\u001d3bi\u0016$'\t\\8dWN\u00042!S)b!\u0011i#\rZ4\n\u0005\r<#A\u0002+va2,'\u0007\u0005\u0002\u001dK&\u0011aM\u0001\u0002\b\u00052|7m[%e!\ta\u0002.\u0003\u0002j\u0005\tY!\t\\8dWN#\u0018\r^;t\u0011\u00159\u0006\u0001\"\u0003l)\tIF\u000eC\u0003nU\u0002\u0007!)\u0001\tv]B,'o]5ti\u0016$'\u000b\u0012#JI\")q\u000e\u0001C!a\u0006qqN\\+oa\u0016\u00148/[:u%\u0012#ECA-r\u0011\u0015\u0011h\u000e1\u0001t\u00031)h\u000e]3sg&\u001cHO\u0015#E!\tiA/\u0003\u0002v\u001d\tI2\u000b]1sW2K7\u000f^3oKJ,f\u000e]3sg&\u001cHO\u0015#E\u0011\u00159\b\u0001\"\u0011y\u0003MygN\u00117pG.l\u0015M\\1hKJ\fE\rZ3e)\tI\u0016\u0010C\u0003{m\u0002\u000710A\tcY>\u001c7.T1oC\u001e,'/\u00113eK\u0012\u0004\"!\u0004?\n\u0005ut!AH*qCJ\\G*[:uK:,'O\u00117pG.l\u0015M\\1hKJ\fE\rZ3e\u0011\u0019y\b\u0001\"\u0011\u0002\u0002\u0005)rN\u001c\"m_\u000e\\W*\u00198bO\u0016\u0014(+Z7pm\u0016$GcA-\u0002\u0004!9\u0011Q\u0001@A\u0002\u0005\u001d\u0011a\u00052m_\u000e\\W*\u00198bO\u0016\u0014(+Z7pm\u0016$\u0007cA\u0007\u0002\n%\u0019\u00111\u0002\b\u0003AM\u0003\u0018M]6MSN$XM\\3s\u00052|7m['b]\u0006<WM\u001d*f[>4X\r\u001a\u0005\b\u0003\u001f\u0001A\u0011IA\t\u00039ygN\u00117pG.,\u0006\u000fZ1uK\u0012$2!WA\n\u0011!\t)\"!\u0004A\u0002\u0005]\u0011\u0001\u00042m_\u000e\\W\u000b\u001d3bi\u0016$\u0007cA\u0007\u0002\u001a%\u0019\u00111\u0004\b\u00033M\u0003\u0018M]6MSN$XM\\3s\u00052|7m[+qI\u0006$X\r\u001a\u0015\b\u0001\u0005}\u0011QEA\u0015!\ri\u0013\u0011E\u0005\u0004\u0003G9#A\u00033faJ,7-\u0019;fI\u0006\u0012\u0011qE\u00010)\"L7\u000fI2mCN\u001c\be^5mY\u0002\u0012W\r\t:f[>4X\r\u001a\u0011j]\u0002\n\u0007EZ;ukJ,\u0007E]3mK\u0006\u001cXML\u0011\u0003\u0003W\tQA\r\u00183]AB3\u0001AA\u0018!\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001b\t\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u00121\u0007\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b")
public class StorageStatusListener
extends SparkListener {
    private final Map<String, StorageStatus> executorIdToStorageStatus = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final ListBuffer<StorageStatus> deadExecutorStorageStatus = new ListBuffer();
    private final int retainedDeadExecutors;

    public Map<String, StorageStatus> executorIdToStorageStatus() {
        return this.executorIdToStorageStatus;
    }

    public ListBuffer<StorageStatus> deadExecutorStorageStatus() {
        return this.deadExecutorStorageStatus;
    }

    public synchronized Seq<StorageStatus> storageStatusList() {
        return this.executorIdToStorageStatus().values().toSeq();
    }

    public synchronized Seq<StorageStatus> deadStorageStatusList() {
        return this.deadExecutorStorageStatus();
    }

    private void updateStorageStatus(String execId, Seq<Tuple2<BlockId, BlockStatus>> updatedBlocks) {
        this.executorIdToStorageStatus().get((Object)execId).foreach((Function1)new Serializable(this, updatedBlocks){
            public static final long serialVersionUID = 0L;
            private final Seq updatedBlocks$1;

            public final void apply(StorageStatus storageStatus2) {
                this.updatedBlocks$1.foreach((Function1)new Serializable(this, storageStatus2){
                    public static final long serialVersionUID = 0L;
                    private final StorageStatus storageStatus$1;

                    public final Object apply(Tuple2<BlockId, BlockStatus> x0$1) {
                        Tuple2<BlockId, BlockStatus> tuple2 = x0$1;
                        if (tuple2 != null) {
                            BoxedUnit boxedUnit;
                            BlockId blockId = (BlockId)tuple2._1();
                            BlockStatus updatedStatus = (BlockStatus)tuple2._2();
                            StorageLevel storageLevel = updatedStatus.storageLevel();
                            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                            if (!(storageLevel != null ? !((Object)storageLevel).equals(storageLevel2) : storageLevel2 != null)) {
                                boxedUnit = this.storageStatus$1.removeBlock(blockId);
                            } else {
                                this.storageStatus$1.updateBlock(blockId, updatedStatus);
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            return boxedUnit2;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.storageStatus$1 = storageStatus$1;
                    }
                });
            }
            {
                this.updatedBlocks$1 = updatedBlocks$1;
            }
        });
    }

    private void updateStorageStatus(int unpersistedRDDId) {
        this.storageStatusList().foreach((Function1)new Serializable(this, unpersistedRDDId){
            public static final long serialVersionUID = 0L;
            private final int unpersistedRDDId$1;

            public final void apply(StorageStatus storageStatus2) {
                storageStatus2.rddBlocksById(this.unpersistedRDDId$1).foreach((Function1)new Serializable(this, storageStatus2){
                    public static final long serialVersionUID = 0L;
                    private final StorageStatus storageStatus$2;

                    public final Option<BlockStatus> apply(Tuple2<BlockId, BlockStatus> x0$2) {
                        Tuple2<BlockId, BlockStatus> tuple2 = x0$2;
                        if (tuple2 != null) {
                            BlockId blockId = (BlockId)tuple2._1();
                            Option<BlockStatus> option = this.storageStatus$2.removeBlock(blockId);
                            return option;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.storageStatus$2 = storageStatus$2;
                    }
                });
            }
            {
                this.unpersistedRDDId$1 = unpersistedRDDId$1;
            }
        });
    }

    @Override
    public synchronized void onUnpersistRDD(SparkListenerUnpersistRDD unpersistRDD) {
        this.updateStorageStatus(unpersistRDD.rddId());
    }

    @Override
    public synchronized void onBlockManagerAdded(SparkListenerBlockManagerAdded blockManagerAdded) {
        BlockManagerId blockManagerId = blockManagerAdded.blockManagerId();
        String executorId = blockManagerId.executorId();
        StorageStatus storageStatus2 = new StorageStatus(blockManagerId, blockManagerAdded.maxMem(), blockManagerAdded.maxOnHeapMem(), blockManagerAdded.maxOffHeapMem());
        this.executorIdToStorageStatus().update((Object)executorId, (Object)storageStatus2);
        ((TraversableForwarder)this.deadExecutorStorageStatus().zipWithIndex(ListBuffer$.MODULE$.canBuildFrom())).find((Function1)new Serializable(this, executorId){
            public static final long serialVersionUID = 0L;
            private final String executorId$1;

            public final boolean apply(Tuple2<StorageStatus, Object> x$1) {
                String string = ((StorageStatus)x$1._1()).blockManagerId().executorId();
                String string2 = this.executorId$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.executorId$1 = executorId$1;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatusListener $outer;

            public final StorageStatus apply(Tuple2<StorageStatus, Object> toRemoveExecutor) {
                return (StorageStatus)this.$outer.deadExecutorStorageStatus().remove(toRemoveExecutor._2$mcI$sp());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public synchronized void onBlockManagerRemoved(SparkListenerBlockManagerRemoved blockManagerRemoved) {
        String executorId = blockManagerRemoved.blockManagerId().executorId();
        this.executorIdToStorageStatus().remove((Object)executorId).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatusListener $outer;

            public final ListBuffer<StorageStatus> apply(StorageStatus status) {
                return this.$outer.deadExecutorStorageStatus().$plus$eq((Object)status);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (this.deadExecutorStorageStatus().size() > this.retainedDeadExecutors) {
            this.deadExecutorStorageStatus().trimStart(1);
        }
    }

    @Override
    public void onBlockUpdated(SparkListenerBlockUpdated blockUpdated) {
        String executorId = blockUpdated.blockUpdatedInfo().blockManagerId().executorId();
        BlockId blockId = blockUpdated.blockUpdatedInfo().blockId();
        StorageLevel storageLevel = blockUpdated.blockUpdatedInfo().storageLevel();
        long memSize = blockUpdated.blockUpdatedInfo().memSize();
        long diskSize = blockUpdated.blockUpdatedInfo().diskSize();
        BlockStatus blockStatus2 = new BlockStatus(storageLevel, memSize, diskSize);
        this.updateStorageStatus(executorId, (Seq<Tuple2<BlockId, BlockStatus>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)blockId, (Object)blockStatus2)}))));
    }

    public StorageStatusListener(SparkConf conf) {
        this.retainedDeadExecutors = conf.getInt("spark.ui.retainedDeadExecutors", 100);
    }
}

