/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcRelationProvider;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DataSource$
implements Serializable {
    public static final DataSource$ MODULE$;
    private final Map<String, String> backwardCompatibilityMap;
    private final Set<String> spark2RemovedClasses;

    static {
        new DataSource$();
    }

    private Map<String, String> backwardCompatibilityMap() {
        return this.backwardCompatibilityMap;
    }

    private Set<String> spark2RemovedClasses() {
        return this.spark2RemovedClasses;
    }

    public Class<?> lookupDataSource(String provider) {
        String provider1 = (String)this.backwardCompatibilityMap().getOrElse((Object)provider, (Function0)new Serializable(provider){
            public static final long serialVersionUID = 0L;
            private final String provider$1;

            public final String apply() {
                return this.provider$1;
            }
            {
                this.provider$1 = provider$1;
            }
        });
        String provider2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".DefaultSource"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider1}));
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        ServiceLoader<DataSourceRegister> serviceLoader = ServiceLoader.load(DataSourceRegister.class, loader);
        try {
            Class clazz;
            List list;
            block15: {
                Try try_;
                block16: {
                    Throwable error;
                    block18: {
                        block17: {
                            block14: {
                                list = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(serviceLoader).asScala()).filter((Function1)new Serializable(provider1){
                                    public static final long serialVersionUID = 0L;
                                    private final String provider1$1;

                                    public final boolean apply(DataSourceRegister x$16) {
                                        return x$16.shortName().equalsIgnoreCase(this.provider1$1);
                                    }
                                    {
                                        this.provider1$1 = provider1$1;
                                    }
                                })).toList();
                                if (!Nil$.MODULE$.equals(list)) break block15;
                                try {
                                    Class dataSource;
                                    Class clazz2;
                                    try_ = Try$.MODULE$.apply((Function0)new Serializable(provider1, loader){
                                        public static final long serialVersionUID = 0L;
                                        private final String provider1$1;
                                        private final ClassLoader loader$1;

                                        public final Class<Object> apply() {
                                            return this.loader$1.loadClass(this.provider1$1);
                                        }
                                        {
                                            this.provider1$1 = provider1$1;
                                            this.loader$1 = loader$1;
                                        }
                                    }).orElse((Function0)new Serializable(provider2, loader){
                                        public static final long serialVersionUID = 0L;
                                        public final String provider2$1;
                                        public final ClassLoader loader$1;

                                        public final Try<Class<Object>> apply() {
                                            return Try$.MODULE$.apply((Function0)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ anonfun.25 $outer;

                                                public final Class<Object> apply() {
                                                    return this.$outer.loader$1.loadClass(this.$outer.provider2$1);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            });
                                        }
                                        {
                                            this.provider2$1 = provider2$1;
                                            this.loader$1 = loader$1;
                                        }
                                    });
                                    if (!(try_ instanceof Success)) break block14;
                                    Success success = (Success)try_;
                                    clazz = clazz2 = (dataSource = (Class)success.value());
                                }
                                catch (NoClassDefFoundError noClassDefFoundError) {
                                    String className = noClassDefFoundError.getMessage().replaceAll("/", ".");
                                    if (this.spark2RemovedClasses().contains((Object)className)) {
                                        throw new ClassNotFoundException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " was removed in Spark 2.0. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{className}))).append((Object)"Please check if your library is compatible with Spark 2.0").toString(), noClassDefFoundError);
                                    }
                                    throw noClassDefFoundError;
                                }
                            }
                            if (!(try_ instanceof Failure)) break block16;
                            Failure failure = (Failure)try_;
                            error = failure.exception();
                            String string = provider1.toLowerCase();
                            String string2 = "orc";
                            if (!(string == null ? string2 != null : !string.equals(string2)) || provider1.startsWith("org.apache.spark.sql.hive.orc")) {
                                throw new AnalysisException("The ORC data source must be used with Hive support enabled", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                            }
                            String string3 = provider1.toLowerCase();
                            String string4 = "avro";
                            if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block17;
                            String string5 = provider1;
                            String string6 = "com.databricks.spark.avro";
                            if (string5 != null ? !string5.equals(string6) : string6 != null) break block18;
                        }
                        throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find data source: ", ". Please find an Avro "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider1.toLowerCase()}))).append((Object)"package at http://spark.apache.org/third-party-projects.html").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    throw new ClassNotFoundException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find data source: ", ". Please find packages at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider1}))).append((Object)"http://spark.apache.org/third-party-projects.html").toString(), error);
                }
                throw new MatchError((Object)try_);
            }
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                DataSourceRegister head2 = (DataSourceRegister)colon2.head();
                List list2 = colon2.tl$1();
                if (Nil$.MODULE$.equals(list2)) {
                    clazz = head2.getClass();
                    return clazz;
                }
            }
            throw package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple sources found for ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)list.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(DataSourceRegister x$17) {
                    return x$17.getClass().getName();
                }
            }, List$.MODULE$.canBuildFrom())).mkString(", ")}))).append((Object)"please specify the fully qualified class name.").toString());
        }
        catch (Throwable throwable) {
            ServiceConfigurationError serviceConfigurationError;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ServiceConfigurationError && (serviceConfigurationError = (ServiceConfigurationError)throwable2).getCause() instanceof NoClassDefFoundError) {
                String className = serviceConfigurationError.getCause().getMessage().replaceAll("/", ".");
                if (this.spark2RemovedClasses().contains((Object)className)) {
                    throw new ClassNotFoundException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected an incompatible DataSourceRegister. "})).s((Seq)Nil$.MODULE$)).append((Object)"Please remove the incompatible library from classpath or upgrade it. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceConfigurationError.getMessage()}))).toString(), serviceConfigurationError);
                }
                throw serviceConfigurationError;
            }
            throw throwable;
        }
    }

    public CatalogStorageFormat buildStorageFormatFromOptions(Map<String, String> options) {
        Option path = new CaseInsensitiveMap(options).get("path");
        Map optionsWithoutPath = options.filterKeys((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$18) {
                String string = x$18.toLowerCase();
                String string2 = "path";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        });
        Option x$28 = path;
        Map x$29 = optionsWithoutPath;
        Option x$30 = CatalogStorageFormat$.MODULE$.empty().copy$default$2();
        Option x$31 = CatalogStorageFormat$.MODULE$.empty().copy$default$3();
        Option x$32 = CatalogStorageFormat$.MODULE$.empty().copy$default$4();
        boolean x$33 = CatalogStorageFormat$.MODULE$.empty().copy$default$5();
        return CatalogStorageFormat$.MODULE$.empty().copy(x$28, x$30, x$31, x$32, x$33, x$29);
    }

    public DataSource apply(SparkSession sparkSession, String className, Seq<String> paths, Option<StructType> userSpecifiedSchema, Seq<String> partitionColumns, Option<BucketSpec> bucketSpec, Map<String, String> options, Option<CatalogTable> catalogTable) {
        return new DataSource(sparkSession, className, paths, userSpecifiedSchema, partitionColumns, bucketSpec, options, catalogTable);
    }

    public Option<Tuple8<SparkSession, String, Seq<String>, Option<StructType>, Seq<String>, Option<BucketSpec>, Map<String, String>, Option<CatalogTable>>> unapply(DataSource x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.sparkSession(), (Object)x$0.className(), x$0.paths(), x$0.userSpecifiedSchema(), x$0.partitionColumns(), x$0.bucketSpec(), x$0.options(), x$0.catalogTable()));
    }

    public Seq<String> apply$default$3() {
        return Nil$.MODULE$;
    }

    public Option<StructType> apply$default$4() {
        return None$.MODULE$;
    }

    public Seq<String> apply$default$5() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Option<BucketSpec> apply$default$6() {
        return None$.MODULE$;
    }

    public Map<String, String> apply$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<CatalogTable> apply$default$8() {
        return None$.MODULE$;
    }

    public Seq<String> $lessinit$greater$default$3() {
        return Nil$.MODULE$;
    }

    public Option<StructType> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Seq<String> $lessinit$greater$default$5() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Option<BucketSpec> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Map<String, String> $lessinit$greater$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<CatalogTable> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DataSource$() {
        MODULE$ = this;
        String jdbc = JdbcRelationProvider.class.getCanonicalName();
        String json = JsonFileFormat.class.getCanonicalName();
        String parquet = ParquetFileFormat.class.getCanonicalName();
        String csv = CSVFileFormat.class.getCanonicalName();
        String libsvm = "org.apache.spark.ml.source.libsvm.LibSVMFileFormat";
        String orc = "org.apache.spark.sql.hive.orc.OrcFileFormat";
        this.backwardCompatibilityMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.jdbc"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.jdbc.DefaultSource"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.jdbc.DefaultSource"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.jdbc"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.json"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.json.DefaultSource"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.json"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.json.DefaultSource"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.parquet"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.parquet.DefaultSource"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.parquet"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.parquet.DefaultSource"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.hive.orc.DefaultSource"), (Object)orc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.hive.orc"), (Object)orc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.ml.source.libsvm.DefaultSource"), (Object)libsvm), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.ml.source.libsvm"), (Object)libsvm), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"com.databricks.spark.csv"), (Object)csv)}));
        this.spark2RemovedClasses = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.spark.sql.DataFrame", "org.apache.spark.sql.sources.HadoopFsRelationProvider", "org.apache.spark.Logging"}));
    }
}

