/*
 * Decompiled with CFR 0.152.
 */
package spire.math.prime;

import java.math.BigInteger;
import java.util.Random;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import spire.algebra.Sign;
import spire.algebra.Sign$;
import spire.algebra.Sign$Positive$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.prime.Factors;
import spire.math.prime.Factors$;

public final class package$ {
    public static final package$ MODULE$;
    private final Random srand;

    static {
        new package$();
    }

    public boolean isPrime(SafeLong n) {
        return n.isProbablePrime(30);
    }

    public Factors factor(SafeLong n) {
        return this.factorPollardRho(n);
    }

    public Factors factorTrialDivision(SafeLong n0) {
        SafeLong safeLong = n0;
        Integer n = BoxesRunTime.boxToInteger((int)0);
        if (safeLong != null && safeLong.equals(n)) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n2 = n0.abs();
        Sign sign = Sign$.MODULE$.apply(n0.signum());
        SafeLong safeLong2 = n2;
        SafeLong safeLong3 = SafeLong$.MODULE$.one();
        if (!(safeLong2 != null ? !safeLong2.equals(safeLong3) : safeLong3 != null)) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), sign);
        }
        scala.collection.mutable.Map facts = Map$.MODULE$.empty();
        SafeLong x = n2;
        Tuple2<SafeLong, Object> tuple22 = this.findPowers(n2, SafeLong$.MODULE$.apply(2L));
        if (tuple22 != null) {
            Tuple2 tuple23 = new Tuple2(tuple22._1(), (Object)BoxesRunTime.boxToInteger((int)tuple22._2$mcI$sp()));
            SafeLong x1 = (SafeLong)tuple23._1();
            int e1 = tuple23._2$mcI$sp();
            if (e1 > 0) {
                facts.update((Object)SafeLong$.MODULE$.apply(2L), (Object)BoxesRunTime.boxToInteger((int)e1));
                x = x1;
            }
            SafeLong limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x);
            SafeLong index$macro$41 = SafeLong$.MODULE$.apply(3L);
            while (index$macro$41.$less$eq(limit) && x.$greater(SafeLong$.MODULE$.apply(1L))) {
                Tuple2<SafeLong, Object> tuple24 = this.findPowers(x, index$macro$41);
                if (tuple24 != null) {
                    Tuple2 tuple25 = new Tuple2(tuple24._1(), (Object)BoxesRunTime.boxToInteger((int)tuple24._2$mcI$sp()));
                    SafeLong x2 = (SafeLong)tuple25._1();
                    int e2 = tuple25._2$mcI$sp();
                    if (e2 > 0) {
                        facts.update((Object)index$macro$41, (Object)BoxesRunTime.boxToInteger((int)e2));
                        x = x2;
                        limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x2);
                    }
                    index$macro$41 = index$macro$41.$plus(2L);
                    continue;
                }
                throw new MatchError(tuple24);
            }
            if (x.$greater(SafeLong$.MODULE$.apply(1L))) {
                facts.update((Object)x, (Object)BoxesRunTime.boxToInteger((int)1));
            }
            return new Factors((Map<SafeLong, Object>)facts.toMap(Predef$.MODULE$.$conforms()), sign);
        }
        throw new MatchError(tuple22);
    }

    public Factors factorWheelDivision(SafeLong n0) {
        SafeLong safeLong = n0;
        Integer n = BoxesRunTime.boxToInteger((int)0);
        if (safeLong != null && safeLong.equals(n)) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n2 = n0.abs();
        Sign sign = Sign$.MODULE$.apply(n0.signum());
        SafeLong safeLong2 = n2;
        Integer n3 = BoxesRunTime.boxToInteger((int)1);
        if (safeLong2 != null && safeLong2.equals(n3)) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), sign);
        }
        scala.collection.mutable.Map facts = Map$.MODULE$.empty();
        SafeLong x = n2;
        Tuple2<SafeLong, Object> tuple22 = this.findPowers(n2, SafeLong$.MODULE$.apply(2L));
        if (tuple22 != null) {
            Tuple2 tuple23 = new Tuple2(tuple22._1(), (Object)BoxesRunTime.boxToInteger((int)tuple22._2$mcI$sp()));
            SafeLong x1 = (SafeLong)tuple23._1();
            int e1 = tuple23._2$mcI$sp();
            if (e1 > 0) {
                facts.update((Object)SafeLong$.MODULE$.apply(2L), (Object)BoxesRunTime.boxToInteger((int)e1));
                x = x1;
            }
            SafeLong index$macro$42 = SafeLong$.MODULE$.apply(3L);
            while (index$macro$42.$less(SafeLong$.MODULE$.apply(30L)) && x.$greater(SafeLong$.MODULE$.apply(1L))) {
                Tuple2<SafeLong, Object> tuple24 = this.findPowers(x, index$macro$42);
                if (tuple24 != null) {
                    Tuple2 tuple25 = new Tuple2(tuple24._1(), (Object)BoxesRunTime.boxToInteger((int)tuple24._2$mcI$sp()));
                    SafeLong x2 = (SafeLong)tuple25._1();
                    int e2 = tuple25._2$mcI$sp();
                    if (e2 > 0) {
                        facts.update((Object)index$macro$42, (Object)BoxesRunTime.boxToInteger((int)e2));
                        x = x2;
                    }
                    index$macro$42 = index$macro$42.$plus(2L);
                    continue;
                }
                throw new MatchError(tuple24);
            }
            SafeLong limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x);
            SafeLong b = SafeLong$.MODULE$.apply(31L);
            int i = 0;
            int[] offsets = new int[]{2, 2, 2, 4, 2, 4, 2, 4, 6, 2};
            while (b.$less$eq(limit) && x.$greater(SafeLong$.MODULE$.apply(1L))) {
                Tuple2<SafeLong, Object> tuple26 = this.findPowers(x, b);
                if (tuple26 != null) {
                    Tuple2 tuple27 = new Tuple2(tuple26._1(), (Object)BoxesRunTime.boxToInteger((int)tuple26._2$mcI$sp()));
                    SafeLong x2 = (SafeLong)tuple27._1();
                    int e2 = tuple27._2$mcI$sp();
                    if (e2 > 0) {
                        facts.update((Object)b, (Object)BoxesRunTime.boxToInteger((int)e2));
                        x = x2;
                        limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x2);
                    }
                    b = b.$plus(offsets[i]);
                    i = (i + 1) % 10;
                    continue;
                }
                throw new MatchError(tuple26);
            }
            if (x.$greater(SafeLong$.MODULE$.apply(1L))) {
                facts.update((Object)x, (Object)BoxesRunTime.boxToInteger((int)1));
            }
            return new Factors((Map<SafeLong, Object>)facts.toMap(Predef$.MODULE$.$conforms()), sign);
        }
        throw new MatchError(tuple22);
    }

    public Factors factorPollardRho(SafeLong n0) {
        SafeLong n;
        SafeLong safeLong = n0;
        Integer n2 = BoxesRunTime.boxToInteger((int)0);
        if (safeLong != null && safeLong.equals(n2)) {
            return Factors$.MODULE$.zero();
        }
        SafeLong safeLong2 = n = n0.abs();
        Integer n3 = BoxesRunTime.boxToInteger((int)1);
        if (safeLong2 != null && safeLong2.equals(n3)) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), Sign$.MODULE$.apply(n0.signum()));
        }
        return n0.$less(SafeLong$.MODULE$.apply(0L)) ? this.factor$1(n).unary_$minus() : this.factor$1(n);
    }

    private Random srand() {
        return this.srand;
    }

    private SafeLong rand(SafeLong n) {
        int bits = n.bitLength();
        BigInteger x = new BigInteger(bits, this.srand());
        while (x.signum() == 0) {
            x = new BigInteger(bits, this.srand());
        }
        return SafeLong$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(x));
    }

    private Tuple2<SafeLong, Object> findPowers(SafeLong x0, SafeLong b) {
        SafeLong x = x0;
        int e = 0;
        while (x.$greater(SafeLong$.MODULE$.apply(1L))) {
            SafeLong safeLong = x.$percent(b);
            Integer n = BoxesRunTime.boxToInteger((int)0);
            if (safeLong == null || !safeLong.equals(n)) break;
            ++e;
            x = x.$div(b);
        }
        return new Tuple2((Object)x, (Object)BoxesRunTime.boxToInteger((int)e));
    }

    private final SafeLong f$1(SafeLong x, SafeLong n$1, SafeLong c$1) {
        return x.$times(x).$percent(n$1).$plus(c$1).$percent(n$1);
    }

    private final SafeLong fastRho$1(SafeLong x, SafeLong q0, SafeLong r, SafeLong m, SafeLong n$1, SafeLong c$1) {
        SafeLong ys;
        SafeLong g;
        while (true) {
            SafeLong y = x;
            SafeLong q = q0;
            int index$macro$43 = 0;
            while (r.$greater(SafeLong$.MODULE$.apply(index$macro$43))) {
                y = y.$times(y).$percent(n$1).$plus(c$1).$percent(n$1);
                ++index$macro$43;
            }
            g = SafeLong$.MODULE$.one();
            SafeLong k = SafeLong$.MODULE$.zero();
            ys = y;
            while (r.$greater(k)) {
                SafeLong safeLong = g;
                Integer n = BoxesRunTime.boxToInteger((int)1);
                if (safeLong == null || !safeLong.equals(n)) break;
                ys = y;
                SafeLong limit = m.min(r.$minus(k));
                int index$macro$44 = 0;
                while (limit.$greater(SafeLong$.MODULE$.apply(index$macro$44))) {
                    y = y.$times(y).$percent(n$1).$plus(c$1).$percent(n$1);
                    q = q.$times(x.$minus(y).abs()).$percent(n$1);
                    ++index$macro$44;
                }
                SafeLong safeLong2 = q;
                Integer n2 = BoxesRunTime.boxToInteger((int)0);
                g = safeLong2 != null && safeLong2.equals(n2) ? n$1 : n$1.gcd(q);
                k = k.$plus(m);
            }
            SafeLong safeLong = g;
            Integer n = BoxesRunTime.boxToInteger((int)1);
            if (safeLong == null || !safeLong.equals(n)) break;
            r = r.$times(2L);
            q0 = q;
            x = y;
        }
        SafeLong safeLong = g;
        return !(safeLong != null ? !safeLong.equals(n$1) : n$1 != null) ? this.slowRho$1(x, ys, n$1, c$1) : g;
    }

    private final SafeLong slowRho$1(SafeLong x, SafeLong ys, SafeLong n$1, SafeLong c$1) {
        SafeLong g;
        while (true) {
            SafeLong yys = ys.$times(ys).$percent(n$1).$plus(c$1).$percent(n$1);
            SafeLong safeLong = g = n$1.gcd(x.$minus(yys).abs());
            Integer n = BoxesRunTime.boxToInteger((int)1);
            if (safeLong == null || !safeLong.equals(n)) break;
            ys = yys;
        }
        return g;
    }

    private final SafeLong rho$1(SafeLong n, SafeLong c) {
        return this.fastRho$1(this.rand(n), SafeLong$.MODULE$.one(), SafeLong$.MODULE$.one(), this.rand(n), n, c);
    }

    private final Factors factor$1(SafeLong n) {
        Factors factors;
        SafeLong safeLong = n;
        Integer n2 = BoxesRunTime.boxToInteger((int)1);
        if (safeLong != null && safeLong.equals(n2)) {
            factors = Factors$.MODULE$.one();
        } else if (n.isProbablePrime(30)) {
            Tuple2[] tuple2Array = new Tuple2[1];
            Integer n3 = BoxesRunTime.boxToInteger((int)1);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)n);
            Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
            tuple2Array[0] = new Tuple2(object, (Object)n3);
            factors = new Factors((Map<SafeLong, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), Sign$Positive$.MODULE$);
        } else {
            SafeLong safeLong2 = n.$percent(2L);
            Integer n4 = BoxesRunTime.boxToInteger((int)0);
            if (safeLong2 != null && safeLong2.equals(n4)) {
                SafeLong x = n.$div(2L);
                int e = 1;
                while (true) {
                    SafeLong safeLong3 = x.$percent(2L);
                    Integer n5 = BoxesRunTime.boxToInteger((int)0);
                    if (safeLong3 == null || !safeLong3.equals(n5)) break;
                    x = x.$div(2L);
                    ++e;
                }
                Tuple2[] tuple2Array = new Tuple2[1];
                Integer n6 = BoxesRunTime.boxToInteger((int)e);
                Object object = Predef$.MODULE$.ArrowAssoc((Object)SafeLong$.MODULE$.apply(2L));
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[0] = new Tuple2(object, (Object)n6);
                factors = new Factors((Map<SafeLong, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), Sign$Positive$.MODULE$).$times(this.factor$1(x));
            } else {
                SafeLong divisor = this.rho$1(n, this.rand(n));
                while (true) {
                    SafeLong safeLong4 = divisor;
                    if (safeLong4 != null ? !safeLong4.equals(n) : n != null) break;
                    divisor = this.rho$1(n, this.rand(n));
                }
                factors = this.factor$1(divisor).$times(this.factor$1(n.$div(divisor)));
            }
        }
        return factors;
    }

    private package$() {
        MODULE$ = this;
        this.srand = new Random();
    }
}

