/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.fusesource.leveldbjni.JniDBFactory;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelDBProvider {
    private static final Logger logger = LoggerFactory.getLogger(LevelDBProvider.class);

    public static DB initLevelDB(File dbFile, StoreVersion version, ObjectMapper mapper) throws IOException {
        DB tmpDb = null;
        if (dbFile != null) {
            Options options = new Options();
            options.createIfMissing(false);
            options.logger((org.iq80.leveldb.Logger)new LevelDBLogger());
            try {
                tmpDb = JniDBFactory.factory.open(dbFile, options);
            }
            catch (NativeDB.DBException e) {
                if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                    logger.info("Creating state database at " + dbFile);
                    options.createIfMissing(true);
                    try {
                        tmpDb = JniDBFactory.factory.open(dbFile, options);
                    }
                    catch (NativeDB.DBException dbExc) {
                        throw new IOException("Unable to create state store", dbExc);
                    }
                }
                logger.error("error opening leveldb file {}.  Creating new file, will not be able to recover state for existing applications", (Object)dbFile, (Object)e);
                if (dbFile.isDirectory()) {
                    for (File f : dbFile.listFiles()) {
                        if (f.delete()) continue;
                        logger.warn("error deleting {}", (Object)f.getPath());
                    }
                }
                if (!dbFile.delete()) {
                    logger.warn("error deleting {}", (Object)dbFile.getPath());
                }
                options.createIfMissing(true);
                try {
                    tmpDb = JniDBFactory.factory.open(dbFile, options);
                }
                catch (NativeDB.DBException dbExc) {
                    throw new IOException("Unable to create state store", dbExc);
                }
            }
            LevelDBProvider.checkVersion(tmpDb, version, mapper);
        }
        return tmpDb;
    }

    public static void checkVersion(DB db, StoreVersion newversion, ObjectMapper mapper) throws IOException {
        byte[] bytes = db.get(StoreVersion.KEY);
        if (bytes == null) {
            LevelDBProvider.storeVersion(db, newversion, mapper);
        } else {
            StoreVersion version = (StoreVersion)mapper.readValue(bytes, StoreVersion.class);
            if (version.major != newversion.major) {
                throw new IOException("cannot read state DB with version " + version + ", incompatible " + "with current version " + newversion);
            }
            LevelDBProvider.storeVersion(db, newversion, mapper);
        }
    }

    public static void storeVersion(DB db, StoreVersion version, ObjectMapper mapper) throws IOException {
        db.put(StoreVersion.KEY, mapper.writeValueAsBytes((Object)version));
    }

    public static class StoreVersion {
        static final byte[] KEY = "StoreVersion".getBytes(StandardCharsets.UTF_8);
        public final int major;
        public final int minor;

        @JsonCreator
        public StoreVersion(@JsonProperty(value="major") int major, @JsonProperty(value="minor") int minor) {
            this.major = major;
            this.minor = minor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StoreVersion that = (StoreVersion)o;
            return this.major == that.major && this.minor == that.minor;
        }

        public int hashCode() {
            int result = this.major;
            result = 31 * result + this.minor;
            return result;
        }
    }

    private static class LevelDBLogger
    implements org.iq80.leveldb.Logger {
        private static final Logger LOG = LoggerFactory.getLogger(LevelDBLogger.class);

        private LevelDBLogger() {
        }

        public void log(String message) {
            LOG.info(message);
        }
    }
}

