/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class IdentityExpression
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum = -1;
    private String type = null;

    public IdentityExpression() {
    }

    public IdentityExpression(int colNum, String type) {
        this.colNum = colNum;
        this.type = type;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
    }

    public static boolean isColumnOnly(VectorExpression ve) {
        if (ve instanceof IdentityExpression) {
            IdentityExpression identityExpression = (IdentityExpression)ve;
            return identityExpression.childExpressions == null;
        }
        return false;
    }

    @Override
    public int getOutputColumn() {
        return this.colNum;
    }

    @Override
    public String getOutputType() {
        return this.type;
    }

    public int getColNum() {
        return this.getOutputColumn();
    }

    public String getType() {
        return this.getOutputType();
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().build();
    }
}

