/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.enumerator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.util.enumerator.EnumeratorFormatException;

public abstract class Enumerator {
    private final String name;
    private static final Map<Class, Map<String, Enumerator>> INSTANCES = Collections.synchronizedMap(new HashMap());

    protected Enumerator(String name) {
        this.name = name;
        Enumerator.getInstances(this.getClass()).put(name, this);
    }

    public final boolean equals(@Nullable Object that) {
        return this == that;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    static Map<String, Enumerator> getInstances(Class enumeratorClass) {
        Map<String, Enumerator> m = INSTANCES.get(enumeratorClass);
        if (m != null) {
            return m;
        }
        m = new HashMap<String, Enumerator>();
        INSTANCES.put(enumeratorClass, m);
        return m;
    }

    protected static final Enumerator fromString(String name, Class enumeratorClass) throws EnumeratorFormatException {
        Enumerator value = Enumerator.getInstances(enumeratorClass).get(name);
        if (value == null) {
            throw new EnumeratorFormatException(name);
        }
        return value;
    }

    public String toString() {
        return this.name;
    }
}

