/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import breeze.linalg.DenseVector;
import breeze.linalg.support.CanCopy;
import breeze.optimize.DiffFunction;
import breeze.optimize.StochasticDiffFunction;
import breeze.util.Isomorphism;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.LBFGS$;
import org.apache.spark.mllib.optimization.Optimizer;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\u0001\u0003\u00015\u0011Q\u0001\u0014\"G\u000fNS!a\u0001\u0003\u0002\u0019=\u0004H/[7ju\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0019!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\n\u001fB$\u0018.\\5{KJ\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\u0011%tG/\u001a:oC2L!!\b\u000e\u0003\u000f1{wmZ5oO\"Aq\u0004\u0001BA\u0002\u0013%\u0001%\u0001\u0005he\u0006$\u0017.\u001a8u+\u0005\t\u0003CA\u000b#\u0013\t\u0019#A\u0001\u0005He\u0006$\u0017.\u001a8u\u0011!)\u0003A!a\u0001\n\u00131\u0013\u0001D4sC\u0012LWM\u001c;`I\u0015\fHCA\u0014+!\ty\u0001&\u0003\u0002*!\t!QK\\5u\u0011\u001dYC%!AA\u0002\u0005\n1\u0001\u001f\u00132\u0011!i\u0003A!A!B\u0013\t\u0013!C4sC\u0012LWM\u001c;!\u0011!y\u0003A!a\u0001\n\u0013\u0001\u0014aB;qI\u0006$XM]\u000b\u0002cA\u0011QCM\u0005\u0003g\t\u0011q!\u00169eCR,'\u000f\u0003\u00056\u0001\t\u0005\r\u0011\"\u00037\u0003-)\b\u000fZ1uKJ|F%Z9\u0015\u0005\u001d:\u0004bB\u00165\u0003\u0003\u0005\r!\r\u0005\ts\u0001\u0011\t\u0011)Q\u0005c\u0005AQ\u000f\u001d3bi\u0016\u0014\b\u0005C\u0003<\u0001\u0011\u0005A(\u0001\u0004=S:LGO\u0010\u000b\u0004{yz\u0004CA\u000b\u0001\u0011\u0015y\"\b1\u0001\"\u0011\u0015y#\b1\u00012\u0011\u001d\t\u0005\u00011A\u0005\n\t\u000baB\\;n\u0007>\u0014(/Z2uS>t7/F\u0001D!\tyA)\u0003\u0002F!\t\u0019\u0011J\u001c;\t\u000f\u001d\u0003\u0001\u0019!C\u0005\u0011\u0006\u0011b.^7D_J\u0014Xm\u0019;j_:\u001cx\fJ3r)\t9\u0013\nC\u0004,\r\u0006\u0005\t\u0019A\"\t\r-\u0003\u0001\u0015)\u0003D\u0003=qW/\\\"peJ,7\r^5p]N\u0004\u0003bB'\u0001\u0001\u0004%IAT\u0001\u000fG>tg/\u001a:hK:\u001cW\rV8m+\u0005y\u0005CA\bQ\u0013\t\t\u0006C\u0001\u0004E_V\u0014G.\u001a\u0005\b'\u0002\u0001\r\u0011\"\u0003U\u0003I\u0019wN\u001c<fe\u001e,gnY3U_2|F%Z9\u0015\u0005\u001d*\u0006bB\u0016S\u0003\u0003\u0005\ra\u0014\u0005\u0007/\u0002\u0001\u000b\u0015B(\u0002\u001f\r|gN^3sO\u0016t7-\u001a+pY\u0002Bq!\u0017\u0001A\u0002\u0013%!)\u0001\tnCbtU/\\%uKJ\fG/[8og\"91\f\u0001a\u0001\n\u0013a\u0016\u0001F7bq:+X.\u0013;fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002(;\"91FWA\u0001\u0002\u0004\u0019\u0005BB0\u0001A\u0003&1)A\tnCbtU/\\%uKJ\fG/[8og\u0002Bq!\u0019\u0001A\u0002\u0013%a*\u0001\u0005sK\u001e\u0004\u0016M]1n\u0011\u001d\u0019\u0007\u00011A\u0005\n\u0011\fAB]3h!\u0006\u0014\u0018-\\0%KF$\"aJ3\t\u000f-\u0012\u0017\u0011!a\u0001\u001f\"1q\r\u0001Q!\n=\u000b\u0011B]3h!\u0006\u0014\u0018-\u001c\u0011\t\u000b%\u0004A\u0011\u00016\u0002#M,GOT;n\u0007>\u0014(/Z2uS>t7\u000f\u0006\u0002lY6\t\u0001\u0001C\u0003nQ\u0002\u00071)A\u0006d_J\u0014Xm\u0019;j_:\u001c\b\"B8\u0001\t\u0003\u0001\u0018!E:fi\u000e{gN^3sO\u0016t7-\u001a+pYR\u00111.\u001d\u0005\u0006e:\u0004\raT\u0001\ni>dWM]1oG\u0016Da\u0001\u001e\u0001\u0005\u0002\u0011)\u0018!E4fi\u000e{gN^3sO\u0016t7-\u001a+pYR\tq\nC\u0003x\u0001\u0011\u0005\u00010\u0001\ttKRtU/\\%uKJ\fG/[8ogR\u00111.\u001f\u0005\u0006uZ\u0004\raQ\u0001\u0006SR,'o\u001d\u0005\u0007y\u0002!\t\u0001B?\u0002!\u001d,GOT;n\u0013R,'/\u0019;j_:\u001cH#A\"\t\r}\u0004A\u0011AA\u0001\u0003-\u0019X\r\u001e*fOB\u000b'/Y7\u0015\u0007-\f\u0019\u0001C\u0003b}\u0002\u0007q\nC\u0004\u0002\b\u0001!\t\u0001B;\u0002\u0017\u001d,GOU3h!\u0006\u0014\u0018-\u001c\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0003-\u0019X\r^$sC\u0012LWM\u001c;\u0015\u0007-\fy\u0001\u0003\u0004 \u0003\u0013\u0001\r!\t\u0005\b\u0003'\u0001A\u0011AA\u000b\u0003)\u0019X\r^+qI\u0006$XM\u001d\u000b\u0004W\u0006]\u0001BB\u0018\u0002\u0012\u0001\u0007\u0011\u0007\u0003\u0005\u0002\u001c\u0001!\t\u0001BA\u000f\u0003)9W\r^+qI\u0006$XM\u001d\u000b\u0002c!9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0012\u0001C8qi&l\u0017N_3\u0015\r\u0005\u0015\u0012\u0011GA$!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016\t\u00051A.\u001b8bY\u001eLA!a\f\u0002*\t1a+Z2u_JD\u0001\"a\r\u0002 \u0001\u0007\u0011QG\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u00028\u0005u\u0012\u0011I\u0007\u0003\u0003sQ1!a\u000f\u0007\u0003\r\u0011H\rZ\u0005\u0005\u0003\u007f\tIDA\u0002S\t\u0012\u0003baDA\"\u001f\u0006\u0015\u0012bAA#!\t1A+\u001e9mKJB\u0001\"!\u0013\u0002 \u0001\u0007\u0011QE\u0001\u000fS:LG/[1m/\u0016Lw\r\u001b;tQ\r\u0001\u0011Q\n\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111\u000b\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002X\u0005E#\u0001\u0004#fm\u0016dw\u000e]3s\u0003BLwaBA.\u0005!\u0005\u0011QL\u0001\u0006\u0019\n3ui\u0015\t\u0004+\u0005}cAB\u0001\u0003\u0011\u0003\t\tg\u0005\u0004\u0002`9A\u00121\r\t\u0004\u001f\u0005\u0015\u0014bAA4!\ta1+\u001a:jC2L'0\u00192mK\"91(a\u0018\u0005\u0002\u0005-DCAA/\u0011!\ty'a\u0018\u0005\u0002\u0005E\u0014\u0001\u0003:v]2\u0013eiR*\u0015%\u0005M\u00141PA?\u0003\u007f\n\t)a!\u0002\u0006\u0006\u001d\u0015\u0011\u0012\t\b\u001f\u0005\r\u0013QEA;!\u0011y\u0011qO(\n\u0007\u0005e\u0004CA\u0003BeJ\f\u0017\u0010\u0003\u0005\u00024\u00055\u0004\u0019AA\u001b\u0011\u0019y\u0012Q\u000ea\u0001C!1q&!\u001cA\u0002EBa!QA7\u0001\u0004\u0019\u0005BB'\u0002n\u0001\u0007q\n\u0003\u0004Z\u0003[\u0002\ra\u0011\u0005\u0007C\u00065\u0004\u0019A(\t\u0011\u0005%\u0013Q\u000ea\u0001\u0003K1q!!$\u0002`\u0011\tyIA\u0004D_N$h)\u001e8\u0014\u000b\u0005-e\"!%\u0011\r\u0005M\u00151TAP\u001b\t\t)J\u0003\u0003\u0002\"\u0005]%BAAM\u0003\u0019\u0011'/Z3{K&!\u0011QTAK\u00051!\u0015N\u001a4Gk:\u001cG/[8o!\u0015\t\t+!*P\u001b\t\t\u0019K\u0003\u0003\u0002,\u0005]\u0015\u0002BAT\u0003G\u00131\u0002R3og\u00164Vm\u0019;pe\"Y\u00111GAF\u0005\u0003\u0005\u000b\u0011BA\u001b\u0011%y\u00121\u0012B\u0001B\u0003%\u0011\u0005C\u00050\u0003\u0017\u0013\t\u0011)A\u0005c!I\u0011-a#\u0003\u0002\u0003\u0006Ia\u0014\u0005\f\u0003g\u000bYI!A!\u0002\u0013\t),A\u0006ok6,\u00050Y7qY\u0016\u001c\bcA\b\u00028&\u0019\u0011\u0011\u0018\t\u0003\t1{gn\u001a\u0005\bw\u0005-E\u0011AA_)1\ty,a1\u0002F\u0006\u001d\u0017\u0011ZAf!\u0011\t\t-a#\u000e\u0005\u0005}\u0003\u0002CA\u001a\u0003w\u0003\r!!\u000e\t\r}\tY\f1\u0001\"\u0011\u0019y\u00131\u0018a\u0001c!1\u0011-a/A\u0002=C\u0001\"a-\u0002<\u0002\u0007\u0011Q\u0017\u0005\t\u0003\u001f\fY\t\"\u0011\u0002R\u0006I1-\u00197dk2\fG/\u001a\u000b\u0005\u0003'\f)\u000e\u0005\u0004\u0010\u0003\u0007z\u0015q\u0014\u0005\t\u0003/\fi\r1\u0001\u0002 \u00069q/Z5hQR\u001c\bBCAn\u0003?\n\t\u0011\"\u0003\u0002^\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u000e\u0005\u0003\u0002b\u0006-XBAAr\u0015\u0011\t)/a:\u0002\t1\fgn\u001a\u0006\u0003\u0003S\fAA[1wC&!\u0011Q^Ar\u0005\u0019y%M[3di\"\"\u0011qLA'Q\u0011\tI&!\u0014")
public class LBFGS
implements Optimizer,
Logging {
    private Gradient gradient;
    private Updater updater;
    private int numCorrections;
    private double convergenceTol;
    private int maxNumIterations;
    private double regParam;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Tuple2<Vector, double[]> runLBFGS(RDD<Tuple2<Object, Vector>> rDD, Gradient gradient2, Updater updater, int n, double d, int n2, double d2, Vector vector) {
        return LBFGS$.MODULE$.runLBFGS(rDD, gradient2, updater, n, d, n2, d2, vector);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private Gradient gradient() {
        return this.gradient;
    }

    private void gradient_$eq(Gradient x$1) {
        this.gradient = x$1;
    }

    private Updater updater() {
        return this.updater;
    }

    private void updater_$eq(Updater x$1) {
        this.updater = x$1;
    }

    private int numCorrections() {
        return this.numCorrections;
    }

    private void numCorrections_$eq(int x$1) {
        this.numCorrections = x$1;
    }

    private double convergenceTol() {
        return this.convergenceTol;
    }

    private void convergenceTol_$eq(double x$1) {
        this.convergenceTol = x$1;
    }

    private int maxNumIterations() {
        return this.maxNumIterations;
    }

    private void maxNumIterations_$eq(int x$1) {
        this.maxNumIterations = x$1;
    }

    private double regParam() {
        return this.regParam;
    }

    private void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    public LBFGS setNumCorrections(int corrections) {
        Predef$.MODULE$.require(corrections > 0, (Function0)new Serializable(this, corrections){
            public static final long serialVersionUID = 0L;
            private final int corrections$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of corrections must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.corrections$1)}));
            }
            {
                this.corrections$1 = corrections$1;
            }
        });
        this.numCorrections_$eq(corrections);
        return this;
    }

    public LBFGS setConvergenceTol(double tolerance) {
        Predef$.MODULE$.require(tolerance >= 0.0, (Function0)new Serializable(this, tolerance){
            public static final long serialVersionUID = 0L;
            private final double tolerance$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Convergence tolerance must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.tolerance$1)}));
            }
            {
                this.tolerance$1 = tolerance$1;
            }
        });
        this.convergenceTol_$eq(tolerance);
        return this;
    }

    public double getConvergenceTol() {
        return this.convergenceTol();
    }

    public LBFGS setNumIterations(int iters) {
        Predef$.MODULE$.require(iters >= 0, (Function0)new Serializable(this, iters){
            public static final long serialVersionUID = 0L;
            private final int iters$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum of iterations must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iters$1)}));
            }
            {
                this.iters$1 = iters$1;
            }
        });
        this.maxNumIterations_$eq(iters);
        return this;
    }

    public int getNumIterations() {
        return this.maxNumIterations();
    }

    public LBFGS setRegParam(double regParam) {
        Predef$.MODULE$.require(regParam >= 0.0, (Function0)new Serializable(this, regParam){
            public static final long serialVersionUID = 0L;
            private final double regParam$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Regularization parameter must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.regParam$1)}));
            }
            {
                this.regParam$1 = regParam$1;
            }
        });
        this.regParam_$eq(regParam);
        return this;
    }

    public double getRegParam() {
        return this.regParam();
    }

    public LBFGS setGradient(Gradient gradient2) {
        this.gradient_$eq(gradient2);
        return this;
    }

    public LBFGS setUpdater(Updater updater) {
        this.updater_$eq(updater);
        return this;
    }

    public Updater getUpdater() {
        return this.updater();
    }

    @Override
    public Vector optimize(RDD<Tuple2<Object, Vector>> data, Vector initialWeights) {
        Tuple2<Vector, double[]> tuple2 = LBFGS$.MODULE$.runLBFGS(data, this.gradient(), this.updater(), this.numCorrections(), this.convergenceTol(), this.maxNumIterations(), this.regParam(), initialWeights);
        if (tuple2 != null) {
            Vector weights;
            Vector vector;
            Vector weights2 = vector = (weights = (Vector)tuple2._1());
            return weights2;
        }
        throw new MatchError(tuple2);
    }

    public LBFGS(Gradient gradient2, Updater updater) {
        this.gradient = gradient2;
        this.updater = updater;
        Logging.class.$init$((Logging)this);
        this.numCorrections = 10;
        this.convergenceTol = 1.0E-6;
        this.maxNumIterations = 100;
        this.regParam = 0.0;
    }

    public static class CostFun
    implements DiffFunction<DenseVector<Object>> {
        private final RDD<Tuple2<Object, Vector>> data;
        private final Gradient gradient;
        private final Updater updater;
        private final double regParam;
        private final long numExamples;

        public DiffFunction<DenseVector<Object>> cached(CanCopy<DenseVector<Object>> copy2) {
            return DiffFunction.class.cached((DiffFunction)this, copy2);
        }

        public <U> DiffFunction<U> throughLens(Isomorphism<DenseVector<Object>, U> l) {
            return DiffFunction.class.throughLens((DiffFunction)this, l);
        }

        public Object gradientAt(Object x) {
            return StochasticDiffFunction.class.gradientAt((StochasticDiffFunction)this, (Object)x);
        }

        public double valueAt(Object x) {
            return StochasticDiffFunction.class.valueAt((StochasticDiffFunction)this, (Object)x);
        }

        public final double apply(Object x) {
            return StochasticDiffFunction.class.apply((StochasticDiffFunction)this, (Object)x);
        }

        public boolean apply$mcZD$sp(double v1) {
            return Function1.class.apply$mcZD$sp((Function1)this, (double)v1);
        }

        public double apply$mcDD$sp(double v1) {
            return Function1.class.apply$mcDD$sp((Function1)this, (double)v1);
        }

        public float apply$mcFD$sp(double v1) {
            return Function1.class.apply$mcFD$sp((Function1)this, (double)v1);
        }

        public int apply$mcID$sp(double v1) {
            return Function1.class.apply$mcID$sp((Function1)this, (double)v1);
        }

        public long apply$mcJD$sp(double v1) {
            return Function1.class.apply$mcJD$sp((Function1)this, (double)v1);
        }

        public void apply$mcVD$sp(double v1) {
            Function1.class.apply$mcVD$sp((Function1)this, (double)v1);
        }

        public boolean apply$mcZF$sp(float v1) {
            return Function1.class.apply$mcZF$sp((Function1)this, (float)v1);
        }

        public double apply$mcDF$sp(float v1) {
            return Function1.class.apply$mcDF$sp((Function1)this, (float)v1);
        }

        public float apply$mcFF$sp(float v1) {
            return Function1.class.apply$mcFF$sp((Function1)this, (float)v1);
        }

        public int apply$mcIF$sp(float v1) {
            return Function1.class.apply$mcIF$sp((Function1)this, (float)v1);
        }

        public long apply$mcJF$sp(float v1) {
            return Function1.class.apply$mcJF$sp((Function1)this, (float)v1);
        }

        public void apply$mcVF$sp(float v1) {
            Function1.class.apply$mcVF$sp((Function1)this, (float)v1);
        }

        public boolean apply$mcZI$sp(int v1) {
            return Function1.class.apply$mcZI$sp((Function1)this, (int)v1);
        }

        public double apply$mcDI$sp(int v1) {
            return Function1.class.apply$mcDI$sp((Function1)this, (int)v1);
        }

        public float apply$mcFI$sp(int v1) {
            return Function1.class.apply$mcFI$sp((Function1)this, (int)v1);
        }

        public int apply$mcII$sp(int v1) {
            return Function1.class.apply$mcII$sp((Function1)this, (int)v1);
        }

        public long apply$mcJI$sp(int v1) {
            return Function1.class.apply$mcJI$sp((Function1)this, (int)v1);
        }

        public void apply$mcVI$sp(int v1) {
            Function1.class.apply$mcVI$sp((Function1)this, (int)v1);
        }

        public boolean apply$mcZJ$sp(long v1) {
            return Function1.class.apply$mcZJ$sp((Function1)this, (long)v1);
        }

        public double apply$mcDJ$sp(long v1) {
            return Function1.class.apply$mcDJ$sp((Function1)this, (long)v1);
        }

        public float apply$mcFJ$sp(long v1) {
            return Function1.class.apply$mcFJ$sp((Function1)this, (long)v1);
        }

        public int apply$mcIJ$sp(long v1) {
            return Function1.class.apply$mcIJ$sp((Function1)this, (long)v1);
        }

        public long apply$mcJJ$sp(long v1) {
            return Function1.class.apply$mcJJ$sp((Function1)this, (long)v1);
        }

        public void apply$mcVJ$sp(long v1) {
            Function1.class.apply$mcVJ$sp((Function1)this, (long)v1);
        }

        public <A> Function1<A, Object> compose(Function1<A, DenseVector<Object>> g) {
            return Function1.class.compose((Function1)this, g);
        }

        public <A> Function1<DenseVector<Object>, A> andThen(Function1<Object, A> g) {
            return Function1.class.andThen((Function1)this, g);
        }

        public String toString() {
            return Function1.class.toString((Function1)this);
        }

        public Tuple2<Object, DenseVector<Object>> calculate(DenseVector<Object> weights) {
            int x$5;
            Serializable x$4;
            Serializable x$3;
            Vector w2 = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)weights);
            int n = w2.size();
            Broadcast bcW = this.data.context().broadcast((Object)w2, ClassTag$.MODULE$.apply(Vector.class));
            Gradient localGradient = this.gradient;
            Tuple2 x$2 = new Tuple2((Object)Vectors$.MODULE$.zeros(n), (Object)BoxesRunTime.boxToDouble((double)0.0));
            Tuple2 tuple2 = (Tuple2)this.data.treeAggregate((Object)x$2, (Function2)(x$3 = new Serializable(this, bcW, localGradient){
                public static final long serialVersionUID = 0L;
                private final Broadcast bcW$1;
                private final Gradient localGradient$1;

                public final Tuple2<Vector, Object> apply(Tuple2<Vector, Object> c, Tuple2<Object, Vector> v) {
                    Tuple2 tuple2 = new Tuple2(c, v);
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        Tuple2 tuple23 = (Tuple2)tuple2._2();
                        if (tuple22 != null) {
                            Vector grad = (Vector)tuple22._1();
                            double loss2 = tuple22._2$mcD$sp();
                            if (tuple23 != null) {
                                double label = tuple23._1$mcD$sp();
                                Vector features = (Vector)tuple23._2();
                                double l = this.localGradient$1.compute(features, label, (Vector)this.bcW$1.value(), grad);
                                Tuple2 tuple24 = new Tuple2((Object)grad, (Object)BoxesRunTime.boxToDouble((double)(loss2 + l)));
                                return tuple24;
                            }
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    this.bcW$1 = bcW$1;
                    this.localGradient$1 = localGradient$1;
                }
            }), (Function2)(x$4 = new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Vector, Object> apply(Tuple2<Vector, Object> c1, Tuple2<Vector, Object> c2) {
                    Tuple2 tuple2 = new Tuple2(c1, c2);
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        Tuple2 tuple23 = (Tuple2)tuple2._2();
                        if (tuple22 != null) {
                            Vector grad1 = (Vector)tuple22._1();
                            double loss1 = tuple22._2$mcD$sp();
                            if (tuple23 != null) {
                                Vector grad2 = (Vector)tuple23._1();
                                double loss2 = tuple23._2$mcD$sp();
                                BLAS$.MODULE$.axpy(1.0, grad2, grad1);
                                Tuple2 tuple24 = new Tuple2((Object)grad1, (Object)BoxesRunTime.boxToDouble((double)(loss1 + loss2)));
                                return tuple24;
                            }
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }
            }), x$5 = this.data.treeAggregate$default$4((Object)x$2), ClassTag$.MODULE$.apply(Tuple2.class));
            if (tuple2 != null) {
                Tuple2 tuple22;
                Vector gradientSum = (Vector)tuple2._1();
                double lossSum = tuple2._2$mcD$sp();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)gradientSum, (Object)BoxesRunTime.boxToDouble((double)lossSum));
                Vector gradientSum2 = (Vector)tuple23._1();
                double lossSum2 = tuple23._2$mcD$sp();
                bcW.destroy();
                double regVal = this.updater.compute(w2, Vectors$.MODULE$.zeros(n), 0.0, 1, this.regParam)._2$mcD$sp();
                double loss2 = lossSum2 / (double)this.numExamples + regVal;
                Vector gradientTotal = w2.copy();
                BLAS$.MODULE$.axpy(-1.0, (Vector)this.updater.compute(w2, Vectors$.MODULE$.zeros(n), 1.0, 1, this.regParam)._1(), gradientTotal);
                BLAS$.MODULE$.axpy(1.0 / (double)this.numExamples, gradientSum2, gradientTotal);
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)loss2), (Object)((DenseVector)gradientTotal.asBreeze()));
            }
            throw new MatchError((Object)tuple2);
        }

        public CostFun(RDD<Tuple2<Object, Vector>> data, Gradient gradient2, Updater updater, double regParam, long numExamples) {
            this.data = data;
            this.gradient = gradient2;
            this.updater = updater;
            this.regParam = regParam;
            this.numExamples = numExamples;
            Function1.class.$init$((Function1)this);
            StochasticDiffFunction.class.$init$((StochasticDiffFunction)this);
            DiffFunction.class.$init$((DiffFunction)this);
        }
    }
}

