/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.impl;

import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.impl.PeriodicCheckpointer$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ecAB\u0001\u0003\u0003\u0003!AB\u0001\u000bQKJLw\u000eZ5d\u0007\",7m\u001b9pS:$XM\u001d\u0006\u0003\u0007\u0011\tA![7qY*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sOV\u0011QbM\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001a-\t9Aj\\4hS:<\u0007\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011A\u000f\u0002%\rDWmY6q_&tG/\u00138uKJ4\u0018\r\\\u0002\u0001+\u0005q\u0002CA\b \u0013\t\u0001\u0003CA\u0002J]RD\u0001B\t\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0014G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\t\u0005\tI\u0001\u0011)\u0019!C\u0001K\u0005\u00111oY\u000b\u0002MA\u0011q\u0005K\u0007\u0002\r%\u0011\u0011F\u0002\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\tW\u0001\u0011\t\u0011)A\u0005M\u0005\u00191o\u0019\u0011\t\u000b5\u0002A\u0011\u0001\u0018\u0002\rqJg.\u001b;?)\ryC(\u0010\t\u0004a\u0001\tT\"\u0001\u0002\u0011\u0005I\u001aD\u0002\u0001\u0003\u0006i\u0001\u0011\r!\u000e\u0002\u0002)F\u0011a'\u000f\t\u0003\u001f]J!\u0001\u000f\t\u0003\u000f9{G\u000f[5oOB\u0011qBO\u0005\u0003wA\u00111!\u00118z\u0011\u0015YB\u00061\u0001\u001f\u0011\u0015!C\u00061\u0001'\u0011\u001dy\u0004A1A\u0005\n\u0001\u000bqb\u00195fG.\u0004x.\u001b8u#V,W/Z\u000b\u0002\u0003B\u0019!iR\u0019\u000e\u0003\rS!\u0001R#\u0002\u000f5,H/\u00192mK*\u0011a\tE\u0001\u000bG>dG.Z2uS>t\u0017B\u0001%D\u0005\u0015\tV/Z;f\u0011\u0019Q\u0005\u0001)A\u0005\u0003\u0006\u00012\r[3dWB|\u0017N\u001c;Rk\u0016,X\r\t\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003A\u00039\u0001XM]:jgR,G-U;fk\u0016DaA\u0014\u0001!\u0002\u0013\t\u0015a\u00049feNL7\u000f^3e#V,W/\u001a\u0011\t\u000fA\u0003\u0001\u0019!C\u0005;\u0005YQ\u000f\u001d3bi\u0016\u001cu.\u001e8u\u0011\u001d\u0011\u0006\u00011A\u0005\nM\u000bq\"\u001e9eCR,7i\\;oi~#S-\u001d\u000b\u0003)^\u0003\"aD+\n\u0005Y\u0003\"\u0001B+oSRDq\u0001W)\u0002\u0002\u0003\u0007a$A\u0002yIEBaA\u0017\u0001!B\u0013q\u0012\u0001D;qI\u0006$XmQ8v]R\u0004\u0003\"\u0002/\u0001\t\u0003i\u0016AB;qI\u0006$X\r\u0006\u0002U=\")ql\u0017a\u0001c\u00059a.Z<ECR\f\u0007\"B1\u0001\r#\u0011\u0017AC2iK\u000e\\\u0007o\\5oiR\u0011Ak\u0019\u0005\u0006I\u0002\u0004\r!M\u0001\u0005I\u0006$\u0018\rC\u0003g\u0001\u0019Eq-\u0001\bjg\u000eCWmY6q_&tG/\u001a3\u0015\u0005!\\\u0007CA\bj\u0013\tQ\u0007CA\u0004C_>dW-\u00198\t\u000b\u0011,\u0007\u0019A\u0019\t\u000b5\u0004a\u0011\u00038\u0002\u000fA,'o]5tiR\u0011Ak\u001c\u0005\u0006I2\u0004\r!\r\u0005\u0006c\u00021\tB]\u0001\nk:\u0004XM]:jgR$\"\u0001V:\t\u000b\u0011\u0004\b\u0019A\u0019\t\u000bU\u0004a\u0011\u0003<\u0002%\u001d,Go\u00115fG.\u0004x.\u001b8u\r&dWm\u001d\u000b\u0004o\u0006U\u0001#\u0002=\u0002\u0002\u0005\u001daBA=\u007f\u001d\tQX0D\u0001|\u0015\taH$\u0001\u0004=e>|GOP\u0005\u0002#%\u0011q\u0010E\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019!!\u0002\u0003\u0011%#XM]1cY\u0016T!a \t\u0011\t\u0005%\u0011q\u0002\b\u0004\u001f\u0005-\u0011bAA\u0007!\u00051\u0001K]3eK\u001aLA!!\u0005\u0002\u0014\t11\u000b\u001e:j]\u001eT1!!\u0004\u0011\u0011\u0015!G\u000f1\u00012\u0011\u001d\tI\u0002\u0001C\u0001\u00037\tA\u0003Z3mKR,\u0017\t\u001c7DQ\u0016\u001c7\u000e]8j]R\u001cH#\u0001+\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\u001c\u0005YB-\u001a7fi\u0016\fE\u000e\\\"iK\u000e\\\u0007o\\5oiN\u0014U\u000f\u001e'bgRDq!a\t\u0001\t\u0003\t)#A\u000bhKR\fE\u000e\\\"iK\u000e\\\u0007o\\5oi\u001aKG.Z:\u0016\u0005\u0005\u001d\u0002#B\b\u0002*\u0005\u001d\u0011bAA\u0016!\t)\u0011I\u001d:bs\"9\u0011q\u0006\u0001\u0005\n\u0005m\u0011\u0001\u0006:f[>4Xm\u00115fG.\u0004x.\u001b8u\r&dWm\u0002\u0005\u00024\tA\tABA\u001b\u0003Q\u0001VM]5pI&\u001c7\t[3dWB|\u0017N\u001c;feB\u0019\u0001'a\u000e\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0004\u0002:M!\u0011q\u0007\b\u0015\u0011\u001di\u0013q\u0007C\u0001\u0003{!\"!!\u000e\t\u0011\u0005=\u0012q\u0007C\u0001\u0003\u0003\"R\u0001VA\"\u0003\u000fB\u0001\"!\u0012\u0002@\u0001\u0007\u0011qA\u0001\u000fG\",7m\u001b9pS:$h)\u001b7f\u0011!\tI%a\u0010A\u0002\u0005-\u0013\u0001B2p]\u001a\u0004B!!\u0014\u0002V5\u0011\u0011q\n\u0006\u0005\u0003\u0013\n\tFC\u0002\u0002T!\ta\u0001[1e_>\u0004\u0018\u0002BA,\u0003\u001f\u0012QbQ8oM&<WO]1uS>t\u0007")
public abstract class PeriodicCheckpointer<T>
implements Logging {
    private final int checkpointInterval;
    private final SparkContext sc;
    private final Queue<T> checkpointQueue;
    private final Queue<T> persistedQueue;
    private int updateCount;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public int checkpointInterval() {
        return this.checkpointInterval;
    }

    public SparkContext sc() {
        return this.sc;
    }

    private Queue<T> checkpointQueue() {
        return this.checkpointQueue;
    }

    private Queue<T> persistedQueue() {
        return this.persistedQueue;
    }

    private int updateCount() {
        return this.updateCount;
    }

    private void updateCount_$eq(int x$1) {
        this.updateCount = x$1;
    }

    public void update(T newData) {
        this.persist(newData);
        this.persistedQueue().enqueue((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newData}));
        while (this.persistedQueue().size() > 3) {
            Object dataToUnpersist = this.persistedQueue().dequeue();
            this.unpersist(dataToUnpersist);
        }
        this.updateCount_$eq(this.updateCount() + 1);
        if (this.checkpointInterval() != -1 && this.updateCount() % this.checkpointInterval() == 0 && this.sc().getCheckpointDir().nonEmpty()) {
            this.checkpoint(newData);
            this.checkpointQueue().enqueue((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newData}));
            boolean canDelete = true;
            while (this.checkpointQueue().size() > 1 && canDelete) {
                if (this.isCheckpointed(this.checkpointQueue().head())) {
                    this.removeCheckpointFile();
                    continue;
                }
                canDelete = false;
            }
        }
    }

    public abstract void checkpoint(T var1);

    public abstract boolean isCheckpointed(T var1);

    public abstract void persist(T var1);

    public abstract void unpersist(T var1);

    public abstract Iterable<String> getCheckpointFiles(T var1);

    public void deleteAllCheckpoints() {
        while (this.checkpointQueue().nonEmpty()) {
            this.removeCheckpointFile();
        }
    }

    public void deleteAllCheckpointsButLast() {
        while (this.checkpointQueue().size() > 1) {
            this.removeCheckpointFile();
        }
    }

    public String[] getAllCheckpointFiles() {
        return (String[])((TraversableOnce)this.checkpointQueue().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PeriodicCheckpointer $outer;

            public final Iterable<String> apply(T data) {
                return this.$outer.getCheckpointFiles(data);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Queue$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private void removeCheckpointFile() {
        Object old = this.checkpointQueue().dequeue();
        this.getCheckpointFiles(old).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PeriodicCheckpointer $outer;

            public final void apply(String x$1) {
                PeriodicCheckpointer$.MODULE$.removeCheckpointFile(x$1, this.$outer.sc().hadoopConfiguration());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public PeriodicCheckpointer(int checkpointInterval, SparkContext sc) {
        this.checkpointInterval = checkpointInterval;
        this.sc = sc;
        Logging.class.$init$((Logging)this);
        this.checkpointQueue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.persistedQueue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.updateCount = 0;
    }
}

