/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel;
import org.apache.spark.ml.regression.GBTRegressor$;
import org.apache.spark.ml.tree.DecisionTreeParams$class;
import org.apache.spark.ml.tree.GBTParams$class;
import org.apache.spark.ml.tree.GBTRegressorParams;
import org.apache.spark.ml.tree.GBTRegressorParams$class;
import org.apache.spark.ml.tree.TreeEnsembleParams$class;
import org.apache.spark.ml.tree.TreeRegressorParams$class;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001B\u0001\u0003\u00015\u0011Ab\u0012\"U%\u0016<'/Z:t_JT!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011#\u0002\u0001\u000f;\rJ\u0003#B\b\u0011%aQR\"\u0001\u0003\n\u0005E!!!\u0003)sK\u0012L7\r^8s!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0004mS:\fGnZ\u0005\u0003/Q\u0011aAV3di>\u0014\bCA\r\u0001\u001b\u0005\u0011\u0001CA\r\u001c\u0013\ta\"A\u0001\nH\u0005R\u0013Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0005\u0003\u0011!(/Z3\n\u0005\tz\"AE$C)J+wM]3tg>\u0014\b+\u0019:b[N\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003Q\u0015\u0012Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW\r\u0005\u0002+[5\t1F\u0003\u0002-\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002/W\t9Aj\\4hS:<\u0007\u0002\u0003\u0019\u0001\u0005\u000b\u0007I\u0011I\u0019\u0002\u0007ULG-F\u00013!\t\u0019\u0014H\u0004\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tAT'\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d6Q\rySh\u0011\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u001a\t!\"\u00198o_R\fG/[8o\u0013\t\u0011uHA\u0003TS:\u001cW-I\u0001E\u0003\u0015\td\u0006\u000e\u00181\u0011!1\u0005A!A!\u0002\u0013\u0011\u0014\u0001B;jI\u0002B3!R\u001fD\u0011\u0015I\u0005\u0001\"\u0001K\u0003\u0019a\u0014N\\5u}Q\u0011\u0001d\u0013\u0005\u0006a!\u0003\rA\r\u0015\u0004\u0017v\u001a\u0005f\u0001%>\u0007\")\u0011\n\u0001C\u0001\u001fR\t\u0001\u0004K\u0002O{\rCQA\u0015\u0001\u0005BM\u000b1b]3u\u001b\u0006DH)\u001a9uQR\u0011A+V\u0007\u0002\u0001!)a+\u0015a\u0001/\u0006)a/\u00197vKB\u0011A\u0007W\u0005\u00033V\u00121!\u00138uQ\r\tVh\u0011\u0005\u00069\u0002!\t%X\u0001\u000bg\u0016$X*\u0019=CS:\u001cHC\u0001+_\u0011\u001516\f1\u0001XQ\rYVh\u0011\u0005\u0006C\u0002!\tEY\u0001\u0017g\u0016$X*\u001b8J]N$\u0018M\\2fgB+'OT8eKR\u0011Ak\u0019\u0005\u0006-\u0002\u0004\ra\u0016\u0015\u0004Av\u001a\u0005\"\u00024\u0001\t\u0003:\u0017AD:fi6Kg.\u00138g_\u001e\u000b\u0017N\u001c\u000b\u0003)\"DQAV3A\u0002%\u0004\"\u0001\u000e6\n\u0005-,$A\u0002#pk\ndW\rK\u0002f{\rCQA\u001c\u0001\u0005B=\f\u0001c]3u\u001b\u0006DX*Z7pefLe.\u0014\"\u0015\u0005Q\u0003\b\"\u0002,n\u0001\u00049\u0006fA7>\u0007\")1\u000f\u0001C!i\u0006y1/\u001a;DC\u000eDWMT8eK&#7\u000f\u0006\u0002Uk\")aK\u001da\u0001mB\u0011Ag^\u0005\u0003qV\u0012qAQ8pY\u0016\fg\u000eK\u0002s{\rCQa\u001f\u0001\u0005Bq\fQc]3u\u0007\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\u0006\u0002U{\")aK\u001fa\u0001/\"\u001a!0P\"\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004\u0005Y1/\u001a;J[B,(/\u001b;z)\r!\u0016Q\u0001\u0005\u0006-~\u0004\rA\r\u0015\u0004\u007fv\u001a\u0005bBA\u0006\u0001\u0011\u0005\u0013QB\u0001\u0013g\u0016$8+\u001e2tC6\u0004H.\u001b8h%\u0006$X\rF\u0002U\u0003\u001fAaAVA\u0005\u0001\u0004I\u0007\u0006BA\u0005{\rCq!!\u0006\u0001\t\u0003\n9\"A\u0004tKR\u001cV-\u001a3\u0015\u0007Q\u000bI\u0002C\u0004W\u0003'\u0001\r!a\u0007\u0011\u0007Q\ni\"C\u0002\u0002 U\u0012A\u0001T8oO\"\"\u00111C\u001fD\u0011\u001d\t)\u0003\u0001C!\u0003O\t!b]3u\u001b\u0006D\u0018\n^3s)\r!\u0016\u0011\u0006\u0005\u0007-\u0006\r\u0002\u0019A,)\t\u0005\rRh\u0011\u0005\b\u0003_\u0001A\u0011IA\u0019\u0003-\u0019X\r^*uKB\u001c\u0016N_3\u0015\u0007Q\u000b\u0019\u0004\u0003\u0004W\u0003[\u0001\r!\u001b\u0015\u0005\u0003[i4\tC\u0004\u0002:\u0001!\t!a\u000f\u0002\u0017M,G\u000fT8tgRK\b/\u001a\u000b\u0004)\u0006u\u0002B\u0002,\u00028\u0001\u0007!\u0007\u000b\u0003\u00028u\u001a\u0005bBA\"\u0001\u0011E\u0013QI\u0001\u0006iJ\f\u0017N\u001c\u000b\u00045\u0005\u001d\u0003\u0002CA%\u0003\u0003\u0002\r!a\u0013\u0002\u000f\u0011\fG/Y:fiB\"\u0011QJA/!\u0019\ty%!\u0016\u0002Z5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'2\u0011aA:rY&!\u0011qKA)\u0005\u001d!\u0015\r^1tKR\u0004B!a\u0017\u0002^1\u0001A\u0001DA0\u0003\u000f\n\t\u0011!A\u0003\u0002\u0005\u0005$aA0%cE!\u00111MA5!\r!\u0014QM\u0005\u0004\u0003O*$a\u0002(pi\"Lgn\u001a\t\u0004i\u0005-\u0014bAA7k\t\u0019\u0011I\\=\t\u000f\u0005E\u0004\u0001\"\u0011\u0002t\u0005!1m\u001c9z)\rA\u0012Q\u000f\u0005\t\u0003o\ny\u00071\u0001\u0002z\u0005)Q\r\u001f;sCB!\u00111PAA\u001b\t\tiHC\u0002\u0002\u0000\u0011\tQ\u0001]1sC6LA!a!\u0002~\tA\u0001+\u0019:b[6\u000b\u0007\u000f\u000b\u0003\u0002pu\u001a\u0005f\u0001\u0001>\u0007\u001e9\u00111\u0012\u0002\t\u0002\u00055\u0015\u0001D$C)J+wM]3tg>\u0014\bcA\r\u0002\u0010\u001a1\u0011A\u0001E\u0001\u0003#\u001b\u0002\"a$\u0002\u0014\u0006e\u0015q\u0014\t\u0004i\u0005U\u0015bAALk\t1\u0011I\\=SK\u001a\u0004B\u0001JAN1%\u0019\u0011QT\u0013\u0003+\u0011+g-Y;miB\u000b'/Y7t%\u0016\fG-\u00192mKB\u0019A'!)\n\u0007\u0005\rVG\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004J\u0003\u001f#\t!a*\u0015\u0005\u00055\u0005BCAV\u0003\u001f\u0013\r\u0011\"\u0002\u0002.\u0006\u00112/\u001e9q_J$X\r\u001a'pgN$\u0016\u0010]3t+\t\ty\u000b\u0005\u00035\u0003c\u0013\u0014bAAZk\t)\u0011I\u001d:bs\"\"\u0011\u0011V\u001fD\u0011%\tI,a$!\u0002\u001b\ty+A\ntkB\u0004xN\u001d;fI2{7o\u001d+za\u0016\u001c\b\u0005\u000b\u0003\u00028v\u001a\u0005\u0002CA`\u0003\u001f#\t%!1\u0002\t1|\u0017\r\u001a\u000b\u00041\u0005\r\u0007bBAc\u0003{\u0003\rAM\u0001\u0005a\u0006$\b\u000eK\u0003\u0002>v\nI-\t\u0002\u0002L\u0006)!G\f\u0019/a!Q\u0011qZAH\u0003\u0003%I!!5\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003'\u0004B!!6\u0002`6\u0011\u0011q\u001b\u0006\u0005\u00033\fY.\u0001\u0003mC:<'BAAo\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0018q\u001b\u0002\u0007\u001f\nTWm\u0019;)\t\u0005=Uh\u0011\u0015\u0005\u0003\u0013k4\t")
public class GBTRegressor
extends Predictor<Vector, GBTRegressor, GBTRegressionModel>
implements GBTRegressorParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> lossType;
    private final Param<String> impurity;
    private final DoubleParam stepSize;
    private final IntParam maxIter;
    private final DoubleParam subsamplingRate;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;

    public static MLReader<GBTRegressor> read() {
        return GBTRegressor$.MODULE$.read();
    }

    public static GBTRegressor load(String string) {
        return GBTRegressor$.MODULE$.load(string);
    }

    public static String[] supportedLossTypes() {
        return GBTRegressor$.MODULE$.supportedLossTypes();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTRegressorParams$_setter_$lossType_$eq(Param x$1) {
        this.lossType = x$1;
    }

    @Override
    public String getLossType() {
        return GBTRegressorParams$class.getLossType(this);
    }

    @Override
    public Loss getOldLossType() {
        return GBTRegressorParams$class.getOldLossType(this);
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeRegressorParams$_setter_$impurity_$eq(Param x$1) {
        this.impurity = x$1;
    }

    @Override
    public final String getImpurity() {
        return TreeRegressorParams$class.getImpurity(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeRegressorParams$class.getOldImpurity(this);
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final double getStepSize() {
        return GBTParams$class.getStepSize(this);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams$class.getOldBoostingStrategy(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams$class.getSubsamplingRate(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams$class.getMaxDepth(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams$class.getMaxBins(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams$class.getMinInstancesPerNode(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams$class.getMinInfoGain(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams$class.getMaxMemoryInMB(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams$class.getCacheNodeIds(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public GBTRegressor setMaxDepth(int value) {
        return (GBTRegressor)this.set(this.maxDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public GBTRegressor setMaxBins(int value) {
        return (GBTRegressor)this.set(this.maxBins(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public GBTRegressor setMinInstancesPerNode(int value) {
        return (GBTRegressor)this.set(this.minInstancesPerNode(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public GBTRegressor setMinInfoGain(double value) {
        return (GBTRegressor)this.set(this.minInfoGain(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public GBTRegressor setMaxMemoryInMB(int value) {
        return (GBTRegressor)this.set(this.maxMemoryInMB(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public GBTRegressor setCacheNodeIds(boolean value) {
        return (GBTRegressor)this.set(this.cacheNodeIds(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public GBTRegressor setCheckpointInterval(int value) {
        return (GBTRegressor)this.set(this.checkpointInterval(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public GBTRegressor setImpurity(String value) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "GBTRegressor.setImpurity should NOT be used";
            }
        });
        return this;
    }

    @Override
    public GBTRegressor setSubsamplingRate(double value) {
        return (GBTRegressor)this.set(this.subsamplingRate(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public GBTRegressor setSeed(long value) {
        return (GBTRegressor)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public GBTRegressor setMaxIter(int value) {
        return (GBTRegressor)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public GBTRegressor setStepSize(double value) {
        return (GBTRegressor)this.set(this.stepSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public GBTRegressor setLossType(String value) {
        return (GBTRegressor)this.set(this.lossType(), value);
    }

    @Override
    public GBTRegressionModel train(Dataset<?> dataset) {
        Map<Object, Object> categoricalFeatures = MetadataUtils$.MODULE$.getCategoricalFeatures(dataset.schema().apply(this.$(this.featuresCol())));
        RDD<LabeledPoint> oldDataset = this.extractLabeledPoints(dataset);
        int numFeatures = ((LabeledPoint)oldDataset.first()).features().size();
        BoostingStrategy boostingStrategy = GBTParams$class.getOldBoostingStrategy(this, categoricalFeatures, Algo$.MODULE$.Regression());
        Instrumentation<GBTRegressor> instr = Instrumentation$.MODULE$.create(this, oldDataset);
        instr.logParams((Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])this.params()));
        instr.logNumFeatures(numFeatures);
        Tuple2<DecisionTreeRegressionModel[], double[]> tuple2 = GradientBoostedTrees$.MODULE$.run(oldDataset, boostingStrategy, BoxesRunTime.unboxToLong((Object)this.$(this.seed())));
        if (tuple2 != null) {
            Tuple2 tuple22;
            DecisionTreeRegressionModel[] baseLearners = (DecisionTreeRegressionModel[])tuple2._1();
            double[] learnerWeights = (double[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)baseLearners, (Object)learnerWeights);
            DecisionTreeRegressionModel[] baseLearners2 = (DecisionTreeRegressionModel[])tuple23._1();
            double[] learnerWeights2 = (double[])tuple23._2();
            GBTRegressionModel m = new GBTRegressionModel(this.uid(), baseLearners2, learnerWeights2, numFeatures);
            instr.logSuccess(m);
            return m;
        }
        throw new MatchError(tuple2);
    }

    @Override
    public GBTRegressor copy(ParamMap extra) {
        return (GBTRegressor)this.defaultCopy(extra);
    }

    public GBTRegressor(String uid) {
        this.uid = uid;
        HasCheckpointInterval$class.$init$(this);
        HasSeed$class.$init$(this);
        DecisionTreeParams$class.$init$(this);
        TreeEnsembleParams$class.$init$(this);
        HasMaxIter$class.$init$(this);
        GBTParams$class.$init$(this);
        TreeRegressorParams$class.$init$(this);
        GBTRegressorParams$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
    }

    public GBTRegressor() {
        this(Identifiable$.MODULE$.randomUID("gbtr"));
    }
}

