/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticCostFun;
import org.apache.spark.ml.classification.LogisticRegression$;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionParams$class;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.MultiClassSummarizer;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams$class;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasAggregationDepth$class;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasThreshold$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u0001\u0003\u00015\u0011!\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]*\u00111\u0001B\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001qAdH\u0013\u0011\u000b=\u0001\"\u0003G\r\u000e\u0003\tI!!\u0005\u0002\u0003/A\u0013xNY1cS2L7\u000f^5d\u00072\f7o]5gS\u0016\u0014\bCA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0019a\u0017N\\1mO&\u0011q\u0003\u0006\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005=\u0001\u0001CA\b\u001b\u0013\tY\"AA\fM_\u001eL7\u000f^5d%\u0016<'/Z:tS>tWj\u001c3fYB\u0011q\"H\u0005\u0003=\t\u0011\u0001\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]B\u000b'/Y7t!\t\u00013%D\u0001\"\u0015\t\u0011C!\u0001\u0003vi&d\u0017B\u0001\u0013\"\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u0004\u0002\u0011%tG/\u001a:oC2L!AK\u0014\u0003\u000f1{wmZ5oO\"AA\u0006\u0001BC\u0002\u0013\u0005S&A\u0002vS\u0012,\u0012A\f\t\u0003_Ur!\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\na\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011A'\r\u0015\u0004Wez\u0004C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003}m\u0012QaU5oG\u0016\f\u0013\u0001Q\u0001\u0006c9\"d\u0006\r\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005]\u0005!Q/\u001b3!Q\r\t\u0015h\u0010\u0005\u0006\u000b\u0002!\tAR\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005a9\u0005\"\u0002\u0017E\u0001\u0004q\u0003fA$:\u007f!\u001aA)\u000f&\"\u0003-\u000bQ!\r\u00183]ABQ!\u0012\u0001\u0005\u00025#\u0012\u0001\u0007\u0015\u0004\u0019fz\u0004\"\u0002)\u0001\t\u0003\t\u0016aC:fiJ+w\rU1sC6$\"AU*\u000e\u0003\u0001AQ\u0001V(A\u0002U\u000bQA^1mk\u0016\u0004\"\u0001\r,\n\u0005]\u000b$A\u0002#pk\ndW\rK\u0002Ps)CQA\u0017\u0001\u0005\u0002m\u000b!c]3u\u000b2\f7\u000f^5d\u001d\u0016$\b+\u0019:b[R\u0011!\u000b\u0018\u0005\u0006)f\u0003\r!\u0016\u0015\u00043fz\u0004\"B0\u0001\t\u0003\u0001\u0017AC:fi6\u000b\u00070\u0013;feR\u0011!+\u0019\u0005\u0006)z\u0003\rA\u0019\t\u0003a\rL!\u0001Z\u0019\u0003\u0007%sG\u000fK\u0002_s)CQa\u001a\u0001\u0005\u0002!\faa]3u)>dGC\u0001*j\u0011\u0015!f\r1\u0001VQ\r1\u0017h\u0010\u0005\u0006Y\u0002!\t!\\\u0001\u0010g\u0016$h)\u001b;J]R,'oY3qiR\u0011!K\u001c\u0005\u0006).\u0004\ra\u001c\t\u0003aAL!!]\u0019\u0003\u000f\t{w\u000e\\3b]\"\u001a1.O \t\u000bQ\u0004A\u0011A;\u0002\u0013M,GOR1nS2LHC\u0001*w\u0011\u0015!6\u000f1\u0001/Q\r\u0019\u0018\b_\u0011\u0002s\u0006)!GL\u0019/a!)1\u0010\u0001C\u0001y\u0006\u00112/\u001a;Ti\u0006tG-\u0019:eSj\fG/[8o)\t\u0011V\u0010C\u0003Uu\u0002\u0007q\u000eK\u0002{s}\f#!!\u0001\u0002\u000bErSG\f\u0019\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b\u0005a1/\u001a;UQJ,7\u000f[8mIR\u0019!+!\u0003\t\rQ\u000b\u0019\u00011\u0001VQ\u0011\t\u0019!O@\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012\u0005aq-\u001a;UQJ,7\u000f[8mIV\tQ\u000b\u000b\u0003\u0002\u000eez\bbBA\f\u0001\u0011\u0005\u0011\u0011D\u0001\rg\u0016$x+Z5hQR\u001cu\u000e\u001c\u000b\u0004%\u0006m\u0001B\u0002+\u0002\u0016\u0001\u0007a\u0006K\u0003\u0002\u0016e\ny\"\t\u0002\u0002\"\u0005)\u0011G\f\u001c/a!9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0012!D:fiRC'/Z:i_2$7\u000fF\u0002S\u0003SAq\u0001VA\u0012\u0001\u0004\tY\u0003\u0005\u00031\u0003[)\u0016bAA\u0018c\t)\u0011I\u001d:bs\"\"\u00111E\u001d\u0000\u0011\u001d\t)\u0004\u0001C!\u0003o\tQbZ3u)\"\u0014Xm\u001d5pY\u0012\u001cXCAA\u0016Q\u0011\t\u0019$O@\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u0005\u00192/\u001a;BO\u001e\u0014XmZ1uS>tG)\u001a9uQR\u0019!+!\u0011\t\rQ\u000bY\u00041\u0001cQ\u0011\tY$\u000f=\t\u0013\u0005\u001d\u0003\u00011A\u0005\n\u0005%\u0013aD8qi&s\u0017\u000e^5bY6{G-\u001a7\u0016\u0005\u0005-\u0003\u0003\u0002\u0019\u0002NeI1!a\u00142\u0005\u0019y\u0005\u000f^5p]\"I\u00111\u000b\u0001A\u0002\u0013%\u0011QK\u0001\u0014_B$\u0018J\\5uS\u0006dWj\u001c3fY~#S-\u001d\u000b\u0005\u0003/\ni\u0006E\u00021\u00033J1!a\u00172\u0005\u0011)f.\u001b;\t\u0015\u0005}\u0013\u0011KA\u0001\u0002\u0004\tY%A\u0002yIEB\u0001\"a\u0019\u0001A\u0003&\u00111J\u0001\u0011_B$\u0018J\\5uS\u0006dWj\u001c3fY\u0002B\u0001\"a\u001a\u0001\t\u00031\u0011\u0011N\u0001\u0010g\u0016$\u0018J\\5uS\u0006dWj\u001c3fYR\u0019!+a\u001b\t\u000f\u00055\u0014Q\ra\u00013\u0005)Qn\u001c3fY\"A\u0011\u0011\u000f\u0001\u0005R\u0019\t\u0019(A\u0003ue\u0006Lg\u000eF\u0002\u001a\u0003kB\u0001\"a\u001e\u0002p\u0001\u0007\u0011\u0011P\u0001\bI\u0006$\u0018m]3ua\u0011\tY(a#\u0011\r\u0005u\u00141QAD\u001b\t\tyHC\u0002\u0002\u0002\u001a\t1a]9m\u0013\u0011\t))a \u0003\u000f\u0011\u000bG/Y:fiB!\u0011\u0011RAF\u0019\u0001!A\"!$\u0002v\u0005\u0005\t\u0011!B\u0001\u0003\u001f\u00131a\u0018\u00132#\u0011\t\t*a&\u0011\u0007A\n\u0019*C\u0002\u0002\u0016F\u0012qAT8uQ&tw\rE\u00021\u00033K1!a'2\u0005\r\te.\u001f\u0005\t\u0003c\u0002A\u0011\u0003\u0004\u0002 R)\u0011$!)\u0002.\"A\u0011qOAO\u0001\u0004\t\u0019\u000b\r\u0003\u0002&\u0006%\u0006CBA?\u0003\u0007\u000b9\u000b\u0005\u0003\u0002\n\u0006%F\u0001DAV\u0003C\u000b\t\u0011!A\u0003\u0002\u0005=%aA0%e!9\u0011qVAO\u0001\u0004y\u0017!\u00055b]\u0012dW\rU3sg&\u001cH/\u001a8dK\"9\u00111\u0017\u0001\u0005B\u0005U\u0016\u0001B2paf$2\u0001GA\\\u0011!\tI,!-A\u0002\u0005m\u0016!B3yiJ\f\u0007\u0003BA_\u0003\u0007l!!a0\u000b\u0007\u0005\u0005G!A\u0003qCJ\fW.\u0003\u0003\u0002F\u0006}&\u0001\u0003)be\u0006lW*\u00199)\t\u0005E\u0016h\u0010\u0015\u0004\u0001eRuaBAg\u0005!\u0005\u0011qZ\u0001\u0013\u0019><\u0017n\u001d;jGJ+wM]3tg&|g\u000eE\u0002\u0010\u0003#4a!\u0001\u0002\t\u0002\u0005M7\u0003CAi\u0003+\fY.!9\u0011\u0007A\n9.C\u0002\u0002ZF\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u0011\u0002^bI1!a8\"\u0005U!UMZ1vYR\u0004\u0016M]1ngJ+\u0017\rZ1cY\u0016\u00042\u0001MAr\u0013\r\t)/\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b\u000b\u0006EG\u0011AAu)\t\ty\r\u0003\u0005\u0002n\u0006EG\u0011IAx\u0003\u0011aw.\u00193\u0015\u0007a\t\t\u0010C\u0004\u0002t\u0006-\b\u0019\u0001\u0018\u0002\tA\fG\u000f\u001b\u0015\u0006\u0003WL\u0014q\u0004\u0005\f\u0003s\f\tN1A\u0005\u0002\t\tY0\u0001\u000btkB\u0004xN\u001d;fI\u001a\u000bW.\u001b7z\u001d\u0006lWm]\u000b\u0003\u0003{\u0004R\u0001MA\u0017\u0003\u007f\u0004BA!\u0001\u0003\f5\u0011!1\u0001\u0006\u0005\u0005\u000b\u00119!\u0001\u0003mC:<'B\u0001B\u0005\u0003\u0011Q\u0017M^1\n\u0007Y\u0012\u0019\u0001C\u0005\u0003\u0010\u0005E\u0007\u0015!\u0003\u0002~\u0006)2/\u001e9q_J$X\r\u001a$b[&d\u0017PT1nKN\u0004\u0003B\u0003B\n\u0003#\f\t\u0011\"\u0003\u0003\u0016\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u00119\u0002\u0005\u0003\u0003\u0002\te\u0011\u0002\u0002B\u000e\u0005\u0007\u0011aa\u00142kK\u000e$\b&BAis\u0005}\u0001&BAfs\u0005}\u0001")
public class LogisticRegression
extends ProbabilisticClassifier<Vector, LogisticRegression, LogisticRegressionModel>
implements LogisticRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private Option<LogisticRegressionModel> optInitialModel;
    private final Param<String> family;
    private final IntParam aggregationDepth;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static MLReader<LogisticRegression> read() {
        return LogisticRegression$.MODULE$.read();
    }

    public static LogisticRegression load(String string) {
        return LogisticRegression$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param x$1) {
        this.family = x$1;
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams$class.getFamily(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams$class.checkThresholdConsistency(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth$class.getAggregationDepth(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LogisticRegression setRegParam(double value) {
        return (LogisticRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setElasticNetParam(double value) {
        return (LogisticRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setMaxIter(int value) {
        return (LogisticRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setTol(double value) {
        return (LogisticRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setFitIntercept(boolean value) {
        return (LogisticRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LogisticRegression setFamily(String value) {
        return (LogisticRegression)this.set(this.family(), value);
    }

    public LogisticRegression setStandardization(boolean value) {
        return (LogisticRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public LogisticRegression setThreshold(double value) {
        return (LogisticRegression)LogisticRegressionParams$class.setThreshold(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams$class.getThreshold(this);
    }

    public LogisticRegression setWeightCol(String value) {
        return (LogisticRegression)this.set(this.weightCol(), value);
    }

    @Override
    public LogisticRegression setThresholds(double[] value) {
        return (LogisticRegression)LogisticRegressionParams$class.setThresholds(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams$class.getThresholds(this);
    }

    public LogisticRegression setAggregationDepth(int value) {
        return (LogisticRegression)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    private Option<LogisticRegressionModel> optInitialModel() {
        return this.optInitialModel;
    }

    private void optInitialModel_$eq(Option<LogisticRegressionModel> x$1) {
        this.optInitialModel = x$1;
    }

    public LogisticRegression setInitialModel(LogisticRegressionModel model) {
        this.optInitialModel_$eq((Option<LogisticRegressionModel>)new Some((Object)model));
        return this;
    }

    @Override
    public LogisticRegressionModel train(Dataset<?> dataset) {
        StorageLevel storageLevel = dataset.rdd().getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        return this.train(dataset, handlePersistence);
    }

    public LogisticRegressionModel train(Dataset<?> dataset, boolean handlePersistence) {
        Tuple2 tuple2;
        block22: {
            Option<Object> option;
            block25: {
                String string;
                block29: {
                    Option<LogisticRegressionModel> option2;
                    block34: {
                        Vector vector;
                        block39: {
                            Tuple3 tuple3;
                            block40: {
                                Tuple2<LogisticRegressionModel, String> tuple22;
                                block43: {
                                    LogisticRegressionModel logisticRegressionModel;
                                    Instrumentation<LogisticRegression> instr;
                                    block42: {
                                        Tuple2 tuple23;
                                        LogisticRegressionModel model;
                                        double[] objectiveHistory;
                                        block41: {
                                            Tuple3 tuple32;
                                            boolean isMultinomial;
                                            int numClasses;
                                            RDD instances;
                                            block31: {
                                                DenseMatrix compressedCoefficientMatrix;
                                                Vector interceptVec;
                                                ArrayBuilder arrayBuilder;
                                                Tuple3 tuple33;
                                                block36: {
                                                    DenseMatrix denseMatrix;
                                                    DenseMatrix denseMatrix2;
                                                    block38: {
                                                        int numFeatures;
                                                        block37: {
                                                            DenseMatrix denseCoefficientMatrix;
                                                            block35: {
                                                                BoxedUnit boxedUnit;
                                                                boolean bl;
                                                                Matrix initialCoefWithInterceptMatrix;
                                                                LBFGS optimizer;
                                                                LogisticCostFun costFun;
                                                                Broadcast bcFeaturesStd;
                                                                double[] featuresStd;
                                                                int numCoefficientSets;
                                                                int numFeaturesPlusIntercept;
                                                                double[] histogram2;
                                                                block33: {
                                                                    block32: {
                                                                        boolean modelIsValid;
                                                                        LBFGS lBFGS;
                                                                        boolean isConstantLabel;
                                                                        MultivariateOnlineSummarizer summarizer;
                                                                        block30: {
                                                                            SparseMatrix coefMatrix;
                                                                            boolean bl2;
                                                                            long numInvalid;
                                                                            block27: {
                                                                                block28: {
                                                                                    block26: {
                                                                                        int n;
                                                                                        block24: {
                                                                                            block23: {
                                                                                                Tuple2 tuple24;
                                                                                                Column w2 = this.isDefined(this.weightCol()) && !this.$(this.weightCol()).isEmpty() ? functions$.MODULE$.col(this.$(this.weightCol())) : functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
                                                                                                instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), w2, functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1)new Serializable(this){
                                                                                                    public static final long serialVersionUID = 0L;

                                                                                                    public final Instance apply(Row x0$1) {
                                                                                                        Row row = x0$1;
                                                                                                        Some some = Row$.MODULE$.unapplySeq(row);
                                                                                                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                                                                                                            Object label = ((SeqLike)some.get()).apply(0);
                                                                                                            Object weight = ((SeqLike)some.get()).apply(1);
                                                                                                            Object features = ((SeqLike)some.get()).apply(2);
                                                                                                            if (label instanceof Double) {
                                                                                                                double d = BoxesRunTime.unboxToDouble((Object)label);
                                                                                                                if (weight instanceof Double) {
                                                                                                                    double d2 = BoxesRunTime.unboxToDouble((Object)weight);
                                                                                                                    if (features instanceof Vector) {
                                                                                                                        Vector vector = (Vector)features;
                                                                                                                        Instance instance = new Instance(d, d2, vector);
                                                                                                                        return instance;
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                        throw new MatchError((Object)row);
                                                                                                    }
                                                                                                }, ClassTag$.MODULE$.apply(Instance.class));
                                                                                                Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
                                                                                                instr = Instrumentation$.MODULE$.create(this, instances);
                                                                                                instr.logParams((Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.regParam(), this.elasticNetParam(), this.standardization(), this.threshold(), this.maxIter(), this.tol(), this.fitIntercept()}));
                                                                                                Serializable seqOp = new Serializable(this){
                                                                                                    public static final long serialVersionUID = 0L;

                                                                                                    public final Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c, Instance instance) {
                                                                                                        return new Tuple2((Object)((MultivariateOnlineSummarizer)c._1()).add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(instance.features()), instance.weight()), (Object)((MultiClassSummarizer)c._2()).add(instance.label(), instance.weight()));
                                                                                                    }
                                                                                                };
                                                                                                Serializable combOp = new Serializable(this){
                                                                                                    public static final long serialVersionUID = 0L;

                                                                                                    public final Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c1, Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c2) {
                                                                                                        return new Tuple2((Object)((MultivariateOnlineSummarizer)c1._1()).merge((MultivariateOnlineSummarizer)c2._1()), (Object)((MultiClassSummarizer)c1._2()).merge((MultiClassSummarizer)c2._2()));
                                                                                                    }
                                                                                                };
                                                                                                tuple2 = (Tuple2)instances.treeAggregate((Object)new Tuple2((Object)new MultivariateOnlineSummarizer(), (Object)new MultiClassSummarizer()), (Function2)seqOp, (Function2)combOp, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(Tuple2.class));
                                                                                                if (tuple2 == null) break block22;
                                                                                                MultivariateOnlineSummarizer summarizer2 = (MultivariateOnlineSummarizer)tuple2._1();
                                                                                                MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
                                                                                                Tuple2 tuple25 = tuple24 = new Tuple2((Object)summarizer2, (Object)labelSummarizer);
                                                                                                summarizer = (MultivariateOnlineSummarizer)tuple25._1();
                                                                                                MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple25._2();
                                                                                                histogram2 = labelSummarizer2.histogram();
                                                                                                numInvalid = labelSummarizer2.countInvalid();
                                                                                                numFeatures = summarizer.mean().size();
                                                                                                numFeaturesPlusIntercept = this.getFitIntercept() ? numFeatures + 1 : numFeatures;
                                                                                                option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
                                                                                                if (!(option instanceof Some)) break block23;
                                                                                                Some some = (Some)option;
                                                                                                int n2 = BoxesRunTime.unboxToInt((Object)some.x());
                                                                                                int n3 = n2;
                                                                                                Predef$.MODULE$.require(n3 >= histogram2.length, (Function0)new Serializable(this, histogram2, n3){
                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                    private final double[] histogram$1;
                                                                                                    private final int x3$1;

                                                                                                    public final String apply() {
                                                                                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specified number of classes ", " was "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x3$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"less than the number of unique labels ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.histogram$1.length)}))).toString();
                                                                                                    }
                                                                                                    {
                                                                                                        this.histogram$1 = histogram$1;
                                                                                                        this.x3$1 = x3$1;
                                                                                                    }
                                                                                                });
                                                                                                n = n3;
                                                                                                break block24;
                                                                                            }
                                                                                            if (!None$.MODULE$.equals(option)) break block25;
                                                                                            n = histogram2.length;
                                                                                        }
                                                                                        numClasses = n;
                                                                                        string = this.$(this.family());
                                                                                        if (!"binomial".equals(string)) break block26;
                                                                                        Predef$.MODULE$.require(numClasses == 1 || numClasses == 2, (Function0)new Serializable(this, numClasses){
                                                                                            public static final long serialVersionUID = 0L;
                                                                                            private final int numClasses$1;

                                                                                            public final String apply() {
                                                                                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Binomial family only supports 1 or 2 "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"outcome classes but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numClasses$1)}))).toString();
                                                                                            }
                                                                                            {
                                                                                                this.numClasses$1 = numClasses$1;
                                                                                            }
                                                                                        });
                                                                                        bl2 = false;
                                                                                        break block27;
                                                                                    }
                                                                                    if (!"multinomial".equals(string)) break block28;
                                                                                    bl2 = true;
                                                                                    break block27;
                                                                                }
                                                                                if (!"auto".equals(string)) break block29;
                                                                                bl2 = numClasses > 2;
                                                                            }
                                                                            isMultinomial = bl2;
                                                                            int n = numCoefficientSets = isMultinomial ? numClasses : 1;
                                                                            if (this.isDefined(this.thresholds())) {
                                                                                Predef$.MODULE$.require(this.$(this.thresholds()).length == numClasses, (Function0)new Serializable(this, numClasses){
                                                                                    public static final long serialVersionUID = 0L;
                                                                                    private final /* synthetic */ LogisticRegression $outer;
                                                                                    private final int numClasses$1;

                                                                                    public final String apply() {
                                                                                        return new StringBuilder().append((Object)this.$outer.getClass().getSimpleName()).append((Object)".train() called with non-matching numClasses and thresholds.length.").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" numClasses=", ", but thresholds has length ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numClasses$1), BoxesRunTime.boxToInteger((int)this.$outer.$(this.$outer.thresholds()).length)}))).toString();
                                                                                    }
                                                                                    {
                                                                                        if ($outer == null) {
                                                                                            throw null;
                                                                                        }
                                                                                        this.$outer = $outer;
                                                                                        this.numClasses$1 = numClasses$1;
                                                                                    }
                                                                                });
                                                                            }
                                                                            instr.logNumClasses(numClasses);
                                                                            instr.logNumFeatures(numFeatures);
                                                                            if (numInvalid != 0L) {
                                                                                String msg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Classification labels should be in [0 to ", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(numClasses - 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " invalid labels."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numInvalid)}))).toString();
                                                                                this.logError((Function0<String>)new Serializable(this, msg){
                                                                                    public static final long serialVersionUID = 0L;
                                                                                    private final String msg$1;

                                                                                    public final String apply() {
                                                                                        return this.msg$1;
                                                                                    }
                                                                                    {
                                                                                        this.msg$1 = msg$1;
                                                                                    }
                                                                                });
                                                                                throw new SparkException(msg);
                                                                            }
                                                                            boolean bl3 = isConstantLabel = Predef$.MODULE$.doubleArrayOps(histogram2).count((Function1)new Serializable(this){
                                                                                public static final long serialVersionUID = 0L;

                                                                                public final boolean apply(double x$2) {
                                                                                    return this.apply$mcZD$sp(x$2);
                                                                                }

                                                                                public boolean apply$mcZD$sp(double x$2) {
                                                                                    return x$2 != 0.0;
                                                                                }
                                                                            }) == 1;
                                                                            if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) || !isConstantLabel) break block30;
                                                                            this.logWarning((Function0<String>)new Serializable(this){
                                                                                public static final long serialVersionUID = 0L;

                                                                                public final String apply() {
                                                                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All labels are the same value and fitIntercept=true, so the coefficients "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"will be zeros. Training is not needed."})).s((Seq)Nil$.MODULE$)).toString();
                                                                                }
                                                                            });
                                                                            int constantLabelIndex = Vectors$.MODULE$.dense(histogram2).argmax();
                                                                            SparseMatrix sparseMatrix = coefMatrix = numFeatures < numCoefficientSets ? new SparseMatrix(numCoefficientSets, numFeatures, (int[])Array$.MODULE$.fill(numFeatures + 1, (Function0)new Serializable(this){
                                                                                public static final long serialVersionUID = 0L;

                                                                                public final int apply() {
                                                                                    return this.apply$mcI$sp();
                                                                                }

                                                                                public int apply$mcI$sp() {
                                                                                    return 0;
                                                                                }
                                                                            }, ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())) : new SparseMatrix(numCoefficientSets, numFeatures, (int[])Array$.MODULE$.fill(numCoefficientSets + 1, (Function0)new Serializable(this){
                                                                                public static final long serialVersionUID = 0L;

                                                                                public final int apply() {
                                                                                    return this.apply$mcI$sp();
                                                                                }

                                                                                public int apply$mcI$sp() {
                                                                                    return 0;
                                                                                }
                                                                            }, ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), true);
                                                                            Vector interceptVec2 = isMultinomial ? Vectors$.MODULE$.sparse(numClasses, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(constantLabelIndex, Double.POSITIVE_INFINITY)}))) : Vectors$.MODULE$.dense(numClasses == 2 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                                                                            tuple33 = new Tuple3((Object)coefMatrix, (Object)interceptVec2, Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                                                                            break block31;
                                                                        }
                                                                        if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isConstantLabel) {
                                                                            this.logWarning((Function0<String>)new Serializable(this){
                                                                                public static final long serialVersionUID = 0L;

                                                                                public final String apply() {
                                                                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All labels belong to a single class and fitIntercept=false. It's a "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dangerous ground, so the algorithm may not converge."})).s((Seq)Nil$.MODULE$)).toString();
                                                                                }
                                                                            });
                                                                        }
                                                                        double[] featuresMean = summarizer.mean().toArray();
                                                                        featuresStd = (double[])Predef$.MODULE$.doubleArrayOps(summarizer.variance().toArray()).map((Function1)new Serializable(this){
                                                                            public static final long serialVersionUID = 0L;

                                                                            public final double apply(double x) {
                                                                                return this.apply$mcDD$sp(x);
                                                                            }

                                                                            public double apply$mcDD$sp(double x) {
                                                                                return package$.MODULE$.sqrt(x);
                                                                            }
                                                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                                                                        if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)new Serializable(this, featuresMean, featuresStd){
                                                                            public static final long serialVersionUID = 0L;
                                                                            private final double[] featuresMean$1;
                                                                            private final double[] featuresStd$1;

                                                                            public final boolean apply(int i) {
                                                                                return this.apply$mcZI$sp(i);
                                                                            }

                                                                            public boolean apply$mcZI$sp(int i) {
                                                                                return this.featuresStd$1[i] == 0.0 && this.featuresMean$1[i] != 0.0;
                                                                            }
                                                                            {
                                                                                this.featuresMean$1 = featuresMean$1;
                                                                                this.featuresStd$1 = featuresStd$1;
                                                                            }
                                                                        })) {
                                                                            this.logWarning((Function0<String>)new Serializable(this){
                                                                                public static final long serialVersionUID = 0L;

                                                                                public final String apply() {
                                                                                    return "Fitting LogisticRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is the same as R glmnet but different from LIBSVM.";
                                                                                }
                                                                            });
                                                                        }
                                                                        double regParamL1 = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
                                                                        double regParamL2 = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
                                                                        bcFeaturesStd = instances.context().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
                                                                        costFun = new LogisticCostFun((RDD<Instance>)instances, numClasses, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())), (Broadcast<double[]>)bcFeaturesStd, regParamL2, isMultinomial, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())));
                                                                        if (BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0) {
                                                                            lBFGS = new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space_Double());
                                                                        } else {
                                                                            boolean standardizationParam = BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization()));
                                                                            lBFGS = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.regParamL1Fun$1(numFeatures, numCoefficientSets, featuresStd, regParamL1, standardizationParam), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
                                                                        }
                                                                        optimizer = lBFGS;
                                                                        initialCoefWithInterceptMatrix = Matrices$.MODULE$.zeros(numCoefficientSets, numFeaturesPlusIntercept);
                                                                        option2 = this.optInitialModel();
                                                                        if (!(option2 instanceof Some)) break block32;
                                                                        Some some = (Some)option2;
                                                                        LogisticRegressionModel _initialModel = (LogisticRegressionModel)some.x();
                                                                        Matrix providedCoefs = _initialModel.coefficientMatrix();
                                                                        boolean bl4 = modelIsValid = providedCoefs.numRows() == numCoefficientSets && providedCoefs.numCols() == numFeatures && _initialModel.interceptVector().size() == numCoefficientSets && _initialModel.getFitIntercept() == BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()));
                                                                        if (!modelIsValid) {
                                                                            this.logWarning((Function0<String>)new Serializable(this, numFeatures, numCoefficientSets, providedCoefs){
                                                                                public static final long serialVersionUID = 0L;
                                                                                private final int numFeatures$1;
                                                                                private final int numCoefficientSets$1;
                                                                                private final Matrix providedCoefs$1;

                                                                                public final String apply() {
                                                                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initial coefficients will be ignored! Its dimensions "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", ") did not match the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.providedCoefs$1.numRows()), BoxesRunTime.boxToInteger((int)this.providedCoefs$1.numCols())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected size (", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numCoefficientSets$1), BoxesRunTime.boxToInteger((int)this.numFeatures$1)}))).toString();
                                                                                }
                                                                                {
                                                                                    this.numFeatures$1 = numFeatures$1;
                                                                                    this.numCoefficientSets$1 = numCoefficientSets$1;
                                                                                    this.providedCoefs$1 = providedCoefs$1;
                                                                                }
                                                                            });
                                                                        }
                                                                        bl = modelIsValid;
                                                                        break block33;
                                                                    }
                                                                    if (!None$.MODULE$.equals(option2)) break block34;
                                                                    bl = false;
                                                                }
                                                                boolean initialModelIsValid = bl;
                                                                if (initialModelIsValid) {
                                                                    Matrix providedCoef = ((LogisticRegressionModel)this.optInitialModel().get()).coefficientMatrix();
                                                                    providedCoef.foreachActive((Function3)new Serializable(this, featuresStd, initialCoefWithInterceptMatrix){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final double[] featuresStd$1;
                                                                        private final Matrix initialCoefWithInterceptMatrix$1;

                                                                        public final void apply(int classIndex, int featureIndex, double value) {
                                                                            this.initialCoefWithInterceptMatrix$1.update(classIndex, featureIndex, value * this.featuresStd$1[featureIndex]);
                                                                        }
                                                                        {
                                                                            this.featuresStd$1 = featuresStd$1;
                                                                            this.initialCoefWithInterceptMatrix$1 = initialCoefWithInterceptMatrix$1;
                                                                        }
                                                                    });
                                                                    if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                                                                        ((LogisticRegressionModel)this.optInitialModel().get()).interceptVector().foreachActive((Function2)new Serializable(this, numFeatures, initialCoefWithInterceptMatrix){
                                                                            public static final long serialVersionUID = 0L;
                                                                            private final int numFeatures$1;
                                                                            private final Matrix initialCoefWithInterceptMatrix$1;

                                                                            public final void apply(int classIndex, double value) {
                                                                                this.apply$mcVID$sp(classIndex, value);
                                                                            }

                                                                            public void apply$mcVID$sp(int classIndex, double value) {
                                                                                this.initialCoefWithInterceptMatrix$1.update(classIndex, this.numFeatures$1, value);
                                                                            }
                                                                            {
                                                                                this.numFeatures$1 = numFeatures$1;
                                                                                this.initialCoefWithInterceptMatrix$1 = initialCoefWithInterceptMatrix$1;
                                                                            }
                                                                        });
                                                                    }
                                                                } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial) {
                                                                    double[] rawIntercepts = (double[])Predef$.MODULE$.doubleArrayOps(histogram2).map((Function1)new Serializable(this){
                                                                        public static final long serialVersionUID = 0L;

                                                                        public final double apply(double c) {
                                                                            return this.apply$mcDD$sp(c);
                                                                        }

                                                                        public double apply$mcDD$sp(double c) {
                                                                            return package$.MODULE$.log(c + 1.0);
                                                                        }
                                                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                                                                    double rawMean = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(rawIntercepts).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)rawIntercepts.length;
                                                                    Predef$.MODULE$.doubleArrayOps(rawIntercepts).indices().foreach$mVc$sp((Function1)new Serializable(this, numFeatures, initialCoefWithInterceptMatrix, rawIntercepts, rawMean){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final int numFeatures$1;
                                                                        private final Matrix initialCoefWithInterceptMatrix$1;
                                                                        private final double[] rawIntercepts$1;
                                                                        private final double rawMean$1;

                                                                        public final void apply(int i) {
                                                                            this.apply$mcVI$sp(i);
                                                                        }

                                                                        public void apply$mcVI$sp(int i) {
                                                                            this.initialCoefWithInterceptMatrix$1.update(i, this.numFeatures$1, this.rawIntercepts$1[i] - this.rawMean$1);
                                                                        }
                                                                        {
                                                                            this.numFeatures$1 = numFeatures$1;
                                                                            this.initialCoefWithInterceptMatrix$1 = initialCoefWithInterceptMatrix$1;
                                                                            this.rawIntercepts$1 = rawIntercepts$1;
                                                                            this.rawMean$1 = rawMean$1;
                                                                        }
                                                                    });
                                                                } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                                                                    initialCoefWithInterceptMatrix.update(0, numFeatures, package$.MODULE$.log(histogram2[1] / histogram2[0]));
                                                                }
                                                                Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)new DenseVector.mcD.sp(initialCoefWithInterceptMatrix.toArray()));
                                                                arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
                                                                FirstOrderMinimizer.State state = null;
                                                                while (states.hasNext()) {
                                                                    state = (FirstOrderMinimizer.State)states.next();
                                                                    arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
                                                                }
                                                                bcFeaturesStd.destroy(false);
                                                                if (state == null) {
                                                                    String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizer.getClass().getName()}));
                                                                    this.logError((Function0<String>)new Serializable(this, msg){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final String msg$2;

                                                                        public final String apply() {
                                                                            return this.msg$2;
                                                                        }
                                                                        {
                                                                            this.msg$2 = msg$2;
                                                                        }
                                                                    });
                                                                    throw new SparkException(msg);
                                                                }
                                                                double[] allCoefficients = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
                                                                DenseMatrix allCoefMatrix = new DenseMatrix(numCoefficientSets, numFeaturesPlusIntercept, allCoefficients);
                                                                denseCoefficientMatrix = new DenseMatrix(numCoefficientSets, numFeatures, new double[numCoefficientSets * numFeatures], true);
                                                                interceptVec = !BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial ? Vectors$.MODULE$.sparse(numCoefficientSets, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)) : Vectors$.MODULE$.zeros(numCoefficientSets);
                                                                allCoefMatrix.foreachActive((Function3)new Serializable(this, numFeatures, featuresStd, denseCoefficientMatrix, interceptVec){
                                                                    public static final long serialVersionUID = 0L;
                                                                    private final /* synthetic */ LogisticRegression $outer;
                                                                    private final int numFeatures$1;
                                                                    private final double[] featuresStd$1;
                                                                    private final DenseMatrix denseCoefficientMatrix$1;
                                                                    private final Vector interceptVec$1;

                                                                    public final void apply(int classIndex, int featureIndex, double value) {
                                                                        boolean isIntercept;
                                                                        boolean bl = isIntercept = BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.fitIntercept())) && featureIndex == this.numFeatures$1;
                                                                        if (!isIntercept && this.featuresStd$1[featureIndex] != 0.0) {
                                                                            this.denseCoefficientMatrix$1.update(classIndex, featureIndex, value / this.featuresStd$1[featureIndex]);
                                                                        }
                                                                        if (isIntercept) {
                                                                            this.interceptVec$1.toArray()[classIndex] = value;
                                                                        }
                                                                    }
                                                                    {
                                                                        if ($outer == null) {
                                                                            throw null;
                                                                        }
                                                                        this.$outer = $outer;
                                                                        this.numFeatures$1 = numFeatures$1;
                                                                        this.featuresStd$1 = featuresStd$1;
                                                                        this.denseCoefficientMatrix$1 = denseCoefficientMatrix$1;
                                                                        this.interceptVec$1 = interceptVec$1;
                                                                    }
                                                                });
                                                                if (BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0 && isMultinomial) {
                                                                    double[] denseValues = denseCoefficientMatrix.values();
                                                                    double coefficientMean = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(denseValues).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)denseValues.length;
                                                                    boxedUnit = denseCoefficientMatrix.update((Function1)new Serializable(this, coefficientMean){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final double coefficientMean$1;

                                                                        public final double apply(double x$3) {
                                                                            return this.apply$mcDD$sp(x$3);
                                                                        }

                                                                        public double apply$mcDD$sp(double x$3) {
                                                                            return x$3 - this.coefficientMean$1;
                                                                        }
                                                                        {
                                                                            this.coefficientMean$1 = coefficientMean$1;
                                                                        }
                                                                    });
                                                                } else {
                                                                    boxedUnit = BoxedUnit.UNIT;
                                                                }
                                                                if (!isMultinomial) break block35;
                                                                denseMatrix2 = denseCoefficientMatrix;
                                                                break block36;
                                                            }
                                                            Vector compressedVector = Vectors$.MODULE$.dense(denseCoefficientMatrix.values()).compressed();
                                                            vector = compressedVector;
                                                            if (!(vector instanceof org.apache.spark.ml.linalg.DenseVector)) break block37;
                                                            denseMatrix = denseCoefficientMatrix;
                                                            break block38;
                                                        }
                                                        if (!(vector instanceof SparseVector)) break block39;
                                                        SparseVector sparseVector = (SparseVector)vector;
                                                        denseMatrix = new SparseMatrix(1, numFeatures, new int[]{0, sparseVector.indices().length}, sparseVector.indices(), sparseVector.values(), true);
                                                    }
                                                    denseMatrix2 = compressedCoefficientMatrix = denseMatrix;
                                                }
                                                if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial) {
                                                    double[] interceptArray = interceptVec.toArray();
                                                    double interceptMean = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(interceptArray).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)interceptArray.length;
                                                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), interceptVec.size()).foreach$mVc$sp((Function1)new Serializable(this, interceptArray, interceptMean){
                                                        public static final long serialVersionUID = 0L;
                                                        private final double[] interceptArray$1;
                                                        private final double interceptMean$1;

                                                        public final void apply(int i) {
                                                            this.apply$mcVI$sp(i);
                                                        }

                                                        public void apply$mcVI$sp(int i) {
                                                            this.interceptArray$1[i] = this.interceptArray$1[i] - this.interceptMean$1;
                                                        }
                                                        {
                                                            this.interceptArray$1 = interceptArray$1;
                                                            this.interceptMean$1 = interceptMean$1;
                                                        }
                                                    });
                                                }
                                                tuple33 = tuple3 = new Tuple3((Object)compressedCoefficientMatrix, (Object)interceptVec.compressed(), arrayBuilder.result());
                                            }
                                            if (tuple3 == null) break block40;
                                            Matrix coefficientMatrix = (Matrix)tuple3._1();
                                            Vector interceptVector = (Vector)tuple3._2();
                                            double[] objectiveHistory2 = (double[])tuple3._3();
                                            Tuple3 tuple34 = tuple32 = new Tuple3((Object)coefficientMatrix, (Object)interceptVector, (Object)objectiveHistory2);
                                            Matrix coefficientMatrix2 = (Matrix)tuple34._1();
                                            Vector interceptVector2 = (Vector)tuple34._2();
                                            objectiveHistory = (double[])tuple34._3();
                                            Object object = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                                            model = this.copyValues(new LogisticRegressionModel(this.uid(), coefficientMatrix2, interceptVector2, numClasses, isMultinomial), this.copyValues$default$2());
                                            if (!isMultinomial) break block41;
                                            logisticRegressionModel = model;
                                            break block42;
                                        }
                                        tuple22 = model.findSummaryModelAndProbabilityCol();
                                        if (tuple22 == null) break block43;
                                        LogisticRegressionModel summaryModel = (LogisticRegressionModel)tuple22._1();
                                        String probabilityColName = (String)tuple22._2();
                                        Tuple2 tuple26 = tuple23 = new Tuple2((Object)summaryModel, (Object)probabilityColName);
                                        LogisticRegressionModel summaryModel2 = (LogisticRegressionModel)tuple26._1();
                                        String probabilityColName2 = (String)tuple26._2();
                                        BinaryLogisticRegressionTrainingSummary logRegSummary = new BinaryLogisticRegressionTrainingSummary(summaryModel2.transform(dataset), probabilityColName2, this.$(this.labelCol()), this.$(this.featuresCol()), objectiveHistory);
                                        logisticRegressionModel = model.setSummary((Option<LogisticRegressionTrainingSummary>)new Some((Object)logRegSummary));
                                    }
                                    LogisticRegressionModel m = logisticRegressionModel;
                                    instr.logSuccess(m);
                                    return m;
                                }
                                throw new MatchError(tuple22);
                            }
                            throw new MatchError((Object)tuple3);
                        }
                        throw new MatchError((Object)vector);
                    }
                    throw new MatchError(option2);
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported family: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
            }
            throw new MatchError(option);
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public LogisticRegression copy(ParamMap extra) {
        return (LogisticRegression)this.defaultCopy(extra);
    }

    private final Function1 regParamL1Fun$1(int numFeatures$1, int numCoefficientSets$1, double[] featuresStd$1, double regParamL1$1, boolean standardizationParam$1) {
        return new Serializable(this, numFeatures$1, numCoefficientSets$1, featuresStd$1, regParamL1$1, standardizationParam$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegression $outer;
            private final int numFeatures$1;
            private final int numCoefficientSets$1;
            private final double[] featuresStd$1;
            private final double regParamL1$1;
            private final boolean standardizationParam$1;

            public final double apply(int index2) {
                return this.apply$mcDI$sp(index2);
            }

            public double apply$mcDI$sp(int index2) {
                int featureIndex;
                boolean isIntercept;
                boolean bl = isIntercept = BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.fitIntercept())) && index2 >= this.numFeatures$1 * this.numCoefficientSets$1;
                return isIntercept ? 0.0 : (this.standardizationParam$1 ? this.regParamL1$1 : (this.featuresStd$1[featureIndex = index2 / this.numCoefficientSets$1] != 0.0 ? this.regParamL1$1 / this.featuresStd$1[featureIndex] : 0.0));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numFeatures$1 = numFeatures$1;
                this.numCoefficientSets$1 = numCoefficientSets$1;
                this.featuresStd$1 = featuresStd$1;
                this.regParamL1$1 = regParamL1$1;
                this.standardizationParam$1 = standardizationParam$1;
            }
        };
    }

    public LogisticRegression(String uid) {
        this.uid = uid;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasTol$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasThreshold$class.$init$(this);
        HasAggregationDepth$class.$init$(this);
        LogisticRegressionParams$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.elasticNetParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.family().$minus$greater("auto")}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.standardization().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aggregationDepth().$minus$greater(BoxesRunTime.boxToInteger((int)2))}));
        this.optInitialModel = None$.MODULE$;
    }

    public LogisticRegression() {
        this(Identifiable$.MODULE$.randomUID("logreg"));
    }
}

