/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import java.util.Iterator;
import java.util.List;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.PrimaryExpressionIsClassLiteralException;
import org.datanucleus.query.expression.PrimaryExpressionIsInvokeException;
import org.datanucleus.query.expression.PrimaryExpressionIsVariableException;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.util.StringUtils;

public class InvokeExpression
extends Expression {
    String methodName;
    List<Expression> arguments;

    public InvokeExpression(Expression invoked, String methodName, List args) {
        this.left = invoked;
        this.methodName = methodName;
        this.arguments = args;
        if (invoked != null) {
            invoked.parent = this;
        }
        if (args != null && !args.isEmpty()) {
            Iterator argIter = args.iterator();
            while (argIter.hasNext()) {
                ((Expression)argIter.next()).parent = this;
            }
        }
    }

    public String getOperation() {
        return this.methodName;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public Symbol bind(SymbolTable symtbl) {
        if (this.left != null) {
            try {
                this.left.bind(symtbl);
            }
            catch (PrimaryExpressionIsVariableException pive) {
                this.left = pive.getVariableExpression();
                this.left.bind(symtbl);
            }
            catch (PrimaryExpressionIsInvokeException piie) {
                this.left = piie.getInvokeExpression();
                this.left.bind(symtbl);
            }
            catch (PrimaryExpressionIsClassLiteralException picle) {
                this.methodName = ((PrimaryExpression)this.left).getId() + "." + this.methodName;
                this.left = null;
            }
        }
        if (this.arguments != null && this.arguments.size() > 0) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                Expression ve;
                Expression expr = this.arguments.get(i);
                try {
                    expr.bind(symtbl);
                    continue;
                }
                catch (PrimaryExpressionIsVariableException pive) {
                    ve = pive.getVariableExpression();
                    ((VariableExpression)ve).bind(symtbl);
                    this.arguments.remove(i);
                    this.arguments.add(i, ve);
                    continue;
                }
                catch (PrimaryExpressionIsInvokeException piie) {
                    ve = piie.getInvokeExpression();
                    ((InvokeExpression)ve).bind(symtbl);
                    this.arguments.remove(i);
                    this.arguments.add(i, ve);
                    continue;
                }
                catch (PrimaryExpressionIsClassLiteralException picle) {
                    Literal l = picle.getLiteral();
                    l.bind(symtbl);
                    this.arguments.remove(i);
                    this.arguments.add(i, l);
                }
            }
        }
        return this.symbol;
    }

    public String toStringWithoutAlias() {
        if (this.left == null) {
            return "InvokeExpression{STATIC." + this.methodName + "(" + StringUtils.collectionToString(this.arguments) + ")}";
        }
        return "InvokeExpression{[" + this.left + "]." + this.methodName + "(" + StringUtils.collectionToString(this.arguments) + ")}";
    }

    public String toString() {
        if (this.left == null) {
            return "InvokeExpression{STATIC." + this.methodName + "(" + StringUtils.collectionToString(this.arguments) + ")}" + (this.alias != null ? " AS " + this.alias : "");
        }
        return "InvokeExpression{[" + this.left + "]." + this.methodName + "(" + StringUtils.collectionToString(this.arguments) + ")}" + (this.alias != null ? " AS " + this.alias : "");
    }
}

