/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.mesos;

import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkCuratorUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterPersistenceEngine;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055a!B\u0001\u0003\u0001!q!A\n.p_.,W\r]3s\u001b\u0016\u001cxn]\"mkN$XM\u001d)feNL7\u000f^3oG\u0016,enZ5oK*\u00111\u0001B\u0001\u0006[\u0016\u001cxn\u001d\u0006\u0003\u000b\u0019\tqa\u00197vgR,'O\u0003\u0002\b\u0011\u0005I1o\u00195fIVdWM\u001d\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON!\u0001aD\u000b\u001a!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u001e\u001b\u0016\u001cxn]\"mkN$XM\u001d)feNL7\u000f^3oG\u0016,enZ5oKB\u0011!$H\u0007\u00027)\u0011A\u0004C\u0001\tS:$XM\u001d8bY&\u0011ad\u0007\u0002\b\u0019><w-\u001b8h\u0011!\u0001\u0003A!A!\u0002\u0013\u0011\u0013a\u00022bg\u0016$\u0015N]\u0002\u0001!\t\u0019cE\u0004\u0002\u0011I%\u0011Q%E\u0001\u0007!J,G-\u001a4\n\u0005\u001dB#AB*ue&twM\u0003\u0002&#!A!\u0006\u0001B\u0001B\u0003%1&\u0001\u0002{WB\u0011A&M\u0007\u0002[)\u0011afL\u0001\nMJ\fW.Z<pe.T!\u0001\r\u0006\u0002\u000f\r,(/\u0019;pe&\u0011!'\f\u0002\u0011\u0007V\u0014\u0018\r^8s\rJ\fW.Z<pe.D\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!N\u0001\u0005G>tg\r\u0005\u00027o5\t\u0001\"\u0003\u00029\u0011\tI1\u000b]1sW\u000e{gN\u001a\u0005\u0006u\u0001!\taO\u0001\u0007y%t\u0017\u000e\u001e \u0015\tqjdh\u0010\t\u0003-\u0001AQ\u0001I\u001dA\u0002\tBQAK\u001dA\u0002-BQ\u0001N\u001dA\u0002UBq!\u0011\u0001C\u0002\u0013%!)A\u0006X\u001fJ[\u0015JT$`\t&\u0013V#A\"\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015\u0001\u00027b]\u001eT\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002(\u000b\"11\n\u0001Q\u0001\n\r\u000bAbV(S\u0017&sui\u0018#J%\u0002BQ!\u0014\u0001\u0005\u00029\u000bA\u0001]1uQR\u0011!e\u0014\u0005\u0006!2\u0003\rAI\u0001\u0005]\u0006lW\rC\u0003S\u0001\u0011\u00053+A\u0004fqB,hnZ3\u0015\u0005Q;\u0006C\u0001\tV\u0013\t1\u0016C\u0001\u0003V]&$\b\"\u0002)R\u0001\u0004\u0011\u0003\"B-\u0001\t\u0003R\u0016a\u00029feNL7\u000f\u001e\u000b\u0004)nc\u0006\"\u0002)Y\u0001\u0004\u0011\u0003\"B/Y\u0001\u0004q\u0016aA8cUB\u0011AiX\u0005\u0003A\u0016\u0013aa\u00142kK\u000e$\b\"\u00022\u0001\t\u0003\u001a\u0017!\u00024fi\u000eDWC\u00013k)\t)7\u000fE\u0002\u0011M\"L!aZ\t\u0003\r=\u0003H/[8o!\tI'\u000e\u0004\u0001\u0005\u000b-\f'\u0019\u00017\u0003\u0003Q\u000b\"!\u001c9\u0011\u0005Aq\u0017BA8\u0012\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001E9\n\u0005I\f\"aA!os\")\u0001+\u0019a\u0001E!)Q\u000f\u0001C!m\u0006Aa-\u001a;dQ\u0006cG.F\u0002x\u0003\u0017!\u0012\u0001\u001f\t\u0006s\u0006\r\u0011\u0011\u0002\b\u0003u~t!a\u001f@\u000e\u0003qT!!`\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012bAA\u0001#\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0003\u0003\u000f\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003\u0003\t\u0002cA5\u0002\f\u0011)1\u000e\u001eb\u0001Y\u0002")
public class ZookeeperMesosClusterPersistenceEngine
implements MesosClusterPersistenceEngine,
Logging {
    private final CuratorFramework zk;
    private final String WORKING_DIR;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private String WORKING_DIR() {
        return this.WORKING_DIR;
    }

    public String path(String name) {
        return new StringBuilder().append((Object)this.WORKING_DIR()).append((Object)"/").append((Object)name).toString();
    }

    @Override
    public void expunge(String name) {
        this.zk.delete().forPath(this.path(name));
    }

    @Override
    public void persist(String name, Object obj) {
        byte[] serialized = Utils$.MODULE$.serialize(obj);
        String zkPath = this.path(name);
        ((PathAndBytesable)this.zk.create().withMode(CreateMode.PERSISTENT)).forPath(zkPath, serialized);
    }

    @Override
    public <T> Option<T> fetch(String name) {
        None$ none$;
        String zkPath = this.path(name);
        try {
            byte[] fileData = (byte[])this.zk.getData().forPath(zkPath);
            none$ = new Some(Utils$.MODULE$.deserialize(fileData));
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception while reading persisted file, deleting";
                }
            }, exception);
            this.zk.delete().forPath(zkPath);
            none$ = None$.MODULE$;
        }
        catch (KeeperException.NoNodeException noNodeException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public <T> Iterable<T> fetchAll() {
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.zk.getChildren().forPath(this.WORKING_DIR())).asScala()).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperMesosClusterPersistenceEngine $outer;

            public final Iterable<T> apply(String name) {
                return Option$.MODULE$.option2Iterable(this.$outer.fetch(name));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public ZookeeperMesosClusterPersistenceEngine(String baseDir, CuratorFramework zk, SparkConf conf) {
        this.zk = zk;
        Logging.class.$init$((Logging)this);
        this.WORKING_DIR = new StringBuilder().append((Object)conf.get("spark.deploy.zookeeper.dir", "/spark_mesos_dispatcher")).append((Object)"/").append((Object)baseDir).toString();
        SparkCuratorUtil$.MODULE$.mkdir(zk, this.WORKING_DIR());
    }
}

