/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.validate.AggregatingScope;
import org.apache.calcite.sql.validate.AggregatingSelectScope;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Stacks;
import org.apache.calcite.util.Static;

class AggChecker
extends SqlBasicVisitor<Void> {
    private final List<SqlValidatorScope> scopes = Lists.newArrayList();
    private final List<SqlNode> groupExprs;
    private boolean distinct;
    private SqlValidatorImpl validator;

    AggChecker(SqlValidatorImpl validator, AggregatingScope scope, List<SqlNode> groupExprs, boolean distinct) {
        this.validator = validator;
        this.groupExprs = groupExprs;
        this.distinct = distinct;
        Stacks.push(this.scopes, scope);
    }

    boolean isGroupExpr(SqlNode expr) {
        for (SqlNode groupExpr : this.groupExprs) {
            if (!groupExpr.equalsDeep(expr, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Void visit(SqlIdentifier id) {
        if (this.isGroupExpr(id)) {
            return null;
        }
        if (id.isStar()) assert (false) : "star should have been expanded";
        SqlCall call = SqlUtil.makeCall(this.validator.getOperatorTable(), id);
        if (call != null) {
            return call.accept(this);
        }
        SqlQualified fqId = Stacks.peek(this.scopes).fullyQualify(id);
        if (this.isGroupExpr(fqId.identifier)) {
            return null;
        }
        SqlNode originalExpr = this.validator.getOriginal(id);
        String exprString = originalExpr.toString();
        throw this.validator.newValidationError(originalExpr, this.distinct ? Static.RESOURCE.notSelectDistinctExpr(exprString) : Static.RESOURCE.notGroupExpr(exprString));
    }

    @Override
    public Void visit(SqlCall call) {
        SqlValidatorScope scope = Stacks.peek(this.scopes);
        if (call.getOperator().isAggregator()) {
            if (this.distinct) {
                if (scope instanceof AggregatingSelectScope) {
                    SqlNodeList selectList = ((SqlSelect)scope.getNode()).getSelectList();
                    for (SqlNode sqlNode : selectList) {
                        if (sqlNode.getKind() == SqlKind.AS) {
                            sqlNode = ((SqlCall)sqlNode).operand(0);
                        }
                        if (!this.validator.expand(sqlNode, scope).equalsDeep(call, false)) continue;
                        return null;
                    }
                }
                SqlNode originalExpr = this.validator.getOriginal(call);
                String exprString = originalExpr.toString();
                throw this.validator.newValidationError(call, Static.RESOURCE.notSelectDistinctExpr(exprString));
            }
            return null;
        }
        if (this.isGroupExpr(call)) {
            return null;
        }
        if (call.isA(SqlKind.QUERY)) {
            return null;
        }
        SqlValidatorScope newScope = scope.getOperandScope(call);
        Stacks.push(this.scopes, newScope);
        call.getOperator().acceptCall(this, call, true, SqlBasicVisitor.ArgHandlerImpl.instance());
        Stacks.pop(this.scopes, newScope);
        return null;
    }
}

