/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;

public final class JoinExtractFilterRule
extends RelOptRule {
    public static final JoinExtractFilterRule INSTANCE = new JoinExtractFilterRule(LogicalJoin.class);

    public JoinExtractFilterRule(Class<? extends Join> clazz) {
        super(JoinExtractFilterRule.operand(clazz, JoinExtractFilterRule.any()));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        if (join.getJoinType() != JoinRelType.INNER) {
            return;
        }
        if (join.getCondition().isAlwaysTrue()) {
            return;
        }
        if (!join.getSystemFieldList().isEmpty()) {
            return;
        }
        Join cartesianJoinRel = join.copy(join.getTraitSet(), join.getCluster().getRexBuilder().makeLiteral(true), join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone());
        RelNode filterRel = RelOptUtil.createFilter((RelNode)cartesianJoinRel, join.getCondition());
        call.transformTo(filterRel);
    }
}

