/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleOperandChildPolicy;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.Util;

public class RelOptRuleOperand {
    private RelOptRuleOperand parent;
    private RelOptRule rule;
    private final Predicate<RelNode> predicate;
    public int[] solveOrder;
    public int ordinalInParent;
    public int ordinalInRule;
    private final RelTrait trait;
    private final Class<? extends RelNode> clazz;
    private final ImmutableList<RelOptRuleOperand> children;
    public final RelOptRuleOperandChildPolicy childPolicy;

    protected <R extends RelNode> RelOptRuleOperand(Class<R> clazz, RelTrait trait, Predicate<? super R> predicate, RelOptRuleOperandChildren children) {
        assert (clazz != null);
        switch (children.policy) {
            case ANY: {
                break;
            }
            case LEAF: {
                assert (children.operands.size() == 0);
                break;
            }
            case UNORDERED: {
                assert (children.operands.size() == 1);
                break;
            }
            default: {
                assert (children.operands.size() > 0);
                break;
            }
        }
        this.childPolicy = children.policy;
        this.clazz = (Class)Preconditions.checkNotNull(clazz);
        this.trait = trait;
        this.predicate = (Predicate)Preconditions.checkNotNull(predicate);
        this.children = children.operands;
        for (RelOptRuleOperand child : this.children) {
            assert (child.parent == null) : "cannot re-use operands";
            child.parent = this;
        }
    }

    public RelOptRuleOperand getParent() {
        return this.parent;
    }

    public void setParent(RelOptRuleOperand parent) {
        this.parent = parent;
    }

    public RelOptRule getRule() {
        return this.rule;
    }

    public void setRule(RelOptRule rule) {
        this.rule = rule;
    }

    public int hashCode() {
        int h = this.clazz.hashCode();
        h = Util.hash(h, this.trait);
        h = Util.hash(h, this.children);
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RelOptRuleOperand)) {
            return false;
        }
        RelOptRuleOperand that = (RelOptRuleOperand)obj;
        return this.clazz == that.clazz && Objects.equal((Object)this.trait, (Object)that.trait) && this.children.equals(that.children);
    }

    public Class<? extends RelNode> getMatchedClass() {
        return this.clazz;
    }

    public List<RelOptRuleOperand> getChildOperands() {
        return this.children;
    }

    public boolean matches(RelNode rel) {
        if (!this.clazz.isInstance(rel)) {
            return false;
        }
        if (this.trait != null && !rel.getTraitSet().contains(this.trait)) {
            return false;
        }
        return this.predicate.apply((Object)rel);
    }
}

