/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.dsl;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Abs;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Lower;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.Sqrt;
import org.apache.spark.sql.catalyst.expressions.Upper;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.expressions.aggregate.First;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Last;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.ObjectType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.runtime.BoxesRunTime;

public abstract class package$ExpressionConversions$class {
    public static package.ExpressionConversions.DslExpression DslExpression(package.ExpressionConversions $this, Expression e) {
        return new package.ExpressionConversions.DslExpression($this, e);
    }

    public static Literal booleanToLiteral(package.ExpressionConversions $this, boolean b) {
        return Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)b));
    }

    public static Literal byteToLiteral(package.ExpressionConversions $this, byte b) {
        return Literal$.MODULE$.apply(BoxesRunTime.boxToByte((byte)b));
    }

    public static Literal shortToLiteral(package.ExpressionConversions $this, short s) {
        return Literal$.MODULE$.apply(BoxesRunTime.boxToShort((short)s));
    }

    public static Literal intToLiteral(package.ExpressionConversions $this, int i) {
        return Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)i));
    }

    public static Literal longToLiteral(package.ExpressionConversions $this, long l) {
        return Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)l));
    }

    public static Literal floatToLiteral(package.ExpressionConversions $this, float f) {
        return Literal$.MODULE$.apply(BoxesRunTime.boxToFloat((float)f));
    }

    public static Literal doubleToLiteral(package.ExpressionConversions $this, double d) {
        return Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)d));
    }

    public static Literal stringToLiteral(package.ExpressionConversions $this, String s) {
        return Literal$.MODULE$.apply(s);
    }

    public static Literal dateToLiteral(package.ExpressionConversions $this, Date d) {
        return Literal$.MODULE$.apply(d);
    }

    public static Literal bigDecimalToLiteral(package.ExpressionConversions $this, BigDecimal d) {
        return Literal$.MODULE$.apply(d.underlying());
    }

    public static Literal bigDecimalToLiteral(package.ExpressionConversions $this, java.math.BigDecimal d) {
        return Literal$.MODULE$.apply(d);
    }

    public static Literal decimalToLiteral(package.ExpressionConversions $this, Decimal d) {
        return Literal$.MODULE$.apply(d);
    }

    public static Literal timestampToLiteral(package.ExpressionConversions $this, Timestamp t) {
        return Literal$.MODULE$.apply(t);
    }

    public static Literal binaryToLiteral(package.ExpressionConversions $this, byte[] a) {
        return Literal$.MODULE$.apply(a);
    }

    public static UnresolvedAttribute symbolToUnresolvedAttribute(package.ExpressionConversions $this, Symbol s) {
        return UnresolvedAttribute$.MODULE$.apply(s.name());
    }

    public static package.ExpressionConversions.StringToAttributeConversionHelper StringToAttributeConversionHelper(package.ExpressionConversions $this, StringContext sc) {
        return new package.ExpressionConversions.StringToAttributeConversionHelper($this, sc);
    }

    public static Expression sum(package.ExpressionConversions $this, Expression e) {
        return new Sum(e).toAggregateExpression();
    }

    public static Expression sumDistinct(package.ExpressionConversions $this, Expression e) {
        return new Sum(e).toAggregateExpression(true);
    }

    public static Expression count(package.ExpressionConversions $this, Expression e) {
        return Count$.MODULE$.apply(e).toAggregateExpression();
    }

    public static Expression countDistinct(package.ExpressionConversions $this, Seq e) {
        return new Count((Seq<Expression>)e).toAggregateExpression(true);
    }

    public static Expression approxCountDistinct(package.ExpressionConversions $this, Expression e, double rsd) {
        return new HyperLogLogPlusPlus(e, rsd, HyperLogLogPlusPlus$.MODULE$.apply$default$3(), HyperLogLogPlusPlus$.MODULE$.apply$default$4()).toAggregateExpression();
    }

    public static double approxCountDistinct$default$2(package.ExpressionConversions $this) {
        return 0.05;
    }

    public static Expression avg(package.ExpressionConversions $this, Expression e) {
        return new Average(e).toAggregateExpression();
    }

    public static Expression first(package.ExpressionConversions $this, Expression e) {
        return new First(e).toAggregateExpression();
    }

    public static Expression last(package.ExpressionConversions $this, Expression e) {
        return new Last(e).toAggregateExpression();
    }

    public static Expression min(package.ExpressionConversions $this, Expression e) {
        return new Min(e).toAggregateExpression();
    }

    public static Expression max(package.ExpressionConversions $this, Expression e) {
        return new Max(e).toAggregateExpression();
    }

    public static Expression upper(package.ExpressionConversions $this, Expression e) {
        return new Upper(e);
    }

    public static Expression lower(package.ExpressionConversions $this, Expression e) {
        return new Lower(e);
    }

    public static Expression sqrt(package.ExpressionConversions $this, Expression e) {
        return new Sqrt(e);
    }

    public static Expression abs(package.ExpressionConversions $this, Expression e) {
        return new Abs(e);
    }

    public static Expression star(package.ExpressionConversions $this, Seq names2) {
        Seq seq = names2;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        UnresolvedStar unresolvedStar = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0 ? new UnresolvedStar((Option<Seq<String>>)None$.MODULE$) : new UnresolvedStar((Option<Seq<String>>)Option$.MODULE$.apply((Object)seq));
        return unresolvedStar;
    }

    public static Expression callFunction(package.ExpressionConversions $this, Function1 func, DataType returnType, Expression argument) {
        Literal function = Literal$.MODULE$.create(func, new ObjectType(Function1.class));
        Expression expression = argument;
        return new Invoke(function, "apply", returnType, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression), Invoke$.MODULE$.apply$default$5());
    }

    public static WindowSpecDefinition windowSpec(package.ExpressionConversions $this, Seq partitionSpec, Seq orderSpec, WindowFrame frame) {
        return new WindowSpecDefinition((Seq<Expression>)partitionSpec, (Seq<SortOrder>)orderSpec, frame);
    }

    public static WindowExpression windowExpr(package.ExpressionConversions $this, Expression windowFunc, WindowSpecDefinition windowSpec) {
        return new WindowExpression(windowFunc, windowSpec);
    }

    public static package.ExpressionConversions.DslSymbol DslSymbol(package.ExpressionConversions $this, Symbol sym) {
        return new package.ExpressionConversions.DslSymbol($this, sym);
    }

    public static package.ExpressionConversions.DslString DslString(package.ExpressionConversions $this, String s) {
        return new package.ExpressionConversions.DslString($this, s);
    }

    public static package.ExpressionConversions.DslAttribute DslAttribute(package.ExpressionConversions $this, AttributeReference a) {
        return new package.ExpressionConversions.DslAttribute($this, a);
    }

    public static void $init$(package.ExpressionConversions $this) {
    }
}

