/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ISetDoubleArg;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncDoubleToDouble;

public class PosModDoubleToDouble
extends MathFuncDoubleToDouble
implements ISetDoubleArg {
    private static final long serialVersionUID = 1L;
    private double divisor;

    public PosModDoubleToDouble(int inputCol, double scalarVal, int outputCol) {
        super(inputCol, outputCol);
        this.divisor = scalarVal;
    }

    public PosModDoubleToDouble() {
    }

    @Override
    protected double func(double v) {
        return (v % this.divisor + this.divisor) % this.divisor;
    }

    @Override
    public void setArg(double arg) {
        this.divisor = arg;
    }

    public void setDivisor(double v) {
        this.divisor = v;
    }

    public double getDivisor() {
        return this.divisor;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

