/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui;

import java.net.URI;
import java.net.URL;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.spark.SSLOptions;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.ui.JettyUtils;
import org.apache.spark.ui.JettyUtils$ServletParams$;
import org.apache.spark.ui.ServerInfo;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import org.spark_project.jetty.client.api.Response;
import org.spark_project.jetty.proxy.ProxyServlet;
import org.spark_project.jetty.server.Connector;
import org.spark_project.jetty.server.Handler;
import org.spark_project.jetty.server.HttpConnectionFactory;
import org.spark_project.jetty.server.Request;
import org.spark_project.jetty.server.Server;
import org.spark_project.jetty.server.ServerConnector;
import org.spark_project.jetty.server.handler.AbstractHandler;
import org.spark_project.jetty.server.handler.ContextHandler;
import org.spark_project.jetty.server.handler.ContextHandlerCollection;
import org.spark_project.jetty.server.handler.ErrorHandler;
import org.spark_project.jetty.servlet.DefaultServlet;
import org.spark_project.jetty.servlet.FilterHolder;
import org.spark_project.jetty.servlet.ServletContextHandler;
import org.spark_project.jetty.servlet.ServletHolder;
import org.spark_project.jetty.servlets.gzip.GzipHandler;
import org.spark_project.jetty.util.ssl.SslContextFactory;
import org.spark_project.jetty.util.thread.QueuedThreadPool;
import org.spark_project.jetty.util.thread.ScheduledExecutorScheduler;
import org.spark_project.jetty.util.thread.Scheduler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.TraitSetter;
import scala.xml.Node;

public final class JettyUtils$
implements Logging {
    public static final JettyUtils$ MODULE$;
    private final String SPARK_CONNECTOR_NAME;
    private final String REDIRECT_CONNECTOR_NAME;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new JettyUtils$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public String SPARK_CONNECTOR_NAME() {
        return this.SPARK_CONNECTOR_NAME;
    }

    public String REDIRECT_CONNECTOR_NAME() {
        return this.REDIRECT_CONNECTOR_NAME;
    }

    public JettyUtils.ServletParams<JsonAST.JValue> jsonResponderToServlet(Function1<HttpServletRequest, JsonAST.JValue> responder) {
        return new JettyUtils.ServletParams<JsonAST.JValue>(responder, "text/json", (Function1<JsonAST.JValue, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(JsonAST.JValue in) {
                JsonAST.JValue x$5 = in;
                Formats x$6 = JsonMethods$.MODULE$.render$default$2(x$5);
                return JsonMethods$.MODULE$.pretty(JsonMethods$.MODULE$.render(x$5, x$6));
            }
        }, (Function1<JsonAST.JValue, Object>)Predef$.MODULE$.$conforms());
    }

    public JettyUtils.ServletParams<Seq<Node>> htmlResponderToServlet(Function1<HttpServletRequest, Seq<Node>> responder) {
        return new JettyUtils.ServletParams<Seq<Node>>(responder, "text/html", (Function1<Seq<Node>, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Seq<Node> in) {
                return new StringBuilder().append((Object)"<!DOCTYPE html>").append((Object)in.toString()).toString();
            }
        }, (Function1<Seq<Node>, Object>)Predef$.MODULE$.$conforms());
    }

    public JettyUtils.ServletParams<String> textResponderToServlet(Function1<HttpServletRequest, String> responder) {
        return new JettyUtils.ServletParams<Object>((Function1<HttpServletRequest, Object>)responder, "text/plain", JettyUtils$ServletParams$.MODULE$.$lessinit$greater$default$3(), (Function1<Object, Object>)Predef$.MODULE$.$conforms());
    }

    public <T> HttpServlet createServlet(JettyUtils.ServletParams<T> servletParams, SecurityManager securityMgr, SparkConf conf, Function1<T, Object> evidence$2) {
        Option<String> allowFramingFrom = conf.getOption("spark.ui.allowFramingFrom");
        String xFrameOptionsValue = (String)allowFramingFrom.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String uri) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALLOW-FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri}));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "SAMEORIGIN";
            }
        });
        return new HttpServlet(servletParams, securityMgr, xFrameOptionsValue){
            private final JettyUtils.ServletParams servletParams$1;
            private final SecurityManager securityMgr$1;
            private final String xFrameOptionsValue$1;

            public void doGet(HttpServletRequest request, HttpServletResponse response) {
                try {
                    if (this.securityMgr$1.checkUIViewPermissions(request.getRemoteUser())) {
                        response.setContentType(new StringOps(Predef$.MODULE$.augmentString("%s;charset=utf-8")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.servletParams$1.contentType()})));
                        response.setStatus(200);
                        Object result2 = this.servletParams$1.responder().apply((Object)request);
                        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                        response.setHeader("X-Frame-Options", this.xFrameOptionsValue$1);
                        response.getWriter().print((String)this.servletParams$1.extractFn().apply(result2));
                    } else {
                        response.setStatus(403);
                        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                        response.sendError(403, "User is not authorized to access this page.");
                    }
                }
                catch (Exception exception2) {
                    JettyUtils$.MODULE$.logWarning((Function0<String>)new Serializable(this, request, exception2){
                        public static final long serialVersionUID = 0L;
                        private final HttpServletRequest request$1;
                        private final Exception e$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GET ", " failed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$1.getRequestURI(), this.e$1}));
                        }
                        {
                            this.request$1 = request$1;
                            this.e$1 = e$1;
                        }
                    }, exception2);
                    throw exception2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    response.sendError(400, illegalArgumentException.getMessage());
                }
            }

            public void doTrace(HttpServletRequest req, HttpServletResponse res) {
                res.sendError(405);
            }
            {
                this.servletParams$1 = servletParams$1;
                this.securityMgr$1 = securityMgr$1;
                this.xFrameOptionsValue$1 = xFrameOptionsValue$1;
            }
        };
    }

    public <T> ServletContextHandler createServletHandler(String path, JettyUtils.ServletParams<T> servletParams, SecurityManager securityMgr, SparkConf conf, String basePath, Function1<T, Object> evidence$3) {
        return this.createServletHandler(path, this.createServlet(servletParams, securityMgr, conf, evidence$3), basePath);
    }

    /*
     * Unable to fully structure code
     */
    public ServletContextHandler createServletHandler(String path, HttpServlet servlet, String basePath) {
        v0 = basePath;
        var4_4 = "";
        if (v0 != null ? v0.equals(var4_4) == false : var4_4 != null) ** GOTO lbl-1000
        v1 = path;
        var5_5 = "/";
        if (!(v1 != null ? v1.equals(var5_5) == false : var5_5 != null)) {
            v2 = path;
        } else lbl-1000:
        // 2 sources

        {
            v2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)basePath).append((Object)path).toString())).stripSuffix("/");
        }
        prefixedPath = v2;
        contextHandler = new ServletContextHandler();
        holder = new ServletHolder((Servlet)servlet);
        contextHandler.setContextPath(prefixedPath);
        contextHandler.addServlet(holder, "/");
        return contextHandler;
    }

    public <T> String createServletHandler$default$5() {
        return "";
    }

    public ServletContextHandler createRedirectHandler(String srcPath, String destPath, Function1<HttpServletRequest, BoxedUnit> beforeRedirect, String basePath, Set<String> httpMethods) {
        String prefixedDestPath = new StringBuilder().append((Object)basePath).append((Object)destPath).toString();
        HttpServlet servlet = new HttpServlet(beforeRedirect, httpMethods, prefixedDestPath){
            private final Function1 beforeRedirect$1;
            private final Set httpMethods$1;
            private final String prefixedDestPath$1;

            public void doGet(HttpServletRequest request, HttpServletResponse response) {
                if (this.httpMethods$1.contains((Object)"GET")) {
                    this.doRequest(request, response);
                } else {
                    response.sendError(405);
                }
            }

            public void doPost(HttpServletRequest request, HttpServletResponse response) {
                if (this.httpMethods$1.contains((Object)"POST")) {
                    this.doRequest(request, response);
                } else {
                    response.sendError(405);
                }
            }

            private void doRequest(HttpServletRequest request, HttpServletResponse response) {
                this.beforeRedirect$1.apply((Object)request);
                String newUrl = new URL(new URL(request.getRequestURL().toString()), this.prefixedDestPath$1).toString();
                response.sendRedirect(newUrl);
            }

            public void doTrace(HttpServletRequest req, HttpServletResponse res) {
                res.sendError(405);
            }
            {
                this.beforeRedirect$1 = beforeRedirect$1;
                this.httpMethods$1 = httpMethods$1;
                this.prefixedDestPath$1 = prefixedDestPath$1;
            }
        };
        return this.createServletHandler(srcPath, servlet, basePath);
    }

    public Function1<HttpServletRequest, BoxedUnit> createRedirectHandler$default$3() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(HttpServletRequest x) {
            }
        };
    }

    public String createRedirectHandler$default$4() {
        return "";
    }

    public Set<String> createRedirectHandler$default$5() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GET"}));
    }

    /*
     * WARNING - void declaration
     */
    public ServletContextHandler createStaticHandler(String resourceBase, String path) {
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setInitParameter("org.spark_project.jetty.servlet.Default.gzip", "false");
        DefaultServlet staticHandler = new DefaultServlet();
        ServletHolder holder = new ServletHolder((Servlet)staticHandler);
        Option option = Option$.MODULE$.apply((Object)Utils$.MODULE$.getSparkClassLoader().getResource(resourceBase));
        if (option instanceof Some) {
            void var3_3;
            Some some = (Some)option;
            URL res = (URL)some.x();
            holder.setInitParameter("resourceBase", res.toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            contextHandler.setContextPath(path);
            contextHandler.addServlet(holder, "/");
            return var3_3;
        }
        if (None$.MODULE$.equals(option)) {
            throw new Exception(new StringBuilder().append((Object)"Could not find resource path for Web UI: ").append((Object)resourceBase).toString());
        }
        throw new MatchError((Object)option);
    }

    public ServletContextHandler createProxyHandler(String prefix, String target) {
        ProxyServlet servlet = new ProxyServlet(prefix, target){
            private final String prefix$1;
            private final String target$1;

            public String rewriteTarget(HttpServletRequest request) {
                URI rewrittenURI = JettyUtils$.MODULE$.createProxyURI(this.prefix$1, this.target$1, request.getRequestURI(), request.getQueryString());
                if (rewrittenURI == null) {
                    return null;
                }
                if (this.validateDestination(rewrittenURI.getHost(), rewrittenURI.getPort())) {
                    return rewrittenURI.toString();
                }
                return null;
            }

            public String filterServerResponseHeader(HttpServletRequest clientRequest, Response serverResponse, String headerName, String headerValue) {
                String newHeader;
                if (headerName.equalsIgnoreCase("location") && (newHeader = JettyUtils$.MODULE$.createProxyLocationHeader(this.prefix$1, headerValue, clientRequest, serverResponse.getRequest().getURI())) != null) {
                    return newHeader;
                }
                return super.filterServerResponseHeader(clientRequest, serverResponse, headerName, headerValue);
            }
            {
                this.prefix$1 = prefix$1;
                this.target$1 = target$1;
            }
        };
        ServletContextHandler contextHandler = new ServletContextHandler();
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        contextHandler.setContextPath(prefix);
        contextHandler.addServlet(holder, "/");
        return contextHandler;
    }

    public void addFilters(Seq<ServletContextHandler> handlers, SparkConf conf) {
        String[] filters = (String[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(conf.get("spark.ui.filters", ""))).split(',')).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Predef$.MODULE$.refArrayOps((Object[])filters).foreach((Function1)new Serializable(handlers, conf){
            public static final long serialVersionUID = 0L;
            private final Seq handlers$1;
            private final SparkConf conf$1;

            public final void apply(String x0$1) {
                String string = x0$1;
                if (string != null) {
                    BoxedUnit boxedUnit;
                    String string2 = string;
                    if (string2.isEmpty()) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        JettyUtils$.MODULE$.logInfo((Function0<String>)new Serializable(this, string2){
                            public static final long serialVersionUID = 0L;
                            private final String x2$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Adding filter: ").append((Object)this.x2$1).toString();
                            }
                            {
                                this.x2$1 = x2$1;
                            }
                        });
                        FilterHolder holder = new FilterHolder();
                        holder.setClassName(string2);
                        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(this.conf$1.get(new StringBuilder().append((Object)"spark.").append((Object)string2).append((Object)".params").toString(), ""))).split(',')).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x$2) {
                                return x$2.trim();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().foreach((Function1)new Serializable(this, holder){
                            public static final long serialVersionUID = 0L;
                            private final FilterHolder holder$1;

                            public final void apply(String param) {
                                String[] parts;
                                if (!param.isEmpty() && (parts = param.split("=")).length == 2) {
                                    this.holder$1.setInitParameter(parts[0], parts[1]);
                                }
                            }
                            {
                                this.holder$1 = holder$1;
                            }
                        });
                        String prefix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.", ".param."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string2}));
                        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.conf$1.getAll()).filter((Function1)new Serializable(this, prefix){
                            public static final long serialVersionUID = 0L;
                            private final String prefix$2;

                            public final boolean apply(Tuple2<String, String> x0$2) {
                                Tuple2<String, String> tuple2 = x0$2;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    boolean bl = k.length() > this.prefix$2.length() && k.startsWith(this.prefix$2);
                                    return bl;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.prefix$2 = prefix$2;
                            }
                        })).foreach((Function1)new Serializable(this, holder, prefix){
                            public static final long serialVersionUID = 0L;
                            private final FilterHolder holder$1;
                            private final String prefix$2;

                            public final void apply(Tuple2<String, String> x0$3) {
                                Tuple2<String, String> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    String v = (String)tuple2._2();
                                    this.holder$1.setInitParameter(k.substring(this.prefix$2.length()), v);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.holder$1 = holder$1;
                                this.prefix$2 = prefix$2;
                            }
                        });
                        EnumSet<DispatcherType> enumDispatcher = EnumSet.of(DispatcherType.ASYNC, DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST);
                        this.handlers$1.foreach((Function1)new Serializable(this, holder, enumDispatcher){
                            public static final long serialVersionUID = 0L;
                            private final FilterHolder holder$1;
                            private final EnumSet enumDispatcher$1;

                            public final void apply(ServletContextHandler x0$4) {
                                ServletContextHandler servletContextHandler = x0$4;
                                servletContextHandler.addFilter(this.holder$1, "/*", (EnumSet<DispatcherType>)this.enumDispatcher$1);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            {
                                this.holder$1 = holder$1;
                                this.enumDispatcher$1 = enumDispatcher$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError((Object)string);
            }
            {
                this.handlers$1 = handlers$1;
                this.conf$1 = conf$1;
            }
        });
    }

    public ServerInfo startJettyServer(String hostName, int port, SSLOptions sslOptions, Seq<ServletContextHandler> handlers, SparkConf conf, String serverName) {
        this.addFilters(handlers, conf);
        Seq gzipHandlers = (Seq)handlers.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final GzipHandler apply(ServletContextHandler h) {
                void var2_2;
                h.setVirtualHosts((String[])((Object[])new String[]{new StringBuilder().append((Object)"@").append((Object)JettyUtils$.MODULE$.SPARK_CONNECTOR_NAME()).toString()}));
                GzipHandler gzipHandler = new GzipHandler();
                gzipHandler.setHandler(h);
                return var2_2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = Utils$.MODULE$.startServiceOnPort(port, new Serializable(hostName, sslOptions, serverName, gzipHandlers){
            public static final long serialVersionUID = 0L;
            private final String hostName$1;
            private final SSLOptions sslOptions$1;
            private final String serverName$1;
            private final Seq gzipHandlers$1;

            public final Tuple2<Tuple2<Server, Option<Object>>, Object> apply(int currentPort) {
                return JettyUtils$.MODULE$.org$apache$spark$ui$JettyUtils$$connect$1(currentPort, this.hostName$1, this.sslOptions$1, this.serverName$1, this.gzipHandlers$1);
            }
            {
                this.hostName$1 = hostName$1;
                this.sslOptions$1 = sslOptions$1;
                this.serverName$1 = serverName$1;
                this.gzipHandlers$1 = gzipHandlers$1;
            }
        }, conf, serverName);
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            int boundPort2 = tuple2._2$mcI$sp();
            if (tuple22 != null) {
                Tuple3 tuple3;
                Server server = (Server)tuple22._1();
                Option securePort = (Option)tuple22._2();
                Tuple3 tuple32 = tuple3 = new Tuple3((Object)server, (Object)securePort, (Object)BoxesRunTime.boxToInteger((int)boundPort2));
                Server server2 = (Server)tuple32._1();
                Option securePort2 = (Option)tuple32._2();
                int boundPort3 = BoxesRunTime.unboxToInt((Object)tuple32._3());
                return new ServerInfo(server2, boundPort3, (Option<Object>)securePort2, (ContextHandlerCollection)server2.getHandler());
            }
        }
        throw new MatchError(tuple2);
    }

    public String startJettyServer$default$6() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private ContextHandler createRedirectHttpsHandler(ServerConnector httpsConnector, String scheme) {
        void var3_3;
        ContextHandler redirectHandler = new ContextHandler();
        redirectHandler.setContextPath("/");
        redirectHandler.setVirtualHosts((String[])((Object[])new String[]{new StringBuilder().append((Object)"@").append((Object)this.REDIRECT_CONNECTOR_NAME()).toString()}));
        redirectHandler.setHandler(new AbstractHandler(httpsConnector, scheme){
            private final ServerConnector httpsConnector$1;
            private final String scheme$1;

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                if (baseRequest.isSecure()) {
                    return;
                }
                String httpsURI = JettyUtils$.MODULE$.org$apache$spark$ui$JettyUtils$$createRedirectURI(this.scheme$1, baseRequest.getServerName(), this.httpsConnector$1.getLocalPort(), baseRequest.getRequestURI(), baseRequest.getQueryString());
                response.setContentLength(0);
                response.encodeRedirectURL(httpsURI);
                response.sendRedirect(httpsURI);
                baseRequest.setHandled(true);
            }
            {
                this.httpsConnector$1 = httpsConnector$1;
                this.scheme$1 = scheme$1;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public URI createProxyURI(String prefix, String target, String path, String query) {
        if (path.startsWith(prefix)) {
            void var7_7;
            BoxedUnit boxedUnit;
            StringBuilder uri = new StringBuilder(target);
            String rest = path.substring(prefix.length());
            if (rest.isEmpty()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Object object = rest.startsWith("/") ? BoxedUnit.UNIT : uri.append("/");
                boxedUnit = uri.append(rest);
            }
            URI rewrittenURI = URI.create(uri.toString());
            if (query == null) {
                return rewrittenURI.normalize();
            }
            return new URI(var7_7.getScheme(), var7_7.getAuthority(), var7_7.getPath(), query, var7_7.getFragment()).normalize();
        }
        return null;
    }

    public String createProxyLocationHeader(String prefix, String headerValue, HttpServletRequest clientRequest, URI targetUri) {
        String toReplace = new StringBuilder().append((Object)targetUri.getScheme()).append((Object)"://").append((Object)targetUri.getAuthority()).toString();
        return headerValue.startsWith(toReplace) ? new StringBuilder().append((Object)clientRequest.getScheme()).append((Object)"://").append((Object)clientRequest.getHeader("host")).append((Object)prefix).append((Object)headerValue.substring(toReplace.length())).toString() : null;
    }

    public String org$apache$spark$ui$JettyUtils$$createRedirectURI(String scheme, String server, int port, String path, String query) {
        String redirectServer = server.contains(":") && !server.startsWith("[") ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{server})) : server;
        String authority = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{redirectServer, BoxesRunTime.boxToInteger((int)port)}));
        return new URI(scheme, authority, path, query, null).toString();
    }

    public final Tuple2 org$apache$spark$ui$JettyUtils$$connect$1(int currentPort, String hostName$1, SSLOptions sslOptions$1, String serverName$1, Seq gzipHandlers$1) {
        Option<SslContextFactory> option;
        block8: {
            None$ none$;
            ServerConnector httpConnector;
            ContextHandlerCollection collection;
            ArrayBuffer connectors;
            Server server;
            QueuedThreadPool pool;
            block7: {
                block6: {
                    pool = new QueuedThreadPool();
                    if (new StringOps(Predef$.MODULE$.augmentString(serverName$1)).nonEmpty()) {
                        pool.setName(serverName$1);
                    }
                    pool.setDaemon(true);
                    server = new Server(pool);
                    connectors = new ArrayBuffer();
                    collection = new ContextHandlerCollection();
                    httpConnector = new ServerConnector(server, null, (Scheduler)new ScheduledExecutorScheduler(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-JettyScheduler"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serverName$1})), true), null, -1, -1, new HttpConnectionFactory());
                    httpConnector.setPort(currentPort);
                    connectors.$plus$eq((Object)httpConnector);
                    option = sslOptions$1.createJettySslContextFactory();
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    SslContextFactory factory = (SslContextFactory)some.x();
                    int securePort = currentPort != 0 ? (currentPort + 400 - 1024) % 64512 + 1024 : 0;
                    String scheme = "https";
                    ServerConnector connector = new ServerConnector(server, factory);
                    connector.setPort(securePort);
                    connector.setName(this.SPARK_CONNECTOR_NAME());
                    connectors.$plus$eq((Object)connector);
                    httpConnector.setName(this.REDIRECT_CONNECTOR_NAME());
                    collection.addHandler(this.createRedirectHttpsHandler(connector, scheme));
                    none$ = new Some((Object)connector);
                    break block7;
                }
                if (!None$.MODULE$.equals(option)) break block8;
                httpConnector.setName(this.SPARK_CONNECTOR_NAME());
                none$ = None$.MODULE$;
            }
            None$ httpsConnector = none$;
            IntRef minThreads = IntRef.create((int)1);
            connectors.foreach((Function1)new Serializable(hostName$1, minThreads){
                public static final long serialVersionUID = 0L;
                private final String hostName$1;
                private final IntRef minThreads$1;

                public final void apply(ServerConnector connector) {
                    connector.setAcceptQueueSize(package$.MODULE$.min(connector.getAcceptors(), 8));
                    connector.setHost(this.hostName$1);
                    this.minThreads$1.elem += connector.getAcceptors() * 2;
                }
                {
                    this.hostName$1 = hostName$1;
                    this.minThreads$1 = minThreads$1;
                }
            });
            pool.setMaxThreads(package$.MODULE$.max(pool.getMaxThreads(), minThreads.elem));
            ErrorHandler errorHandler = new ErrorHandler();
            errorHandler.setShowStacks(true);
            errorHandler.setServer(server);
            server.addBean(errorHandler);
            gzipHandlers$1.foreach((Function1)new Serializable(collection){
                public static final long serialVersionUID = 0L;
                private final ContextHandlerCollection collection$1;

                public final void apply(Handler x$1) {
                    this.collection$1.addHandler(x$1);
                }
                {
                    this.collection$1 = collection$1;
                }
            });
            server.setHandler(collection);
            server.setConnectors((Connector[])connectors.toArray(ClassTag$.MODULE$.apply(Connector.class)));
            try {
                server.start();
                return new Tuple2((Object)new Tuple2((Object)server, (Object)httpsConnector.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(ServerConnector x$3) {
                        return x$3.getLocalPort();
                    }
                })), (Object)BoxesRunTime.boxToInteger((int)httpConnector.getLocalPort()));
            }
            catch (Exception exception2) {
                server.stop();
                pool.stop();
                throw exception2;
            }
        }
        throw new MatchError(option);
    }

    private JettyUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.SPARK_CONNECTOR_NAME = "Spark";
        this.REDIRECT_CONNECTOR_NAME = "HttpsRedirect";
    }
}

