/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.ForeignKeyRIChecker;
import org.apache.derby.impl.sql.execute.GenericRIChecker;
import org.apache.derby.impl.sql.execute.ReferencedKeyRIChecker;

public class RISetChecker {
    private GenericRIChecker[] checkers;
    LanguageConnectionContext lcc;

    public RISetChecker(LanguageConnectionContext languageConnectionContext, TransactionController transactionController, FKInfo[] fKInfoArray) throws StandardException {
        if (fKInfoArray == null) {
            return;
        }
        this.checkers = new GenericRIChecker[fKInfoArray.length];
        this.lcc = languageConnectionContext;
        for (int i = 0; i < fKInfoArray.length; ++i) {
            this.checkers[i] = fKInfoArray[i].type == 1 ? new ForeignKeyRIChecker(languageConnectionContext, transactionController, fKInfoArray[i]) : new ReferencedKeyRIChecker(languageConnectionContext, transactionController, fKInfoArray[i]);
        }
    }

    void reopen() throws StandardException {
    }

    public void doPKCheck(Activation activation, ExecRow execRow, boolean bl, int n) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (GenericRIChecker genericRIChecker : this.checkers) {
            if (!(genericRIChecker instanceof ReferencedKeyRIChecker)) continue;
            genericRIChecker.doCheck(activation, execRow, bl, n);
        }
    }

    public void postCheck() throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i = 0; i < this.checkers.length; ++i) {
            this.postCheck(i);
        }
    }

    public void postCheck(int n) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        if (this.checkers[n] instanceof ReferencedKeyRIChecker) {
            ((ReferencedKeyRIChecker)this.checkers[n]).postCheck();
        }
    }

    public void doFKCheck(Activation activation, ExecRow execRow) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i = 0; i < this.checkers.length; ++i) {
            if (!(this.checkers[i] instanceof ForeignKeyRIChecker)) continue;
            this.checkers[i].doCheck(activation, execRow, false, 0);
        }
    }

    public void doRICheck(Activation activation, int n, ExecRow execRow, boolean bl, int n2) throws StandardException {
        this.checkers[n].doCheck(activation, execRow, bl, n2);
    }

    public void close() throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i = 0; i < this.checkers.length; ++i) {
            this.checkers[i].close();
        }
    }
}

