/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import java.util.Arrays;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.fpm.FPGrowth$;
import org.apache.spark.mllib.fpm.FPGrowthModel;
import org.apache.spark.mllib.fpm.FPTree;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t}c\u0001B\u0001\u0003\u00015\u0011\u0001B\u0012)He><H\u000f\u001b\u0006\u0003\u0007\u0011\t1A\u001a9n\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00155A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!!\u0007\f\u0003\u000f1{wmZ5oOB\u0011qbG\u0005\u00039A\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\b\u0001\u0003\u0002\u0004%IaH\u0001\u000b[&t7+\u001e9q_J$X#\u0001\u0011\u0011\u0005=\t\u0013B\u0001\u0012\u0011\u0005\u0019!u.\u001e2mK\"AA\u0005\u0001BA\u0002\u0013%Q%\u0001\bnS:\u001cV\u000f\u001d9peR|F%Z9\u0015\u0005\u0019J\u0003CA\b(\u0013\tA\u0003C\u0001\u0003V]&$\bb\u0002\u0016$\u0003\u0003\u0005\r\u0001I\u0001\u0004q\u0012\n\u0004\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0011\u0002\u00175LgnU;qa>\u0014H\u000f\t\u0005\t]\u0001\u0011\t\u0019!C\u0005_\u0005ia.^7QCJ$\u0018\u000e^5p]N,\u0012\u0001\r\t\u0003\u001fEJ!A\r\t\u0003\u0007%sG\u000f\u0003\u00055\u0001\t\u0005\r\u0011\"\u00036\u0003EqW/\u001c)beRLG/[8og~#S-\u001d\u000b\u0003MYBqAK\u001a\u0002\u0002\u0003\u0007\u0001\u0007\u0003\u00059\u0001\t\u0005\t\u0015)\u00031\u00039qW/\u001c)beRLG/[8og\u0002BQA\u000f\u0001\u0005\nm\na\u0001P5oSRtDc\u0001\u001f?\u007fA\u0011Q\bA\u0007\u0002\u0005!)a$\u000fa\u0001A!)a&\u000fa\u0001a!)!\b\u0001C\u0001\u0003R\tA\bK\u0002A\u0007&\u0003\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002I\u000b\n)1+\u001b8dK\u0006\n!*A\u00032]Mr\u0003\u0007C\u0003M\u0001\u0011\u0005Q*A\u0007tKRl\u0015N\\*vaB|'\u000f\u001e\u000b\u0003\u001d>k\u0011\u0001\u0001\u0005\u0006=-\u0003\r\u0001\t\u0015\u0004\u0017\u000eK\u0005\"\u0002*\u0001\t\u0003\u0019\u0016\u0001E:fi:+X\u000eU1si&$\u0018n\u001c8t)\tqE\u000bC\u0003/#\u0002\u0007\u0001\u0007K\u0002R\u0007&CQa\u0016\u0001\u0005\u0002a\u000b1A];o+\tI\u0006\r\u0006\u0002[cR\u00111,\u001b\t\u0004{qs\u0016BA/\u0003\u000551\u0005k\u0012:poRDWj\u001c3fYB\u0011q\f\u0019\u0007\u0001\t\u0015\tgK1\u0001c\u0005\u0011IE/Z7\u0012\u0005\r4\u0007CA\be\u0013\t)\u0007CA\u0004O_RD\u0017N\\4\u0011\u0005=9\u0017B\u00015\u0011\u0005\r\te.\u001f\u0005\bUZ\u000b\t\u0011q\u0001l\u0003))g/\u001b3f]\u000e,Ge\r\t\u0004Y>tV\"A7\u000b\u00059\u0004\u0012a\u0002:fM2,7\r^\u0005\u0003a6\u0014\u0001b\u00117bgN$\u0016m\u001a\u0005\u0006eZ\u0003\ra]\u0001\u0005I\u0006$\u0018\rE\u0002uofl\u0011!\u001e\u0006\u0003m\u001a\t1A\u001d3e\u0013\tAXOA\u0002S\t\u0012\u00032a\u0004>_\u0013\tY\bCA\u0003BeJ\f\u0017\u0010K\u0002W\u0007&CQa\u0016\u0001\u0005\u0002y,Ra`A\u0003\u00037!B!!\u0001\u0002\bA!Q\bXA\u0002!\ry\u0016Q\u0001\u0003\u0006Cv\u0014\rA\u0019\u0005\u0007ev\u0004\r!!\u0003\u0011\r\u0005-\u0011QCA\r\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011\u0001\u00026bm\u0006T1!a\u0005\u0007\u0003\r\t\u0007/[\u0005\u0005\u0003/\tiAA\u0004KCZ\f'\u000b\u0012#\u0011\u0007}\u000bY\u0002B\u0004\u0002\u001eu\u0014\r!a\b\u0003\r\t\u000b7o[3u#\r\u0019\u0017\u0011\u0005\t\u0007\u0003G\tY#a\u0001\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\tA\u0001\\1oO*\u0011\u0011qB\u0005\u0005\u0003[\t)C\u0001\u0005Ji\u0016\u0014\u0018M\u00197fQ\ri8)\u0013\u0005\b\u0003g\u0001A\u0011BA\u001b\u000319WM\u001c$sKFLE/Z7t+\u0011\t9$a\u0010\u0015\u0011\u0005e\u0012qIA&\u0003+\"B!a\u000f\u0002BA!qB_A\u001f!\ry\u0016q\b\u0003\u0007C\u0006E\"\u0019\u00012\t\u0015\u0005\r\u0013\u0011GA\u0001\u0002\b\t)%\u0001\u0006fm&$WM\\2fIQ\u0002B\u0001\\8\u0002>!9!/!\rA\u0002\u0005%\u0003\u0003\u0002;x\u0003wA\u0001\"!\u0014\u00022\u0001\u0007\u0011qJ\u0001\t[&t7i\\;oiB\u0019q\"!\u0015\n\u0007\u0005M\u0003C\u0001\u0003M_:<\u0007\u0002CA,\u0003c\u0001\r!!\u0017\u0002\u0017A\f'\u000f^5uS>tWM\u001d\t\u0005\u00037\ni&D\u0001\u0007\u0013\r\tyF\u0002\u0002\f!\u0006\u0014H/\u001b;j_:,'\u000fC\u0004\u0002d\u0001!I!!\u001a\u0002\u001f\u001d,gN\u0012:fc&#X-\\:fiN,B!a\u001a\u0003\u0012QQ\u0011\u0011\u000eB\r\u0005?\u0011\tC!\n\u0015\t\u0005-$1\u0003\t\u0005i^\fi\u0007\u0005\u0004\u0002p\u0005e%q\u0002\b\u0005\u0003c\nYI\u0004\u0003\u0002t\u0005%e\u0002BA;\u0003\u000fsA!a\u001e\u0002\u0006:!\u0011\u0011PAB\u001d\u0011\tY(!!\u000e\u0005\u0005u$bAA@\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u000f\u001d\tiI\u0001E\u0001\u0003\u001f\u000b\u0001B\u0012)He><H\u000f\u001b\t\u0004{\u0005EeAB\u0001\u0003\u0011\u0003\t\u0019j\u0005\u0003\u0002\u0012:Q\u0002b\u0002\u001e\u0002\u0012\u0012\u0005\u0011q\u0013\u000b\u0003\u0003\u001f3q!a'\u0002\u0012\u0002\tiJA\u0006Ge\u0016\f\u0018\n^3ng\u0016$X\u0003BAP\u0003W\u001bB!!'\u000f5!Y\u00111UAM\u0005\u000b\u0007I\u0011AAS\u0003\u0015IG/Z7t+\t\t9\u000b\u0005\u0003\u0010u\u0006%\u0006cA0\u0002,\u00121\u0011-!'C\u0002\tDC!!)D\u0013\"Y\u0011\u0011WAM\u0005\u0003\u0005\u000b\u0011BAT\u0003\u0019IG/Z7tA!\"\u0011qV\"J\u0011-\t9,!'\u0003\u0006\u0004%\t!!/\u0002\t\u0019\u0014X-]\u000b\u0003\u0003\u001fBC!!.D\u0013\"Y\u0011qXAM\u0005\u0003\u0005\u000b\u0011BA(\u0003\u00151'/Z9!Q\u0011\tilQ%\t\u000fi\nI\n\"\u0001\u0002FR1\u0011qYAf\u0003\u001f\u0004b!!3\u0002\u001a\u0006%VBAAI\u0011!\t\u0019+a1A\u0002\u0005\u001d\u0006\u0006BAf\u0007&C\u0001\"a.\u0002D\u0002\u0007\u0011q\n\u0015\u0005\u0003\u001f\u001c\u0015\n\u000b\u0003\u0002D\u000eK\u0005\u0002CAl\u00033#\t!!7\u0002\u0013)\fg/Y%uK6\u001cXCAAn!\u0019\ti.a9\u0002*6\u0011\u0011q\u001c\u0006\u0005\u0003C\fI#\u0001\u0003vi&d\u0017\u0002BAs\u0003?\u0014A\u0001T5ti\"\"\u0011Q[\"J\u0011!\tY/!'\u0005B\u00055\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005=\b\u0003BAy\u0003ot1aDAz\u0013\r\t)\u0010E\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00181 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005U\b\u0003\u000b\u0003\u0002\u001a\u000eK\u0005B\u0003B\u0001\u0003#\u000b\t\u0011\"\u0003\u0003\u0004\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011)\u0001\u0005\u0003\u0002$\t\u001d\u0011\u0002\u0002B\u0005\u0003K\u0011aa\u00142kK\u000e$\b\u0006BAI\u0007&CC!a#D\u0013B\u0019qL!\u0005\u0005\r\u0005\f\tG1\u0001c\u0011)\u0011)\"!\u0019\u0002\u0002\u0003\u000f!qC\u0001\u000bKZLG-\u001a8dK\u0012*\u0004\u0003\u00027p\u0005\u001fAqA]A1\u0001\u0004\u0011Y\u0002\u0005\u0003uo\nu\u0001\u0003B\b{\u0005\u001fA\u0001\"!\u0014\u0002b\u0001\u0007\u0011q\n\u0005\t\u0005G\t\t\u00071\u0001\u0003\u001e\u0005IaM]3r\u0013R,Wn\u001d\u0005\t\u0003/\n\t\u00071\u0001\u0002Z!9!\u0011\u0006\u0001\u0005\n\t-\u0012aE4f]\u000e{g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:\u001cX\u0003\u0002B\u0017\u0005\u0017\"\u0002Ba\f\u0003N\tM#1\f\u000b\u0005\u0005c\u0011\u0019\u0005E\u0004\u00034\tu\u0002G!\u0011\u000e\u0005\tU\"\u0002\u0002B\u001c\u0005s\tq!\\;uC\ndWMC\u0002\u0003<A\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yD!\u000e\u0003\u00075\u000b\u0007\u000fE\u0002\u0010uBB!B!\u0012\u0003(\u0005\u0005\t9\u0001B$\u0003))g/\u001b3f]\u000e,GE\u000e\t\u0005Y>\u0014I\u0005E\u0002`\u0005\u0017\"a!\u0019B\u0014\u0005\u0004\u0011\u0007\u0002\u0003B(\u0005O\u0001\rA!\u0015\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\t\u0005\u001fi\u0014I\u0005\u0003\u0005\u0003V\t\u001d\u0002\u0019\u0001B,\u0003)IG/Z7U_J\u000bgn\u001b\t\b\u0003c\u0014IF!\u00131\u0013\u0011\u0011y$a?\t\u0011\u0005]#q\u0005a\u0001\u00033B3\u0001A\"J\u0001")
public class FPGrowth
implements Logging,
Serializable {
    private double minSupport;
    private int numPartitions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private double minSupport() {
        return this.minSupport;
    }

    private void minSupport_$eq(double x$1) {
        this.minSupport = x$1;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(int x$1) {
        this.numPartitions = x$1;
    }

    public FPGrowth setMinSupport(double minSupport) {
        Predef$.MODULE$.require(minSupport >= 0.0 && minSupport <= 1.0, (Function0)new Serializable(this, minSupport){
            public static final long serialVersionUID = 0L;
            private final double minSupport$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Minimal support level must be in range [0, 1] but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.minSupport$1)}));
            }
            {
                this.minSupport$1 = minSupport$1;
            }
        });
        this.minSupport_$eq(minSupport);
        return this;
    }

    public FPGrowth setNumPartitions(int numPartitions) {
        Predef$.MODULE$.require(numPartitions > 0, (Function0)new Serializable(this, numPartitions){
            public static final long serialVersionUID = 0L;
            private final int numPartitions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of partitions must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numPartitions$1)}));
            }
            {
                this.numPartitions$1 = numPartitions$1;
            }
        });
        this.numPartitions_$eq(numPartitions);
        return this;
    }

    public <Item> FPGrowthModel<Item> run(RDD<Object> data, ClassTag<Item> evidence$3) {
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Input data is not cached.";
                }
            });
        }
        long count = data.count();
        long minCount = (long)package$.MODULE$.ceil(this.minSupport() * (double)count);
        int numParts = this.numPartitions() > 0 ? this.numPartitions() : data.partitions().length;
        HashPartitioner partitioner = new HashPartitioner(numParts);
        Object freqItems = this.genFreqItems(data, minCount, (Partitioner)partitioner, evidence$3);
        RDD<FreqItemset<Item>> freqItemsets = this.genFreqItemsets(data, minCount, freqItems, (Partitioner)partitioner, evidence$3);
        return new FPGrowthModel<Item>(freqItemsets, evidence$3);
    }

    public <Item, Basket extends java.lang.Iterable<Item>> FPGrowthModel<Item> run(JavaRDD<Basket> data) {
        ClassTag tag = JavaSparkContext$.MODULE$.fakeClassTag();
        return this.run((RDD<Object>)data.rdd().map((Function1)new Serializable(this, tag){
            public static final long serialVersionUID = 0L;
            private final ClassTag tag$1;

            public final Object apply(Basket x$2) {
                return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$2).asScala()).toArray(this.tag$1);
            }
            {
                this.tag$1 = tag$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(tag.runtimeClass()))), tag);
    }

    private <Item> Object genFreqItems(RDD<Object> data, long minCount, Partitioner partitioner, ClassTag<Item> evidence$4) {
        RDD x$10 = data.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<Item> apply(Object t) {
                Set uniq = Predef$.MODULE$.genericArrayOps(t).toSet();
                if (ScalaRunTime$.MODULE$.array_length(t) != uniq.size()) {
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Items in a transaction must be unique but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps(t).toSeq()})));
                }
                return Predef$.MODULE$.genericArrayOps(t);
            }
        }, evidence$4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Item, Object> apply(Item v) {
                return new Tuple2(v, (Object)BoxesRunTime.boxToLong((long)1L));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag<Item> x$11 = evidence$4;
        ClassTag x$12 = ClassTag$.MODULE$.Long();
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$10);
        Object x$13 = null;
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(x$10, x$11, x$12, null).reduceByKey(partitioner, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$3, long x$4) {
                return this.apply$mcJJJ$sp(x$3, x$4);
            }

            public long apply$mcJJJ$sp(long x$3, long x$4) {
                return x$3 + x$4;
            }
        }).filter((Function1)new Serializable(this, minCount){
            public static final long serialVersionUID = 0L;
            private final long minCount$1;

            public final boolean apply(Tuple2<Item, Object> x$5) {
                return x$5._2$mcJ$sp() >= this.minCount$1;
            }
            {
                this.minCount$1 = minCount$1;
            }
        }).collect()).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Item, Object> x$6) {
                return -x$6._2$mcJ$sp();
            }
        }, (Ordering)Ordering.Long$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Item apply(Tuple2<Item, Object> x$7) {
                return (Item)x$7._1();
            }
        }, Array$.MODULE$.canBuildFrom(evidence$4));
    }

    private <Item> RDD<FreqItemset<Item>> genFreqItemsets(RDD<Object> data, long minCount, Object freqItems, Partitioner partitioner, ClassTag<Item> evidence$5) {
        Map itemToRank = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(freqItems).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        return RDD$.MODULE$.rddToPairRDDFunctions(data.flatMap((Function1)new Serializable(this, partitioner, evidence$5, itemToRank){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FPGrowth $outer;
            private final Partitioner partitioner$1;
            private final ClassTag evidence$5$1;
            private final Map itemToRank$1;

            public final scala.collection.mutable.Map<Object, int[]> apply(Object transaction) {
                return this.$outer.org$apache$spark$mllib$fpm$FPGrowth$$genCondTransactions(transaction, this.itemToRank$1, this.partitioner$1, this.evidence$5$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitioner$1 = partitioner$1;
                this.evidence$5$1 = evidence$5$1;
                this.itemToRank$1 = itemToRank$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)), (Ordering)Ordering.Int$.MODULE$).aggregateByKey(new FPTree(), partitioner.numPartitions(), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FPTree<Object> apply(FPTree<Object> tree, int[] transaction) {
                return tree.add((Iterable<Object>)Predef$.MODULE$.wrapIntArray(transaction), 1L);
            }
        }, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FPTree<Object> apply(FPTree<Object> tree1, FPTree<Object> tree2) {
                return tree1.merge(tree2);
            }
        }, ClassTag$.MODULE$.apply(FPTree.class)).flatMap((Function1)new Serializable(this, minCount, partitioner){
            public static final long serialVersionUID = 0L;
            private final long minCount$2;
            public final Partitioner partitioner$1;

            public final Iterator<Tuple2<List<Object>, Object>> apply(Tuple2<Object, FPTree<Object>> x0$1) {
                Tuple2<Object, FPTree<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int part = tuple2._1$mcI$sp();
                    FPTree tree = (FPTree)tuple2._2();
                    Iterator<Tuple2<List<T>, Object>> iterator = tree.extract(this.minCount$2, new Serializable(this, part){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$genFreqItemsets$4 $outer;
                        private final int part$1;

                        public final boolean apply(int x) {
                            return this.apply$mcZI$sp(x);
                        }

                        public boolean apply$mcZI$sp(int x) {
                            return this.$outer.partitioner$1.getPartition((Object)BoxesRunTime.boxToInteger((int)x)) == this.part$1;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.part$1 = part$1;
                        }
                    });
                    return iterator;
                }
                throw new MatchError(tuple2);
            }
            {
                this.minCount$2 = minCount$2;
                this.partitioner$1 = partitioner$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(this, freqItems, evidence$5){
            public static final long serialVersionUID = 0L;
            public final Object freqItems$1;
            private final ClassTag evidence$5$1;

            public final FreqItemset<Item> apply(Tuple2<List<Object>, Object> x0$2) {
                Tuple2<List<Object>, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    List ranks = (List)tuple2._1();
                    long count = tuple2._2$mcJ$sp();
                    FreqItemset<Item> freqItemset = new FreqItemset<Item>(((TraversableOnce)ranks.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$genFreqItemsets$5 $outer;

                        public final Item apply(int i) {
                            return (Item)ScalaRunTime$.MODULE$.array_apply(this.$outer.freqItems$1, i);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, List$.MODULE$.canBuildFrom())).toArray(this.evidence$5$1), count);
                    return freqItemset;
                }
                throw new MatchError(tuple2);
            }
            {
                this.freqItems$1 = freqItems$1;
                this.evidence$5$1 = evidence$5$1;
            }
        }, ClassTag$.MODULE$.apply(FreqItemset.class));
    }

    public <Item> scala.collection.mutable.Map<Object, int[]> org$apache$spark$mllib$fpm$FPGrowth$$genCondTransactions(Object transaction, Map<Item, Object> itemToRank, Partitioner partitioner, ClassTag<Item> evidence$6) {
        scala.collection.mutable.Map output = Map$.MODULE$.empty();
        int[] filtered = (int[])Predef$.MODULE$.genericArrayOps(transaction).flatMap((Function1)new Serializable(this, itemToRank){
            public static final long serialVersionUID = 0L;
            private final Map itemToRank$2;

            public final Iterable<Object> apply(Item key) {
                return Option$.MODULE$.option2Iterable(this.itemToRank$2.get(key));
            }
            {
                this.itemToRank$2 = itemToRank$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Arrays.sort(filtered);
        int n = filtered.length;
        for (int i = n - 1; i >= 0; --i) {
            int item = filtered[i];
            int part = partitioner.getPartition((Object)BoxesRunTime.boxToInteger((int)item));
            if (output.contains((Object)BoxesRunTime.boxToInteger((int)part))) continue;
            output.update((Object)BoxesRunTime.boxToInteger((int)part), Predef$.MODULE$.intArrayOps(filtered).slice(0, i + 1));
        }
        return output;
    }

    private FPGrowth(double minSupport, int numPartitions) {
        this.minSupport = minSupport;
        this.numPartitions = numPartitions;
        Logging.class.$init$((Logging)this);
    }

    public FPGrowth() {
        this(0.3, -1);
    }

    public static class FreqItemset<Item>
    implements Serializable {
        private final Object items;
        private final long freq;

        public Object items() {
            return this.items;
        }

        public long freq() {
            return this.freq;
        }

        public java.util.List<Item> javaItems() {
            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.genericArrayOps(this.items()).toList()).asJava();
        }

        public String toString() {
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps(this.items()).mkString("{", ",", "}"), BoxesRunTime.boxToLong((long)this.freq())}));
        }

        public FreqItemset(Object items, long freq) {
            this.items = items;
            this.freq = freq;
        }
    }
}

