/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasAggregationDepth$class;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasSolver$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.regression.LinearRegressionModel$;
import org.apache.spark.ml.regression.LinearRegressionModel$LinearRegressionModelWriter$;
import org.apache.spark.ml.regression.LinearRegressionModel$LinearRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionSummary;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\tmg\u0001B\u0001\u0003\u00015\u0011Q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8N_\u0012,GN\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019IB\u0004\u0005\u0003\u0010!IAR\"\u0001\u0002\n\u0005E\u0011!a\u0004*fOJ,7o]5p]6{G-\u001a7\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011A\u00027j]\u0006dw-\u0003\u0002\u0018)\t1a+Z2u_J\u0004\"a\u0004\u0001\u0011\u0005=Q\u0012BA\u000e\u0003\u0005Ya\u0015N\\3beJ+wM]3tg&|g\u000eU1sC6\u001c\bCA\u000f!\u001b\u0005q\"BA\u0010\u0005\u0003\u0011)H/\u001b7\n\u0005\u0005r\"AC'M/JLG/\u00192mK\"A1\u0005\u0001BC\u0002\u0013\u0005C%A\u0002vS\u0012,\u0012!\n\t\u0003M1r!a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\na\u0001\u0015:fI\u00164\u0017BA\u0017/\u0005\u0019\u0019FO]5oO*\u00111\u0006\u000b\u0015\u0004EA2\u0004CA\u00195\u001b\u0005\u0011$BA\u001a\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003kI\u0012QaU5oG\u0016\f\u0013aN\u0001\u0006c9\"d\u0006\r\u0005\ts\u0001\u0011\t\u0011)A\u0005K\u0005!Q/\u001b3!Q\rA\u0004G\u000e\u0005\ty\u0001\u0011)\u0019!C\u0001{\u0005a1m\\3gM&\u001c\u0017.\u001a8ugV\t!\u0003K\u0002<a}\n\u0013\u0001Q\u0001\u0006e9\u0002d\u0006\r\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005%\u0005i1m\\3gM&\u001c\u0017.\u001a8ug\u0002B3!\u0011\u0019@\u0011!)\u0005A!b\u0001\n\u00031\u0015!C5oi\u0016\u00148-\u001a9u+\u00059\u0005CA\u0014I\u0013\tI\u0005F\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\tBZ\u0015%\u0001'\u0002\u000bEr3G\f\u0019\t\u00119\u0003!\u0011!Q\u0001\n\u001d\u000b!\"\u001b8uKJ\u001cW\r\u001d;!Q\ri\u0005g\u0013\u0005\u0007#\u0002!\t\u0001\u0002*\u0002\rqJg.\u001b;?)\u0011A2+V,\t\u000b\r\u0002\u0006\u0019A\u0013)\u0007M\u0003d\u0007C\u0003=!\u0002\u0007!\u0003K\u0002Va}BQ!\u0012)A\u0002\u001dC3a\u0016\u0019L\u0011\u001dQ\u0006\u00011A\u0005\nm\u000bq\u0002\u001e:bS:LgnZ*v[6\f'/_\u000b\u00029B\u0019q%X0\n\u0005yC#AB(qi&|g\u000e\u0005\u0002\u0010A&\u0011\u0011M\u0001\u0002 \u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:$&/Y5oS:<7+^7nCJL\bbB2\u0001\u0001\u0004%I\u0001Z\u0001\u0014iJ\f\u0017N\\5oON+X.\\1ss~#S-\u001d\u000b\u0003K\"\u0004\"a\n4\n\u0005\u001dD#\u0001B+oSRDq!\u001b2\u0002\u0002\u0003\u0007A,A\u0002yIEBaa\u001b\u0001!B\u0013a\u0016\u0001\u0005;sC&t\u0017N\\4Tk6l\u0017M]=!\u0011\u001di\u0007A1A\u0005B9\f1B\\;n\r\u0016\fG/\u001e:fgV\tq\u000e\u0005\u0002(a&\u0011\u0011\u000f\u000b\u0002\u0004\u0013:$\bBB:\u0001A\u0003%q.\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b\u0005C\u0003v\u0001\u0011\u0005a/A\u0004tk6l\u0017M]=\u0016\u0003}C3\u0001\u001e\u0019yC\u0005I\u0018!B\u0019/k9\u0002\u0004BB>\u0001\t\u0003\u0011A0\u0001\u0006tKR\u001cV/\\7bef$\"! @\u000e\u0003\u0001AQ!\u001e>A\u0002qCq!!\u0001\u0001\t\u0003\t\u0019!\u0001\u0006iCN\u001cV/\\7bef,\"!!\u0002\u0011\u0007\u001d\n9!C\u0002\u0002\n!\u0012qAQ8pY\u0016\fg\u000eK\u0002\u0000aaDq!a\u0004\u0001\t\u0003\t\t\"\u0001\u0005fm\u0006dW/\u0019;f)\u0011\t\u0019\"!\u0007\u0011\u0007=\t)\"C\u0002\u0002\u0018\t\u0011q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8Tk6l\u0017M]=\t\u0011\u0005m\u0011Q\u0002a\u0001\u0003;\tq\u0001Z1uCN,G\u000f\r\u0003\u0002 \u0005=\u0002CBA\u0011\u0003O\tY#\u0004\u0002\u0002$)\u0019\u0011Q\u0005\u0004\u0002\u0007M\fH.\u0003\u0003\u0002*\u0005\r\"a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003[\ty\u0003\u0004\u0001\u0005\u0019\u0005E\u0012\u0011DA\u0001\u0002\u0003\u0015\t!a\r\u0003\u0007}##'\u0005\u0003\u00026\u0005m\u0002cA\u0014\u00028%\u0019\u0011\u0011\b\u0015\u0003\u000f9{G\u000f[5oOB\u0019q%!\u0010\n\u0007\u0005}\u0002FA\u0002B]fDC!!\u00041\u007f!A\u0011Q\t\u0001\u0005\u0002\t\t9%\u0001\u0011gS:$7+^7nCJLXj\u001c3fY\u0006sG\r\u0015:fI&\u001cG/[8o\u0007>dGCAA%!\u00159\u00131\n\r&\u0013\r\ti\u0005\u000b\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005E\u0003\u0001\"\u0015\u0002T\u00059\u0001O]3eS\u000e$HcA$\u0002V!9\u0011qKA(\u0001\u0004\u0011\u0012\u0001\u00034fCR,(/Z:\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^\u0005!1m\u001c9z)\rA\u0012q\f\u0005\t\u0003C\nI\u00061\u0001\u0002d\u0005)Q\r\u001f;sCB!\u0011QMA6\u001b\t\t9GC\u0002\u0002j\u0011\tQ\u0001]1sC6LA!!\u001c\u0002h\tA\u0001+\u0019:b[6\u000b\u0007\u000f\u000b\u0003\u0002ZA2\u0004bBA:\u0001\u0011\u0005\u0013QO\u0001\u0006oJLG/Z\u000b\u0003\u0003o\u00022!HA=\u0013\r\tYH\b\u0002\t\u001b2;&/\u001b;fe\"*\u0011\u0011\u000f\u0019\u0002\u0000\u0005\u0012\u0011\u0011Q\u0001\u0006c92d\u0006\r\u0015\u0004\u0001AZuaBAD\u0005!\u0005\u0011\u0011R\u0001\u0016\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\ry\u00111\u0012\u0004\u0007\u0003\tA\t!!$\u0014\u0011\u0005-\u0015qRAK\u00037\u00032aJAI\u0013\r\t\u0019\n\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\tu\t9\nG\u0005\u0004\u00033s\"AC'M%\u0016\fG-\u00192mKB\u0019q%!(\n\u0007\u0005}\u0005F\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004R\u0003\u0017#\t!a)\u0015\u0005\u0005%\u0005\u0002CAT\u0003\u0017#\t%!+\u0002\tI,\u0017\rZ\u000b\u0003\u0003W\u0003B!HAW1%\u0019\u0011q\u0016\u0010\u0003\u00115c%+Z1eKJDS!!*1\u0003\u007fB\u0001\"!.\u0002\f\u0012\u0005\u0013qW\u0001\u0005Y>\fG\rF\u0002\u0019\u0003sCq!a/\u00024\u0002\u0007Q%\u0001\u0003qCRD\u0007&BAZa\u0005}d!CAa\u0003\u0017\u0003\u00111RAb\u0005ma\u0015N\\3beJ+wM]3tg&|g.T8eK2<&/\u001b;feN1\u0011qXA<\u0003\u000b\u0004B!a2\u0002N6\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u00174\u0011\u0001C5oi\u0016\u0014h.\u00197\n\t\u0005=\u0017\u0011\u001a\u0002\b\u0019><w-\u001b8h\u0011)\t\u0019.a0\u0003\u0002\u0003\u0006I\u0001G\u0001\tS:\u001cH/\u00198dK\"9\u0011+a0\u0005\u0002\u0005]G\u0003BAm\u0003;\u0004B!a7\u0002@6\u0011\u00111\u0012\u0005\b\u0003'\f)\u000e1\u0001\u0019\r\u001d\t\t/a0E\u0003G\u0014A\u0001R1uCNA\u0011q\\AH\u0003K\fY\nE\u0002(\u0003OL1!!;)\u0005\u001d\u0001&o\u001c3vGRD\u0011\"RAp\u0005+\u0007I\u0011\u0001$\t\u00139\u000byN!E!\u0002\u00139\u0005\"\u0003\u001f\u0002`\nU\r\u0011\"\u0001>\u0011%\u0011\u0015q\u001cB\tB\u0003%!\u0003C\u0004R\u0003?$\t!!>\u0015\r\u0005]\u00181`A\u007f!\u0011\tI0a8\u000e\u0005\u0005}\u0006BB#\u0002t\u0002\u0007q\t\u0003\u0004=\u0003g\u0004\rA\u0005\u0005\u000b\u00037\ny.!A\u0005\u0002\t\u0005ACBA|\u0005\u0007\u0011)\u0001\u0003\u0005F\u0003\u007f\u0004\n\u00111\u0001H\u0011!a\u0014q I\u0001\u0002\u0004\u0011\u0002B\u0003B\u0005\u0003?\f\n\u0011\"\u0001\u0003\f\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u0007U\r9%qB\u0016\u0003\u0005#\u0001BAa\u0005\u0003\u001c5\u0011!Q\u0003\u0006\u0005\u0005/\u0011I\"A\u0005v]\u000eDWmY6fI*\u00111\u0007K\u0005\u0005\u0005;\u0011)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!B!\t\u0002`F\u0005I\u0011\u0001B\u0012\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\n+\u0007I\u0011y\u0001\u0003\u0006\u0003*\u0005}\u0017\u0011!C!\u0005W\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0017!\u0011\u0011yC!\u000f\u000e\u0005\tE\"\u0002\u0002B\u001a\u0005k\tA\u0001\\1oO*\u0011!qG\u0001\u0005U\u00064\u0018-C\u0002.\u0005cA\u0011B!\u0010\u0002`\u0006\u0005I\u0011\u00018\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0015\t\u0005\u0013q\\A\u0001\n\u0003\u0011\u0019%\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m\"Q\t\u0005\tS\n}\u0012\u0011!a\u0001_\"Q!\u0011JAp\u0003\u0003%\tEa\u0013\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0014\u0011\r\t=#QKA\u001e\u001b\t\u0011\tFC\u0002\u0003T!\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119F!\u0015\u0003\u0011%#XM]1u_JD!Ba\u0017\u0002`\u0006\u0005I\u0011\u0001B/\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0003\u0005?B\u0011\"\u001bB-\u0003\u0003\u0005\r!a\u000f\t\u0015\t\r\u0014q\\A\u0001\n\u0003\u0012)'\u0001\u0005iCND7i\u001c3f)\u0005y\u0007B\u0003B5\u0003?\f\t\u0011\"\u0011\u0003l\u0005AAo\\*ue&tw\r\u0006\u0002\u0003.!Q!qNAp\u0003\u0003%\tE!\u001d\u0002\r\u0015\fX/\u00197t)\u0011\t)Aa\u001d\t\u0013%\u0014i'!AA\u0002\u0005mrA\u0003B<\u0003\u007f\u000b\t\u0011#\u0003\u0003z\u0005!A)\u0019;b!\u0011\tIPa\u001f\u0007\u0015\u0005\u0005\u0018qXA\u0001\u0012\u0013\u0011ih\u0005\u0004\u0003|\t}\u00141\u0014\t\t\u0005\u0003\u00139i\u0012\n\u0002x6\u0011!1\u0011\u0006\u0004\u0005\u000bC\u0013a\u0002:v]RLW.Z\u0005\u0005\u0005\u0013\u0013\u0019IA\tBEN$(/Y2u\rVt7\r^5p]JBq!\u0015B>\t\u0003\u0011i\t\u0006\u0002\u0003z!Q!\u0011\u000eB>\u0003\u0003%)Ea\u001b\t\u0015\tM%1PA\u0001\n\u0003\u0013)*A\u0003baBd\u0017\u0010\u0006\u0004\u0002x\n]%\u0011\u0014\u0005\u0007\u000b\nE\u0005\u0019A$\t\rq\u0012\t\n1\u0001\u0013\u0011)\u0011iJa\u001f\u0002\u0002\u0013\u0005%qT\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tK!*\u0011\t\u001dj&1\u0015\t\u0006O\u0005-sI\u0005\u0005\u000b\u0005O\u0013Y*!AA\u0002\u0005]\u0018a\u0001=%a!A!1VA`\t#\u0012i+\u0001\u0005tCZ,\u0017*\u001c9m)\r)'q\u0016\u0005\b\u0003w\u0013I\u000b1\u0001&\r\u001d\u0011\u0019,a#\u0005\u0005k\u00131\u0004T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8N_\u0012,GNU3bI\u0016\u00148\u0003\u0002BY\u0003WCq!\u0015BY\t\u0003\u0011I\f\u0006\u0002\u0003<B!\u00111\u001cBY\u0011)\u0011yL!-C\u0002\u0013%!1F\u0001\nG2\f7o\u001d(b[\u0016D\u0011Ba1\u00032\u0002\u0006IA!\f\u0002\u0015\rd\u0017m]:OC6,\u0007\u0005\u0003\u0005\u00026\nEF\u0011\tBd)\rA\"\u0011\u001a\u0005\b\u0003w\u0013)\r1\u0001&\u0011)\u0011i-a#\u0002\u0002\u0013%!qZ\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003RB!!q\u0006Bj\u0013\u0011\u0011)N!\r\u0003\r=\u0013'.Z2uQ\u0015\tY\tMA@Q\u0015\t)\tMA@\u0001")
public class LinearRegressionModel
extends RegressionModel<Vector, LinearRegressionModel>
implements LinearRegressionParams,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private Option<LinearRegressionTrainingSummary> trainingSummary;
    private final int numFeatures;
    private final IntParam aggregationDepth;
    private final Param<String> solver;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static LinearRegressionModel load(String string) {
        return LinearRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LinearRegressionModel> read() {
        return LinearRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth$class.getAggregationDepth(this);
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param x$1) {
        this.solver = x$1;
    }

    @Override
    public final String getSolver() {
        return HasSolver$class.getSolver(this);
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    private Option<LinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public LinearRegressionTrainingSummary summary() {
        return (LinearRegressionTrainingSummary)this.trainingSummary().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SparkException("No training summary available for this LinearRegressionModel");
            }
        });
    }

    public LinearRegressionModel setSummary(Option<LinearRegressionTrainingSummary> summary2) {
        this.trainingSummary_$eq(summary2);
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LinearRegressionSummary evaluate(Dataset<?> dataset) {
        Tuple2<LinearRegressionModel, String> tuple2 = this.findSummaryModelAndPredictionCol();
        if (tuple2 != null) {
            Tuple2 tuple22;
            LinearRegressionModel summaryModel = (LinearRegressionModel)tuple2._1();
            String predictionColName = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)summaryModel, (Object)predictionColName);
            LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple23._1();
            String predictionColName2 = (String)tuple23._2();
            return new LinearRegressionSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), summaryModel2, new double[]{0.0});
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<LinearRegressionModel, String> findSummaryModelAndPredictionCol() {
        Tuple2 tuple2;
        String string = this.$(this.predictionCol());
        if ("".equals(string)) {
            String predictionColName = new StringBuilder().append((Object)"prediction_").append((Object)UUID.randomUUID().toString()).toString();
            tuple2 = new Tuple2(this.copy(ParamMap$.MODULE$.empty()).setPredictionCol(predictionColName), (Object)predictionColName);
        } else {
            tuple2 = new Tuple2((Object)this, (Object)string);
        }
        return tuple2;
    }

    @Override
    public double predict(Vector features) {
        return BLAS$.MODULE$.dot(features, this.coefficients()) + this.intercept();
    }

    @Override
    public LinearRegressionModel copy(ParamMap extra) {
        LinearRegressionModel newModel = this.copyValues(new LinearRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        return (LinearRegressionModel)newModel.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new LinearRegressionModelWriter(this);
    }

    public LinearRegressionModel(String uid, Vector coefficients2, double intercept) {
        this.uid = uid;
        this.coefficients = coefficients2;
        this.intercept = intercept;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasSolver$class.$init$(this);
        HasAggregationDepth$class.$init$(this);
        MLWritable$class.$init$(this);
        this.trainingSummary = None$.MODULE$;
        this.numFeatures = coefficients2.size();
    }

    public static class LinearRegressionModelWriter
    extends MLWriter {
        private final LinearRegressionModel instance;
        private volatile LinearRegressionModel$LinearRegressionModelWriter$Data$ org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$$Data$module;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private LinearRegressionModel$LinearRegressionModelWriter$Data$ org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$$Data$lzycompute() {
            LinearRegressionModelWriter linearRegressionModelWriter = this;
            synchronized (linearRegressionModelWriter) {
                if (this.org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$$Data$module != null) return this.org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$$Data$module;
                this.org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$$Data$module = new LinearRegressionModel$LinearRegressionModelWriter$Data$(this);
                return this.org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$$Data$module;
            }
        }

        public LinearRegressionModel$LinearRegressionModelWriter$Data$ org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$$Data() {
            return this.org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$$Data$module == null ? this.org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$$Data$lzycompute() : this.org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$$Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = this.org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$$Data().apply(this.instance.intercept(), this.instance.coefficients());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_LinearRegressionModel$LinearRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.LinearRegressionModel.LinearRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.LinearRegressionModel.LinearRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_LinearRegressionModel$LinearRegressionModelWriter$$typecreator1$1(LinearRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionModel$LinearRegressionModelWriter$$typecreator1$1(this))).repartition(1).write().parquet(dataPath);
        }

        public LinearRegressionModelWriter(LinearRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        Serializable {
            private final double intercept;
            private final Vector coefficients;
            public final /* synthetic */ LinearRegressionModelWriter $outer;

            public double intercept() {
                return this.intercept;
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public Data copy(double intercept, Vector coefficients2) {
                return new Data(this.org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$Data$$$outer(), intercept, coefficients2);
            }

            public double copy$default$1() {
                return this.intercept();
            }

            public Vector copy$default$2() {
                return this.coefficients();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 1: {
                        object = this.coefficients();
                        break;
                    }
                    case 0: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.intercept() != data.intercept()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LinearRegressionModelWriter org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LinearRegressionModelWriter $outer, double intercept, Vector coefficients2) {
                this.intercept = intercept;
                this.coefficients = coefficients2;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.class.$init$((Product)this);
            }
        }
    }

    public static class LinearRegressionModelReader
    extends MLReader<LinearRegressionModel> {
        private final String className = LinearRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LinearRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Dataset data = this.sparkSession().read().format("parquet").load(dataPath);
            Row row = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).head();
            Some some = Row$.MODULE$.unapplySeq(row);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                Object intercept = ((SeqLike)some.get()).apply(0);
                Object coefficients2 = ((SeqLike)some.get()).apply(1);
                if (intercept instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)intercept);
                    if (coefficients2 instanceof Vector) {
                        Tuple2 tuple2;
                        Vector vector = (Vector)coefficients2;
                        Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)d), (Object)vector);
                        double intercept2 = tuple22._1$mcD$sp();
                        Vector coefficients3 = (Vector)tuple22._2();
                        LinearRegressionModel model = new LinearRegressionModel(metadata.uid(), coefficients3, intercept2);
                        DefaultParamsReader$.MODULE$.getAndSetParams(model, metadata);
                        return model;
                    }
                }
            }
            throw new MatchError((Object)row);
        }
    }
}

