/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.recommendation.ALSParams;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public abstract class ALSParams$class {
    public static int getRank(ALSParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.rank()));
    }

    public static int getNumUserBlocks(ALSParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.numUserBlocks()));
    }

    public static int getNumItemBlocks(ALSParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.numItemBlocks()));
    }

    public static boolean getImplicitPrefs(ALSParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$($this.implicitPrefs()));
    }

    public static double getAlpha(ALSParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$($this.alpha()));
    }

    public static String getRatingCol(ALSParams $this) {
        return $this.$($this.ratingCol());
    }

    public static boolean getNonnegative(ALSParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$($this.nonnegative()));
    }

    public static String getIntermediateStorageLevel(ALSParams $this) {
        return $this.$($this.intermediateStorageLevel());
    }

    public static String getFinalStorageLevel(ALSParams $this) {
        return $this.$($this.finalStorageLevel());
    }

    public static StructType validateAndTransformSchema(ALSParams $this, StructType schema) {
        SchemaUtils$.MODULE$.checkNumericType(schema, $this.$($this.userCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        SchemaUtils$.MODULE$.checkNumericType(schema, $this.$($this.itemCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        SchemaUtils$.MODULE$.checkNumericType(schema, $this.$($this.ratingCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        return SchemaUtils$.MODULE$.appendColumn(schema, $this.$($this.predictionCol()), (DataType)FloatType$.MODULE$, SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    public static void $init$(ALSParams $this) {
        $this.org$apache$spark$ml$recommendation$ALSParams$_setter_$rank_$eq(new IntParam((Identifiable)$this, "rank", "rank of the factorization", (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(1.0)));
        $this.org$apache$spark$ml$recommendation$ALSParams$_setter_$numUserBlocks_$eq(new IntParam((Identifiable)$this, "numUserBlocks", "number of user blocks", (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(1.0)));
        $this.org$apache$spark$ml$recommendation$ALSParams$_setter_$numItemBlocks_$eq(new IntParam((Identifiable)$this, "numItemBlocks", "number of item blocks", (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(1.0)));
        $this.org$apache$spark$ml$recommendation$ALSParams$_setter_$implicitPrefs_$eq(new BooleanParam($this, "implicitPrefs", "whether to use implicit preference"));
        $this.org$apache$spark$ml$recommendation$ALSParams$_setter_$alpha_$eq(new DoubleParam((Identifiable)$this, "alpha", "alpha for implicit preference", (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(0.0)));
        $this.org$apache$spark$ml$recommendation$ALSParams$_setter_$ratingCol_$eq(new Param($this, "ratingCol", "column name for ratings"));
        $this.org$apache$spark$ml$recommendation$ALSParams$_setter_$nonnegative_$eq(new BooleanParam($this, "nonnegative", "whether to use nonnegative constraint for least squares"));
        $this.org$apache$spark$ml$recommendation$ALSParams$_setter_$intermediateStorageLevel_$eq(new Param($this, "intermediateStorageLevel", "StorageLevel for intermediate datasets. Cannot be 'NONE'.", new Serializable($this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(String s) {
                if (!Try$.MODULE$.apply((Function0)new Serializable(this, s){
                    public static final long serialVersionUID = 0L;
                    private final String s$1;

                    public final StorageLevel apply() {
                        return StorageLevel$.MODULE$.fromString(this.s$1);
                    }
                    {
                        this.s$1 = s$1;
                    }
                }).isSuccess()) return false;
                String string = s;
                String string2 = "NONE";
                if (string == null) {
                    if (string2 == null) return false;
                    return true;
                } else if (string.equals(string2)) return false;
                return true;
            }
        }));
        $this.org$apache$spark$ml$recommendation$ALSParams$_setter_$finalStorageLevel_$eq(new Param($this, "finalStorageLevel", "StorageLevel for ALS model factors.", new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String s) {
                return Try$.MODULE$.apply((Function0)new Serializable(this, s){
                    public static final long serialVersionUID = 0L;
                    private final String s$2;

                    public final StorageLevel apply() {
                        return StorageLevel$.MODULE$.fromString(this.s$2);
                    }
                    {
                        this.s$2 = s$2;
                    }
                }).isSuccess();
            }
        }));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.rank().$minus$greater(BoxesRunTime.boxToInteger((int)10)), $this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)10)), $this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.1)), $this.numUserBlocks().$minus$greater(BoxesRunTime.boxToInteger((int)10)), $this.numItemBlocks().$minus$greater(BoxesRunTime.boxToInteger((int)10)), $this.implicitPrefs().$minus$greater(BoxesRunTime.boxToBoolean((boolean)false)), $this.alpha().$minus$greater(BoxesRunTime.boxToDouble((double)1.0)), $this.userCol().$minus$greater("user"), $this.itemCol().$minus$greater("item"), $this.ratingCol().$minus$greater("rating"), $this.nonnegative().$minus$greater(BoxesRunTime.boxToBoolean((boolean)false)), $this.checkpointInterval().$minus$greater(BoxesRunTime.boxToInteger((int)10)), $this.intermediateStorageLevel().$minus$greater("MEMORY_AND_DISK"), $this.finalStorageLevel().$minus$greater("MEMORY_AND_DISK")}));
    }
}

