/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.classification.NaiveBayes;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.NaiveBayesWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReadable$class;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.MatchError;
import scala.Tuple2;

public final class NaiveBayesWrapper$
implements MLReadable<NaiveBayesWrapper> {
    public static final NaiveBayesWrapper$ MODULE$;
    private final String PREDICTED_LABEL_INDEX_COL;
    private final String PREDICTED_LABEL_COL;

    static {
        new NaiveBayesWrapper$();
    }

    public String PREDICTED_LABEL_INDEX_COL() {
        return this.PREDICTED_LABEL_INDEX_COL;
    }

    public String PREDICTED_LABEL_COL() {
        return this.PREDICTED_LABEL_COL;
    }

    public NaiveBayesWrapper fit(String formula, Dataset<Row> data, double smoothing) {
        RFormula rFormula = new RFormula().setFormula(formula).setForceIndexLabel(true);
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        Tuple2<String[], String[]> tuple2 = RWrapperUtils$.MODULE$.getFeaturesAndLabels((RFormulaModel)rFormulaModel, data);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String[] features = (String[])tuple2._1();
            String[] labels = (String[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)features, (Object)labels);
            String[] features2 = (String[])tuple23._1();
            String[] labels2 = (String[])tuple23._2();
            NaiveBayes naiveBayes = (NaiveBayes)((Predictor)((Predictor)new NaiveBayes().setSmoothing(smoothing).setModelType("bernoulli").setFeaturesCol(rFormula.getFeaturesCol())).setLabelCol(rFormula.getLabelCol())).setPredictionCol(this.PREDICTED_LABEL_INDEX_COL());
            IndexToString idxToStr = new IndexToString().setInputCol(this.PREDICTED_LABEL_INDEX_COL()).setOutputCol(this.PREDICTED_LABEL_COL()).setLabels(labels2);
            Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, naiveBayes, idxToStr})).fit((Dataset)data);
            return new NaiveBayesWrapper((PipelineModel)pipeline, labels2, features2);
        }
        throw new MatchError(tuple2);
    }

    @Override
    public MLReader<NaiveBayesWrapper> read() {
        return new NaiveBayesWrapper.NaiveBayesWrapperReader();
    }

    @Override
    public NaiveBayesWrapper load(String path) {
        return (NaiveBayesWrapper)MLReadable$class.load(this, path);
    }

    private NaiveBayesWrapper$() {
        MODULE$ = this;
        MLReadable$class.$init$(this);
        this.PREDICTED_LABEL_INDEX_COL = "pred_label_idx";
        this.PREDICTED_LABEL_COL = "prediction";
    }
}

