/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.RegressionEvaluator$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasLabelCol$class;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u00055\u00111CU3he\u0016\u001c8/[8o\u000bZ\fG.^1u_JT!a\u0001\u0003\u0002\u0015\u00154\u0018\r\\;bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011#\u0002\u0001\u000f%ii\u0002CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005%)e/\u00197vCR|'\u000f\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u000511\u000f[1sK\u0012T!a\u0006\u0003\u0002\u000bA\f'/Y7\n\u0005e!\"\u0001\u0005%bgB\u0013X\rZ5di&|gnQ8m!\t\u00192$\u0003\u0002\u001d)\tY\u0001*Y:MC\n,GnQ8m!\tq\u0012%D\u0001 \u0015\t\u0001C!\u0001\u0003vi&d\u0017B\u0001\u0012 \u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016D\u0001\u0002\n\u0001\u0003\u0006\u0004%\t%J\u0001\u0004k&$W#\u0001\u0014\u0011\u0005\u001djcB\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J\u0013A\u0002)sK\u0012,g-\u0003\u0002/_\t11\u000b\u001e:j]\u001eT!\u0001L\u0015)\u0007\r\nt\u0007\u0005\u00023k5\t1G\u0003\u00025\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\u001a$!B*j]\u000e,\u0017%\u0001\u001d\u0002\u000bErCG\f\u0019\t\u0011i\u0002!\u0011!Q\u0001\n\u0019\nA!^5eA!\u001a\u0011(M\u001c\t\u000bu\u0002A\u0011\u0001 \u0002\rqJg.\u001b;?)\ty\u0004\t\u0005\u0002\u0010\u0001!)A\u0005\u0010a\u0001M!\u001a\u0001)M\u001c)\u0007q\nt\u0007C\u0003>\u0001\u0011\u0005A\tF\u0001@Q\r\u0019\u0015g\u000e\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003)iW\r\u001e:jG:\u000bW.Z\u000b\u0002\u0013B\u0019!j\u0013\u0014\u000e\u0003YI!\u0001\u0014\f\u0003\u000bA\u000b'/Y7)\u0007\u0019\u000bt\u0007\u0003\u0004P\u0001\u0001\u0006I!S\u0001\f[\u0016$(/[2OC6,\u0007\u0005K\u0002Oc]BQA\u0015\u0001\u0005\u0002\u0015\nQbZ3u\u001b\u0016$(/[2OC6,\u0007fA)2o!)Q\u000b\u0001C\u0001-\u0006i1/\u001a;NKR\u0014\u0018n\u0019(b[\u0016$\"a\u0016-\u000e\u0003\u0001AQ!\u0017+A\u0002\u0019\nQA^1mk\u0016D3\u0001V\u00198\u0011\u0015a\u0006\u0001\"\u0001^\u0003A\u0019X\r\u001e)sK\u0012L7\r^5p]\u000e{G\u000e\u0006\u0002X=\")\u0011l\u0017a\u0001M!\u001a1,M\u001c\t\u000b\u0005\u0004A\u0011\u00012\u0002\u0017M,G\u000fT1cK2\u001cu\u000e\u001c\u000b\u0003/\u000eDQ!\u00171A\u0002\u0019B3\u0001Y\u00198\u0011\u00151\u0007\u0001\"\u0011h\u0003!)g/\u00197vCR,GC\u00015l!\tA\u0013.\u0003\u0002kS\t1Ai\\;cY\u0016DQ\u0001\\3A\u00025\fq\u0001Z1uCN,G\u000f\r\u0002omB\u0019qN\u001d;\u000e\u0003AT!!\u001d\u0004\u0002\u0007M\fH.\u0003\u0002ta\n9A)\u0019;bg\u0016$\bCA;w\u0019\u0001!\u0011b^6\u0002\u0002\u0003\u0005)\u0011\u0001=\u0003\u0007}#\u0013'\u0005\u0002zyB\u0011\u0001F_\u0005\u0003w&\u0012qAT8uQ&tw\r\u0005\u0002){&\u0011a0\u000b\u0002\u0004\u0003:L\b\u0006B32\u0003\u0003\t#!a\u0001\u0002\u000bIr\u0003G\f\u0019\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n\u0005q\u0011n\u001d'be\u001e,'OQ3ui\u0016\u0014XCAA\u0006!\rA\u0013QB\u0005\u0004\u0003\u001fI#a\u0002\"p_2,\u0017M\u001c\u0015\u0005\u0003\u000b\tt\u0007C\u0004\u0002\u0016\u0001!\t%a\u0006\u0002\t\r|\u0007/\u001f\u000b\u0004\u007f\u0005e\u0001\u0002CA\u000e\u0003'\u0001\r!!\b\u0002\u000b\u0015DHO]1\u0011\u0007)\u000by\"C\u0002\u0002\"Y\u0011\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0006\u0003'\t\u0014QE\u0011\u0003\u0003O\tQ!\r\u00186]AB3\u0001AA\u0016!\r\u0011\u0014QF\u0005\u0004\u0003_\u0019$\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006d\u0007f\u0001\u00012o\u001d9\u0011Q\u0007\u0002\t\u0002\u0005]\u0012a\u0005*fOJ,7o]5p]\u00163\u0018\r\\;bi>\u0014\bcA\b\u0002:\u00191\u0011A\u0001E\u0001\u0003w\u0019\u0002\"!\u000f\u0002>\u0005\r\u0013\u0011\n\t\u0004Q\u0005}\u0012bAA!S\t1\u0011I\\=SK\u001a\u0004BAHA#\u007f%\u0019\u0011qI\u0010\u0003+\u0011+g-Y;miB\u000b'/Y7t%\u0016\fG-\u00192mKB\u0019\u0001&a\u0013\n\u0007\u00055\u0013F\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004>\u0003s!\t!!\u0015\u0015\u0005\u0005]\u0002\u0002CA+\u0003s!\t%a\u0016\u0002\t1|\u0017\r\u001a\u000b\u0004\u007f\u0005e\u0003bBA.\u0003'\u0002\rAJ\u0001\u0005a\u0006$\b\u000eK\u0003\u0002TE\ny&\t\u0002\u0002b\u0005)\u0011G\f\u001c/a!Q\u0011QMA\u001d\u0003\u0003%I!a\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003S\u0002B!a\u001b\u0002v5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(\u0001\u0003mC:<'BAA:\u0003\u0011Q\u0017M^1\n\t\u0005]\u0014Q\u000e\u0002\u0007\u001f\nTWm\u0019;)\u000b\u0005e\u0012'a\u0018)\u000b\u0005M\u0012'a\u0018")
public final class RegressionEvaluator
extends Evaluator
implements HasPredictionCol,
HasLabelCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> labelCol;
    private final Param<String> predictionCol;

    public static MLReader<RegressionEvaluator> read() {
        return RegressionEvaluator$.MODULE$.read();
    }

    public static RegressionEvaluator load(String string) {
        return RegressionEvaluator$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public RegressionEvaluator setMetricName(String value) {
        return (RegressionEvaluator)this.set(this.metricName(), value);
    }

    public RegressionEvaluator setPredictionCol(String value) {
        return (RegressionEvaluator)this.set(this.predictionCol(), value);
    }

    public RegressionEvaluator setLabelCol(String value) {
        return (RegressionEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(Dataset<?> dataset) {
        String string;
        block6: {
            double d;
            block3: {
                RegressionMetrics metrics;
                block5: {
                    block4: {
                        block2: {
                            StructType schema = dataset.schema();
                            SchemaUtils$.MODULE$.checkColumnTypes(schema, this.$(this.predictionCol()), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FractionalType[]{DoubleType$.MODULE$, FloatType$.MODULE$}))), SchemaUtils$.MODULE$.checkColumnTypes$default$4());
                            SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.labelCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
                            RDD predictionAndLabels = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$)})).rdd().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<Object, Object> apply(Row x0$1) {
                                    Row row = x0$1;
                                    Some some = Row$.MODULE$.unapplySeq(row);
                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                        Object prediction = ((SeqLike)some.get()).apply(0);
                                        Object label = ((SeqLike)some.get()).apply(1);
                                        if (prediction instanceof Double) {
                                            double d = BoxesRunTime.unboxToDouble((Object)prediction);
                                            if (label instanceof Double) {
                                                double d2 = BoxesRunTime.unboxToDouble((Object)label);
                                                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
                                                return sp2;
                                            }
                                        }
                                    }
                                    throw new MatchError((Object)row);
                                }
                            }, ClassTag$.MODULE$.apply(Tuple2.class));
                            metrics = new RegressionMetrics((RDD<Tuple2<Object, Object>>)predictionAndLabels);
                            string = this.$(this.metricName());
                            if (!"rmse".equals(string)) break block2;
                            d = metrics.rootMeanSquaredError();
                            break block3;
                        }
                        if (!"mse".equals(string)) break block4;
                        d = metrics.meanSquaredError();
                        break block3;
                    }
                    if (!"r2".equals(string)) break block5;
                    d = metrics.r2();
                    break block3;
                }
                if (!"mae".equals(string)) break block6;
                d = metrics.meanAbsoluteError();
            }
            double metric = d;
            return metric;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public boolean isLargerBetter() {
        String string;
        block6: {
            boolean bl;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            string = this.$(this.metricName());
                            if (!"rmse".equals(string)) break block2;
                            bl = false;
                            break block3;
                        }
                        if (!"mse".equals(string)) break block4;
                        bl = false;
                        break block3;
                    }
                    if (!"r2".equals(string)) break block5;
                    bl = true;
                    break block3;
                }
                if (!"mae".equals(string)) break block6;
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public RegressionEvaluator copy(ParamMap extra) {
        return (RegressionEvaluator)this.defaultCopy(extra);
    }

    public RegressionEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol$class.$init$(this);
        HasLabelCol$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"mse", "rmse", "r2", "mae"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (mse|rmse|r2|mae)", allowedParams);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("rmse")}));
    }

    public RegressionEvaluator() {
        this(Identifiable$.MODULE$.randomUID("regEval"));
    }
}

