/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IScriptEvaluator;
import org.codehaus.commons.compiler.samples.DemoBase;

public final class Jsh
extends DemoBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Object[] arguments;
        String arg;
        int i;
        Class returnType = Void.TYPE;
        ArrayList<String> parameterNames = new ArrayList<String>();
        ArrayList<Class<String[]>> parameterTypes = new ArrayList<Class<String[]>>();
        ArrayList<Class<Exception>> thrownExceptions = new ArrayList<Class<Exception>>();
        ArrayList<String> defaultImports = new ArrayList<String>();
        String optionalEncoding = null;
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if ("--return-type".equals(arg)) {
                returnType = DemoBase.stringToType(args[++i]);
                continue;
            }
            if ("--parameter".equals(arg)) {
                parameterTypes.add(DemoBase.stringToType(args[++i]));
                parameterNames.add(args[++i]);
                continue;
            }
            if ("--thrown-exception".equals(arg)) {
                thrownExceptions.add(DemoBase.stringToType(args[++i]));
                continue;
            }
            if ("--default-import".equals(arg)) {
                defaultImports.add(args[++i]);
                continue;
            }
            if ("--help".equals(arg)) {
                System.err.println("Usage:");
                System.err.println("  Jsh { <option> } <script-file> { <argument> }");
                System.err.println("Valid options are:");
                System.err.println(" --return-type <return-type>         (default: void)");
                System.err.println(" --parameter <type> <name>           (multiple allowed)");
                System.err.println(" --thrown-exception <exception-type> (multiple allowed)");
                System.err.println(" --default-import <imports>          (multiple allowed)");
                System.err.println(" --help");
                System.err.println("If no \"--parameter\"s are specified, then the <argument>s are passed as a single");
                System.err.println("parameter \"String[] args\".");
                System.err.println("Otherwise, the number of <argument>s must exactly match the number of");
                System.err.println("parameters, and each <argument> is converted to the respective parameter's");
                System.err.println("type.");
                System.err.println("Iff the return type is not \"void\", then the return value is printed to STDOUT.");
                System.exit(0);
                continue;
            }
            System.err.println("Invalid command line option \"" + arg + "\"; try \"--help\".");
            System.exit(1);
        }
        if (i == args.length) {
            System.err.println("Script missing on command line; try \"--help\".");
            System.exit(1);
        }
        File scriptFile = new File(args[i++]);
        if (parameterTypes.isEmpty()) {
            parameterTypes.add(String[].class);
            parameterNames.add("args");
            arguments = new Object[]{Arrays.copyOfRange(args, i, args.length)};
            if (thrownExceptions.isEmpty()) {
                thrownExceptions.add(Exception.class);
            }
        } else {
            if (args.length - i != parameterTypes.size()) {
                System.err.println("Argument count (" + (args.length - i) + ") and parameter count (" + parameterTypes.size() + ") do not match; try \"--help\".");
                System.exit(1);
            }
            arguments = new Object[parameterTypes.size()];
            for (int j = 0; j < arguments.length; ++j) {
                arguments[j] = DemoBase.createObject((Class)parameterTypes.get(j), args[i + j]);
            }
        }
        IScriptEvaluator se = CompilerFactoryFactory.getDefaultCompilerFactory().newScriptEvaluator();
        se.setReturnType(returnType);
        se.setDefaultImports(defaultImports.toArray(new String[0]));
        se.setParameters(parameterNames.toArray(new String[0]), parameterTypes.toArray(new Class[0]));
        se.setThrownExceptions(thrownExceptions.toArray(new Class[0]));
        FileInputStream is = new FileInputStream(scriptFile);
        try {
            se.cook(scriptFile.toString(), is, optionalEncoding);
            ((InputStream)is).close();
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
        Object res = se.evaluate(arguments);
        if (returnType != Void.TYPE) {
            System.out.println(res instanceof Object[] ? Arrays.toString((Object[])res) : String.valueOf(res));
        }
    }

    private Jsh() {
    }
}

